/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.stix;

import com.dickimawbooks.texparserlib.generic.MathAccent;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import java.io.IOException;

public class StixSty
extends LaTeXSty {
    private static final Object[][] GREEK = new Object[][]{{"alpha", 120572}, {"beta", 120573}, {"gamma", 120574}, {"delta", 120575}, {"varepsilon", 120576}, {"zeta", 120577}, {"eta", 120578}, {"theta", 120579}, {"iota", 120580}, {"kappa", 120581}, {"lambda", 120582}, {"mu", 120583}, {"nu", 120584}, {"xi", 120585}, {"omicron", 120586}, {"pi", 120587}, {"rho", 120588}, {"varsigma", 120589}, {"sigma", 120590}, {"tau", 120591}, {"upsilon", 120592}, {"varphi", 120593}, {"chi", 120594}, {"psi", 120595}, {"omega", 120596}, {"epsilon", 120598}, {"vartheta", 120599}, {"varkappa", 120600}, {"phi", 120601}, {"varrho", 120602}, {"varpi", 120603}, {"Alpha", 120546}, {"Beta", 120547}, {"Gamma", 120548}, {"Delta", 120549}, {"Epsilon", 120550}, {"Zeta", 120551}, {"Eta", 120552}, {"Theta", 120553}, {"Iota", 120554}, {"Kappa", 120555}, {"Lambda", 120556}, {"Mu", 120557}, {"Nu", 120558}, {"Xi", 120559}, {"Omicron", 120560}, {"Pi", 120561}, {"Rho", 120562}, {"Theta", 120563}, {"Sigma", 120564}, {"Tau", 120565}, {"Upsilon", 120566}, {"Phi", 120567}, {"Chi", 120568}, {"Psi", 120569}, {"Omega", 120570}, {"nabla", 120571}};
    private static final Object[][] ALPHABETICS = new Object[][]{{"nabla", 8711}, {"partial", 8706}, {"imath", 120484}, {"jmath", 120485}};
    private static final Object[][] ORDINARY = new Object[][]{{"mathdollar", 36}, {"mathsterling", 163}, {"mathsection", 167}, {"neg", 172}, {"lnot", 172}, {"mathparagraph", 182}, {"eth", 240}, {"Zbar", 437}, {"digamma", 989}, {"backepsilon", 1014}, {"upbackepsilon", 1014}, {"enleadertwodots", 8229}, {"mathellipsis", 8230}, {"prime", 8242}, {"dprime", 8243}, {"trprime", 8244}, {"backprime", 8245}, {"backdprime", 8246}, {"backtrprime", 8247}, {"caretinsert", 8248}, {"Exclam", 8252}, {"hyphenbullet", 8259}, {"Question", 8263}, {"qprime", 8279}, {"enclosecircle", 8413}, {"enclosesquare", 8414}, {"enclosediamond", 8415}, {"enclosetriangle", 8420}, {"Eulerconst", 8455}, {"hbar", 8463}, {"hslash", 8463}, {"Im", 8465}, {"ell", 8467}, {"wp", 8472}, {"Re", 8476}, {"mho", 8487}, {"turnediota", 8489}, {"Angstrom", 8491}, {"Finv", 8498}, {"aleph", 8501}, {"beth", 8502}, {"gimel", 8503}, {"daleth", 8504}, {"Game", 8513}, {"sansLturned", 8514}, {"sansLmirroed", 8515}, {"Yup", 8516}, {"PropertyLine", 8522}, {"updownarrowbar", 8616}, {"linefeed", 8628}, {"carriagereturn", 8629}, {"barovernorthwestarrow", 8632}, {"barleftarrowrightarrowbar", 8633}, {"acwopencirclearrow", 8634}, {"cwopencirclearrow", 8635}, {"nHuparrow", 8670}, {"nHdownarrow", 8671}, {"leftdasharrow", 8672}, {"updasharrow", 8673}, {"rightdasharrow", 8674}, {"downdasharrow", 8675}, {"leftwhitearrow", 8678}, {"upwhitearrow", 8679}, {"rightwhitearrow", 8680}, {"downwhitearrow", 8681}, {"whitearrowupfrombar", 8682}, {"forall", 8704}, {"complement", 8705}, {"exists", 8707}, {"nexists", 8708}, {"varnothing", 8709}, {"emptyset", 8709}, {"increment", 8710}, {"QED", 8718}, {"infty", 8734}, {"rightangle", 8735}, {"angle", 8736}, {"measuredangle", 8737}, {"sphericalangle", 8738}, {"therefore", 8756}, {"because", 8757}, {"sinewave", 8767}, {"top", 8868}, {"bot", 8869}, {"hermitmatrix", 8889}, {"measuredrightangle", 8894}, {"varlrtriangle", 8895}, {"cdots", 8943}, {"diameter", 8960}, {"house", 8962}, {"invnot", 8976}, {"sqlozenge", 8977}, {"profline", 8978}, {"profsurf", 8979}, {"viewdata", 8983}, {"turnednot", 8985}, {"varhexagonlrbonds", 9004}, {"conictaper", 9010}, {"topbot", 9014}, {"APLnotbackslash", 9024}, {"APLboxquestion", 9072}, {"rangledownzigzagarrow", 9084}, {"hexagon", 9108}, {"bbrktbrk", 9142}, {"varcarriagereturn", 9166}, {"obrbrak", 9184}, {"ubrbrak", 9185}, {"trapezium", 9186}, {"benzenr", 9187}, {"strns", 9188}, {"fltns", 9189}, {"accurrent", 9190}, {"elinters", 9191}, {"mathvisiblespace", 9251}, {"circledR", 9415}, {"circledS", 9416}, {"mdlgblksquare", 9632}, {"mdlgwhtsquare", 9633}, {"square", 9633}, {"Box", 9633}, {"squoval", 9634}, {"blackinwhitesquare", 9635}, {"squarehfill", 9636}, {"squarevfill", 9637}, {"squarehvfill", 9638}, {"squarenwsefill", 9639}, {"squareneswfill", 9640}, {"squarecrossfill", 9641}, {"smblksquare", 9642}, {"smwhtsquare", 9643}, {"hrectangleblack", 9644}, {"hrectangle", 9645}, {"vrectangleblack", 9646}, {"vrectangle", 9647}, {"parallelogramblack", 9648}, {"parallelogram", 9649}, {"bigblacktriangleup", 9650}, {"blacktriangle", 9652}, {"blacktriangleright", 9654}, {"smallblacktriangleright", 9656}, {"smalltriangleright", 9657}, {"blackpointerright", 9658}, {"whitepointerright", 9659}, {"bigblacktriangledown", 9660}, {"bigtriangledown", 9661}, {"blacktriangledown", 9662}, {"triangledown", 9663}, {"blacktriangleleft", 9664}, {"smallblacktriangleleft", 9666}, {"smalltriangleleft", 9667}, {"blackpointerleft", 9668}, {"whitepointerleft", 9669}, {"mdlgblkdiamond", 9670}, {"mdlgwhtdiamond", 9671}, {"blackinwhitediamond", 9672}, {"fisheye", 9673}, {"mdlgwhtlozenge", 9674}, {"lozenge", 9674}, {"Diamond", 9674}, {"dottedcircle", 9676}, {"circlevertfill", 9677}, {"bullseye", 9678}, {"mdlgblkcircle", 9679}, {"circlelefthalfblack", 9680}, {"circlerighthalfblack", 9681}, {"circlebottomhalfblack", 9682}, {"circletophalfblack", 9683}, {"circleurquadblack", 9684}, {"blackcircleulquadwhite", 9685}, {"blacklefthalfcircle", 9686}, {"blackrighthalfcircle", 9687}, {"inversebullet", 9688}, {"inversewhitecircle", 9689}, {"invwhiteupperhalfcircle", 9690}, {"invwhitelowerhalfcircle", 9691}, {"ularc", 9692}, {"urarc", 9693}, {"lrarc", 9694}, {"llarc", 9695}, {"topsemicircle", 9696}, {"botsemicircle", 9697}, {"lrblacktriangle", 9698}, {"llblacktriangle", 9699}, {"ulblacktriangle", 9700}, {"urblacktriangle", 9701}, {"circ", 9702}, {"smwhtcircle", 9702}, {"squareleftblack", 9703}, {"squarerightblack", 9704}, {"squareulblack", 9705}, {"squarelrblack", 9706}, {"trianglecdot", 9708}, {"triangleleftblack", 9709}, {"trianglerightblack", 9710}, {"lgwhtcircle", 9711}, {"squareulquad", 9712}, {"squarellquad", 9713}, {"squarelrquad", 9714}, {"squareurquad", 9715}, {"circleulquad", 9716}, {"circlellquad", 9717}, {"circlelrquad", 9718}, {"circleurquad", 9719}, {"ultriangle", 9720}, {"urtriangle", 9721}, {"lltriangle", 9722}, {"mdwhtsquare", 9723}, {"mdblksquare", 9724}, {"mdsmwhtsquare", 9725}, {"mdsmblksquare", 9726}, {"lrtriangle", 9727}, {"bigstar", 9733}, {"bigwhitestar", 9734}, {"astrosun", 9737}, {"danger", 9761}, {"blacksmiley", 9787}, {"sun", 9788}, {"rightmoon", 9789}, {"leftmoon", 9790}, {"female", 9792}, {"male", 9794}, {"spadesuit", 9824}, {"heartsuit", 9825}, {"diamondsuit", 9826}, {"clubsuit", 9827}, {"varspadesuit", 9828}, {"varheartsuit", 9829}, {"vardiamondsuit", 9830}, {"varclubsuit", 9831}, {"quarternote", 9833}, {"eighthnote", 9834}, {"twonotes", 9835}, {"flat", 9837}, {"natural", 9838}, {"sharp", 9839}, {"acidfree", 9854}, {"dicei", 9856}, {"diceii", 9857}, {"diceiii", 9858}, {"diceiv", 9859}, {"dicev", 9860}, {"dicevi", 9861}, {"circledrightdot", 9862}, {"circledtwodots", 9863}, {"blackcircledrightdot", 9864}, {"blackcircledtwodots", 9865}, {"Hermaphrodite", 9893}, {"mdwhtcircle", 9898}, {"mdblkcircle", 9899}, {"mdsmwhtcircle", 9900}, {"neuter", 9906}, {"checkmark", 10003}, {"maltese", 10016}, {"circledstar", 10026}, {"varstar", 10038}, {"dingasterisk", 10045}, {"draftingarrow", 10139}, {"threedangle", 10176}, {"whiteinwhitetriangle", 10177}, {"subsetcirc", 10179}, {"supsetcirc", 10180}, {"diagup", 10187}, {"diagdown", 10189}, {"diamondcdot", 10192}, {"rdiagovfdiag", 10539}, {"fdiagovrdiag", 10540}, {"seovnearrow", 10541}, {"neovsearrow", 10542}, {"fdiagovnearrow", 10543}, {"rdiagovsearrow", 10544}, {"neovnwarrow", 10545}, {"nwovnearrow", 10546}, {"uprightcurvearrow", 10548}, {"downrightcurvedarrow", 10549}, {"mdsmblkcircle", 10625}, {"fourvdots", 10649}, {"vzigzag", 10650}, {"measuredangleleft", 10651}, {"rightanglesqr", 10652}, {"rightanglemdot", 10653}, {"angles", 10654}, {"angdnr", 10655}, {"gtlpar", 10656}, {"sphericalangleup", 10657}, {"turnangle", 10658}, {"revangle", 10659}, {"angleubar", 10660}, {"revangleubar", 10661}, {"wideangledown", 10662}, {"wideangleup", 10663}, {"measanglerutone", 10664}, {"measanglelutonw", 10665}, {"measanglerdtose", 10666}, {"measangleldtosw", 10667}, {"measangleurtone", 10668}, {"measangleultonw", 10669}, {"measangledrtose", 10670}, {"measangledltosw", 10671}, {"revemptyset", 10672}, {"emptysetobar", 10673}, {"emptysetocirc", 10674}, {"emptysetoarr", 10675}, {"emptysetoarrl", 10676}, {"obot", 10682}, {"olcross", 10683}, {"odotslashdot", 10684}, {"uparrowoncircle", 10685}, {"circledwhitebullet", 10686}, {"circledbullet", 10687}, {"cirscir", 10690}, {"cirE", 10691}, {"boxonbox", 10697}, {"triangleodot", 10698}, {"triangleubar", 10699}, {"triangles", 10700}, {"iinfin", 10716}, {"tieinfty", 10717}, {"nvinfty", 10718}, {"laplac", 10720}, {"thermod", 10727}, {"downtriangleleftblack", 10728}, {"downtrianglerightblack", 10729}, {"blackdiamonddownarrow", 10730}, {"blacklozenge", 10731}, {"circledownarrow", 10732}, {"blackcircledownarrow", 10733}, {"errbarsquare", 10734}, {"errbarblacksquare", 10735}, {"errbardiamond", 10736}, {"errbarblackdiamond", 10737}, {"errbarcircle", 10738}, {"errbarblackcircle", 10739}, {"perps", 10977}, {"topcir", 10993}, {"squaretopblack", 11026}, {"squarebotblack", 11027}, {"squareurblack", 11028}, {"squarellblack", 11029}, {"diamondleftblack", 11030}, {"diamondrightblack", 11031}, {"diamondtopblack", 11032}, {"diamondbotblack", 11033}, {"dottedsquare", 11034}, {"lgblksquare", 11035}, {"lgwhtsquare", 11036}, {"vysmblksquare", 11037}, {"vysmwhtsquare", 11038}, {"pentagonblack", 11039}, {"pentagon", 11040}, {"varhexagon", 11041}, {"varhexagonblack", 11042}, {"hexagonblack", 11043}, {"lgblkcircle", 11044}, {"mdblkdiamond", 11045}, {"mdwhtdiamond", 11046}, {"mdblklozenge", 11047}, {"mdwhtlozenge", 11048}, {"smblkdiamond", 11049}, {"smblklozenge", 11050}, {"smwhtlozenge", 11051}, {"blkhorzoval", 11052}, {"whthorzoval", 11053}, {"blkvertoval", 11054}, {"whtvertoval", 11055}, {"medwhitestar", 11088}, {"medblackstar", 11089}, {"smwhitestar", 11090}, {"rightpentagonblack", 11091}, {"rightpentagon", 11092}, {"postalmark", 12306}, {"hzigzag", 12336}, {"Bbbk", 120156}};
    private static final Object[][] BINARY = new Object[][]{{"pm", 177}, {"cdotp", 183}, {"centerdot", 183}, {"times", 215}, {"div", 247}, {"dagger", 8224}, {"ddagger", 8225}, {"smblkcircle", 8226}, {"fracslash", 8260}, {"upand", 8523}, {"mp", 8723}, {"dotplus", 8724}, {"smallsetminus", 8726}, {"ast", 8727}, {"vysmwhtcircle", 8728}, {"vysmblkcircle", 8729}, {"wedge", 8743}, {"land", 8743}, {"vee", 8744}, {"lor", 8744}, {"cap", 8745}, {"cup", 8746}, {"dotminus", 8760}, {"invlazys", 8766}, {"wr", 8768}, {"cupleftarrow", 8844}, {"cupdot", 8845}, {"uplus", 8846}, {"sqcap", 8851}, {"sqcup", 8852}, {"oplus", 8853}, {"ominus", 8854}, {"otimes", 8855}, {"oslash", 8856}, {"odot", 8857}, {"circledcirc", 8858}, {"circledast", 8859}, {"circledequal", 8860}, {"circleddash", 8861}, {"boxplus", 8862}, {"boxminus", 8863}, {"boxtimes", 8864}, {"boxdot", 8865}, {"intercal", 8890}, {"veebar", 8891}, {"barwedge", 8892}, {"barvee", 8893}, {"diamond", 8900}, {"smwhtdiamond", 8900}, {"cdot", 8901}, {"star", 8902}, {"divideontimes", 8903}, {"ltimes", 8905}, {"rtimes", 8906}, {"leftthreetimes", 8907}, {"rightthreetimes", 8908}, {"curlyvee", 8910}, {"curlywedge", 8911}, {"Cap", 8914}, {"doublecap", 8914}, {"Cup", 8915}, {"doublecup", 8915}, {"varbarwedge", 8965}, {"vardoublebarwedge", 8966}, {"obar", 9021}, {"triangle", 9651}, {"bigtriangleup", 9651}, {"lhd", 8882}, {"rhd", 8883}, {"unlhd", 8884}, {"unrhd", 8885}, {"mdlgwhtcircle", 9675}, {"boxbar", 9707}, {"veedot", 10183}, {"wedgedot", 10193}, {"lozengeminus", 10208}, {"concavediamond", 10209}, {"concavediamondtickleft", 10210}, {"concavediamondtickright", 10211}, {"whitesquaretickleft", 10212}, {"whitesquaretickright", 10213}, {"typecolon", 10626}, {"circlehbar", 10677}, {"circledvert", 10678}, {"circledparallel", 10679}, {"obslash", 10680}, {"operp", 10681}, {"olessthan", 10688}, {"ogreaterthan", 10689}, {"boxdiag", 10692}, {"boxbslash", 10693}, {"boxast", 10694}, {"boxcircle", 10695}, {"boxbox", 10696}, {"triangleserifs", 10701}, {"hourglass", 10710}, {"blackhourglass", 10711}, {"shuffle", 10722}, {"mdlgblklozenge", 10731}, {"setminus", 10741}, {"dsol", 10742}, {"rsolbar", 10743}, {"doubleplus", 10746}, {"tripleplus", 10747}, {"tplus", 10750}, {"tminus", 10751}, {"ringplus", 10786}, {"plushat", 10787}, {"simplus", 10788}, {"plusdot", 10789}, {"plussim", 10790}, {"plussubtwo", 10791}, {"plustrif", 10792}, {"commaminus", 10793}, {"minusdot", 10794}, {"minusfdots", 10795}, {"minusrdots", 10796}, {"opluslhrim", 10797}, {"oplusrhrim", 10798}, {"vectimes", 10799}, {"dottimes", 10800}, {"timesbar", 10801}, {"btimes", 10802}, {"smashtimes", 10803}, {"otimeslhrim", 10804}, {"otimesrhrim", 10805}, {"otimeshat", 10806}, {"Otimes", 10807}, {"odiv", 10808}, {"triangleplus", 10809}, {"triangleminus", 10810}, {"triangletimes", 10811}, {"intprod", 10812}, {"intprodr", 10813}, {"fcmp", 10814}, {"amalg", 10815}, {"capdot", 10816}, {"uminus", 10817}, {"barcup", 10818}, {"barcap", 10819}, {"capwedge", 10820}, {"cupvee", 10821}, {"cupovercap", 10822}, {"capovercup", 10823}, {"cupbarcap", 10824}, {"capbarcup", 10825}, {"twocups", 10826}, {"twocaps", 10827}, {"closedvarcup", 10828}, {"closedvarcap", 10829}, {"Sqcap", 10830}, {"Sqcup", 10831}, {"closedvarcupsmashprod", 10832}, {"wedgeodot", 10833}, {"veeodot", 10834}, {"Wedge", 10835}, {"Vee", 10836}, {"wedgeonwedge", 10837}, {"veeonvee", 10838}, {"bigslopedvee", 10839}, {"bigslopedwedge", 10840}, {"wedgemidvert", 10842}, {"veemidvert", 10843}, {"midbarwedge", 10844}, {"midbarvee", 10845}, {"doublebarwedge", 10846}, {"wedgebar", 10847}, {"wedgedoublebar", 10848}, {"varveebar", 10849}, {"doublebarvee", 10850}, {"veedoublebar", 10851}, {"dsub", 10852}, {"rsub", 10853}, {"eqqplus", 10865}, {"pluseqq", 10866}, {"interleave", 10996}, {"nhVvert", 10997}, {"threedotcolon", 10998}, {"trslash", 11003}, {"sslash", 11005}, {"talloblong", 11006}, {"ast", 42}, {"less", 60}, {"equal", 61}, {"greater", 62}, {"closure", 8272}, {"vertoverlay", 8402}, {"leftarrow", 8592}, {"gets", 8592}, {"uparrow", 8593}, {"rightarrow", 8594}, {"to", 8594}, {"downarrow", 8595}, {"leftrightarrow", 8596}, {"updownarrow", 8597}, {"nwarrow", 8598}, {"nearrow", 8599}, {"searrow", 8600}, {"swarrow", 8601}, {"nleftarrow", 8602}, {"nrightarrow", 8603}, {"leftwavearrow", 8604}, {"rightwavearrow", 8605}, {"twoheadleftarrow", 8606}, {"twoheaduparrow", 8607}, {"twoheadrightarrow", 8608}, {"twoheaddownarrow", 8609}, {"leftarrowtail", 8610}, {"rightarrowtail", 8611}, {"mapsfrom", 8612}, {"mapsup", 8613}, {"mapsto", 8614}, {"mapsdown", 8615}, {"hookleftarrow", 8617}, {"hookrightarrow", 8618}, {"looparrowleft", 8619}, {"looparrowright", 8620}, {"leftrightsquigarrow", 8621}, {"nleftrightarrow", 8622}, {"downzigzagarrow", 8623}, {"Lsh", 8624}, {"Rsh", 8625}, {"Ldsh", 8626}, {"Rdsh", 8627}, {"curvearrowleft", 8630}, {"curvearrowright", 8631}, {"circlearrowleft", 8634}, {"circlearrowright", 8635}, {"leftharpoonup", 8636}, {"leftharpoondown", 8637}, {"upharpoonright", 8638}, {"restriction", 8638}, {"upharpoonleft", 8639}, {"rightharpoonup", 8640}, {"rightharpoondown", 8641}, {"downharpoonright", 8642}, {"downharpoonleft", 8643}, {"rightleftarrows", 8644}, {"updownarrows", 8645}, {"leftrightarrows", 8646}, {"leftleftarrows", 8647}, {"upuparrows", 8648}, {"rightrightarrows", 8649}, {"downdownarrows", 8650}, {"leftrightharpoons", 8651}, {"rightleftharpoons", 8652}, {"nLeftarrow", 8653}, {"nLeftrightarrow", 8654}, {"nRightarrow", 8655}, {"Leftarrow", 8656}, {"Uparrow", 8657}, {"Rightarrow", 8658}, {"Downarrow", 8659}, {"Leftrightarrow", 8660}, {"Updownarrow", 8661}, {"Nwarrow", 8662}, {"Nearrow", 8663}, {"Searrow", 8664}, {"Swarrow", 8665}, {"Lleftarrow", 8666}, {"Rrightarrow", 8667}, {"leftsquigarrow", 8668}, {"rightsquigarrow", 8669}, {"leadsto", 8669}, {"barleftarrow", 8676}, {"rightarrowbar", 8677}, {"circleonrightarrow", 8692}, {"downuparrows", 8693}, {"rightthreearrows", 8694}, {"nvleftarrow", 8695}, {"nvrightarrow", 8696}, {"nvleftrightarrow", 8697}, {"nVleftarrow", 8698}, {"nVrightarrow", 8699}, {"nVleftrightarrow", 8700}, {"leftarrowtriangle", 8701}, {"rightarrowtriangle", 8702}, {"leftrightarrowtriangle", 8703}, {"in", 8712}, {"notin", 8713}, {"smallin", 8714}, {"ni", 8715}, {"owns", 8715}, {"nni", 8716}, {"smallni", 8717}, {"propto", 8733}, {"varpropto", 8733}, {"mid", 8739}, {"shortmid", 8739}, {"nmid", 8740}, {"nshortmid", 8740}, {"parallel", 8741}, {"shortparallel", 8741}, {"nparallel", 8742}, {"nshortparallel", 8742}, {"Colon", 8759}, {"dashcolon", 8761}, {"dotsminusdots", 8762}, {"kernelcontraction", 8763}, {"sim", 8764}, {"thicksim", 8764}, {"backsim", 8765}, {"nsim", 8769}, {"eqsim", 8770}, {"simeq", 8771}, {"nsime", 8772}, {"cong", 8773}, {"simneqq", 8774}, {"ncong", 8775}, {"approx", 8776}, {"thickapprox", 8776}, {"napprox", 8777}, {"approxeq", 8778}, {"approxident", 8779}, {"backcong", 8780}, {"asymp", 8781}, {"Bumpeq", 8782}, {"bumpeq", 8783}, {"doteq", 8784}, {"Doteq", 8785}, {"doteqdot", 8785}, {"fallingdotseq", 8786}, {"risingdotseq", 8787}, {"coloneq", 8788}, {"eqcolon", 8789}, {"eqcirc", 8790}, {"circeq", 8791}, {"arceq", 8792}, {"wedgeq", 8793}, {"veeeq", 8794}, {"stareq", 8795}, {"triangleq", 8796}, {"eqdef", 8797}, {"measeq", 8798}, {"questeq", 8799}, {"ne", 8800}, {"neq", 8800}, {"equiv", 8801}, {"nequiv", 8802}, {"Equiv", 8803}, {"leq", 8804}, {"le", 8804}, {"geq", 8805}, {"ge", 8805}, {"leqq", 8806}, {"geqq", 8807}, {"lneqq", 8808}, {"lvertneqq", 8808}, {"gneqq", 8809}, {"gvertneqq", 8809}, {"ll", 8810}, {"gg", 8811}, {"between", 8812}, {"nasymp", 8813}, {"nless", 8814}, {"ngtr", 8815}, {"nleq", 8816}, {"ngeq", 8817}, {"lesssim", 8818}, {"gtrsim", 8819}, {"nlesssim", 8820}, {"ngtrsim", 8821}, {"lessgtr", 8822}, {"gtrless", 8823}, {"nlessgtr", 8824}, {"ngtrless", 8825}, {"prec", 8826}, {"succ", 8827}, {"preccurlyeq", 8828}, {"succcurlyeq", 8829}, {"precsim", 8830}, {"succsim", 8831}, {"nprec", 8832}, {"nsucc", 8833}, {"subset", 8834}, {"supset", 8835}, {"nsubset", 8836}, {"nsupset", 8837}, {"subseteq", 8838}, {"supseteq", 8839}, {"nsubseteq", 8840}, {"nsupseteq", 8841}, {"subsetneq", 8842}, {"varsubsetneq", 8842}, {"supsetneq", 8843}, {"varsupsetneq", 8843}, {"sqsubset", 8847}, {"sqsupset", 8848}, {"sqsubseteq", 8849}, {"sqsupseteq", 8850}, {"vdash", 8866}, {"dashv", 8867}, {"assert", 8870}, {"models", 8871}, {"vDash", 8872}, {"Vdash", 8873}, {"Vvdash", 8874}, {"VDash", 8875}, {"nvdash", 8876}, {"nvDash", 8877}, {"nVdash", 8878}, {"nVDash", 8879}, {"prurel", 8880}, {"scurel", 8881}, {"vartriangleleft", 8882}, {"vartriangleright", 8883}, {"trianglelefteq", 8884}, {"trianglerighteq", 8885}, {"origof", 8886}, {"imageof", 8887}, {"multimap", 8888}, {"bowtie", 8904}, {"backsimeq", 8909}, {"Subset", 8912}, {"Supset", 8913}, {"pitchfork", 8916}, {"equalparallel", 8917}, {"lessdot", 8918}, {"gtrdot", 8919}, {"lll", 8920}, {"llless", 8920}, {"ggg", 8921}, {"gggtr", 8921}, {"lesseqgtr", 8922}, {"gtreqless", 8923}, {"eqless", 8924}, {"eqgtr", 8925}, {"curlyeqprec", 8926}, {"curlyeqsucc", 8927}, {"npreccurlyeq", 8928}, {"nsucccurlyeq", 8929}, {"nsqsubseteq", 8930}, {"nsqsupseteq", 8931}, {"sqsubsetneq", 8932}, {"sqsupsetneq", 8933}, {"lnsim", 8934}, {"gnsim", 8935}, {"precnsim", 8936}, {"succnsim", 8937}, {"nvartriangleleft", 8938}, {"nvartriangleright", 8939}, {"ntrianglelefteq", 8940}, {"ntrianglerighteq", 8941}, {"vdots", 8942}, {"adots", 8944}, {"ddots", 8945}, {"disin", 8946}, {"varisins", 8947}, {"isins", 8948}, {"isindot", 8949}, {"varisinobar", 8950}, {"isinobar", 8951}, {"isinvb", 8952}, {"isinE", 8953}, {"nisd", 8954}, {"varnis", 8955}, {"nis", 8956}, {"varniobar", 8957}, {"niobar", 8958}, {"bagmember", 8959}, {"frown", 8994}, {"smallfrown", 8994}, {"smile", 8995}, {"smallsmile", 8995}, {"APLnotslash", 9023}, {"vartriangle", 9653}, {"perp", 10178}, {"bsolhsub", 10184}, {"suphsol", 10185}, {"upin", 10194}, {"pullback", 10195}, {"pushout", 10196}, {"DashVDash", 10202}, {"dashVdash", 10203}, {"multimapinv", 10204}, {"vlongdash", 10205}, {"longdashv", 10206}, {"cirbot", 10207}, {"UUparrow", 10224}, {"DDownarrow", 10225}, {"acwgapcirclearrow", 10226}, {"cwgapcirclearrow", 10227}, {"rightarrowonoplus", 10228}, {"longleftarrow", 10229}, {"longrightarrow", 10230}, {"longleftrightarrow", 10231}, {"Longleftarrow", 10232}, {"Longrightarrow", 10233}, {"Longleftrightarrow", 10234}, {"longmapsfrom", 10235}, {"longmapsto", 10236}, {"Longmapsfrom", 10237}, {"Longmapsto", 10238}, {"longrightsquigarrow", 10239}, {"nvtwoheadrightarrow", 10496}, {"nVtwoheadrightarrow", 10497}, {"nvLeftarrow", 10498}, {"nvRightarrow", 10499}, {"nvLeftrightarrow", 10500}, {"twoheadmapsto", 10501}, {"Mapsfrom", 10502}, {"Mapsto", 10503}, {"downarrowbarred", 10504}, {"uparrowbarred", 10505}, {"Uuparrow", 10506}, {"Ddownarrow", 10507}, {"leftbkarrow", 10508}, {"rightbkarrow", 10509}, {"leftdbkarrow", 10510}, {"dashleftarrow", 10510}, {"dbkarow", 10511}, {"dashrightarrow", 10511}, {"drbkarow", 10512}, {"rightdotarrow", 10513}, {"baruparrow", 10514}, {"downarrowbar", 10515}, {"nvrightarrowtail", 10516}, {"nVrightarrowtail", 10517}, {"twoheadrightarrowtail", 10518}, {"nvtwoheadrightarrowtail", 10519}, {"nVtwoheadrightarrowtail", 10520}, {"lefttail", 10521}, {"righttail", 10522}, {"leftdbltail", 10523}, {"rightdbltail", 10524}, {"diamondleftarrow", 10525}, {"rightarrowdiamond", 10526}, {"diamondleftarrowbar", 10527}, {"barrightarrowdiamond", 10528}, {"nwsearrow", 10529}, {"neswarrow", 10530}, {"hknwarrow", 10531}, {"hknearrow", 10532}, {"hksearow", 10533}, {"hkswarow", 10534}, {"tona", 10535}, {"toea", 10536}, {"tosa", 10537}, {"towa", 10538}, {"rightcurvedarrow", 10547}, {"leftdowncurvedarrow", 10550}, {"rightdowncurvedarrow", 10551}, {"cwrightarcarrow", 10552}, {"acwleftarcarrow", 10553}, {"acwoverarcarrow", 10554}, {"acwunderarcarrow", 10555}, {"curvearrowrightminus", 10556}, {"curvearrowleftplus", 10557}, {"cwundercurvearrow", 10558}, {"ccwundercurvearrow", 10559}, {"acwcirclearrow", 10560}, {"cwcirclearrow", 10561}, {"rightarrowshortleftarrow", 10562}, {"leftarrowshortrightarrow", 10563}, {"shortrightarrowleftarrow", 10564}, {"rightarrowplus", 10565}, {"leftarrowplus", 10566}, {"rightarrowx", 10567}, {"leftrightarrowcircle", 10568}, {"twoheaduparrowcircle", 10569}, {"leftrightharpoonupdown", 10570}, {"leftrightharpoondownup", 10571}, {"updownharpoonrightleft", 10572}, {"updownharpoonleftright", 10573}, {"leftrightharpoonupup", 10574}, {"updownharpoonrightright", 10575}, {"leftrightharpoondowndown", 10576}, {"updownharpoonleftleft", 10577}, {"barleftharpoonup", 10578}, {"rightharpoonupbar", 10579}, {"barupharpoonright", 10580}, {"downharpoonrightbar", 10581}, {"barleftharpoondown", 10582}, {"rightharpoondownbar", 10583}, {"barupharpoonleft", 10584}, {"downharpoonleftbar", 10585}, {"leftharpoonupbar", 10586}, {"barrightharpoonup", 10587}, {"upharpoonrightbar", 10588}, {"bardownharpoonright", 10589}, {"leftharpoondownbar", 10590}, {"barrightharpoondown", 10591}, {"upharpoonleftbar", 10592}, {"bardownharpoonleft", 10593}, {"leftharpoonsupdown", 10594}, {"upharpoonsleftright", 10595}, {"rightharpoonsupdown", 10596}, {"downharpoonsleftright", 10597}, {"leftrightharpoonsup", 10598}, {"leftrightharpoonsdown", 10599}, {"rightleftharpoonsup", 10600}, {"rightleftharpoonsdown", 10601}, {"leftharpoonupdash", 10602}, {"dashleftharpoondown", 10603}, {"rightharpoonupdash", 10604}, {"dashrightharpoondown", 10605}, {"updownharpoonsleftright", 10606}, {"downupharpoonsleftright", 10607}, {"rightimply", 10608}, {"equalrightarrow", 10609}, {"similarrightarrow", 10610}, {"leftarrowsimilar", 10611}, {"rightarrowsimilar", 10612}, {"rightarrowapprox", 10613}, {"ltlarr", 10614}, {"leftarrowless", 10615}, {"gtrarr", 10616}, {"subrarr", 10617}, {"leftarrowsubset", 10618}, {"suplarr", 10619}, {"leftfishtail", 10620}, {"rightfishtail", 10621}, {"upfishtail", 10622}, {"downfishtail", 10623}, {"rtriltri", 10702}, {"ltrivb", 10703}, {"vbrtri", 10704}, {"lfbowtie", 10705}, {"rfbowtie", 10706}, {"fbowtie", 10707}, {"lftimes", 10708}, {"rftimes", 10709}, {"dualmap", 10719}, {"lrtriangleeq", 10721}, {"eparsl", 10723}, {"smeparsl", 10724}, {"eqvparsl", 10725}, {"gleichstark", 10726}, {"ruledelayed", 10740}, {"veeonwedge", 10841}, {"eqdot", 10854}, {"dotequiv", 10855}, {"equivVert", 10856}, {"equivVvert", 10857}, {"dotsim", 10858}, {"simrdots", 10859}, {"simminussim", 10860}, {"congdot", 10861}, {"asteq", 10862}, {"hatapprox", 10863}, {"approxeqq", 10864}, {"eqqsim", 10867}, {"Coloneq", 10868}, {"eqeq", 10869}, {"eqeqeq", 10870}, {"ddotseq", 10871}, {"equivDD", 10872}, {"ltcir", 10873}, {"gtcir", 10874}, {"ltquest", 10875}, {"gtquest", 10876}, {"leqslant", 10877}, {"geqslant", 10878}, {"lesdot", 10879}, {"gesdot", 10880}, {"lesdoto", 10881}, {"gesdoto", 10882}, {"lesdotor", 10883}, {"gesdotol", 10884}, {"lessapprox", 10885}, {"gtrapprox", 10886}, {"lneq", 10887}, {"gneq", 10888}, {"lnapprox", 10889}, {"gnapprox", 10890}, {"lesseqqgtr", 10891}, {"gtreqqless", 10892}, {"lsime", 10893}, {"gsime", 10894}, {"lsimg", 10895}, {"gsiml", 10896}, {"lgE", 10897}, {"glE", 10898}, {"lesges", 10899}, {"gesles", 10900}, {"eqslantless", 10901}, {"eqslantgtr", 10902}, {"elsdot", 10903}, {"egsdot", 10904}, {"eqqless", 10905}, {"eqqgtr", 10906}, {"eqqslantless", 10907}, {"eqqslantgtr", 10908}, {"simless", 10909}, {"simgtr", 10910}, {"simlE", 10911}, {"simgE", 10912}, {"Lt", 10913}, {"Gt", 10914}, {"partialmeetcontraction", 10915}, {"glj", 10916}, {"gla", 10917}, {"ltcc", 10918}, {"gtcc", 10919}, {"lescc", 10920}, {"gescc", 10921}, {"smt", 10922}, {"lat", 10923}, {"smte", 10924}, {"late", 10925}, {"bumpeqq", 10926}, {"preceq", 10927}, {"succeq", 10928}, {"precneq", 10929}, {"succneq", 10930}, {"preceqq", 10931}, {"succeqq", 10932}, {"precneqq", 10933}, {"succneqq", 10934}, {"precapprox", 10935}, {"succapprox", 10936}, {"precnapprox", 10937}, {"succnapprox", 10938}, {"Prec", 10939}, {"Succ", 10940}, {"subsetdot", 10941}, {"supsetdot", 10942}, {"subsetplus", 10943}, {"supsetplus", 10944}, {"submult", 10945}, {"supmult", 10946}, {"subedot", 10947}, {"supedot", 10948}, {"subseteqq", 10949}, {"supseteqq", 10950}, {"subsim", 10951}, {"supsim", 10952}, {"subsetapprox", 10953}, {"supsetapprox", 10954}, {"subsetneqq", 10955}, {"varsubsetneqq", 10955}, {"supsetneqq", 10956}, {"varsupsetneqq", 10956}, {"lsqhook", 10957}, {"rsqhook", 10958}, {"csub", 10959}, {"csup", 10960}, {"csube", 10961}, {"csupe", 10962}, {"subsup", 10963}, {"supsub", 10964}, {"subsub", 10965}, {"supsup", 10966}, {"suphsub", 10967}, {"supdsub", 10968}, {"forkv", 10969}, {"topfork", 10970}, {"mlcp", 10971}, {"forks", 10972}, {"forksnot", 10973}, {"shortlefttack", 10974}, {"shortdowntack", 10975}, {"shortuptack", 10976}, {"vDdash", 10978}, {"dashV", 10979}, {"Dashv", 10980}, {"DashV", 10981}, {"varVdash", 10982}, {"Barv", 10983}, {"vBar", 10984}, {"vBarv", 10985}, {"barV", 10986}, {"Vbar", 10987}, {"Not", 10988}, {"bNot", 10989}, {"revnmid", 10990}, {"cirmid", 10991}, {"midcir", 10992}, {"nhpar", 10994}, {"parsim", 10995}, {"lllnest", 10999}, {"gggnest", 11000}, {"leqqslant", 11001}, {"geqqslant", 11002}, {"circleonleftarrow", 11056}, {"leftthreearrows", 11057}, {"leftarrowonoplus", 11058}, {"longleftsquigarrow", 11059}, {"nvtwoheadleftarrow", 11060}, {"nVtwoheadleftarrow", 11061}, {"twoheadmapsfrom", 11062}, {"twoheadleftdbkarrow", 11063}, {"leftdotarrow", 11064}, {"nvleftarrowtail", 11065}, {"nVleftarrowtail", 11066}, {"twoheadleftarrowtail", 11067}, {"nvtwoheadleftarrowtail", 11068}, {"nVtwoheadleftarrowtail", 11069}, {"leftarrowx", 11070}, {"leftcurvedarrow", 11071}, {"equalleftarrow", 11072}, {"bsimilarleftarrow", 11073}, {"leftarrowbackapprox", 11074}, {"rightarrowgtr", 11075}, {"rightarrowsupset", 11076}, {"LLeftarrow", 11077}, {"RRightarrow", 11078}, {"bsimilarrightarrow", 11079}, {"rightarrowbackapprox", 11080}, {"similarleftarrow", 11081}, {"leftarrowapprox", 11082}, {"leftarrowbsimilar", 11083}, {"rightarrowbsimilar", 11084}};
    private static final Object[][] PUNCTUATION = new Object[][]{{"ldotp", 46}, {"colon", 58}};
    private static final Object[][] SMALL_INTEGRALS = new Object[][]{{"smallint", 8747}, {"smalliint", 8748}, {"smalliiint", 8749}, {"smalloint", 8750}, {"smalloiint", 8751}, {"smalloiiint", 8752}, {"smallintclockwise", 8753}, {"smallvarointclockwise", 8754}, {"smallointctrclockwise", 8755}, {"smallsumint", 10763}, {"smalliiiint", 10764}, {"smallintbar", 10765}, {"smallintBar", 10766}, {"smallfint", 10767}, {"smallcirfnint", 10768}, {"smallawint", 10769}, {"smallrppolint", 10770}, {"smallscpolint", 10771}, {"smallnpolint", 10772}, {"smallpointint", 10773}, {"smallsqint", 10774}, {"smallintlarhk", 10775}, {"smallintx", 10776}, {"smallintcap", 10777}, {"smallintcup", 10778}, {"smallupint", 10779}, {"smalllowint", 10780}};
    private static final Object[][] INTEGRALS = new Object[][]{{"int", 8747}, {"iint", 8748}, {"iiint", 8749}, {"oint", 8750}, {"oiint", 8751}, {"oiiint", 8752}, {"intclockwise", 8753}, {"varointclockwise", 8754}, {"ointctrclockwise", 8755}, {"sumint", 10763}, {"iiiint", 10764}, {"intbar", 10765}, {"intBar", 10766}, {"fint", 10767}, {"cirfnint", 10768}, {"awint", 10769}, {"rppolint", 10770}, {"scpolint", 10771}, {"npolint", 10772}, {"pointint", 10773}, {"sqint", 10774}, {"intlarhk", 10775}, {"intx", 10776}, {"intcap", 10777}, {"intcup", 10778}, {"upint", 10779}, {"lowint", 10780}};
    private static final Object[][] BIG_OPERATORS = new Object[][]{{"Bbbsum", 8512}, {"prod", 8719}, {"coprod", 8720}, {"sum", 8721}, {"bigwedge", 8896}, {"bigvee", 8897}, {"bigcap", 8898}, {"bigcup", 8899}, {"leftouterjoin", 10197}, {"rightouterjoin", 10198}, {"fullouterjoin", 10199}, {"bigbot", 10200}, {"bigtop", 10201}, {"xsol", 10744}, {"xbsol", 10745}, {"bigodot", 10752}, {"bigoplus", 10753}, {"bigotimes", 10754}, {"bigcupdot", 10755}, {"biguplus", 10756}, {"bigsqcap", 10757}, {"bigsqcup", 10758}, {"conjquant", 10759}, {"disjquant", 10760}, {"bigtimes", 10761}, {"modtwosum", 10762}, {"Join", 10781}, {"bigtriangleleft", 10782}, {"zcmp", 10783}, {"zpipe", 10784}, {"zproject", 10785}, {"biginterleave", 11004}, {"bigtalloblong", 11007}};
    private static final Object[][] DELIMITERS = new Object[][]{{"lbrace", 123}, {"backslash", 92}, {"rbrace", 125}, {"lceil", 8968}, {"lfloor", 8970}, {"lmoustache", 9136}, {"lbrbrak", 10098}, {"lBrack", 10214}, {"langle", 10216}, {"lAngle", 10218}, {"lgroup", 10222}, {"lBrace", 10627}, {"lParen", 10629}, {"rceil", 8969}, {"rfloor", 8971}, {"rmoustache", 9137}, {"rbrbrak", 10099}, {"rBrack", 10215}, {"rangle", 10217}, {"rAngle", 10219}, {"rgroup", 10223}, {"rBrace", 10628}, {"rParen", 10630}, {"vert", 124}, {"Vert", 8214}, {"|", 8214}, {"Vvert", 10624}, {"uparrow", 8593}, {"downarrow", 8595}, {"updownarrow", 8597}, {"Uparrow", 8657}, {"Downarrow", 8659}, {"Updownarrow", 8661}, {"Uuparrow", 10506}, {"Ddownarrow", 10507}, {"UUparrow", 10224}, {"DDownarrow", 10225}};
    private static final Object[][] OTHER_BRACES = new Object[][]{{"ulcorner", 8988}, {"urcorner", 8989}, {"llcorner", 8990}, {"lrcorner", 8991}, {"Lbrbrak", 10220}, {"Rbrbrak", 10221}, {"llparenthesis", 10631}, {"rrparenthesis", 10632}, {"llangle", 10633}, {"rrangle", 10634}, {"lbrackubar", 10635}, {"rbrackubar", 10636}, {"lbrackultick", 10637}, {"rbracklrtick", 10638}, {"lbracklltick", 10639}, {"rbrackurtick", 10640}, {"langledot", 10641}, {"rangledot", 10642}, {"lparenless", 10643}, {"rparengtr", 10644}, {"Lparengtr", 10645}, {"Rparenless", 10646}, {"lblkbrbrak", 10647}, {"rblkbrbrak", 10648}, {"lvzigzag", 10712}, {"rvzigzag", 10713}, {"Lvzigzag", 10714}, {"Rvzigzag", 10715}, {"lcurvyangle", 10748}, {"rcurvyangle", 10749}, {"lbrbrak", 10098}, {"rbrbrak", 10099}, {"lbag", 10181}, {"rbag", 10182}, {"Lbrbrak", 10220}, {"Rbrbrak", 10221}};
    private static final Object[][] ACCENTS = new Object[][]{{"grave", 768}, {"acute", 769}, {"hat", 770}, {"tilde", 771}, {"bar", 772}, {"breve", 774}, {"dot", 775}, {"ddot", 776}, {"ovhook", 777}, {"mathring", 778}, {"check", 780}, {"candra", 784}, {"oturnedcomma", 786}, {"ocommatopright", 789}, {"droang", 794}, {"leftharpoonaccent", 8400}, {"rightharpoonaccent", 8401}, {"leftarrowaccent", 8406}, {"vec", 8407}, {"rightarrowaccent", 8407}, {"leftrightarrowaccent", 8417}, {"dddot", 8411}, {"ddddot", 8412}, {"annuity", 8423}, {"widebridgeabove", 8425}, {"asteraccent", 8432}};
    private static final Object[][] WIDE_ACCENTS = new Object[][]{{"widehat", 770}, {"widetilde", 771}, {"widecheck", 780}, {"overleftarrow", 8406}, {"overrightarrow", 8407}, {"underrightarrow", 8431}, {"underleftarrow", 8430}, {"overleftrightarrow", 8417}, {"underleftrightarrow", 845}, {"overleftharpoon", 8400}, {"overrightharpoon", 8401}, {"underleftharpoon", 8428}, {"underrightharpoon", 8429}};
    private static final Object[][] WIDE_BRACKETS = new Object[][]{{"overbracket", 9140}, {"overparen", 9180}, {"overbrace", 9182}, {"underbracket", 9141}, {"underparen", 9181}, {"underbrace", 9183}};
    private static final Object[][] RADICALS = new Object[][]{{"sqrt", 8730}, {"longdivision", 10188}};

    public StixSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, "stix", laTeXParserListener, bl);
    }

    @Override
    public void addDefinitions() {
        int n;
        LaTeXParserListener laTeXParserListener = this.getListener();
        for (n = 0; n < GREEK.length; ++n) {
            this.registerControlSequence(laTeXParserListener.createGreekSymbol((String)GREEK[n][0], (Integer)GREEK[n][1]));
        }
        for (n = 0; n < ALPHABETICS.length; ++n) {
            this.registerControlSequence(laTeXParserListener.createMathSymbol((String)ALPHABETICS[n][0], (Integer)ALPHABETICS[n][1]));
        }
        for (n = 0; n < ORDINARY.length; ++n) {
            this.registerControlSequence(laTeXParserListener.createMathSymbol((String)ORDINARY[n][0], (Integer)ORDINARY[n][1]));
        }
        for (n = 0; n < BINARY.length; ++n) {
            this.registerControlSequence(laTeXParserListener.createBinarySymbol((String)BINARY[n][0], (Integer)BINARY[n][1]));
        }
        for (n = 0; n < PUNCTUATION.length; ++n) {
            this.registerControlSequence(laTeXParserListener.createMathSymbol((String)PUNCTUATION[n][0], (Integer)PUNCTUATION[n][1]));
        }
        for (n = 0; n < SMALL_INTEGRALS.length; ++n) {
            this.registerControlSequence(laTeXParserListener.createMathSymbol((String)SMALL_INTEGRALS[n][0], (Integer)SMALL_INTEGRALS[n][1]));
        }
        for (n = 0; n < INTEGRALS.length; ++n) {
            this.registerControlSequence(laTeXParserListener.createBigOperator((String)INTEGRALS[n][0], (Integer)INTEGRALS[n][1]));
        }
        for (n = 0; n < BIG_OPERATORS.length; ++n) {
            this.registerControlSequence(laTeXParserListener.createBigOperator((String)BIG_OPERATORS[n][0], (Integer)BIG_OPERATORS[n][1]));
        }
        for (n = 0; n < DELIMITERS.length; ++n) {
            this.registerControlSequence(laTeXParserListener.createBigOperator((String)DELIMITERS[n][0], (Integer)DELIMITERS[n][1]));
        }
        for (n = 0; n < OTHER_BRACES.length; ++n) {
            this.registerControlSequence(laTeXParserListener.createMathSymbol((String)OTHER_BRACES[n][0], (Integer)OTHER_BRACES[n][1]));
        }
        for (n = 0; n < ACCENTS.length; ++n) {
            this.registerControlSequence(new MathAccent((String)ACCENTS[n][0], (Integer)ACCENTS[n][1]));
        }
        for (n = 0; n < WIDE_ACCENTS.length; ++n) {
            this.registerControlSequence(new MathAccent((String)WIDE_ACCENTS[n][0], (Integer)WIDE_ACCENTS[n][1]));
        }
        for (n = 0; n < WIDE_BRACKETS.length; ++n) {
            this.registerControlSequence(new MathAccent((String)WIDE_BRACKETS[n][0], (Integer)WIDE_BRACKETS[n][1]));
        }
        for (n = 0; n < RADICALS.length; ++n) {
            this.registerControlSequence(new MathAccent((String)RADICALS[n][0], (Integer)RADICALS[n][1]));
        }
    }
}

