/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.CsvList;
import java.io.IOException;

public class GlsSeeRecord {
    private String label;
    private String tag = null;
    private String[] xrLabels;

    public GlsSeeRecord(TeXObject teXObject, TeXObject teXObject2, TeXParser teXParser) throws IOException {
        if (teXObject == null || teXObject2 == null) {
            throw new NullPointerException();
        }
        this.label = teXObject.toString(teXParser);
        this.init(teXObject2, teXParser);
    }

    private void init(TeXObject teXObject, TeXParser teXParser) throws IOException {
        if (!(teXObject instanceof TeXObjectList)) {
            this.xrLabels = new String[1];
            this.xrLabels[0] = teXObject.toString(teXParser);
            return;
        }
        TeXObjectList teXObjectList = (TeXObjectList)teXObject;
        TeXObject teXObject2 = teXObjectList.popArg(teXParser, 91, 93);
        if (teXObject2 != null) {
            this.tag = teXObject2.toString(teXParser);
        }
        CsvList csvList = CsvList.getList(teXParser, teXObjectList);
        int n = csvList.size();
        this.xrLabels = new String[n];
        for (int i = 0; i < n; ++i) {
            this.xrLabels[i] = csvList.getValue(i).toString(teXParser);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getTag() {
        return this.tag;
    }

    public String[] getXrLabels() {
        return this.xrLabels;
    }

    public String toString() {
        return String.format("CrossRef[label=%s,tag=%s,n=%d]", this.label, this.tag, this.xrLabels.length);
    }
}

