// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32f411.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32f411

/*
// STM32F411
*/

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32F411"
	CPU          = "CM4"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Window watchdog
	IRQ_WWDG = 0

	// Window watchdog
	IRQ_PVD = 1

	// External interrupt/event controller
	IRQ_TAMP_STAMP = 2

	// DMA controller
	IRQ_RTC_WKUP = 3

	// FLASH
	IRQ_FLASH = 4

	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	// DMA controller
	IRQ_DMA1_Stream0 = 11

	// DMA controller
	IRQ_DMA1_Stream1 = 12

	// DMA controller
	IRQ_DMA1_Stream2 = 13

	// DMA controller
	IRQ_DMA1_Stream3 = 14

	// DMA controller
	IRQ_DMA1_Stream4 = 15

	// DMA controller
	IRQ_DMA1_Stream5 = 16

	// DMA controller
	IRQ_DMA1_Stream6 = 17

	// Analog-to-digital converter
	IRQ_ADC = 18

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	IRQ_TIM1_BRK_TIM9 = 24

	IRQ_TIM1_UP_TIM10 = 25

	// General-purpose I/Os //
	IRQ_TIM1_TRG_COM_TIM11 = 26

	IRQ_TIM1_CC = 27

	// General-purpose I/Os
	IRQ_TIM2 = 28

	IRQ_TIM3 = 29

	// General purpose timers
	IRQ_TIM4 = 30

	// Reset and clock control //
	IRQ_I2C1_EV = 31

	// Reset and clock control //
	IRQ_I2C1_ER = 32

	// Real-time clock // Inter-integrated circuit
	IRQ_I2C2_EV = 33

	// Real-time clock // Inter-integrated circuit
	IRQ_I2C2_ER = 34

	// General-purpose-timers //
	IRQ_SPI1 = 35

	// General-purpose-timers //
	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 37

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART2 = 38

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// DMA controller
	IRQ_RTC_Alarm = 41

	// Universal synchronous asynchronous receiver transmitter
	IRQ_OTG_FS_WKUP = 42

	// DMA controller
	IRQ_DMA1_Stream7 = 47

	// General-purpose I/Os
	IRQ_SDIO = 49

	// General-purpose-timers
	IRQ_TIM5 = 50

	// General purpose timers //
	IRQ_SPI3 = 51

	// DMA controller
	IRQ_DMA2_Stream0 = 56

	// DMA controller
	IRQ_DMA2_Stream1 = 57

	// DMA controller
	IRQ_DMA2_Stream2 = 58

	// DMA controller
	IRQ_DMA2_Stream3 = 59

	// DMA controller
	IRQ_DMA2_Stream4 = 60

	// Universal synchronous asynchronous receiver transmitter
	IRQ_OTG_FS = 67

	// DMA controller
	IRQ_DMA2_Stream5 = 68

	// DMA controller
	IRQ_DMA2_Stream6 = 69

	// DMA controller
	IRQ_DMA2_Stream7 = 70

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART6 = 71

	// Secure digital input/output interface //
	IRQ_I2C3_EV = 72

	// Secure digital input/output interface //
	IRQ_I2C3_ER = 73

	// ADC common registers // Floting point unit
	IRQ_FPU = 81

	// General purpose timers
	IRQ_SPI4 = 84

	// Serial peripheral interface
	IRQ_SPI5 = 85

	// Highest interrupt number on this device.
	IRQ_max = 85
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_IRQHandler
func interruptPVD() {
	callHandlers(IRQ_PVD)
}

//export TAMP_STAMP_IRQHandler
func interruptTAMP_STAMP() {
	callHandlers(IRQ_TAMP_STAMP)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA1_Stream0_IRQHandler
func interruptDMA1_Stream0() {
	callHandlers(IRQ_DMA1_Stream0)
}

//export DMA1_Stream1_IRQHandler
func interruptDMA1_Stream1() {
	callHandlers(IRQ_DMA1_Stream1)
}

//export DMA1_Stream2_IRQHandler
func interruptDMA1_Stream2() {
	callHandlers(IRQ_DMA1_Stream2)
}

//export DMA1_Stream3_IRQHandler
func interruptDMA1_Stream3() {
	callHandlers(IRQ_DMA1_Stream3)
}

//export DMA1_Stream4_IRQHandler
func interruptDMA1_Stream4() {
	callHandlers(IRQ_DMA1_Stream4)
}

//export DMA1_Stream5_IRQHandler
func interruptDMA1_Stream5() {
	callHandlers(IRQ_DMA1_Stream5)
}

//export DMA1_Stream6_IRQHandler
func interruptDMA1_Stream6() {
	callHandlers(IRQ_DMA1_Stream6)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM1_BRK_TIM9_IRQHandler
func interruptTIM1_BRK_TIM9() {
	callHandlers(IRQ_TIM1_BRK_TIM9)
}

//export TIM1_UP_TIM10_IRQHandler
func interruptTIM1_UP_TIM10() {
	callHandlers(IRQ_TIM1_UP_TIM10)
}

//export TIM1_TRG_COM_TIM11_IRQHandler
func interruptTIM1_TRG_COM_TIM11() {
	callHandlers(IRQ_TIM1_TRG_COM_TIM11)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export I2C1_EV_IRQHandler
func interruptI2C1_EV() {
	callHandlers(IRQ_I2C1_EV)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C2_EV_IRQHandler
func interruptI2C2_EV() {
	callHandlers(IRQ_I2C2_EV)
}

//export I2C2_ER_IRQHandler
func interruptI2C2_ER() {
	callHandlers(IRQ_I2C2_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTC_Alarm_IRQHandler
func interruptRTC_Alarm() {
	callHandlers(IRQ_RTC_Alarm)
}

//export OTG_FS_WKUP_IRQHandler
func interruptOTG_FS_WKUP() {
	callHandlers(IRQ_OTG_FS_WKUP)
}

//export DMA1_Stream7_IRQHandler
func interruptDMA1_Stream7() {
	callHandlers(IRQ_DMA1_Stream7)
}

//export SDIO_IRQHandler
func interruptSDIO() {
	callHandlers(IRQ_SDIO)
}

//export TIM5_IRQHandler
func interruptTIM5() {
	callHandlers(IRQ_TIM5)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export DMA2_Stream0_IRQHandler
func interruptDMA2_Stream0() {
	callHandlers(IRQ_DMA2_Stream0)
}

//export DMA2_Stream1_IRQHandler
func interruptDMA2_Stream1() {
	callHandlers(IRQ_DMA2_Stream1)
}

//export DMA2_Stream2_IRQHandler
func interruptDMA2_Stream2() {
	callHandlers(IRQ_DMA2_Stream2)
}

//export DMA2_Stream3_IRQHandler
func interruptDMA2_Stream3() {
	callHandlers(IRQ_DMA2_Stream3)
}

//export DMA2_Stream4_IRQHandler
func interruptDMA2_Stream4() {
	callHandlers(IRQ_DMA2_Stream4)
}

//export OTG_FS_IRQHandler
func interruptOTG_FS() {
	callHandlers(IRQ_OTG_FS)
}

//export DMA2_Stream5_IRQHandler
func interruptDMA2_Stream5() {
	callHandlers(IRQ_DMA2_Stream5)
}

//export DMA2_Stream6_IRQHandler
func interruptDMA2_Stream6() {
	callHandlers(IRQ_DMA2_Stream6)
}

//export DMA2_Stream7_IRQHandler
func interruptDMA2_Stream7() {
	callHandlers(IRQ_DMA2_Stream7)
}

//export USART6_IRQHandler
func interruptUSART6() {
	callHandlers(IRQ_USART6)
}

//export I2C3_EV_IRQHandler
func interruptI2C3_EV() {
	callHandlers(IRQ_I2C3_EV)
}

//export I2C3_ER_IRQHandler
func interruptI2C3_ER() {
	callHandlers(IRQ_I2C3_ER)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export SPI4_IRQHandler
func interruptSPI4() {
	callHandlers(IRQ_SPI4)
}

//export SPI5_IRQHandler
func interruptSPI5() {
	callHandlers(IRQ_SPI5)
}

// Peripherals.
var (
	// ADC common registers
	ADC_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012300)))

	// Analog-to-digital converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012000)))

	// Cryptographic processor
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Debug support
	DBGMCU = (*DBG_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40013c00)))

	// FLASH
	FLASH = (*FLASH_Type)(unsafe.Pointer(uintptr(0x40023c00)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// USB on the go full speed
	OTG_FS_DEVICE = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// USB on the go full speed
	OTG_FS_GLOBAL = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// USB on the go full speed
	OTG_FS_HOST = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// USB on the go full speed
	OTG_FS_PWRCLK = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000e00)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40023800)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Secure digital input/output interface
	SDIO = (*SDIO_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// General-purpose-timers
	TIM10 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// General-purpose-timers
	TIM11 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// General purpose timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General purpose timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General-purpose-timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// General purpose timers
	TIM9 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// Window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// DMA controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021c00)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// General purpose timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART6 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011400)))

	// DMA controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026400)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020c00)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Serial peripheral interface
	I2S2ext = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003400)))

	// Serial peripheral interface
	I2S3ext = (*SPI_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Serial peripheral interface
	SPI4 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// Serial peripheral interface
	SPI5 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015000)))
)

// ADC common registers
type ADC_Type struct {
	_   [4]byte
	CCR volatile.Register32 // 0x4
}

// ADC.CCR: ADC common control register
func (o *ADC_Type) SetCCR_TSVREFE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCCR_TSVREFE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCCR_VBATE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCCR_VBATE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCCR_ADCPRE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetCCR_ADCPRE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x30000) >> 16
}

// Cryptographic processor
type CRC_Type struct {
	DR  volatile.Register32 // 0x0
	IDR volatile.Register32 // 0x4
	CR  volatile.Register32 // 0x8
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent Data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xff)|value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0xff
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// Debug support
type DBG_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB1_FZ volatile.Register32 // 0x8
	APB2_FZ volatile.Register32 // 0xC
}

// DBG.IDCODE: IDCODE
func (o *DBG_Type) SetIDCODE_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xfff)|value)
}
func (o *DBG_Type) GetIDCODE_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDCODE.Reg) & 0xfff
}
func (o *DBG_Type) SetIDCODE_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBG_Type) GetIDCODE_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff0000) >> 16
}

// DBG.CR: Control Register
func (o *DBG_Type) SetCR_DBG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetCR_DBG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DBG_Type) SetCR_DBG_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetCR_DBG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetCR_DBG_STANDBY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBG_Type) GetCR_DBG_STANDBY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBG_Type) SetCR_TRACE_IOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBG_Type) GetCR_TRACE_IOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBG_Type) SetCR_TRACE_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DBG_Type) GetCR_TRACE_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}

// DBG.APB1_FZ: Debug MCU APB1 Freeze registe
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM2_STOP() uint32 {
	return volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM4_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x4)|value<<2)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM4_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x4) >> 2
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM5_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x8)|value<<3)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM5_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x8) >> 3
}
func (o *DBG_Type) SetAPB1_FZ_DBG_RTC_Stop(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x400)|value<<10)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_RTC_Stop() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x400) >> 10
}
func (o *DBG_Type) SetAPB1_FZ_DBG_WWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x800)|value<<11)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_WWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x800) >> 11
}
func (o *DBG_Type) SetAPB1_FZ_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1000)|value<<12)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1000) >> 12
}
func (o *DBG_Type) SetAPB1_FZ_DBG_I2C1_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x200000)|value<<21)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_I2C1_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x200000) >> 21
}
func (o *DBG_Type) SetAPB1_FZ_DBG_I2C2_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x400000)|value<<22)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_I2C2_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x400000) >> 22
}
func (o *DBG_Type) SetAPB1_FZ_DBG_I2C3SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x800000)|value<<23)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_I2C3SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x800000) >> 23
}

// DBG.APB2_FZ: Debug MCU APB2 Freeze registe
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM1_STOP() uint32 {
	return volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x1
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM9_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x10000)|value<<16)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM9_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x10000) >> 16
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM10_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x20000)|value<<17)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM10_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x20000) >> 17
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM11_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x40000)|value<<18)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM11_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x40000) >> 18
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// EXTI.IMR: Interrupt mask register (EXTI_IMR)
func (o *EXTI_Type) SetIMR_MR0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR_MR0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR_MR1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR_MR1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR_MR2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR_MR2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR_MR3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR_MR3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR_MR4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR_MR4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR_MR5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR_MR5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR_MR6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR_MR6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR_MR7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR_MR7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR_MR8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR_MR8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR_MR9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR_MR9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR_MR10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR_MR10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR_MR11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR_MR11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR_MR12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR_MR12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR_MR13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR_MR13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR_MR14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR_MR14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR_MR15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR_MR15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR_MR16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR_MR16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetIMR_MR17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetIMR_MR17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetIMR_MR18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetIMR_MR18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetIMR_MR19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetIMR_MR19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetIMR_MR20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetIMR_MR20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetIMR_MR21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetIMR_MR21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetIMR_MR22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetIMR_MR22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}

// EXTI.EMR: Event mask register (EXTI_EMR)
func (o *EXTI_Type) SetEMR_MR0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR_MR0() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR_MR1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR_MR1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR_MR2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR_MR2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR_MR3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR_MR3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR_MR4(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR_MR4() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR_MR5(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR_MR5() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR_MR6(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR_MR6() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR_MR7(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetEMR_MR7() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetEMR_MR8(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR_MR8() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR_MR9(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR_MR9() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR_MR10(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR_MR10() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetEMR_MR11(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetEMR_MR11() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetEMR_MR12(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetEMR_MR12() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetEMR_MR13(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetEMR_MR13() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetEMR_MR14(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetEMR_MR14() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetEMR_MR15(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetEMR_MR15() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetEMR_MR16(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetEMR_MR16() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetEMR_MR17(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetEMR_MR17() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetEMR_MR18(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetEMR_MR18() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetEMR_MR19(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetEMR_MR19() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetEMR_MR20(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetEMR_MR20() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetEMR_MR21(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetEMR_MR21() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetEMR_MR22(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetEMR_MR22() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x400000) >> 22
}

// EXTI.RTSR: Rising Trigger selection register (EXTI_RTSR)
func (o *EXTI_Type) SetRTSR_TR0(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR_TR0() uint32 {
	return volatile.LoadUint32(&o.RTSR.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR_TR1(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR_TR1() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR_TR2(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR_TR2() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR_TR3(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR_TR3() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR_TR4(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR_TR4() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR_TR5(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR_TR5() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR_TR6(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR_TR6() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR_TR7(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR_TR7() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR_TR8(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR_TR8() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR_TR9(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR_TR9() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR_TR10(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR_TR10() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR_TR11(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR_TR11() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR_TR12(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR_TR12() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR_TR13(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR_TR13() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR_TR14(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR_TR14() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR_TR15(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR_TR15() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR_TR16(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR_TR16() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR_TR17(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR_TR17() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR_TR18(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR_TR18() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR_TR19(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR_TR19() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetRTSR_TR20(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR_TR20() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR_TR21(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR_TR21() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR_TR22(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR_TR22() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x400000) >> 22
}

// EXTI.FTSR: Falling Trigger selection register (EXTI_FTSR)
func (o *EXTI_Type) SetFTSR_TR0(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR_TR0() uint32 {
	return volatile.LoadUint32(&o.FTSR.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR_TR1(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR_TR1() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR_TR2(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR_TR2() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR_TR3(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR_TR3() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR_TR4(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR_TR4() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR_TR5(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR_TR5() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR_TR6(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR_TR6() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR_TR7(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR_TR7() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR_TR8(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR_TR8() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR_TR9(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR_TR9() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR_TR10(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR_TR10() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR_TR11(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR_TR11() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR_TR12(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR_TR12() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR_TR13(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR_TR13() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR_TR14(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR_TR14() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR_TR15(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR_TR15() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR_TR16(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR_TR16() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR_TR17(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR_TR17() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR_TR18(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR_TR18() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR_TR19(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR_TR19() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetFTSR_TR20(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR_TR20() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR_TR21(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR_TR21() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR_TR22(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR_TR22() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x400000) >> 22
}

// EXTI.SWIER: Software interrupt event register (EXTI_SWIER)
func (o *EXTI_Type) SetSWIER_SWIER0(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER_SWIER0() uint32 {
	return volatile.LoadUint32(&o.SWIER.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER_SWIER1(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER_SWIER1() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER_SWIER2(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER_SWIER2() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER_SWIER3(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER_SWIER3() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER_SWIER4(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER_SWIER4() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER_SWIER5(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER_SWIER5() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER_SWIER6(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER_SWIER6() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER_SWIER7(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER_SWIER7() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER_SWIER8(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER_SWIER8() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER_SWIER9(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER_SWIER9() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER_SWIER10(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER_SWIER10() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER_SWIER11(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER_SWIER11() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER_SWIER12(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER_SWIER12() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER_SWIER13(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER_SWIER13() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER_SWIER14(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER_SWIER14() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER_SWIER15(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER_SWIER15() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER_SWIER16(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER_SWIER16() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER_SWIER17(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER_SWIER17() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER_SWIER18(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER_SWIER18() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER_SWIER19(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER_SWIER19() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSWIER_SWIER20(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER_SWIER20() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER_SWIER21(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER_SWIER21() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER_SWIER22(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER_SWIER22() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x400000) >> 22
}

// EXTI.PR: Pending register (EXTI_PR)
func (o *EXTI_Type) SetPR_PR0(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR_PR0() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x1
}
func (o *EXTI_Type) SetPR_PR1(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR_PR1() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR_PR2(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPR_PR2() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPR_PR3(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPR_PR3() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPR_PR4(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPR_PR4() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPR_PR5(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPR_PR5() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPR_PR6(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPR_PR6() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPR_PR7(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPR_PR7() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPR_PR8(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR_PR8() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR_PR9(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR_PR9() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPR_PR10(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPR_PR10() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetPR_PR11(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetPR_PR11() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetPR_PR12(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetPR_PR12() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetPR_PR13(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPR_PR13() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetPR_PR14(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetPR_PR14() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetPR_PR15(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetPR_PR15() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetPR_PR16(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetPR_PR16() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetPR_PR17(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetPR_PR17() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetPR_PR18(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetPR_PR18() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetPR_PR19(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetPR_PR19() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetPR_PR20(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetPR_PR20() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetPR_PR21(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetPR_PR21() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetPR_PR22(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetPR_PR22() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x400000) >> 22
}

// FLASH
type FLASH_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	OPTCR   volatile.Register32 // 0x14
}

// FLASH.ACR: Flash access control register
func (o *FLASH_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xf)|value)
}
func (o *FLASH_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0xf
}
func (o *FLASH_Type) SetACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *FLASH_Type) GetACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *FLASH_Type) SetACR_ICEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *FLASH_Type) GetACR_ICEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *FLASH_Type) SetACR_DCEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x400)|value<<10)
}
func (o *FLASH_Type) GetACR_DCEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x400) >> 10
}
func (o *FLASH_Type) SetACR_ICRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x800)|value<<11)
}
func (o *FLASH_Type) GetACR_ICRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x800) >> 11
}
func (o *FLASH_Type) SetACR_DCRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1000)|value<<12)
}
func (o *FLASH_Type) GetACR_DCRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x1000) >> 12
}

// FLASH.KEYR: Flash key register
func (o *FLASH_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *FLASH_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// FLASH.OPTKEYR: Flash option key register
func (o *FLASH_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *FLASH_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// FLASH.SR: Status register
func (o *FLASH_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetSR_EOP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *FLASH_Type) SetSR_OPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetSR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *FLASH_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *FLASH_Type) SetSR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *FLASH_Type) GetSR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *FLASH_Type) SetSR_PGPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *FLASH_Type) GetSR_PGPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *FLASH_Type) SetSR_PGSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_Type) GetSR_PGSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *FLASH_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// FLASH.CR: Control register
func (o *FLASH_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetCR_PG() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *FLASH_Type) SetCR_SER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetCR_SER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetCR_MER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *FLASH_Type) GetCR_MER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *FLASH_Type) SetCR_SNB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x78)|value<<3)
}
func (o *FLASH_Type) GetCR_SNB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x78) >> 3
}
func (o *FLASH_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *FLASH_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *FLASH_Type) SetCR_STRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_Type) GetCR_STRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *FLASH_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *FLASH_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *FLASH_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *FLASH_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *FLASH_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_Type) GetCR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}

// FLASH.OPTCR: Flash option control register
func (o *FLASH_Type) SetOPTCR_OPTLOCK(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetOPTCR_OPTLOCK() uint32 {
	return volatile.LoadUint32(&o.OPTCR.Reg) & 0x1
}
func (o *FLASH_Type) SetOPTCR_OPTSTRT(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetOPTCR_OPTSTRT() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetOPTCR_BOR_LEV(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xc)|value<<2)
}
func (o *FLASH_Type) GetOPTCR_BOR_LEV() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xc) >> 2
}
func (o *FLASH_Type) SetOPTCR_WDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x20)|value<<5)
}
func (o *FLASH_Type) GetOPTCR_WDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x20) >> 5
}
func (o *FLASH_Type) SetOPTCR_NRST_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x40)|value<<6)
}
func (o *FLASH_Type) GetOPTCR_NRST_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x40) >> 6
}
func (o *FLASH_Type) SetOPTCR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_Type) GetOPTCR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x80) >> 7
}
func (o *FLASH_Type) SetOPTCR_RDP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xff00)|value<<8)
}
func (o *FLASH_Type) GetOPTCR_RDP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xff00) >> 8
}
func (o *FLASH_Type) SetOPTCR_NWRP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xfff0000)|value<<16)
}
func (o *FLASH_Type) GetOPTCR_NWRP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xfff0000) >> 16
}

// Independent watchdog
type IWDG_Type struct {
	KR  volatile.Register32 // 0x0
	PR  volatile.Register32 // 0x4
	RLR volatile.Register32 // 0x8
	SR  volatile.Register32 // 0xC
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// USB on the go full speed
type USB_OTG_FS_Type struct {
	DCFG       volatile.Register32 // 0x0
	DCTL       volatile.Register32 // 0x4
	DSTS       volatile.Register32 // 0x8
	_          [4]byte
	DIEPMSK    volatile.Register32 // 0x10
	DOEPMSK    volatile.Register32 // 0x14
	DAINT      volatile.Register32 // 0x18
	DAINTMSK   volatile.Register32 // 0x1C
	_          [8]byte
	DVBUSDIS   volatile.Register32 // 0x28
	DVBUSPULSE volatile.Register32 // 0x2C
	_          [4]byte
	DIEPEMPMSK volatile.Register32 // 0x34
	_          [200]byte
	DIEPCTL0   volatile.Register32 // 0x100
	_          [4]byte
	DIEPINT0   volatile.Register32 // 0x108
	_          [4]byte
	DIEPTSIZ0  volatile.Register32 // 0x110
	_          [4]byte
	DTXFSTS0   volatile.Register32 // 0x118
	_          [4]byte
	DIEPCTL1   volatile.Register32 // 0x120
	_          [4]byte
	DIEPINT1   volatile.Register32 // 0x128
	_          [4]byte
	DIEPTSIZ1  volatile.Register32 // 0x130
	_          [4]byte
	DTXFSTS1   volatile.Register32 // 0x138
	_          [4]byte
	DIEPCTL2   volatile.Register32 // 0x140
	_          [4]byte
	DIEPINT2   volatile.Register32 // 0x148
	_          [4]byte
	DIEPTSIZ2  volatile.Register32 // 0x150
	_          [4]byte
	DTXFSTS2   volatile.Register32 // 0x158
	_          [4]byte
	DIEPCTL3   volatile.Register32 // 0x160
	_          [4]byte
	DIEPINT3   volatile.Register32 // 0x168
	_          [4]byte
	DIEPTSIZ3  volatile.Register32 // 0x170
	_          [4]byte
	DTXFSTS3   volatile.Register32 // 0x178
	_          [388]byte
	DOEPCTL0   volatile.Register32 // 0x300
	_          [4]byte
	DOEPINT0   volatile.Register32 // 0x308
	_          [4]byte
	DOEPTSIZ0  volatile.Register32 // 0x310
	_          [12]byte
	DOEPCTL1   volatile.Register32 // 0x320
	_          [4]byte
	DOEPINT1   volatile.Register32 // 0x328
	_          [4]byte
	DOEPTSIZ1  volatile.Register32 // 0x330
	_          [12]byte
	DOEPCTL2   volatile.Register32 // 0x340
	_          [4]byte
	DOEPINT2   volatile.Register32 // 0x348
	_          [4]byte
	DOEPTSIZ2  volatile.Register32 // 0x350
	_          [12]byte
	DOEPCTL3   volatile.Register32 // 0x360
	_          [4]byte
	DOEPINT3   volatile.Register32 // 0x368
	_          [4]byte
	DOEPTSIZ3  volatile.Register32 // 0x370
}

// USB_OTG_FS.DCFG: OTG_FS device configuration register (OTG_FS_DCFG)
func (o *USB_OTG_FS_Type) SetDCFG_DSPD(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x3)|value)
}
func (o *USB_OTG_FS_Type) GetDCFG_DSPD() uint32 {
	return volatile.LoadUint32(&o.DCFG.Reg) & 0x3
}
func (o *USB_OTG_FS_Type) SetDCFG_NZLSOHSK(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetDCFG_NZLSOHSK() uint32 {
	return (volatile.LoadUint32(&o.DCFG.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetDCFG_DAD(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x7f0)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDCFG_DAD() uint32 {
	return (volatile.LoadUint32(&o.DCFG.Reg) & 0x7f0) >> 4
}
func (o *USB_OTG_FS_Type) SetDCFG_PFIVL(value uint32) {
	volatile.StoreUint32(&o.DCFG.Reg, volatile.LoadUint32(&o.DCFG.Reg)&^(0x1800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetDCFG_PFIVL() uint32 {
	return (volatile.LoadUint32(&o.DCFG.Reg) & 0x1800) >> 11
}

// USB_OTG_FS.DCTL: OTG_FS device control register (OTG_FS_DCTL)
func (o *USB_OTG_FS_Type) SetDCTL_RWUSIG(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDCTL_RWUSIG() uint32 {
	return volatile.LoadUint32(&o.DCTL.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetDCTL_SDIS(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDCTL_SDIS() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDCTL_GINSTS(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetDCTL_GINSTS() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetDCTL_GONSTS(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDCTL_GONSTS() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDCTL_TCTL(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x70)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDCTL_TCTL() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x70) >> 4
}
func (o *USB_OTG_FS_Type) SetDCTL_SGINAK(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetDCTL_SGINAK() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetDCTL_CGINAK(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetDCTL_CGINAK() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetDCTL_SGONAK(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetDCTL_SGONAK() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetDCTL_CGONAK(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetDCTL_CGONAK() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetDCTL_POPRGDNE(value uint32) {
	volatile.StoreUint32(&o.DCTL.Reg, volatile.LoadUint32(&o.DCTL.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetDCTL_POPRGDNE() uint32 {
	return (volatile.LoadUint32(&o.DCTL.Reg) & 0x800) >> 11
}

// USB_OTG_FS.DSTS: OTG_FS device status register (OTG_FS_DSTS)
func (o *USB_OTG_FS_Type) SetDSTS_SUSPSTS(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDSTS_SUSPSTS() uint32 {
	return volatile.LoadUint32(&o.DSTS.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetDSTS_ENUMSPD(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0x6)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDSTS_ENUMSPD() uint32 {
	return (volatile.LoadUint32(&o.DSTS.Reg) & 0x6) >> 1
}
func (o *USB_OTG_FS_Type) SetDSTS_EERR(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDSTS_EERR() uint32 {
	return (volatile.LoadUint32(&o.DSTS.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDSTS_FNSOF(value uint32) {
	volatile.StoreUint32(&o.DSTS.Reg, volatile.LoadUint32(&o.DSTS.Reg)&^(0x3fff00)|value<<8)
}
func (o *USB_OTG_FS_Type) GetDSTS_FNSOF() uint32 {
	return (volatile.LoadUint32(&o.DSTS.Reg) & 0x3fff00) >> 8
}

// USB_OTG_FS.DIEPMSK: OTG_FS device IN endpoint common interrupt mask register (OTG_FS_DIEPMSK)
func (o *USB_OTG_FS_Type) SetDIEPMSK_XFRCM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPMSK_XFRCM() uint32 {
	return volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetDIEPMSK_EPDM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDIEPMSK_EPDM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDIEPMSK_TOM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDIEPMSK_TOM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDIEPMSK_ITTXFEMSK(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDIEPMSK_ITTXFEMSK() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDIEPMSK_INEPNMM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetDIEPMSK_INEPNMM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetDIEPMSK_INEPNEM(value uint32) {
	volatile.StoreUint32(&o.DIEPMSK.Reg, volatile.LoadUint32(&o.DIEPMSK.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDIEPMSK_INEPNEM() uint32 {
	return (volatile.LoadUint32(&o.DIEPMSK.Reg) & 0x40) >> 6
}

// USB_OTG_FS.DOEPMSK: OTG_FS device OUT endpoint common interrupt mask register (OTG_FS_DOEPMSK)
func (o *USB_OTG_FS_Type) SetDOEPMSK_XFRCM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPMSK_XFRCM() uint32 {
	return volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetDOEPMSK_EPDM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDOEPMSK_EPDM() uint32 {
	return (volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDOEPMSK_STUPM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDOEPMSK_STUPM() uint32 {
	return (volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDOEPMSK_OTEPDM(value uint32) {
	volatile.StoreUint32(&o.DOEPMSK.Reg, volatile.LoadUint32(&o.DOEPMSK.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDOEPMSK_OTEPDM() uint32 {
	return (volatile.LoadUint32(&o.DOEPMSK.Reg) & 0x10) >> 4
}

// USB_OTG_FS.DAINT: OTG_FS device all endpoints interrupt register (OTG_FS_DAINT)
func (o *USB_OTG_FS_Type) SetDAINT_IEPINT(value uint32) {
	volatile.StoreUint32(&o.DAINT.Reg, volatile.LoadUint32(&o.DAINT.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDAINT_IEPINT() uint32 {
	return volatile.LoadUint32(&o.DAINT.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetDAINT_OEPINT(value uint32) {
	volatile.StoreUint32(&o.DAINT.Reg, volatile.LoadUint32(&o.DAINT.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDAINT_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.DAINT.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.DAINTMSK: OTG_FS all endpoints interrupt mask register (OTG_FS_DAINTMSK)
func (o *USB_OTG_FS_Type) SetDAINTMSK_IEPM(value uint32) {
	volatile.StoreUint32(&o.DAINTMSK.Reg, volatile.LoadUint32(&o.DAINTMSK.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDAINTMSK_IEPM() uint32 {
	return volatile.LoadUint32(&o.DAINTMSK.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetDAINTMSK_OEPM(value uint32) {
	volatile.StoreUint32(&o.DAINTMSK.Reg, volatile.LoadUint32(&o.DAINTMSK.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDAINTMSK_OEPM() uint32 {
	return (volatile.LoadUint32(&o.DAINTMSK.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.DVBUSDIS: OTG_FS device VBUS discharge time register
func (o *USB_OTG_FS_Type) SetDVBUSDIS_VBUSDT(value uint32) {
	volatile.StoreUint32(&o.DVBUSDIS.Reg, volatile.LoadUint32(&o.DVBUSDIS.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDVBUSDIS_VBUSDT() uint32 {
	return volatile.LoadUint32(&o.DVBUSDIS.Reg) & 0xffff
}

// USB_OTG_FS.DVBUSPULSE: OTG_FS device VBUS pulsing time register
func (o *USB_OTG_FS_Type) SetDVBUSPULSE_DVBUSP(value uint32) {
	volatile.StoreUint32(&o.DVBUSPULSE.Reg, volatile.LoadUint32(&o.DVBUSPULSE.Reg)&^(0xfff)|value)
}
func (o *USB_OTG_FS_Type) GetDVBUSPULSE_DVBUSP() uint32 {
	return volatile.LoadUint32(&o.DVBUSPULSE.Reg) & 0xfff
}

// USB_OTG_FS.DIEPEMPMSK: OTG_FS device IN endpoint FIFO empty interrupt mask register
func (o *USB_OTG_FS_Type) SetDIEPEMPMSK_INEPTXFEM(value uint32) {
	volatile.StoreUint32(&o.DIEPEMPMSK.Reg, volatile.LoadUint32(&o.DIEPEMPMSK.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPEMPMSK_INEPTXFEM() uint32 {
	return volatile.LoadUint32(&o.DIEPEMPMSK.Reg) & 0xffff
}

// USB_OTG_FS.DIEPCTL0: OTG_FS device control IN endpoint 0 control register (OTG_FS_DIEPCTL0)
func (o *USB_OTG_FS_Type) SetDIEPCTL0_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x3)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x3
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_STALL(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_STALL() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDIEPCTL0_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL0.Reg, volatile.LoadUint32(&o.DIEPCTL0.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL0_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL0.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.DIEPINT0: device endpoint-x interrupt register
func (o *USB_OTG_FS_Type) SetDIEPINT0_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetDIEPINT0_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetDIEPINT0_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDIEPINT0_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDIEPINT0_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDIEPINT0_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDIEPINT0_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDIEPINT0_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDIEPINT0_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDIEPINT0_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDIEPINT0_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT0.Reg, volatile.LoadUint32(&o.DIEPINT0.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPINT0_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT0.Reg) & 0x1
}

// USB_OTG_FS.DIEPTSIZ0: device endpoint-0 transfer size register
func (o *USB_OTG_FS_Type) SetDIEPTSIZ0_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ0.Reg, volatile.LoadUint32(&o.DIEPTSIZ0.Reg)&^(0x180000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ0_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ0.Reg) & 0x180000) >> 19
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ0_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ0.Reg, volatile.LoadUint32(&o.DIEPTSIZ0.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ0_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ0.Reg) & 0x7f
}

// USB_OTG_FS.DTXFSTS0: OTG_FS device IN endpoint transmit FIFO status register
func (o *USB_OTG_FS_Type) SetDTXFSTS0_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS0.Reg, volatile.LoadUint32(&o.DTXFSTS0.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDTXFSTS0_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS0.Reg) & 0xffff
}

// USB_OTG_FS.DIEPCTL1: OTG device endpoint-1 control register
func (o *USB_OTG_FS_Type) SetDIEPCTL1_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_SODDFRM_SD1PID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_SODDFRM_SD1PID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_STALL(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_STALL() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDIEPCTL1_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL1.Reg, volatile.LoadUint32(&o.DIEPCTL1.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL1_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL1.Reg) & 0x7ff
}

// USB_OTG_FS.DIEPINT1: device endpoint-1 interrupt register
func (o *USB_OTG_FS_Type) SetDIEPINT1_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetDIEPINT1_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetDIEPINT1_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDIEPINT1_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDIEPINT1_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDIEPINT1_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDIEPINT1_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDIEPINT1_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDIEPINT1_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDIEPINT1_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDIEPINT1_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT1.Reg, volatile.LoadUint32(&o.DIEPINT1.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPINT1_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT1.Reg) & 0x1
}

// USB_OTG_FS.DIEPTSIZ1: device endpoint-1 transfer size register
func (o *USB_OTG_FS_Type) SetDIEPTSIZ1_MCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ1.Reg, volatile.LoadUint32(&o.DIEPTSIZ1.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ1_MCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ1.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ1_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ1.Reg, volatile.LoadUint32(&o.DIEPTSIZ1.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ1_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ1.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ1_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ1.Reg, volatile.LoadUint32(&o.DIEPTSIZ1.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ1_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ1.Reg) & 0x7ffff
}

// USB_OTG_FS.DTXFSTS1: OTG_FS device IN endpoint transmit FIFO status register
func (o *USB_OTG_FS_Type) SetDTXFSTS1_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS1.Reg, volatile.LoadUint32(&o.DTXFSTS1.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDTXFSTS1_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS1.Reg) & 0xffff
}

// USB_OTG_FS.DIEPCTL2: OTG device endpoint-1 control register
func (o *USB_OTG_FS_Type) SetDIEPCTL2_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_SODDFRM_SD1PID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_SODDFRM_SD1PID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_STALL(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_STALL() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDIEPCTL2_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL2.Reg, volatile.LoadUint32(&o.DIEPCTL2.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL2_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL2.Reg) & 0x7ff
}

// USB_OTG_FS.DIEPINT2: device endpoint-2 interrupt register
func (o *USB_OTG_FS_Type) SetDIEPINT2_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetDIEPINT2_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetDIEPINT2_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDIEPINT2_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDIEPINT2_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDIEPINT2_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDIEPINT2_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDIEPINT2_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDIEPINT2_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDIEPINT2_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDIEPINT2_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT2.Reg, volatile.LoadUint32(&o.DIEPINT2.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPINT2_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT2.Reg) & 0x1
}

// USB_OTG_FS.DIEPTSIZ2: device endpoint-2 transfer size register
func (o *USB_OTG_FS_Type) SetDIEPTSIZ2_MCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ2.Reg, volatile.LoadUint32(&o.DIEPTSIZ2.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ2_MCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ2.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ2_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ2.Reg, volatile.LoadUint32(&o.DIEPTSIZ2.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ2_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ2.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ2_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ2.Reg, volatile.LoadUint32(&o.DIEPTSIZ2.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ2_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ2.Reg) & 0x7ffff
}

// USB_OTG_FS.DTXFSTS2: OTG_FS device IN endpoint transmit FIFO status register
func (o *USB_OTG_FS_Type) SetDTXFSTS2_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS2.Reg, volatile.LoadUint32(&o.DTXFSTS2.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDTXFSTS2_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS2.Reg) & 0xffff
}

// USB_OTG_FS.DIEPCTL3: OTG device endpoint-1 control register
func (o *USB_OTG_FS_Type) SetDIEPCTL3_EPENA(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_SODDFRM_SD1PID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_SODDFRM_SD1PID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_SNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_CNAK(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x3c00000)|value<<22)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x3c00000) >> 22
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_STALL(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_STALL() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDIEPCTL3_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPCTL3.Reg, volatile.LoadUint32(&o.DIEPCTL3.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPCTL3_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPCTL3.Reg) & 0x7ff
}

// USB_OTG_FS.DIEPINT3: device endpoint-3 interrupt register
func (o *USB_OTG_FS_Type) SetDIEPINT3_TXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetDIEPINT3_TXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetDIEPINT3_INEPNE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDIEPINT3_INEPNE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDIEPINT3_ITTXFE(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDIEPINT3_ITTXFE() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDIEPINT3_TOC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDIEPINT3_TOC() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDIEPINT3_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDIEPINT3_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDIEPINT3_XFRC(value uint32) {
	volatile.StoreUint32(&o.DIEPINT3.Reg, volatile.LoadUint32(&o.DIEPINT3.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPINT3_XFRC() uint32 {
	return volatile.LoadUint32(&o.DIEPINT3.Reg) & 0x1
}

// USB_OTG_FS.DIEPTSIZ3: device endpoint-3 transfer size register
func (o *USB_OTG_FS_Type) SetDIEPTSIZ3_MCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ3.Reg, volatile.LoadUint32(&o.DIEPTSIZ3.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ3_MCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ3.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ3_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ3.Reg, volatile.LoadUint32(&o.DIEPTSIZ3.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ3_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DIEPTSIZ3.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDIEPTSIZ3_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DIEPTSIZ3.Reg, volatile.LoadUint32(&o.DIEPTSIZ3.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_FS_Type) GetDIEPTSIZ3_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DIEPTSIZ3.Reg) & 0x7ffff
}

// USB_OTG_FS.DTXFSTS3: OTG_FS device IN endpoint transmit FIFO status register
func (o *USB_OTG_FS_Type) SetDTXFSTS3_INEPTFSAV(value uint32) {
	volatile.StoreUint32(&o.DTXFSTS3.Reg, volatile.LoadUint32(&o.DTXFSTS3.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetDTXFSTS3_INEPTFSAV() uint32 {
	return volatile.LoadUint32(&o.DTXFSTS3.Reg) & 0xffff
}

// USB_OTG_FS.DOEPCTL0: device endpoint-0 control register
func (o *USB_OTG_FS_Type) SetDOEPCTL0_EPENA(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_SNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_CNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_STALL(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_STALL() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_SNPM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_SNPM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDOEPCTL0_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL0.Reg, volatile.LoadUint32(&o.DOEPCTL0.Reg)&^(0x3)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL0_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPCTL0.Reg) & 0x3
}

// USB_OTG_FS.DOEPINT0: device endpoint-0 interrupt register
func (o *USB_OTG_FS_Type) SetDOEPINT0_B2BSTUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT0.Reg, volatile.LoadUint32(&o.DOEPINT0.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDOEPINT0_B2BSTUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT0.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDOEPINT0_OTEPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPINT0.Reg, volatile.LoadUint32(&o.DOEPINT0.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDOEPINT0_OTEPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT0.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDOEPINT0_STUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT0.Reg, volatile.LoadUint32(&o.DOEPINT0.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDOEPINT0_STUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT0.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDOEPINT0_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DOEPINT0.Reg, volatile.LoadUint32(&o.DOEPINT0.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDOEPINT0_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT0.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDOEPINT0_XFRC(value uint32) {
	volatile.StoreUint32(&o.DOEPINT0.Reg, volatile.LoadUint32(&o.DOEPINT0.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPINT0_XFRC() uint32 {
	return volatile.LoadUint32(&o.DOEPINT0.Reg) & 0x1
}

// USB_OTG_FS.DOEPTSIZ0: device OUT endpoint-0 transfer size register
func (o *USB_OTG_FS_Type) SetDOEPTSIZ0_STUPCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ0.Reg, volatile.LoadUint32(&o.DOEPTSIZ0.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ0_STUPCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ0.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ0_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ0.Reg, volatile.LoadUint32(&o.DOEPTSIZ0.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ0_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ0.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ0_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ0.Reg, volatile.LoadUint32(&o.DOEPTSIZ0.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ0_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPTSIZ0.Reg) & 0x7f
}

// USB_OTG_FS.DOEPCTL1: device endpoint-1 control register
func (o *USB_OTG_FS_Type) SetDOEPCTL1_EPENA(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_SNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_CNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_STALL(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_STALL() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_SNPM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_SNPM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDOEPCTL1_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL1.Reg, volatile.LoadUint32(&o.DOEPCTL1.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL1_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPCTL1.Reg) & 0x7ff
}

// USB_OTG_FS.DOEPINT1: device endpoint-1 interrupt register
func (o *USB_OTG_FS_Type) SetDOEPINT1_B2BSTUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT1.Reg, volatile.LoadUint32(&o.DOEPINT1.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDOEPINT1_B2BSTUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT1.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDOEPINT1_OTEPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPINT1.Reg, volatile.LoadUint32(&o.DOEPINT1.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDOEPINT1_OTEPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT1.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDOEPINT1_STUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT1.Reg, volatile.LoadUint32(&o.DOEPINT1.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDOEPINT1_STUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT1.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDOEPINT1_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DOEPINT1.Reg, volatile.LoadUint32(&o.DOEPINT1.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDOEPINT1_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT1.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDOEPINT1_XFRC(value uint32) {
	volatile.StoreUint32(&o.DOEPINT1.Reg, volatile.LoadUint32(&o.DOEPINT1.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPINT1_XFRC() uint32 {
	return volatile.LoadUint32(&o.DOEPINT1.Reg) & 0x1
}

// USB_OTG_FS.DOEPTSIZ1: device OUT endpoint-1 transfer size register
func (o *USB_OTG_FS_Type) SetDOEPTSIZ1_RXDPID_STUPCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ1.Reg, volatile.LoadUint32(&o.DOEPTSIZ1.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ1_RXDPID_STUPCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ1.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ1_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ1.Reg, volatile.LoadUint32(&o.DOEPTSIZ1.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ1_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ1.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ1_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ1.Reg, volatile.LoadUint32(&o.DOEPTSIZ1.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ1_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPTSIZ1.Reg) & 0x7ffff
}

// USB_OTG_FS.DOEPCTL2: device endpoint-1 control register
func (o *USB_OTG_FS_Type) SetDOEPCTL2_EPENA(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_SNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_CNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_STALL(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_STALL() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_SNPM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_SNPM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDOEPCTL2_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL2.Reg, volatile.LoadUint32(&o.DOEPCTL2.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL2_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPCTL2.Reg) & 0x7ff
}

// USB_OTG_FS.DOEPINT2: device endpoint-2 interrupt register
func (o *USB_OTG_FS_Type) SetDOEPINT2_B2BSTUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT2.Reg, volatile.LoadUint32(&o.DOEPINT2.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDOEPINT2_B2BSTUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT2.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDOEPINT2_OTEPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPINT2.Reg, volatile.LoadUint32(&o.DOEPINT2.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDOEPINT2_OTEPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT2.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDOEPINT2_STUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT2.Reg, volatile.LoadUint32(&o.DOEPINT2.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDOEPINT2_STUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT2.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDOEPINT2_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DOEPINT2.Reg, volatile.LoadUint32(&o.DOEPINT2.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDOEPINT2_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT2.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDOEPINT2_XFRC(value uint32) {
	volatile.StoreUint32(&o.DOEPINT2.Reg, volatile.LoadUint32(&o.DOEPINT2.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPINT2_XFRC() uint32 {
	return volatile.LoadUint32(&o.DOEPINT2.Reg) & 0x1
}

// USB_OTG_FS.DOEPTSIZ2: device OUT endpoint-2 transfer size register
func (o *USB_OTG_FS_Type) SetDOEPTSIZ2_RXDPID_STUPCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ2.Reg, volatile.LoadUint32(&o.DOEPTSIZ2.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ2_RXDPID_STUPCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ2.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ2_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ2.Reg, volatile.LoadUint32(&o.DOEPTSIZ2.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ2_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ2.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ2_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ2.Reg, volatile.LoadUint32(&o.DOEPTSIZ2.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ2_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPTSIZ2.Reg) & 0x7ffff
}

// USB_OTG_FS.DOEPCTL3: device endpoint-1 control register
func (o *USB_OTG_FS_Type) SetDOEPCTL3_EPENA(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_EPENA() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_EPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_EPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_SODDFRM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_SODDFRM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_SD0PID_SEVNFRM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_SD0PID_SEVNFRM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_SNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_SNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x8000000) >> 27
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_CNAK(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_CNAK() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_STALL(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_STALL() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_SNPM(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_SNPM() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_EPTYP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_NAKSTS(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_NAKSTS() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_EONUM_DPID(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_EONUM_DPID() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_USBAEP(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_USBAEP() uint32 {
	return (volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetDOEPCTL3_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPCTL3.Reg, volatile.LoadUint32(&o.DOEPCTL3.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPCTL3_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPCTL3.Reg) & 0x7ff
}

// USB_OTG_FS.DOEPINT3: device endpoint-3 interrupt register
func (o *USB_OTG_FS_Type) SetDOEPINT3_B2BSTUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT3.Reg, volatile.LoadUint32(&o.DOEPINT3.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetDOEPINT3_B2BSTUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT3.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetDOEPINT3_OTEPDIS(value uint32) {
	volatile.StoreUint32(&o.DOEPINT3.Reg, volatile.LoadUint32(&o.DOEPINT3.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetDOEPINT3_OTEPDIS() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT3.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetDOEPINT3_STUP(value uint32) {
	volatile.StoreUint32(&o.DOEPINT3.Reg, volatile.LoadUint32(&o.DOEPINT3.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetDOEPINT3_STUP() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT3.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetDOEPINT3_EPDISD(value uint32) {
	volatile.StoreUint32(&o.DOEPINT3.Reg, volatile.LoadUint32(&o.DOEPINT3.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetDOEPINT3_EPDISD() uint32 {
	return (volatile.LoadUint32(&o.DOEPINT3.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetDOEPINT3_XFRC(value uint32) {
	volatile.StoreUint32(&o.DOEPINT3.Reg, volatile.LoadUint32(&o.DOEPINT3.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPINT3_XFRC() uint32 {
	return volatile.LoadUint32(&o.DOEPINT3.Reg) & 0x1
}

// USB_OTG_FS.DOEPTSIZ3: device OUT endpoint-3 transfer size register
func (o *USB_OTG_FS_Type) SetDOEPTSIZ3_RXDPID_STUPCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ3.Reg, volatile.LoadUint32(&o.DOEPTSIZ3.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ3_RXDPID_STUPCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ3.Reg) & 0x60000000) >> 29
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ3_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ3.Reg, volatile.LoadUint32(&o.DOEPTSIZ3.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ3_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.DOEPTSIZ3.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_FS_Type) SetDOEPTSIZ3_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.DOEPTSIZ3.Reg, volatile.LoadUint32(&o.DOEPTSIZ3.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_FS_Type) GetDOEPTSIZ3_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.DOEPTSIZ3.Reg) & 0x7ffff
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// PWR.CR: power control register
func (o *PWR_Type) SetCR_VOS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc000)|value<<14)
}
func (o *PWR_Type) GetCR_VOS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc000) >> 14
}
func (o *PWR_Type) SetCR_ADCDC1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCR_ADCDC1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetCR_FPDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR_FPDS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR_DBP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR_PLS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe0)|value<<5)
}
func (o *PWR_Type) GetCR_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe0) >> 5
}
func (o *PWR_Type) SetCR_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR_PVDE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR_CSBF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR_CSBF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR_CWUF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR_CWUF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR_PDDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR_PDDS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR_LPDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR_LPDS() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// PWR.CSR: power control/status register
func (o *PWR_Type) SetCSR_WUF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCSR_WUF() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *PWR_Type) SetCSR_SBF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCSR_SBF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCSR_PVDO(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCSR_PVDO() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCSR_BRR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCSR_BRR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCSR_EWUP(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCSR_EWUP() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCSR_BRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCSR_BRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCSR_VOSRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCSR_VOSRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000) >> 14
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	PLLCFGR    volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	CIR        volatile.Register32 // 0xC
	AHB1RSTR   volatile.Register32 // 0x10
	AHB2RSTR   volatile.Register32 // 0x14
	_          [8]byte
	APB1RSTR   volatile.Register32 // 0x20
	APB2RSTR   volatile.Register32 // 0x24
	_          [8]byte
	AHB1ENR    volatile.Register32 // 0x30
	AHB2ENR    volatile.Register32 // 0x34
	_          [8]byte
	APB1ENR    volatile.Register32 // 0x40
	APB2ENR    volatile.Register32 // 0x44
	_          [8]byte
	AHB1LPENR  volatile.Register32 // 0x50
	AHB2LPENR  volatile.Register32 // 0x54
	_          [8]byte
	APB1LPENR  volatile.Register32 // 0x60
	APB2LPENR  volatile.Register32 // 0x64
	_          [8]byte
	BDCR       volatile.Register32 // 0x70
	CSR        volatile.Register32 // 0x74
	_          [8]byte
	SSCGR      volatile.Register32 // 0x80
	PLLI2SCFGR volatile.Register32 // 0x84
	_          [4]byte
	DCKCFGR    volatile.Register32 // 0x8C
}

// RCC.CR: clock control register
func (o *RCC_Type) SetCR_PLLI2SRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCR_PLLI2SRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCR_PLLI2SON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCR_PLLI2SON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCR_PLLRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLLRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCR_PLLON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLLON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_CSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCR_CSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCR_HSEBYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCR_HSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_HSICAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff00)|value<<8)
}
func (o *RCC_Type) GetCR_HSICAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff00) >> 8
}
func (o *RCC_Type) SetCR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf8)|value<<3)
}
func (o *RCC_Type) GetCR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf8) >> 3
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// RCC.PLLCFGR: PLL configuration register
func (o *RCC_Type) SetPLLCFGR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetPLLCFGR_PLLSRC() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetPLLCFGR_PLLM(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3f)|value)
}
func (o *RCC_Type) GetPLLCFGR_PLLM() uint32 {
	return volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3f
}
func (o *RCC_Type) SetPLLCFGR_PLLN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x7fc0)|value<<6)
}
func (o *RCC_Type) GetPLLCFGR_PLLN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x7fc0) >> 6
}
func (o *RCC_Type) SetPLLCFGR_PLLP(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetPLLCFGR_PLLP() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetPLLCFGR_PLLQ(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetPLLCFGR_PLLQ() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xf000000) >> 24
}

// RCC.CFGR: clock configuration register
func (o *RCC_Type) SetCFGR_MCO2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0000000)|value<<30)
}
func (o *RCC_Type) GetCFGR_MCO2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0000000) >> 30
}
func (o *RCC_Type) SetCFGR_MCO2PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x38000000)|value<<27)
}
func (o *RCC_Type) GetCFGR_MCO2PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x38000000) >> 27
}
func (o *RCC_Type) SetCFGR_MCO1PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *RCC_Type) GetCFGR_MCO1PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *RCC_Type) SetCFGR_I2SSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCFGR_I2SSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCFGR_MCO1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x600000)|value<<21)
}
func (o *RCC_Type) GetCFGR_MCO1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x600000) >> 21
}
func (o *RCC_Type) SetCFGR_RTCPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1f0000)|value<<16)
}
func (o *RCC_Type) GetCFGR_RTCPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1f0000) >> 16
}
func (o *RCC_Type) SetCFGR_PPRE2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *RCC_Type) GetCFGR_PPRE2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *RCC_Type) SetCFGR_PPRE1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1c00)|value<<10)
}
func (o *RCC_Type) GetCFGR_PPRE1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1c00) >> 10
}
func (o *RCC_Type) SetCFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCFGR_HPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc) >> 2
}

// RCC.CIR: clock interrupt register
func (o *RCC_Type) SetCIR_CSSC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCIR_CSSC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCIR_PLLI2SRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetCIR_PLLRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetCIR_PLLRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetCIR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCIR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCIR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCIR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCIR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCIR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCIR_LSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCIR_LSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCIR_PLLI2SRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetCIR_PLLRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetCIR_PLLRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetCIR_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCIR_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCIR_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIR_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCIR_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIR_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIR_LSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIR_LSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIR_CSSF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCIR_CSSF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCIR_PLLI2SRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIR_PLLRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIR_PLLRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIR_LSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIR_LSIRDYF() uint32 {
	return volatile.LoadUint32(&o.CIR.Reg) & 0x1
}

// RCC.AHB1RSTR: AHB1 peripheral reset register
func (o *RCC_Type) SetAHB1RSTR_DMA2RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1RSTR_DMA2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1RSTR_DMA1RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1RSTR_DMA1RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1RSTR_CRCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1RSTR_CRCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1RSTR_GPIOHRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1RSTR_GPIOERST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOERST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1RSTR_GPIODRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1RSTR_GPIODRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1RSTR_GPIOCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1RSTR_GPIOBRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOBRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1RSTR_GPIOARST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOARST() uint32 {
	return volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1
}

// RCC.AHB2RSTR: AHB2 peripheral reset register
func (o *RCC_Type) SetAHB2RSTR_OTGFSRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2RSTR_OTGFSRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x80) >> 7
}

// RCC.APB1RSTR: APB1 peripheral reset register
func (o *RCC_Type) SetAPB1RSTR_PWRRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1RSTR_PWRRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1RSTR_I2C3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1RSTR_I2C3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1RSTR_I2C2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1RSTR_I2C2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1RSTR_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1RSTR_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1RSTR_USART2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1RSTR_USART2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1RSTR_SPI3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1RSTR_SPI3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1RSTR_SPI2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1RSTR_SPI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1RSTR_WWDGRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1RSTR_WWDGRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1RSTR_TIM5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1RSTR_TIM5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1RSTR_TIM4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1RSTR_TIM4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1RSTR_TIM3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1RSTR_TIM3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1RSTR_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x1
}

// RCC.APB2RSTR: APB2 peripheral reset register
func (o *RCC_Type) SetAPB2RSTR_TIM11RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2RSTR_TIM11RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2RSTR_TIM10RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2RSTR_TIM10RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2RSTR_TIM9RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2RSTR_TIM9RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2RSTR_SYSCFGRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2RSTR_SYSCFGRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2RSTR_SPI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2RSTR_SPI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2RSTR_SDIORST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2RSTR_SDIORST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2RSTR_ADCRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2RSTR_ADCRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2RSTR_USART6RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2RSTR_USART6RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2RSTR_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2RSTR_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2RSTR_TIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2RSTR_TIM1RST() uint32 {
	return volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2RSTR_SPI4RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2RSTR_SPI4RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2RSTR_SPI5RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2RSTR_SPI5RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x100000) >> 20
}

// RCC.AHB1ENR: AHB1 peripheral clock register
func (o *RCC_Type) SetAHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1ENR_DMA1EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1ENR_GPIOHEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1ENR_GPIOHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1ENR_GPIOEEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1ENR_GPIOEEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1ENR_GPIODEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1ENR_GPIODEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1
}

// RCC.AHB2ENR: AHB2 peripheral clock enable register
func (o *RCC_Type) SetAHB2ENR_OTGFSEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2ENR_OTGFSEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x80) >> 7
}

// RCC.APB1ENR: APB1 peripheral clock enable register
func (o *RCC_Type) SetAPB1ENR_PWREN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1ENR_PWREN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1ENR_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1ENR_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1ENR_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1ENR_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1ENR_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1ENR_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1ENR_USART2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1ENR_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1ENR_SPI3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1ENR_SPI3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1ENR_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1ENR_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1ENR_WWDGEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1ENR_WWDGEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1ENR_TIM5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1ENR_TIM5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1ENR_TIM4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1ENR_TIM4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1ENR_TIM3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1ENR_TIM3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1ENR_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR.Reg) & 0x1
}

// RCC.APB2ENR: APB2 peripheral clock enable register
func (o *RCC_Type) SetAPB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2ENR_TIM1EN() uint32 {
	return volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2ENR_USART6EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2ENR_USART6EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2ENR_ADC1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2ENR_ADC1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2ENR_SDIOEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2ENR_SDIOEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2ENR_SPI4EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2ENR_SPI4EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2ENR_SYSCFGEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2ENR_SYSCFGEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2ENR_TIM9EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2ENR_TIM9EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2ENR_TIM10EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2ENR_TIM10EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2ENR_TIM11EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2ENR_TIM11EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2ENR_SPI5EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2ENR_SPI5EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x100000) >> 20
}

// RCC.AHB1LPENR: AHB1 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB1LPENR_DMA2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1LPENR_DMA2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1LPENR_DMA1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1LPENR_DMA1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1LPENR_SRAM1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1LPENR_SRAM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1LPENR_FLITFLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAHB1LPENR_FLITFLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAHB1LPENR_CRCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1LPENR_CRCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1LPENR_GPIOHLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOHLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1LPENR_GPIOELPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOELPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1LPENR_GPIODLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1LPENR_GPIODLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1LPENR_GPIOCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1LPENR_GPIOBLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOBLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1LPENR_GPIOALPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOALPEN() uint32 {
	return volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x1
}

// RCC.AHB2LPENR: AHB2 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB2LPENR_OTGFSLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2LPENR_OTGFSLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x80) >> 7
}

// RCC.APB1LPENR: APB1 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAPB1LPENR_PWRLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1LPENR_PWRLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1LPENR_I2C3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1LPENR_I2C3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1LPENR_I2C2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1LPENR_I2C2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1LPENR_I2C1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1LPENR_I2C1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1LPENR_USART2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1LPENR_USART2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1LPENR_SPI3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1LPENR_SPI3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1LPENR_SPI2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1LPENR_SPI2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1LPENR_WWDGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1LPENR_WWDGLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1LPENR_TIM5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1LPENR_TIM5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1LPENR_TIM4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1LPENR_TIM4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1LPENR_TIM3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1LPENR_TIM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1LPENR_TIM2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1LPENR_TIM2LPEN() uint32 {
	return volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x1
}

// RCC.APB2LPENR: APB2 peripheral clock enabled in low power mode register
func (o *RCC_Type) SetAPB2LPENR_TIM1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2LPENR_TIM1LPEN() uint32 {
	return volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2LPENR_USART1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2LPENR_USART1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2LPENR_USART6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2LPENR_USART6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2LPENR_ADC1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2LPENR_ADC1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2LPENR_SDIOLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2LPENR_SDIOLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2LPENR_SPI1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2LPENR_SPI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2LPENR_SPI4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2LPENR_SPI4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2LPENR_SYSCFGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2LPENR_SYSCFGLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2LPENR_TIM9LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2LPENR_TIM9LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2LPENR_TIM10LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2LPENR_TIM10LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2LPENR_TIM11LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2LPENR_TIM11LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2LPENR_SPI5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2LPENR_SPI5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x100000) >> 20
}

// RCC.BDCR: Backup domain control register
func (o *RCC_Type) SetBDCR_BDRST(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetBDCR_BDRST() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetBDCR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetBDCR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetBDCR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetBDCR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetBDCR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetBDCR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetBDCR_LSEON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetBDCR_LSEON() uint32 {
	return volatile.LoadUint32(&o.BDCR.Reg) & 0x1
}
func (o *RCC_Type) SetBDCR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetBDCR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x300) >> 8
}

// RCC.CSR: clock control & status register
func (o *RCC_Type) SetCSR_LPWRRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCSR_LPWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetCSR_WWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCSR_WWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCSR_WDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCSR_WDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCSR_PORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCSR_PORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCSR_PADRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCSR_PADRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCSR_BORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCSR_BORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCSR_LSIRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCSR_LSION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSION() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// RCC.SSCGR: spread spectrum clock generation register
func (o *RCC_Type) SetSSCGR_SSCGEN(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetSSCGR_SSCGEN() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetSSCGR_SPREADSEL(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetSSCGR_SPREADSEL() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetSSCGR_INCSTEP(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0xfffe000)|value<<13)
}
func (o *RCC_Type) GetSSCGR_INCSTEP() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0xfffe000) >> 13
}
func (o *RCC_Type) SetSSCGR_MODPER(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x1fff)|value)
}
func (o *RCC_Type) GetSSCGR_MODPER() uint32 {
	return volatile.LoadUint32(&o.SSCGR.Reg) & 0x1fff
}

// RCC.PLLI2SCFGR: PLLI2S configuration register
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SR(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SR() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x70000000) >> 28
}
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SN(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x7fc0)|value<<6)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SN() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x7fc0) >> 6
}
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SM(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x3f)|value)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SM() uint32 {
	return volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x3f
}

// RCC.DCKCFGR: RCC Dedicated Clock Configuration Register
func (o *RCC_Type) SetDCKCFGR_TIMPRE(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR.Reg, volatile.LoadUint32(&o.DCKCFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetDCKCFGR_TIMPRE() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR.Reg) & 0x1000000) >> 24
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CALIBR   volatile.Register32 // 0x18
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAFCR    volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	_        [4]byte
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
}

// RTC.TR: time register
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}

// RTC.DR: date register
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}

// RTC.CR: control register
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_COSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetCR_COSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_DCE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCR_DCE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_BYPSHAD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCR_BYPSHAD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}

// RTC.ISR: initialization and status register
func (o *RTC_Type) SetISR_ALRAWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetISR_ALRAWF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *RTC_Type) SetISR_ALRBWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetISR_ALRBWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetISR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetISR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetISR_SHPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetISR_SHPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetISR_INITS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetISR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetISR_RSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetISR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetISR_INITF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetISR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetISR_INIT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetISR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetISR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetISR_ALRAF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetISR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetISR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetISR_WUTF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetISR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetISR_TSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetISR_TSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetISR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetISR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetISR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetISR_TAMP1F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetISR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetISR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetISR_RECALPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetISR_RECALPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}

// RTC.PRER: prescaler register
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x7fff
}

// RTC.WUTR: wakeup timer register
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.CALIBR: calibration register
func (o *RTC_Type) SetCALIBR_DCS(value uint32) {
	volatile.StoreUint32(&o.CALIBR.Reg, volatile.LoadUint32(&o.CALIBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCALIBR_DCS() uint32 {
	return (volatile.LoadUint32(&o.CALIBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCALIBR_DC(value uint32) {
	volatile.StoreUint32(&o.CALIBR.Reg, volatile.LoadUint32(&o.CALIBR.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetCALIBR_DC() uint32 {
	return volatile.LoadUint32(&o.CALIBR.Reg) & 0x1f
}

// RTC.ALRMAR: alarm A register
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}

// RTC.ALRMBR: alarm B register
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}

// RTC.WPR: write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.SSR: sub second register
func (o *RTC_Type) SetSSR_SS(value uint32) {
	volatile.StoreUint32(&o.SSR.Reg, volatile.LoadUint32(&o.SSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetSSR_SS() uint32 {
	return volatile.LoadUint32(&o.SSR.Reg) & 0xffff
}

// RTC.SHIFTR: shift control register
func (o *RTC_Type) SetSHIFTR_ADD1S(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSHIFTR_ADD1S() uint32 {
	return (volatile.LoadUint32(&o.SHIFTR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetSHIFTR_SUBFS(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetSHIFTR_SUBFS() uint32 {
	return volatile.LoadUint32(&o.SHIFTR.Reg) & 0x7fff
}

// RTC.TSTR: time stamp time register
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}

// RTC.TSDR: time stamp date register
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}

// RTC.TSSSR: timestamp sub second register
func (o *RTC_Type) SetTSSSR_SS(value uint32) {
	volatile.StoreUint32(&o.TSSSR.Reg, volatile.LoadUint32(&o.TSSSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTSSSR_SS() uint32 {
	return volatile.LoadUint32(&o.TSSSR.Reg) & 0xffff
}

// RTC.CALR: calibration register
func (o *RTC_Type) SetCALR_CALP(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCALR_CALP() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCALR_CALW8(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCALR_CALW8() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCALR_CALW16(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCALR_CALW16() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCALR_CALM(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetCALR_CALM() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x1ff
}

// RTC.TAFCR: tamper and alternate function configuration register
func (o *RTC_Type) SetTAFCR_ALARMOUTTYPE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetTAFCR_ALARMOUTTYPE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetTAFCR_TSINSEL(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetTAFCR_TSINSEL() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetTAFCR_TAMP1INSEL(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetTAFCR_TAMP1INSEL() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetTAFCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetTAFCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetTAFCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x6000)|value<<13)
}
func (o *RTC_Type) GetTAFCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x6000) >> 13
}
func (o *RTC_Type) SetTAFCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x1800)|value<<11)
}
func (o *RTC_Type) GetTAFCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x1800) >> 11
}
func (o *RTC_Type) SetTAFCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x700)|value<<8)
}
func (o *RTC_Type) GetTAFCR_TAMPFREQ() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x700) >> 8
}
func (o *RTC_Type) SetTAFCR_TAMPTS(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetTAFCR_TAMPTS() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetTAFCR_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetTAFCR_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetTAFCR_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetTAFCR_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetTAFCR_TAMPIE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetTAFCR_TAMPIE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetTAFCR_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetTAFCR_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetTAFCR_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTAFCR_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.TAFCR.Reg) & 0x1
}

// RTC.ALRMASSR: alarm A sub second register
func (o *RTC_Type) SetALRMASSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMASSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMASSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMASSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x7fff
}

// RTC.ALRMBSSR: alarm B sub second register
func (o *RTC_Type) SetALRMBSSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBSSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBSSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMBSSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x7fff
}

// RTC.BKP0R: backup register
func (o *RTC_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *RTC_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// RTC.BKP1R: backup register
func (o *RTC_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *RTC_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// RTC.BKP2R: backup register
func (o *RTC_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *RTC_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// RTC.BKP3R: backup register
func (o *RTC_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *RTC_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// RTC.BKP4R: backup register
func (o *RTC_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *RTC_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// RTC.BKP5R: backup register
func (o *RTC_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *RTC_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// RTC.BKP6R: backup register
func (o *RTC_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *RTC_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// RTC.BKP7R: backup register
func (o *RTC_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *RTC_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// RTC.BKP8R: backup register
func (o *RTC_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *RTC_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// RTC.BKP9R: backup register
func (o *RTC_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *RTC_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// RTC.BKP10R: backup register
func (o *RTC_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *RTC_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// RTC.BKP11R: backup register
func (o *RTC_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *RTC_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// RTC.BKP12R: backup register
func (o *RTC_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *RTC_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// RTC.BKP13R: backup register
func (o *RTC_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *RTC_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// RTC.BKP14R: backup register
func (o *RTC_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *RTC_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// RTC.BKP15R: backup register
func (o *RTC_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *RTC_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// RTC.BKP16R: backup register
func (o *RTC_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *RTC_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// RTC.BKP17R: backup register
func (o *RTC_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *RTC_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// RTC.BKP18R: backup register
func (o *RTC_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *RTC_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// RTC.BKP19R: backup register
func (o *RTC_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *RTC_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// Secure digital input/output interface
type SDIO_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// SDIO.POWER: power control register
func (o *SDIO_Type) SetPOWER_PWRCTRL(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x3)|value)
}
func (o *SDIO_Type) GetPOWER_PWRCTRL() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x3
}

// SDIO.CLKCR: SDI clock control register
func (o *SDIO_Type) SetCLKCR_HWFC_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetCLKCR_HWFC_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetCLKCR_NEGEDGE(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetCLKCR_NEGEDGE() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetCLKCR_WIDBUS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x1800)|value<<11)
}
func (o *SDIO_Type) GetCLKCR_WIDBUS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x1800) >> 11
}
func (o *SDIO_Type) SetCLKCR_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetCLKCR_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetCLKCR_PWRSAV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetCLKCR_PWRSAV() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetCLKCR_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetCLKCR_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetCLKCR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0xff)|value)
}
func (o *SDIO_Type) GetCLKCR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.CLKCR.Reg) & 0xff
}

// SDIO.ARG: argument register
func (o *SDIO_Type) SetARG(value uint32) {
	volatile.StoreUint32(&o.ARG.Reg, value)
}
func (o *SDIO_Type) GetARG() uint32 {
	return volatile.LoadUint32(&o.ARG.Reg)
}

// SDIO.CMD: command register
func (o *SDIO_Type) SetCMD_CE_ATACMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetCMD_CE_ATACMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetCMD_NIEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetCMD_NIEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetCMD_ENCMDcompl(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetCMD_ENCMDcompl() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetCMD_SDIOSuspend(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetCMD_SDIOSuspend() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetCMD_CPSMEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetCMD_CPSMEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetCMD_WAITPEND(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetCMD_WAITPEND() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetCMD_WAITINT(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetCMD_WAITINT() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetCMD_WAITRESP(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xc0)|value<<6)
}
func (o *SDIO_Type) GetCMD_WAITRESP() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0xc0) >> 6
}
func (o *SDIO_Type) SetCMD_CMDINDEX(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3f)|value)
}
func (o *SDIO_Type) GetCMD_CMDINDEX() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x3f
}

// SDIO.RESPCMD: command response register
func (o *SDIO_Type) SetRESPCMD(value uint32) {
	volatile.StoreUint32(&o.RESPCMD.Reg, volatile.LoadUint32(&o.RESPCMD.Reg)&^(0x3f)|value)
}
func (o *SDIO_Type) GetRESPCMD() uint32 {
	return volatile.LoadUint32(&o.RESPCMD.Reg) & 0x3f
}

// SDIO.RESP1: response 1..4 register
func (o *SDIO_Type) SetRESP1(value uint32) {
	volatile.StoreUint32(&o.RESP1.Reg, value)
}
func (o *SDIO_Type) GetRESP1() uint32 {
	return volatile.LoadUint32(&o.RESP1.Reg)
}

// SDIO.RESP2: response 1..4 register
func (o *SDIO_Type) SetRESP2(value uint32) {
	volatile.StoreUint32(&o.RESP2.Reg, value)
}
func (o *SDIO_Type) GetRESP2() uint32 {
	return volatile.LoadUint32(&o.RESP2.Reg)
}

// SDIO.RESP3: response 1..4 register
func (o *SDIO_Type) SetRESP3(value uint32) {
	volatile.StoreUint32(&o.RESP3.Reg, value)
}
func (o *SDIO_Type) GetRESP3() uint32 {
	return volatile.LoadUint32(&o.RESP3.Reg)
}

// SDIO.RESP4: response 1..4 register
func (o *SDIO_Type) SetRESP4(value uint32) {
	volatile.StoreUint32(&o.RESP4.Reg, value)
}
func (o *SDIO_Type) GetRESP4() uint32 {
	return volatile.LoadUint32(&o.RESP4.Reg)
}

// SDIO.DTIMER: data timer register
func (o *SDIO_Type) SetDTIMER(value uint32) {
	volatile.StoreUint32(&o.DTIMER.Reg, value)
}
func (o *SDIO_Type) GetDTIMER() uint32 {
	return volatile.LoadUint32(&o.DTIMER.Reg)
}

// SDIO.DLEN: data length register
func (o *SDIO_Type) SetDLEN_DATALENGTH(value uint32) {
	volatile.StoreUint32(&o.DLEN.Reg, volatile.LoadUint32(&o.DLEN.Reg)&^(0x1ffffff)|value)
}
func (o *SDIO_Type) GetDLEN_DATALENGTH() uint32 {
	return volatile.LoadUint32(&o.DLEN.Reg) & 0x1ffffff
}

// SDIO.DCTRL: data control register
func (o *SDIO_Type) SetDCTRL_SDIOEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetDCTRL_SDIOEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetDCTRL_RWMOD(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetDCTRL_RWMOD() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetDCTRL_RWSTOP(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetDCTRL_RWSTOP() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetDCTRL_RWSTART(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetDCTRL_RWSTART() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetDCTRL_DBLOCKSIZE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0xf0)|value<<4)
}
func (o *SDIO_Type) GetDCTRL_DBLOCKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0xf0) >> 4
}
func (o *SDIO_Type) SetDCTRL_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetDCTRL_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetDCTRL_DTMODE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetDCTRL_DTMODE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetDCTRL_DTDIR(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetDCTRL_DTDIR() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetDCTRL_DTEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetDCTRL_DTEN() uint32 {
	return volatile.LoadUint32(&o.DCTRL.Reg) & 0x1
}

// SDIO.DCOUNT: data counter register
func (o *SDIO_Type) SetDCOUNT_DATACOUNT(value uint32) {
	volatile.StoreUint32(&o.DCOUNT.Reg, volatile.LoadUint32(&o.DCOUNT.Reg)&^(0x1ffffff)|value)
}
func (o *SDIO_Type) GetDCOUNT_DATACOUNT() uint32 {
	return volatile.LoadUint32(&o.DCOUNT.Reg) & 0x1ffffff
}

// SDIO.STA: status register
func (o *SDIO_Type) SetSTA_CEATAEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetSTA_CEATAEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetSTA_SDIOIT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetSTA_SDIOIT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetSTA_RXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x200000)|value<<21)
}
func (o *SDIO_Type) GetSTA_RXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x200000) >> 21
}
func (o *SDIO_Type) SetSTA_TXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100000)|value<<20)
}
func (o *SDIO_Type) GetSTA_TXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100000) >> 20
}
func (o *SDIO_Type) SetSTA_RXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80000)|value<<19)
}
func (o *SDIO_Type) GetSTA_RXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80000) >> 19
}
func (o *SDIO_Type) SetSTA_TXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40000)|value<<18)
}
func (o *SDIO_Type) GetSTA_TXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40000) >> 18
}
func (o *SDIO_Type) SetSTA_RXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20000)|value<<17)
}
func (o *SDIO_Type) GetSTA_RXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20000) >> 17
}
func (o *SDIO_Type) SetSTA_TXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10000)|value<<16)
}
func (o *SDIO_Type) GetSTA_TXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10000) >> 16
}
func (o *SDIO_Type) SetSTA_RXFIFOHF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8000)|value<<15)
}
func (o *SDIO_Type) GetSTA_RXFIFOHF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8000) >> 15
}
func (o *SDIO_Type) SetSTA_TXFIFOHE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetSTA_TXFIFOHE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetSTA_RXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetSTA_RXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetSTA_TXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetSTA_TXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetSTA_CMDACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetSTA_CMDACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetSTA_DBCKEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetSTA_DBCKEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetSTA_STBITERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetSTA_STBITERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetSTA_DATAEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetSTA_DATAEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetSTA_CMDSENT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetSTA_CMDSENT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetSTA_CMDREND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetSTA_CMDREND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetSTA_RXOVERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetSTA_RXOVERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetSTA_TXUNDERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetSTA_TXUNDERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetSTA_DTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetSTA_DTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetSTA_CTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetSTA_CTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetSTA_DCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetSTA_DCRCFAIL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetSTA_CCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetSTA_CCRCFAIL() uint32 {
	return volatile.LoadUint32(&o.STA.Reg) & 0x1
}

// SDIO.ICR: interrupt clear register
func (o *SDIO_Type) SetICR_CEATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetICR_CEATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetICR_SDIOITC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetICR_SDIOITC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetICR_DBCKENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetICR_DBCKENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetICR_STBITERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetICR_STBITERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetICR_DATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetICR_DATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetICR_CMDSENTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetICR_CMDSENTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetICR_CMDRENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetICR_CMDRENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetICR_RXOVERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetICR_RXOVERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetICR_TXUNDERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetICR_TXUNDERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetICR_DTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetICR_DTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetICR_CTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetICR_CTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetICR_DCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetICR_DCRCFAILC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetICR_CCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetICR_CCRCFAILC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// SDIO.MASK: mask register
func (o *SDIO_Type) SetMASK_CEATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetMASK_CEATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetMASK_SDIOITIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetMASK_SDIOITIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetMASK_RXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x200000)|value<<21)
}
func (o *SDIO_Type) GetMASK_RXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x200000) >> 21
}
func (o *SDIO_Type) SetMASK_TXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100000)|value<<20)
}
func (o *SDIO_Type) GetMASK_TXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100000) >> 20
}
func (o *SDIO_Type) SetMASK_RXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80000)|value<<19)
}
func (o *SDIO_Type) GetMASK_RXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80000) >> 19
}
func (o *SDIO_Type) SetMASK_TXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40000)|value<<18)
}
func (o *SDIO_Type) GetMASK_TXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40000) >> 18
}
func (o *SDIO_Type) SetMASK_RXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20000)|value<<17)
}
func (o *SDIO_Type) GetMASK_RXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20000) >> 17
}
func (o *SDIO_Type) SetMASK_TXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10000)|value<<16)
}
func (o *SDIO_Type) GetMASK_TXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10000) >> 16
}
func (o *SDIO_Type) SetMASK_RXFIFOHFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8000)|value<<15)
}
func (o *SDIO_Type) GetMASK_RXFIFOHFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8000) >> 15
}
func (o *SDIO_Type) SetMASK_TXFIFOHEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetMASK_TXFIFOHEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetMASK_RXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetMASK_RXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetMASK_TXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetMASK_TXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetMASK_CMDACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetMASK_CMDACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetMASK_DBCKENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetMASK_DBCKENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetMASK_STBITERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetMASK_STBITERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetMASK_DATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetMASK_DATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetMASK_CMDSENTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetMASK_CMDSENTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetMASK_CMDRENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetMASK_CMDRENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetMASK_RXOVERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetMASK_RXOVERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetMASK_TXUNDERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetMASK_TXUNDERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetMASK_DTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetMASK_DTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetMASK_CTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetMASK_CTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetMASK_DCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetMASK_DCRCFAILIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetMASK_CCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetMASK_CCRCFAILIE() uint32 {
	return volatile.LoadUint32(&o.MASK.Reg) & 0x1
}

// SDIO.FIFOCNT: FIFO counter register
func (o *SDIO_Type) SetFIFOCNT_FIFOCOUNT(value uint32) {
	volatile.StoreUint32(&o.FIFOCNT.Reg, volatile.LoadUint32(&o.FIFOCNT.Reg)&^(0xffffff)|value)
}
func (o *SDIO_Type) GetFIFOCNT_FIFOCOUNT() uint32 {
	return volatile.LoadUint32(&o.FIFOCNT.Reg) & 0xffffff
}

// SDIO.FIFO: data FIFO register
func (o *SDIO_Type) SetFIFO(value uint32) {
	volatile.StoreUint32(&o.FIFO.Reg, value)
}
func (o *SDIO_Type) GetFIFO() uint32 {
	return volatile.LoadUint32(&o.FIFO.Reg)
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRM   volatile.Register32 // 0x0
	PMC     volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [8]byte
	CMPCR   volatile.Register32 // 0x20
}

// SYSCFG.MEMRM: memory remap register
func (o *SYSCFG_Type) SetMEMRM_MEM_MODE(value uint32) {
	volatile.StoreUint32(&o.MEMRM.Reg, volatile.LoadUint32(&o.MEMRM.Reg)&^(0x3)|value)
}
func (o *SYSCFG_Type) GetMEMRM_MEM_MODE() uint32 {
	return volatile.LoadUint32(&o.MEMRM.Reg) & 0x3
}

// SYSCFG.PMC: peripheral mode configuration register
func (o *SYSCFG_Type) SetPMC_ADC1DC2(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetPMC_ADC1DC2() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x10000) >> 16
}

// SYSCFG.EXTICR1: external interrupt configuration register 1
func (o *SYSCFG_Type) SetEXTICR1_EXTI3(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI3() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI2(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI2() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI1(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI1() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI0(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI0() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf
}

// SYSCFG.EXTICR2: external interrupt configuration register 2
func (o *SYSCFG_Type) SetEXTICR2_EXTI7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI7() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI6(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI6() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI5(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI5() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI4(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI4() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf
}

// SYSCFG.EXTICR3: external interrupt configuration register 3
func (o *SYSCFG_Type) SetEXTICR3_EXTI11(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI11() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI10(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI10() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI9(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI9() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI8(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI8() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf
}

// SYSCFG.EXTICR4: external interrupt configuration register 4
func (o *SYSCFG_Type) SetEXTICR4_EXTI15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI14(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI14() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI13(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI13() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI12(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI12() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf
}

// SYSCFG.CMPCR: Compensation cell control register
func (o *SYSCFG_Type) SetCMPCR_READY(value uint32) {
	volatile.StoreUint32(&o.CMPCR.Reg, volatile.LoadUint32(&o.CMPCR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCMPCR_READY() uint32 {
	return (volatile.LoadUint32(&o.CMPCR.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetCMPCR_CMP_PD(value uint32) {
	volatile.StoreUint32(&o.CMPCR.Reg, volatile.LoadUint32(&o.CMPCR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetCMPCR_CMP_PD() uint32 {
	return volatile.LoadUint32(&o.CMPCR.Reg) & 0x1
}

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60)|value<<5)
}
func (o *TIM_Type) GetCR1_CMS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60) >> 5
}
func (o *TIM_Type) SetCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// TIM.CR2: control register 2
func (o *TIM_Type) SetCR2_OIS4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetCR2_OIS4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetCR2_OIS3N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCR2_OIS3N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCR2_OIS3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCR2_OIS3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCR2_OIS2N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR2_OIS2N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCR2_OIS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCR2_OIS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCR2_OIS1N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCR2_OIS1N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCR2_OIS1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCR2_OIS1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR2_CCUS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR2_CCUS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR2_CCPC(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR2_CCPC() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// TIM.SMCR: slave mode control register
func (o *TIM_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIM_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIM_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSMCR_TS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetSMCR_TS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetSMCR_SMS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetSMCR_SMS() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}

// TIM.DIER: DMA/Interrupt enable register
func (o *TIM_Type) SetDIER_TDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetDIER_TDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetDIER_COMDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetDIER_COMDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetDIER_CC4DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetDIER_CC4DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetDIER_CC3DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetDIER_CC3DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetDIER_BIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetDIER_BIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetDIER_COMIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetDIER_COMIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetDIER_CC4IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetDIER_CC4IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetDIER_CC3IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetDIER_CC3IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_CC4OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetSR_CC4OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetSR_CC3OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetSR_CC3OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetSR_BIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSR_BIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetSR_COMIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetSR_COMIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetSR_CC4IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetSR_CC4IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetSR_CC3IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSR_CC3IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_BG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetEGR_BG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetEGR_COMG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetEGR_COMG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetEGR_CC4G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetEGR_CC4G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetEGR_CC3G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetEGR_CC3G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}

// TIM.CCMR1_Output: capture/compare mode register 1 (output mode)
func (o *TIM_Type) SetCCMR1_Output_OC2CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR1_Output_OC2CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}

// TIM.CCMR2_Output: capture/compare mode register 2 (output mode)
func (o *TIM_Type) SetCCMR2_Output_OC4CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR2_Output_OC4CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR2_Output_OC4M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR2_Output_OC4PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR2_Output_OC4PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR2_Output_OC4FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR2_Output_OC4FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR2_Output_CC4S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR2_Output_CC4S() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR2_Output_OC3CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR2_Output_OC3CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR2_Output_OC3M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR2_Output_OC3PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR2_Output_OC3PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR2_Output_OC3FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR2_Output_OC3FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR2_Output_CC3S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR2_Output_CC3S() uint32 {
	return volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x3
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC4P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCCER_CC4P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCCER_CC4E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCCER_CC4E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCCER_CC3NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCER_CC3NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCER_CC3NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCER_CC3NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCER_CC3P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCCER_CC3P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCCER_CC3E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCCER_CC3E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCER_CC2NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetCCER_CC2NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC1NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCER_CC1NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// TIM.RCR: repetition counter register
func (o *TIM_Type) SetRCR_REP(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetRCR_REP() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xff
}

// TIM.CCR1: capture/compare register
func (o *TIM_Type) SetCCR1_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR1_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xffff
}

// TIM.CCR2: capture/compare register
func (o *TIM_Type) SetCCR2_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR2_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xffff
}

// TIM.CCR3: capture/compare register
func (o *TIM_Type) SetCCR3_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR3_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0xffff
}

// TIM.CCR4: capture/compare register
func (o *TIM_Type) SetCCR4_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR4_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0xffff
}

// TIM.BDTR: break and dead-time register
func (o *TIM_Type) SetBDTR_MOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetBDTR_MOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetBDTR_AOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetBDTR_AOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetBDTR_BKP(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetBDTR_BKP() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetBDTR_BKE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetBDTR_BKE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetBDTR_OSSR(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetBDTR_OSSR() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetBDTR_OSSI(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetBDTR_OSSI() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetBDTR_LOCK(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetBDTR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetBDTR_DTG(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetBDTR_DTG() uint32 {
	return volatile.LoadUint32(&o.BDTR.Reg) & 0xff
}

// TIM.DCR: DMA control register
func (o *TIM_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIM_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}
func (o *TIM_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIM_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}

// TIM.DMAR: DMA address for full transfer
func (o *TIM_Type) SetDMAR_DMAB(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, volatile.LoadUint32(&o.DMAR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetDMAR_DMAB() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg) & 0xffff
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	SR   volatile.Register32 // 0x0
	DR   volatile.Register32 // 0x4
	BRR  volatile.Register32 // 0x8
	CR1  volatile.Register32 // 0xC
	CR2  volatile.Register32 // 0x10
	CR3  volatile.Register32 // 0x14
	GTPR volatile.Register32 // 0x18
}

// USART.SR: Status register
func (o *USART_Type) SetSR_CTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetSR_LBD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetSR_LBD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetSR_TC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetSR_TC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetSR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetSR_IDLE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetSR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetSR_ORE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetSR_ORE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetSR_NF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetSR_NF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetSR_FE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetSR_FE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetSR_PE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetSR_PE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// USART.DR: Data register
func (o *USART_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0x1ff
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR_DIV_Mantissa(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xfff0)|value<<4)
}
func (o *USART_Type) GetBRR_DIV_Mantissa() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0xfff0) >> 4
}
func (o *USART_Type) SetBRR_DIV_Fraction(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetBRR_DIV_Fraction() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xf
}

// USART.CR1: Control register 1
func (o *USART_Type) SetCR1_OVER8(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR1_OVER8() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_UE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_M(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_M() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_RWU(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR1_RWU() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR1_SBK(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_SBK() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_LINEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR2_LINEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR2_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR2_LBCL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR2_LBCL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR2_LBDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR2_LBDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR2_LBDL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR2_LBDL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetCR2_ADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0xf
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR3_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_SCEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR3_SCEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR3_NACK(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR3_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_IRLP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR3_IRLP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR3_IREN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// USART.GTPR: Guard time and prescaler register
func (o *USART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x180)|value<<7)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x180) >> 7
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// DMA controller
type DMA_Type struct {
	LISR  volatile.Register32 // 0x0
	HISR  volatile.Register32 // 0x4
	LIFCR volatile.Register32 // 0x8
	HIFCR volatile.Register32 // 0xC
	ST    [8]DMA_ST_Type      // 0x10
}

// DMA.LISR: low interrupt status register
func (o *DMA_Type) SetLISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetLISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetLISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetLISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetLISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetLISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetLISR_DMEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetLISR_DMEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetLISR_FEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetLISR_FEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetLISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetLISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetLISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetLISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetLISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetLISR_DMEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetLISR_DMEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetLISR_FEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetLISR_FEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetLISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetLISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetLISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetLISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetLISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetLISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetLISR_DMEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetLISR_DMEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetLISR_FEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetLISR_FEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetLISR_TCIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetLISR_TCIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetLISR_HTIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetLISR_HTIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetLISR_TEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetLISR_TEIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetLISR_DMEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetLISR_DMEIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetLISR_FEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetLISR_FEIF0() uint32 {
	return volatile.LoadUint32(&o.LISR.Reg) & 0x1
}

// DMA.HISR: high interrupt status register
func (o *DMA_Type) SetHISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetHISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetHISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetHISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetHISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetHISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetHISR_DMEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetHISR_DMEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetHISR_FEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetHISR_FEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetHISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetHISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetHISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetHISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetHISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetHISR_DMEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetHISR_DMEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetHISR_FEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetHISR_FEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetHISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHISR_DMEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHISR_DMEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHISR_FEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHISR_FEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHISR_DMEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHISR_DMEIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHISR_FEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHISR_FEIF4() uint32 {
	return volatile.LoadUint32(&o.HISR.Reg) & 0x1
}

// DMA.LIFCR: low interrupt flag clear register
func (o *DMA_Type) SetLIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetLIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetLIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetLIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetLIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetLIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetLIFCR_CDMEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetLIFCR_CDMEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetLIFCR_CFEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetLIFCR_CFEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetLIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetLIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetLIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetLIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetLIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetLIFCR_CDMEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetLIFCR_CDMEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetLIFCR_CFEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetLIFCR_CFEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetLIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetLIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetLIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetLIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetLIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetLIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetLIFCR_CDMEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetLIFCR_CDMEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetLIFCR_CFEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetLIFCR_CFEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetLIFCR_CTCIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetLIFCR_CTCIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetLIFCR_CHTIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetLIFCR_CHTIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetLIFCR_CTEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetLIFCR_CTEIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetLIFCR_CDMEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetLIFCR_CDMEIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetLIFCR_CFEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetLIFCR_CFEIF0() uint32 {
	return volatile.LoadUint32(&o.LIFCR.Reg) & 0x1
}

// DMA.HIFCR: high interrupt flag clear register
func (o *DMA_Type) SetHIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetHIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetHIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetHIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetHIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetHIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetHIFCR_CDMEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetHIFCR_CDMEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetHIFCR_CFEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetHIFCR_CFEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetHIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetHIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetHIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetHIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetHIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetHIFCR_CDMEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetHIFCR_CDMEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetHIFCR_CFEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetHIFCR_CFEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetHIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHIFCR_CDMEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHIFCR_CDMEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHIFCR_CFEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHIFCR_CFEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHIFCR_CTEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHIFCR_CTEIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHIFCR_CDMEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHIFCR_CDMEIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHIFCR_CFEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHIFCR_CFEIF4() uint32 {
	return volatile.LoadUint32(&o.HIFCR.Reg) & 0x1
}

// Stream cluster: S?CR, S?NDTR, S?M0AR, S?M1AR and S?FCR registers
type DMA_ST_Type struct {
	CR   volatile.Register32 // 0x10
	NDTR volatile.Register32 // 0x14
	PAR  volatile.Register32 // 0x18
	M0AR volatile.Register32 // 0x1C
	M1AR volatile.Register32 // 0x20
	FCR  volatile.Register32 // 0x24
}

// DMA_ST.CR: stream x configuration register
func (o *DMA_ST_Type) SetCR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe000000)|value<<25)
}
func (o *DMA_ST_Type) GetCR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe000000) >> 25
}
func (o *DMA_ST_Type) SetCR_MBURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_ST_Type) GetCR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_ST_Type) SetCR_PBURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_ST_Type) GetCR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *DMA_ST_Type) SetCR_CT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_ST_Type) GetCR_CT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *DMA_ST_Type) SetCR_DBM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_ST_Type) GetCR_DBM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DMA_ST_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_ST_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}
func (o *DMA_ST_Type) SetCR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_ST_Type) GetCR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *DMA_ST_Type) SetCR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_ST_Type) GetCR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6000) >> 13
}
func (o *DMA_ST_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_ST_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1800) >> 11
}
func (o *DMA_ST_Type) SetCR_MINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_ST_Type) GetCR_MINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *DMA_ST_Type) SetCR_PINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_ST_Type) GetCR_PINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *DMA_ST_Type) SetCR_CIRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_ST_Type) GetCR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *DMA_ST_Type) SetCR_DIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_ST_Type) GetCR_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DMA_ST_Type) SetCR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_ST_Type) GetCR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA_ST_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_ST_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA_ST_Type) SetCR_HTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_ST_Type) GetCR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DMA_ST_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_ST_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA_ST_Type) SetCR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_ST_Type) GetCR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA_ST_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA_ST_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DMA_ST.NDTR: stream x number of data register
func (o *DMA_ST_Type) SetNDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.NDTR.Reg, volatile.LoadUint32(&o.NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_ST_Type) GetNDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.NDTR.Reg) & 0xffff
}

// DMA_ST.PAR: stream x peripheral address register
func (o *DMA_ST_Type) SetPAR(value uint32) {
	volatile.StoreUint32(&o.PAR.Reg, value)
}
func (o *DMA_ST_Type) GetPAR() uint32 {
	return volatile.LoadUint32(&o.PAR.Reg)
}

// DMA_ST.M0AR: stream x memory 0 address register
func (o *DMA_ST_Type) SetM0AR(value uint32) {
	volatile.StoreUint32(&o.M0AR.Reg, value)
}
func (o *DMA_ST_Type) GetM0AR() uint32 {
	return volatile.LoadUint32(&o.M0AR.Reg)
}

// DMA_ST.M1AR: stream x memory 1 address register
func (o *DMA_ST_Type) SetM1AR(value uint32) {
	volatile.StoreUint32(&o.M1AR.Reg, value)
}
func (o *DMA_ST_Type) GetM1AR() uint32 {
	return volatile.LoadUint32(&o.M1AR.Reg)
}

// DMA_ST.FCR: stream x FIFO control register
func (o *DMA_ST_Type) SetFCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_ST_Type) GetFCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x80) >> 7
}
func (o *DMA_ST_Type) SetFCR_FS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_ST_Type) GetFCR_FS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x38) >> 3
}
func (o *DMA_ST_Type) SetFCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_ST_Type) GetFCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x4) >> 2
}
func (o *DMA_ST_Type) SetFCR_FTH(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3)|value)
}
func (o *DMA_ST_Type) GetFCR_FTH() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x3
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFRL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFRL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFRL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFRL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFRL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFRL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFRL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFRL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFRL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFRL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFRL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFRL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFRL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFRL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFRL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFRL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFRH15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFRH15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFRH14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFRH14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFRH13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFRH13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFRH12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFRH12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFRH11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFRH11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFRH10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFRH10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFRH9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFRH9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFRH8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFRH8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	OAR1  volatile.Register32 // 0x8
	OAR2  volatile.Register32 // 0xC
	DR    volatile.Register32 // 0x10
	SR1   volatile.Register32 // 0x14
	SR2   volatile.Register32 // 0x18
	CCR   volatile.Register32 // 0x1C
	TRISE volatile.Register32 // 0x20
	FLTR  volatile.Register32 // 0x24
}

// I2C.CR1: Control register 1
func (o *I2C_Type) SetCR1_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_ALERT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR1_ALERT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR1_PEC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_PEC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_POS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR1_POS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR1_ACK(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR1_ACK() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR1_STOP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetCR1_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetCR1_START(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCR1_START() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_ENGC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_ENGC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ENPEC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_ENPEC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_ENARP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_ENARP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_SMBTYPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_SMBTYPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_SMBUS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_SMBUS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// I2C.CR2: Control register 2
func (o *I2C_Type) SetCR2_LAST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_LAST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_ITBUFEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_ITBUFEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_ITEVTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetCR2_ITEVTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetCR2_ITERREN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCR2_ITERREN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetCR2_FREQ(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3f)|value)
}
func (o *I2C_Type) GetCR2_FREQ() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3f
}

// I2C.OAR1: Own address register 1
func (o *I2C_Type) SetOAR1_ADDMODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_ADDMODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetOAR1_ADD(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_ADD() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}

// I2C.OAR2: Own address register 2
func (o *I2C_Type) SetOAR2_ADD2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_ADD2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_ENDUAL(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetOAR2_ENDUAL() uint32 {
	return volatile.LoadUint32(&o.OAR2.Reg) & 0x1
}

// I2C.DR: Data register
func (o *I2C_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xff
}

// I2C.SR1: Status register 1
func (o *I2C_Type) SetSR1_SMBALERT(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetSR1_SMBALERT() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetSR1_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetSR1_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetSR1_PECERR(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetSR1_PECERR() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetSR1_OVR(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetSR1_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetSR1_AF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetSR1_AF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetSR1_ARLO(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetSR1_ARLO() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetSR1_BERR(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetSR1_BERR() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetSR1_TxE(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSR1_TxE() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetSR1_RxNE(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSR1_RxNE() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSR1_STOPF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSR1_STOPF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSR1_ADD10(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSR1_ADD10() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetSR1_BTF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetSR1_BTF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetSR1_ADDR(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSR1_ADDR() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSR1_SB(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSR1_SB() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}

// I2C.SR2: Status register 2
func (o *I2C_Type) SetSR2_PEC(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetSR2_PEC() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetSR2_DUALF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSR2_DUALF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetSR2_SMBHOST(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSR2_SMBHOST() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSR2_SMBDEFAULT(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetSR2_SMBDEFAULT() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetSR2_GENCALL(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSR2_GENCALL() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSR2_TRA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetSR2_TRA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetSR2_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSR2_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSR2_MSL(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSR2_MSL() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}

// I2C.CCR: Clock control register
func (o *I2C_Type) SetCCR_F_S(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCCR_F_S() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCCR_DUTY(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCCR_DUTY() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCCR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetCCR() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0xfff
}

// I2C.TRISE: TRISE register
func (o *I2C_Type) SetTRISE(value uint32) {
	volatile.StoreUint32(&o.TRISE.Reg, volatile.LoadUint32(&o.TRISE.Reg)&^(0x3f)|value)
}
func (o *I2C_Type) GetTRISE() uint32 {
	return volatile.LoadUint32(&o.TRISE.Reg) & 0x3f
}

// I2C.FLTR: FLTR register
func (o *I2C_Type) SetFLTR_ANOFF(value uint32) {
	volatile.StoreUint32(&o.FLTR.Reg, volatile.LoadUint32(&o.FLTR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetFLTR_ANOFF() uint32 {
	return (volatile.LoadUint32(&o.FLTR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetFLTR_DNF(value uint32) {
	volatile.StoreUint32(&o.FLTR.Reg, volatile.LoadUint32(&o.FLTR.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetFLTR_DNF() uint32 {
	return volatile.LoadUint32(&o.FLTR.Reg) & 0xf
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// SPI.CR1: control register 1
func (o *SPI_Type) SetCR1_BIDIMODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_BIDIMODE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCR1_BIDIOE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_BIDIOE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_CRCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_CRCNEXT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_CRCNEXT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_DFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_DFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_RXONLY(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_RXONLY() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_SSM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_SSM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_SSI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_SSI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR1_SPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR1_SPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR1_BR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x38)|value<<3)
}
func (o *SPI_Type) GetCR1_BR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x38) >> 3
}
func (o *SPI_Type) SetCR1_MSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR1_MSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_CPHA() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// SPI.CR2: control register 2
func (o *SPI_Type) SetCR2_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR2_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR2_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR2_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR2_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR2_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR2_FRF(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR2_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR2_SSOE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR2_SSOE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR2_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR2_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR2_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR2_RXDMAEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// SPI.SR: status register
func (o *SPI_Type) SetSR_FRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_FRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_CRCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_UDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_UDR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_CHSIDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_CHSIDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// SPI.DR: data register
func (o *SPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// SPI.CRCPR: CRC polynomial register
func (o *SPI_Type) SetCRCPR_CRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPR.Reg, volatile.LoadUint32(&o.CRCPR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetCRCPR_CRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPR.Reg) & 0xffff
}

// SPI.RXCRCR: RX CRC register
func (o *SPI_Type) SetRXCRCR_RxCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRCR.Reg, volatile.LoadUint32(&o.RXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRXCRCR_RxCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRCR.Reg) & 0xffff
}

// SPI.TXCRCR: TX CRC register
func (o *SPI_Type) SetTXCRCR_TxCRC(value uint32) {
	volatile.StoreUint32(&o.TXCRCR.Reg, volatile.LoadUint32(&o.TXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXCRCR_TxCRC() uint32 {
	return volatile.LoadUint32(&o.TXCRCR.Reg) & 0xffff
}

// SPI.I2SCFGR: I2S configuration register
func (o *SPI_Type) SetI2SCFGR_I2SMOD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetI2SCFGR_I2SMOD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetI2SCFGR_I2SE(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetI2SCFGR_I2SE() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetI2SCFGR_I2SCFG(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetI2SCFGR_I2SCFG() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetI2SCFGR_PCMSYNC(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetI2SCFGR_PCMSYNC() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetI2SCFGR_I2SSTD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x30)|value<<4)
}
func (o *SPI_Type) GetI2SCFGR_I2SSTD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x30) >> 4
}
func (o *SPI_Type) SetI2SCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetI2SCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetI2SCFGR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x6)|value<<1)
}
func (o *SPI_Type) GetI2SCFGR_DATLEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x6) >> 1
}
func (o *SPI_Type) SetI2SCFGR_CHLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetI2SCFGR_CHLEN() uint32 {
	return volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1
}

// SPI.I2SPR: I2S prescaler register
func (o *SPI_Type) SetI2SPR_MCKOE(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetI2SPR_MCKOE() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetI2SPR_ODD(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetI2SPR_ODD() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetI2SPR_I2SDIV(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetI2SPR_I2SDIV() uint32 {
	return volatile.LoadUint32(&o.I2SPR.Reg) & 0xff
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
}

// NVIC.ISER0: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER0(value uint32) {
	volatile.StoreUint32(&o.ISER0.Reg, value)
}
func (o *NVIC_Type) GetISER0() uint32 {
	return volatile.LoadUint32(&o.ISER0.Reg)
}

// NVIC.ISER1: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER1(value uint32) {
	volatile.StoreUint32(&o.ISER1.Reg, value)
}
func (o *NVIC_Type) GetISER1() uint32 {
	return volatile.LoadUint32(&o.ISER1.Reg)
}

// NVIC.ISER2: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER2(value uint32) {
	volatile.StoreUint32(&o.ISER2.Reg, value)
}
func (o *NVIC_Type) GetISER2() uint32 {
	return volatile.LoadUint32(&o.ISER2.Reg)
}

// NVIC.ICER0: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER0(value uint32) {
	volatile.StoreUint32(&o.ICER0.Reg, value)
}
func (o *NVIC_Type) GetICER0() uint32 {
	return volatile.LoadUint32(&o.ICER0.Reg)
}

// NVIC.ICER1: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER1(value uint32) {
	volatile.StoreUint32(&o.ICER1.Reg, value)
}
func (o *NVIC_Type) GetICER1() uint32 {
	return volatile.LoadUint32(&o.ICER1.Reg)
}

// NVIC.ICER2: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER2(value uint32) {
	volatile.StoreUint32(&o.ICER2.Reg, value)
}
func (o *NVIC_Type) GetICER2() uint32 {
	return volatile.LoadUint32(&o.ICER2.Reg)
}

// NVIC.ISPR0: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR0(value uint32) {
	volatile.StoreUint32(&o.ISPR0.Reg, value)
}
func (o *NVIC_Type) GetISPR0() uint32 {
	return volatile.LoadUint32(&o.ISPR0.Reg)
}

// NVIC.ISPR1: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR1(value uint32) {
	volatile.StoreUint32(&o.ISPR1.Reg, value)
}
func (o *NVIC_Type) GetISPR1() uint32 {
	return volatile.LoadUint32(&o.ISPR1.Reg)
}

// NVIC.ISPR2: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR2(value uint32) {
	volatile.StoreUint32(&o.ISPR2.Reg, value)
}
func (o *NVIC_Type) GetISPR2() uint32 {
	return volatile.LoadUint32(&o.ISPR2.Reg)
}

// NVIC.ICPR0: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR0(value uint32) {
	volatile.StoreUint32(&o.ICPR0.Reg, value)
}
func (o *NVIC_Type) GetICPR0() uint32 {
	return volatile.LoadUint32(&o.ICPR0.Reg)
}

// NVIC.ICPR1: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR1(value uint32) {
	volatile.StoreUint32(&o.ICPR1.Reg, value)
}
func (o *NVIC_Type) GetICPR1() uint32 {
	return volatile.LoadUint32(&o.ICPR1.Reg)
}

// NVIC.ICPR2: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR2(value uint32) {
	volatile.StoreUint32(&o.ICPR2.Reg, value)
}
func (o *NVIC_Type) GetICPR2() uint32 {
	return volatile.LoadUint32(&o.ICPR2.Reg)
}

// NVIC.IABR0: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR0(value uint32) {
	volatile.StoreUint32(&o.IABR0.Reg, value)
}
func (o *NVIC_Type) GetIABR0() uint32 {
	return volatile.LoadUint32(&o.IABR0.Reg)
}

// NVIC.IABR1: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR1(value uint32) {
	volatile.StoreUint32(&o.IABR1.Reg, value)
}
func (o *NVIC_Type) GetIABR1() uint32 {
	return volatile.LoadUint32(&o.IABR1.Reg)
}

// NVIC.IABR2: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR2(value uint32) {
	volatile.StoreUint32(&o.IABR2.Reg, value)
}
func (o *NVIC_Type) GetIABR2() uint32 {
	return volatile.LoadUint32(&o.IABR2.Reg)
}

// NVIC.IPR0: Interrupt Priority Register
func (o *NVIC_Type) SetIPR0_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR0_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR0_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR0_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR0_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR0_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR0_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR0_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.IPR1: Interrupt Priority Register
func (o *NVIC_Type) SetIPR1_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR1_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR1_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR1_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR1_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR1_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR1_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR1_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.IPR2: Interrupt Priority Register
func (o *NVIC_Type) SetIPR2_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR2_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR2_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR2_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR2_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR2_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR2_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR2_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.IPR3: Interrupt Priority Register
func (o *NVIC_Type) SetIPR3_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR3_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR3_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR3_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR3_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR3_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR3_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR3_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.IPR4: Interrupt Priority Register
func (o *NVIC_Type) SetIPR4_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR4_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR4_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR4_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR4_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR4_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR4_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR4_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.IPR5: Interrupt Priority Register
func (o *NVIC_Type) SetIPR5_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR5_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR5_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR5_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR5_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR5_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR5_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR5_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.IPR6: Interrupt Priority Register
func (o *NVIC_Type) SetIPR6_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR6_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR6_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR6_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR6_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR6_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR6_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR6_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.IPR7: Interrupt Priority Register
func (o *NVIC_Type) SetIPR7_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR7_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR7_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR7_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR7_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR7_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR7_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR7_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff000000) >> 24
}

// NVIC.IPR8: Interrupt Priority Register
func (o *NVIC_Type) SetIPR8_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR8_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR8.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR8_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR8_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR8_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR8_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR8_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR8_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff000000) >> 24
}

// NVIC.IPR9: Interrupt Priority Register
func (o *NVIC_Type) SetIPR9_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR9_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR9.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR9_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR9_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR9_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR9_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR9_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR9_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff000000) >> 24
}

// NVIC.IPR10: Interrupt Priority Register
func (o *NVIC_Type) SetIPR10_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR10_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR10.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR10_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR10_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR10_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR10_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR10_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR10_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff000000) >> 24
}

// NVIC.IPR11: Interrupt Priority Register
func (o *NVIC_Type) SetIPR11_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR11_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR11.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR11_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR11_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR11_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR11_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR11_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR11_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff000000) >> 24
}

// NVIC.IPR12: Interrupt Priority Register
func (o *NVIC_Type) SetIPR12_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR12_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR12.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR12_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR12_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR12_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR12_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR12_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR12_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff000000) >> 24
}

// NVIC.IPR13: Interrupt Priority Register
func (o *NVIC_Type) SetIPR13_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR13_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR13.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR13_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR13_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR13_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR13_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR13_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR13_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff000000) >> 24
}

// NVIC.IPR14: Interrupt Priority Register
func (o *NVIC_Type) SetIPR14_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR14_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR14.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR14_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR14_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR14_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR14_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR14_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR14_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff000000) >> 24
}

// NVIC.IPR15: Interrupt Priority Register
func (o *NVIC_Type) SetIPR15_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR15_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR15.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR15_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR15_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR15_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR15_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR15_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR15_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff000000) >> 24
}

// NVIC.IPR16: Interrupt Priority Register
func (o *NVIC_Type) SetIPR16_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR16_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR16.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR16_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR16_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR16_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR16_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR16_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR16_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff000000) >> 24
}

// NVIC.IPR17: Interrupt Priority Register
func (o *NVIC_Type) SetIPR17_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR17_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR17.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR17_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR17_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR17_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR17_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR17_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR17_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff000000) >> 24
}

// NVIC.IPR18: Interrupt Priority Register
func (o *NVIC_Type) SetIPR18_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR18_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR18.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR18_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR18_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR18_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR18_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR18_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR18_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff000000) >> 24
}

// NVIC.IPR19: Interrupt Priority Register
func (o *NVIC_Type) SetIPR19_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR19_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR19.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR19_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR19_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR19_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR19_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR19_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR19_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff000000) >> 24
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// FPU.FPCCR: Floating-point context control register
func (o *FPU_Type) SetFPCCR_LSPACT(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPCCR_LSPACT() uint32 {
	return volatile.LoadUint32(&o.FPCCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPCCR_USER(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPCCR_USER() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPCCR_THREAD(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPCCR_THREAD() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPCCR_HFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPCCR_HFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPCCR_MMRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x20)|value<<5)
}
func (o *FPU_Type) GetFPCCR_MMRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x20) >> 5
}
func (o *FPU_Type) SetFPCCR_BFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40)|value<<6)
}
func (o *FPU_Type) GetFPCCR_BFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40) >> 6
}
func (o *FPU_Type) SetFPCCR_MONRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x100)|value<<8)
}
func (o *FPU_Type) GetFPCCR_MONRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x100) >> 8
}
func (o *FPU_Type) SetFPCCR_LSPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPCCR_LSPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPCCR_ASPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FPU_Type) GetFPCCR_ASPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x80000000) >> 31
}

// FPU.FPCAR: Floating-point context address register
func (o *FPU_Type) SetFPCAR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.FPCAR.Reg, volatile.LoadUint32(&o.FPCAR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *FPU_Type) GetFPCAR_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.FPCAR.Reg) & 0xfffffff8) >> 3
}

// FPU.FPSCR: Floating-point status control register
func (o *FPU_Type) SetFPSCR_IOC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPSCR_IOC() uint32 {
	return volatile.LoadUint32(&o.FPSCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPSCR_DZC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPSCR_DZC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPSCR_OFC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x4)|value<<2)
}
func (o *FPU_Type) GetFPSCR_OFC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x4) >> 2
}
func (o *FPU_Type) SetFPSCR_UFC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPSCR_UFC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPSCR_IXC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPSCR_IXC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPSCR_IDC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x80)|value<<7)
}
func (o *FPU_Type) GetFPSCR_IDC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x80) >> 7
}
func (o *FPU_Type) SetFPSCR_RMode(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0xc00000)|value<<22)
}
func (o *FPU_Type) GetFPSCR_RMode() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0xc00000) >> 22
}
func (o *FPU_Type) SetFPSCR_FZ(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x1000000)|value<<24)
}
func (o *FPU_Type) GetFPSCR_FZ() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x1000000) >> 24
}
func (o *FPU_Type) SetFPSCR_DN(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x2000000)|value<<25)
}
func (o *FPU_Type) GetFPSCR_DN() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x2000000) >> 25
}
func (o *FPU_Type) SetFPSCR_AHP(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x4000000)|value<<26)
}
func (o *FPU_Type) GetFPSCR_AHP() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x4000000) >> 26
}
func (o *FPU_Type) SetFPSCR_V(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x10000000)|value<<28)
}
func (o *FPU_Type) GetFPSCR_V() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x10000000) >> 28
}
func (o *FPU_Type) SetFPSCR_C(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x20000000)|value<<29)
}
func (o *FPU_Type) GetFPSCR_C() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x20000000) >> 29
}
func (o *FPU_Type) SetFPSCR_Z(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPSCR_Z() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPSCR_N(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FPU_Type) GetFPSCR_N() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x80000000) >> 31
}

// Memory protection unit
type MPU_Type struct {
	TYPER volatile.Register32 // 0x0
	CTRL  volatile.Register32 // 0x4
	RNR   volatile.Register32 // 0x8
	RBAR  volatile.Register32 // 0xC
	RASR  volatile.Register32 // 0x10
}

// MPU.TYPER: MPU type register
func (o *MPU_Type) SetTYPER_SEPARATE(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetTYPER_SEPARATE() uint32 {
	return volatile.LoadUint32(&o.TYPER.Reg) & 0x1
}
func (o *MPU_Type) SetTYPER_DREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetTYPER_DREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetTYPER_IREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff0000)|value<<16)
}
func (o *MPU_Type) GetTYPER_IREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff0000) >> 16
}

// MPU.CTRL: MPU control register
func (o *MPU_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *MPU_Type) SetCTRL_HFNMIENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *MPU_Type) GetCTRL_HFNMIENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *MPU_Type) SetCTRL_PRIVDEFENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *MPU_Type) GetCTRL_PRIVDEFENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}

// MPU.RNR: MPU region number register
func (o *MPU_Type) SetRNR_REGION(value uint32) {
	volatile.StoreUint32(&o.RNR.Reg, volatile.LoadUint32(&o.RNR.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetRNR_REGION() uint32 {
	return volatile.LoadUint32(&o.RNR.Reg) & 0xff
}

// MPU.RBAR: MPU region base address register
func (o *MPU_Type) SetRBAR_REGION(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xf)|value)
}
func (o *MPU_Type) GetRBAR_REGION() uint32 {
	return volatile.LoadUint32(&o.RBAR.Reg) & 0xf
}
func (o *MPU_Type) SetRBAR_VALID(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0x10)|value<<4)
}
func (o *MPU_Type) GetRBAR_VALID() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0x10) >> 4
}
func (o *MPU_Type) SetRBAR_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetRBAR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0xffffffe0) >> 5
}

// MPU.RASR: MPU region attribute and size register
func (o *MPU_Type) SetRASR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetRASR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RASR.Reg) & 0x1
}
func (o *MPU_Type) SetRASR_SIZE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x3e)|value<<1)
}
func (o *MPU_Type) GetRASR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x3e) >> 1
}
func (o *MPU_Type) SetRASR_SRD(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetRASR_SRD() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetRASR_B(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000)|value<<16)
}
func (o *MPU_Type) GetRASR_B() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000) >> 16
}
func (o *MPU_Type) SetRASR_C(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x20000)|value<<17)
}
func (o *MPU_Type) GetRASR_C() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x20000) >> 17
}
func (o *MPU_Type) SetRASR_S(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x40000)|value<<18)
}
func (o *MPU_Type) GetRASR_S() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x40000) >> 18
}
func (o *MPU_Type) SetRASR_TEX(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x380000)|value<<19)
}
func (o *MPU_Type) GetRASR_TEX() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x380000) >> 19
}
func (o *MPU_Type) SetRASR_AP(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x7000000)|value<<24)
}
func (o *MPU_Type) GetRASR_AP() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x7000000) >> 24
}
func (o *MPU_Type) SetRASR_XN(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000000)|value<<28)
}
func (o *MPU_Type) GetRASR_XN() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000000) >> 28
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// STK.CTRL: SysTick control and status register
func (o *STK_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *STK_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *STK_Type) SetCTRL_TICKINT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *STK_Type) GetCTRL_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *STK_Type) SetCTRL_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *STK_Type) GetCTRL_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *STK_Type) SetCTRL_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *STK_Type) GetCTRL_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}

// STK.LOAD: SysTick reload value register
func (o *STK_Type) SetLOAD_RELOAD(value uint32) {
	volatile.StoreUint32(&o.LOAD.Reg, volatile.LoadUint32(&o.LOAD.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetLOAD_RELOAD() uint32 {
	return volatile.LoadUint32(&o.LOAD.Reg) & 0xffffff
}

// STK.VAL: SysTick current value register
func (o *STK_Type) SetVAL_CURRENT(value uint32) {
	volatile.StoreUint32(&o.VAL.Reg, volatile.LoadUint32(&o.VAL.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetVAL_CURRENT() uint32 {
	return volatile.LoadUint32(&o.VAL.Reg) & 0xffffff
}

// STK.CALIB: SysTick calibration value register
func (o *STK_Type) SetCALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetCALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.CALIB.Reg) & 0xffffff
}
func (o *STK_Type) SetCALIB_SKEW(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x40000000)|value<<30)
}
func (o *STK_Type) GetCALIB_SKEW() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x40000000) >> 30
}
func (o *STK_Type) SetCALIB_NOREF(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x80000000)|value<<31)
}
func (o *STK_Type) GetCALIB_NOREF() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x80000000) >> 31
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCRS                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// SCB.CPUID: CPUID base register
func (o *SCB_Type) SetCPUID_Revision(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf)|value)
}
func (o *SCB_Type) GetCPUID_Revision() uint32 {
	return volatile.LoadUint32(&o.CPUID.Reg) & 0xf
}
func (o *SCB_Type) SetCPUID_PartNo(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xfff0)|value<<4)
}
func (o *SCB_Type) GetCPUID_PartNo() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xfff0) >> 4
}
func (o *SCB_Type) SetCPUID_Constant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf0000)|value<<16)
}
func (o *SCB_Type) GetCPUID_Constant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf0000) >> 16
}
func (o *SCB_Type) SetCPUID_Variant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf00000)|value<<20)
}
func (o *SCB_Type) GetCPUID_Variant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf00000) >> 20
}
func (o *SCB_Type) SetCPUID_Implementer(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetCPUID_Implementer() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xff000000) >> 24
}

// SCB.ICSR: Interrupt control and state register
func (o *SCB_Type) SetICSR_VECTACTIVE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x1ff)|value)
}
func (o *SCB_Type) GetICSR_VECTACTIVE() uint32 {
	return volatile.LoadUint32(&o.ICSR.Reg) & 0x1ff
}
func (o *SCB_Type) SetICSR_RETTOBASE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetICSR_RETTOBASE() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetICSR_VECTPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x7f000)|value<<12)
}
func (o *SCB_Type) GetICSR_VECTPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x7f000) >> 12
}
func (o *SCB_Type) SetICSR_ISRPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x400000)|value<<22)
}
func (o *SCB_Type) GetICSR_ISRPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x400000) >> 22
}
func (o *SCB_Type) SetICSR_PENDSTCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetICSR_PENDSTCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x2000000) >> 25
}
func (o *SCB_Type) SetICSR_PENDSTSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x4000000)|value<<26)
}
func (o *SCB_Type) GetICSR_PENDSTSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x4000000) >> 26
}
func (o *SCB_Type) SetICSR_PENDSVCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x8000000)|value<<27)
}
func (o *SCB_Type) GetICSR_PENDSVCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x8000000) >> 27
}
func (o *SCB_Type) SetICSR_PENDSVSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10000000)|value<<28)
}
func (o *SCB_Type) GetICSR_PENDSVSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10000000) >> 28
}
func (o *SCB_Type) SetICSR_NMIPENDSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetICSR_NMIPENDSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x80000000) >> 31
}

// SCB.VTOR: Vector table offset register
func (o *SCB_Type) SetVTOR_TBLOFF(value uint32) {
	volatile.StoreUint32(&o.VTOR.Reg, volatile.LoadUint32(&o.VTOR.Reg)&^(0x3ffffe00)|value<<9)
}
func (o *SCB_Type) GetVTOR_TBLOFF() uint32 {
	return (volatile.LoadUint32(&o.VTOR.Reg) & 0x3ffffe00) >> 9
}

// SCB.AIRCR: Application interrupt and reset control register
func (o *SCB_Type) SetAIRCR_VECTRESET(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetAIRCR_VECTRESET() uint32 {
	return volatile.LoadUint32(&o.AIRCR.Reg) & 0x1
}
func (o *SCB_Type) SetAIRCR_VECTCLRACTIVE(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetAIRCR_VECTCLRACTIVE() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetAIRCR_SYSRESETREQ(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetAIRCR_SYSRESETREQ() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetAIRCR_PRIGROUP(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x700)|value<<8)
}
func (o *SCB_Type) GetAIRCR_PRIGROUP() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x700) >> 8
}
func (o *SCB_Type) SetAIRCR_ENDIANESS(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetAIRCR_ENDIANESS() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetAIRCR_VECTKEYSTAT(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCB_Type) GetAIRCR_VECTKEYSTAT() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0xffff0000) >> 16
}

// SCB.SCR: System control register
func (o *SCB_Type) SetSCR_SLEEPONEXIT(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSCR_SLEEPONEXIT() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSCR_SLEEPDEEP(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetSCR_SLEEPDEEP() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetSCR_SEVEONPEND(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetSCR_SEVEONPEND() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}

// SCB.CCR: Configuration and control register
func (o *SCB_Type) SetCCR_NONBASETHRDENA(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetCCR_NONBASETHRDENA() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *SCB_Type) SetCCR_USERSETMPEND(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCCR_USERSETMPEND() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCCR_UNALIGN__TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCCR_UNALIGN__TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCCR_DIV_0_TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCCR_DIV_0_TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCCR_BFHFNMIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCCR_BFHFNMIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCCR_STKALIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x200)|value<<9)
}
func (o *SCB_Type) GetCCR_STKALIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x200) >> 9
}

// SCB.SHPR1: System handler priority registers
func (o *SCB_Type) SetSHPR1_PRI_4(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff)|value)
}
func (o *SCB_Type) GetSHPR1_PRI_4() uint32 {
	return volatile.LoadUint32(&o.SHPR1.Reg) & 0xff
}
func (o *SCB_Type) SetSHPR1_PRI_5(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff00)|value<<8)
}
func (o *SCB_Type) GetSHPR1_PRI_5() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff00) >> 8
}
func (o *SCB_Type) SetSHPR1_PRI_6(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR1_PRI_6() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff0000) >> 16
}

// SCB.SHPR2: System handler priority registers
func (o *SCB_Type) SetSHPR2_PRI_11(value uint32) {
	volatile.StoreUint32(&o.SHPR2.Reg, volatile.LoadUint32(&o.SHPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR2_PRI_11() uint32 {
	return (volatile.LoadUint32(&o.SHPR2.Reg) & 0xff000000) >> 24
}

// SCB.SHPR3: System handler priority registers
func (o *SCB_Type) SetSHPR3_PRI_14(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR3_PRI_14() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff0000) >> 16
}
func (o *SCB_Type) SetSHPR3_PRI_15(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR3_PRI_15() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff000000) >> 24
}

// SCB.SHCRS: System handler control and state register
func (o *SCB_Type) SetSHCRS_MEMFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetSHCRS_MEMFAULTACT() uint32 {
	return volatile.LoadUint32(&o.SHCRS.Reg) & 0x1
}
func (o *SCB_Type) SetSHCRS_BUSFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSHCRS_BUSFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSHCRS_USGFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetSHCRS_USGFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetSHCRS_SVCALLACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetSHCRS_SVCALLACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetSHCRS_MONITORACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetSHCRS_MONITORACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetSHCRS_PENDSVACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetSHCRS_PENDSVACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetSHCRS_SYSTICKACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetSHCRS_SYSTICKACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetSHCRS_USGFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetSHCRS_USGFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x1000) >> 12
}
func (o *SCB_Type) SetSHCRS_MEMFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetSHCRS_MEMFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetSHCRS_BUSFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x4000)|value<<14)
}
func (o *SCB_Type) GetSHCRS_BUSFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x4000) >> 14
}
func (o *SCB_Type) SetSHCRS_SVCALLPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetSHCRS_SVCALLPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetSHCRS_MEMFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetSHCRS_MEMFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetSHCRS_BUSFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetSHCRS_BUSFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetSHCRS_USGFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetSHCRS_USGFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x40000) >> 18
}

// SCB.CFSR_UFSR_BFSR_MMFSR: Configurable fault status register
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IACCVIOL(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IACCVIOL() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MUNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MUNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MLSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x20)|value<<5)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MLSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x20) >> 5
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MMARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MMARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IBUSERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IBUSERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_PRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x200)|value<<9)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_PRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x200) >> 9
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IMPRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IMPRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_STKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_STKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x1000) >> 12
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_LSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_LSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_BFARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_BFARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNDEFINSTR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNDEFINSTR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_INVSTATE(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_INVSTATE() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_INVPC(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_INVPC() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x40000) >> 18
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_NOCP(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x80000)|value<<19)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_NOCP() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x80000) >> 19
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNALIGNED(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNALIGNED() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x1000000) >> 24
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_DIVBYZERO(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_DIVBYZERO() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2000000) >> 25
}

// SCB.HFSR: Hard fault status register
func (o *SCB_Type) SetHFSR_VECTTBL(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetHFSR_VECTTBL() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetHFSR_FORCED(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *SCB_Type) GetHFSR_FORCED() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x40000000) >> 30
}
func (o *SCB_Type) SetHFSR_DEBUG_VT(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetHFSR_DEBUG_VT() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x80000000) >> 31
}

// SCB.MMFAR: Memory management fault address register
func (o *SCB_Type) SetMMFAR(value uint32) {
	volatile.StoreUint32(&o.MMFAR.Reg, value)
}
func (o *SCB_Type) GetMMFAR() uint32 {
	return volatile.LoadUint32(&o.MMFAR.Reg)
}

// SCB.BFAR: Bus fault address register
func (o *SCB_Type) SetBFAR(value uint32) {
	volatile.StoreUint32(&o.BFAR.Reg, value)
}
func (o *SCB_Type) GetBFAR() uint32 {
	return volatile.LoadUint32(&o.BFAR.Reg)
}

// SCB.AFSR: Auxiliary fault status register
func (o *SCB_Type) SetAFSR(value uint32) {
	volatile.StoreUint32(&o.AFSR.Reg, value)
}
func (o *SCB_Type) GetAFSR() uint32 {
	return volatile.LoadUint32(&o.AFSR.Reg)
}

// Constants for ADC_Common: ADC common registers
const (
	// CCR: ADC common control register
	// Position of TSVREFE field.
	ADC_CCR_TSVREFE_Pos = 0x17
	// Bit mask of TSVREFE field.
	ADC_CCR_TSVREFE_Msk = 0x800000
	// Bit TSVREFE.
	ADC_CCR_TSVREFE = 0x800000
	// Temperature sensor and V_REFINT channel disabled
	ADC_CCR_TSVREFE_Disabled = 0x0
	// Temperature sensor and V_REFINT channel enabled
	ADC_CCR_TSVREFE_Enabled = 0x1
	// Position of VBATE field.
	ADC_CCR_VBATE_Pos = 0x16
	// Bit mask of VBATE field.
	ADC_CCR_VBATE_Msk = 0x400000
	// Bit VBATE.
	ADC_CCR_VBATE = 0x400000
	// V_BAT channel disabled
	ADC_CCR_VBATE_Disabled = 0x0
	// V_BAT channel enabled
	ADC_CCR_VBATE_Enabled = 0x1
	// Position of ADCPRE field.
	ADC_CCR_ADCPRE_Pos = 0x10
	// Bit mask of ADCPRE field.
	ADC_CCR_ADCPRE_Msk = 0x30000
	// PCLK2 divided by 2
	ADC_CCR_ADCPRE_Div2 = 0x0
	// PCLK2 divided by 4
	ADC_CCR_ADCPRE_Div4 = 0x1
	// PCLK2 divided by 6
	ADC_CCR_ADCPRE_Div6 = 0x2
	// PCLK2 divided by 8
	ADC_CCR_ADCPRE_Div8 = 0x3
)

// Constants for CRC: Cryptographic processor
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent Data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xff

	// CR: Control register
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1
	// Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
	CRC_CR_RESET_Reset = 0x1
)

// Constants for DBGMCU: Debug support
const (
	// IDCODE: IDCODE
	// Position of DEV_ID field.
	DBG_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBG_IDCODE_DEV_ID_Msk = 0xfff
	// Position of REV_ID field.
	DBG_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBG_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: Control Register
	// Position of DBG_SLEEP field.
	DBG_CR_DBG_SLEEP_Pos = 0x0
	// Bit mask of DBG_SLEEP field.
	DBG_CR_DBG_SLEEP_Msk = 0x1
	// Bit DBG_SLEEP.
	DBG_CR_DBG_SLEEP = 0x1
	// Position of DBG_STOP field.
	DBG_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBG_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBG_CR_DBG_STOP = 0x2
	// Position of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBG_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBG_CR_DBG_STANDBY = 0x4
	// Position of TRACE_IOEN field.
	DBG_CR_TRACE_IOEN_Pos = 0x5
	// Bit mask of TRACE_IOEN field.
	DBG_CR_TRACE_IOEN_Msk = 0x20
	// Bit TRACE_IOEN.
	DBG_CR_TRACE_IOEN = 0x20
	// Position of TRACE_MODE field.
	DBG_CR_TRACE_MODE_Pos = 0x6
	// Bit mask of TRACE_MODE field.
	DBG_CR_TRACE_MODE_Msk = 0xc0

	// APB1_FZ: Debug MCU APB1 Freeze registe
	// Position of DBG_TIM2_STOP field.
	DBG_APB1_FZ_DBG_TIM2_STOP_Pos = 0x0
	// Bit mask of DBG_TIM2_STOP field.
	DBG_APB1_FZ_DBG_TIM2_STOP_Msk = 0x1
	// Bit DBG_TIM2_STOP.
	DBG_APB1_FZ_DBG_TIM2_STOP = 0x1
	// Position of DBG_TIM3_STOP field.
	DBG_APB1_FZ_DBG_TIM3_STOP_Pos = 0x1
	// Bit mask of DBG_TIM3_STOP field.
	DBG_APB1_FZ_DBG_TIM3_STOP_Msk = 0x2
	// Bit DBG_TIM3_STOP.
	DBG_APB1_FZ_DBG_TIM3_STOP = 0x2
	// Position of DBG_TIM4_STOP field.
	DBG_APB1_FZ_DBG_TIM4_STOP_Pos = 0x2
	// Bit mask of DBG_TIM4_STOP field.
	DBG_APB1_FZ_DBG_TIM4_STOP_Msk = 0x4
	// Bit DBG_TIM4_STOP.
	DBG_APB1_FZ_DBG_TIM4_STOP = 0x4
	// Position of DBG_TIM5_STOP field.
	DBG_APB1_FZ_DBG_TIM5_STOP_Pos = 0x3
	// Bit mask of DBG_TIM5_STOP field.
	DBG_APB1_FZ_DBG_TIM5_STOP_Msk = 0x8
	// Bit DBG_TIM5_STOP.
	DBG_APB1_FZ_DBG_TIM5_STOP = 0x8
	// Position of DBG_RTC_Stop field.
	DBG_APB1_FZ_DBG_RTC_Stop_Pos = 0xa
	// Bit mask of DBG_RTC_Stop field.
	DBG_APB1_FZ_DBG_RTC_Stop_Msk = 0x400
	// Bit DBG_RTC_Stop.
	DBG_APB1_FZ_DBG_RTC_Stop = 0x400
	// Position of DBG_WWDG_STOP field.
	DBG_APB1_FZ_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBG_APB1_FZ_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBG_APB1_FZ_DBG_WWDG_STOP = 0x800
	// Position of DBG_IWDG_STOP field.
	DBG_APB1_FZ_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBG_APB1_FZ_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBG_APB1_FZ_DBG_IWDG_STOP = 0x1000
	// Position of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT_Pos = 0x15
	// Bit mask of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT_Msk = 0x200000
	// Bit DBG_I2C1_SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT = 0x200000
	// Position of DBG_I2C2_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2C2_SMBUS_TIMEOUT_Pos = 0x16
	// Bit mask of DBG_I2C2_SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2C2_SMBUS_TIMEOUT_Msk = 0x400000
	// Bit DBG_I2C2_SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_I2C2_SMBUS_TIMEOUT = 0x400000
	// Position of DBG_I2C3SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2C3SMBUS_TIMEOUT_Pos = 0x17
	// Bit mask of DBG_I2C3SMBUS_TIMEOUT field.
	DBG_APB1_FZ_DBG_I2C3SMBUS_TIMEOUT_Msk = 0x800000
	// Bit DBG_I2C3SMBUS_TIMEOUT.
	DBG_APB1_FZ_DBG_I2C3SMBUS_TIMEOUT = 0x800000

	// APB2_FZ: Debug MCU APB2 Freeze registe
	// Position of DBG_TIM1_STOP field.
	DBG_APB2_FZ_DBG_TIM1_STOP_Pos = 0x0
	// Bit mask of DBG_TIM1_STOP field.
	DBG_APB2_FZ_DBG_TIM1_STOP_Msk = 0x1
	// Bit DBG_TIM1_STOP.
	DBG_APB2_FZ_DBG_TIM1_STOP = 0x1
	// Position of DBG_TIM9_STOP field.
	DBG_APB2_FZ_DBG_TIM9_STOP_Pos = 0x10
	// Bit mask of DBG_TIM9_STOP field.
	DBG_APB2_FZ_DBG_TIM9_STOP_Msk = 0x10000
	// Bit DBG_TIM9_STOP.
	DBG_APB2_FZ_DBG_TIM9_STOP = 0x10000
	// Position of DBG_TIM10_STOP field.
	DBG_APB2_FZ_DBG_TIM10_STOP_Pos = 0x11
	// Bit mask of DBG_TIM10_STOP field.
	DBG_APB2_FZ_DBG_TIM10_STOP_Msk = 0x20000
	// Bit DBG_TIM10_STOP.
	DBG_APB2_FZ_DBG_TIM10_STOP = 0x20000
	// Position of DBG_TIM11_STOP field.
	DBG_APB2_FZ_DBG_TIM11_STOP_Pos = 0x12
	// Bit mask of DBG_TIM11_STOP field.
	DBG_APB2_FZ_DBG_TIM11_STOP_Msk = 0x40000
	// Bit DBG_TIM11_STOP.
	DBG_APB2_FZ_DBG_TIM11_STOP = 0x40000
)

// Constants for EXTI: External interrupt/event controller
const (
	// IMR: Interrupt mask register (EXTI_IMR)
	// Position of MR0 field.
	EXTI_IMR_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_IMR_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_IMR_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_IMR_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_IMR_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_IMR_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_IMR_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_IMR_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_IMR_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_IMR_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_IMR_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_IMR_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_IMR_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_IMR_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_IMR_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_IMR_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_IMR_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_IMR_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_IMR_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_IMR_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_IMR_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_IMR_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_IMR_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_IMR_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_IMR_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_IMR_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_IMR_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_IMR_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_IMR_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_IMR_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_IMR_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_IMR_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_IMR_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_IMR_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_IMR_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_IMR_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_IMR_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_IMR_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_IMR_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_IMR_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_IMR_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_IMR_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_IMR_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_IMR_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_IMR_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_IMR_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_IMR_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_IMR_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_IMR_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_IMR_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_IMR_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_IMR_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_IMR_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_IMR_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_IMR_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_IMR_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_IMR_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_IMR_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_IMR_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_IMR_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_IMR_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_IMR_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_IMR_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_IMR_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_IMR_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_IMR_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_IMR_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_IMR_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_IMR_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_IMR_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_IMR_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_IMR_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_IMR_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_IMR_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_IMR_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_IMR_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_IMR_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_IMR_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_IMR_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_IMR_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_IMR_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_IMR_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_IMR_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_IMR_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_IMR_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_IMR_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_IMR_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_IMR_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_IMR_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_IMR_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_IMR_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_IMR_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR22_Unmasked = 0x1

	// EMR: Event mask register (EXTI_EMR)
	// Position of MR0 field.
	EXTI_EMR_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_EMR_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_EMR_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_EMR_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_EMR_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_EMR_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_EMR_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_EMR_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_EMR_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_EMR_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_EMR_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_EMR_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_EMR_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_EMR_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_EMR_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_EMR_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_EMR_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_EMR_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_EMR_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_EMR_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_EMR_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_EMR_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_EMR_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_EMR_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_EMR_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_EMR_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_EMR_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_EMR_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_EMR_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_EMR_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_EMR_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_EMR_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_EMR_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_EMR_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_EMR_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_EMR_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_EMR_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_EMR_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_EMR_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_EMR_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_EMR_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_EMR_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_EMR_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_EMR_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_EMR_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_EMR_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_EMR_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_EMR_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_EMR_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_EMR_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_EMR_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_EMR_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_EMR_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_EMR_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_EMR_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_EMR_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_EMR_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_EMR_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_EMR_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_EMR_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_EMR_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_EMR_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_EMR_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_EMR_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_EMR_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_EMR_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_EMR_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_EMR_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_EMR_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_EMR_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_EMR_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_EMR_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_EMR_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_EMR_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_EMR_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_EMR_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_EMR_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_EMR_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_EMR_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_EMR_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_EMR_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_EMR_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_EMR_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_EMR_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_EMR_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_EMR_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_EMR_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_EMR_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_EMR_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_EMR_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_EMR_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_EMR_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR22_Unmasked = 0x1

	// RTSR: Rising Trigger selection register (EXTI_RTSR)
	// Position of TR0 field.
	EXTI_RTSR_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_RTSR_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_RTSR_TR0 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR_TR0_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_RTSR_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_RTSR_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_RTSR_TR1 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR_TR1_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_RTSR_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_RTSR_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_RTSR_TR2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR_TR2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_RTSR_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_RTSR_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_RTSR_TR3 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR_TR3_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_RTSR_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_RTSR_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_RTSR_TR4 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR_TR4_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_RTSR_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_RTSR_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_RTSR_TR5 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR_TR5_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_RTSR_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_RTSR_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_RTSR_TR6 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR_TR6_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_RTSR_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_RTSR_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_RTSR_TR7 = 0x80
	// Rising edge trigger is disabled
	EXTI_RTSR_TR7_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_RTSR_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_RTSR_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_RTSR_TR8 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR_TR8_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_RTSR_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_RTSR_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_RTSR_TR9 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR_TR9_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_RTSR_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_RTSR_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_RTSR_TR10 = 0x400
	// Rising edge trigger is disabled
	EXTI_RTSR_TR10_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_RTSR_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_RTSR_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_RTSR_TR11 = 0x800
	// Rising edge trigger is disabled
	EXTI_RTSR_TR11_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_RTSR_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_RTSR_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_RTSR_TR12 = 0x1000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR12_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_RTSR_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_RTSR_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_RTSR_TR13 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR13_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_RTSR_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_RTSR_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_RTSR_TR14 = 0x4000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR14_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_RTSR_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_RTSR_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_RTSR_TR15 = 0x8000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR15_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_RTSR_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_RTSR_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_RTSR_TR16 = 0x10000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR16_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_RTSR_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_RTSR_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_RTSR_TR17 = 0x20000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR17_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR17_Enabled = 0x1
	// Position of TR18 field.
	EXTI_RTSR_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_RTSR_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_RTSR_TR18 = 0x40000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR18_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_RTSR_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_RTSR_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_RTSR_TR19 = 0x80000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR19_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_RTSR_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_RTSR_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_RTSR_TR20 = 0x100000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR20_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_RTSR_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_RTSR_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_RTSR_TR21 = 0x200000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR21_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_RTSR_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_RTSR_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_RTSR_TR22 = 0x400000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR22_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR22_Enabled = 0x1

	// FTSR: Falling Trigger selection register (EXTI_FTSR)
	// Position of TR0 field.
	EXTI_FTSR_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_FTSR_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_FTSR_TR0 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR_TR0_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_FTSR_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_FTSR_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_FTSR_TR1 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR_TR1_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_FTSR_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_FTSR_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_FTSR_TR2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR_TR2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_FTSR_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_FTSR_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_FTSR_TR3 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR_TR3_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_FTSR_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_FTSR_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_FTSR_TR4 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR_TR4_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_FTSR_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_FTSR_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_FTSR_TR5 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR_TR5_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_FTSR_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_FTSR_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_FTSR_TR6 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR_TR6_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_FTSR_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_FTSR_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_FTSR_TR7 = 0x80
	// Falling edge trigger is disabled
	EXTI_FTSR_TR7_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_FTSR_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_FTSR_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_FTSR_TR8 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR_TR8_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_FTSR_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_FTSR_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_FTSR_TR9 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR_TR9_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_FTSR_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_FTSR_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_FTSR_TR10 = 0x400
	// Falling edge trigger is disabled
	EXTI_FTSR_TR10_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_FTSR_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_FTSR_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_FTSR_TR11 = 0x800
	// Falling edge trigger is disabled
	EXTI_FTSR_TR11_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_FTSR_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_FTSR_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_FTSR_TR12 = 0x1000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR12_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_FTSR_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_FTSR_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_FTSR_TR13 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR13_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_FTSR_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_FTSR_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_FTSR_TR14 = 0x4000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR14_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_FTSR_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_FTSR_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_FTSR_TR15 = 0x8000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR15_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_FTSR_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_FTSR_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_FTSR_TR16 = 0x10000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR16_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_FTSR_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_FTSR_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_FTSR_TR17 = 0x20000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR17_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR17_Enabled = 0x1
	// Position of TR18 field.
	EXTI_FTSR_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_FTSR_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_FTSR_TR18 = 0x40000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR18_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_FTSR_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_FTSR_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_FTSR_TR19 = 0x80000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR19_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_FTSR_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_FTSR_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_FTSR_TR20 = 0x100000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR20_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_FTSR_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_FTSR_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_FTSR_TR21 = 0x200000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR21_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_FTSR_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_FTSR_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_FTSR_TR22 = 0x400000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR22_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR22_Enabled = 0x1

	// SWIER: Software interrupt event register (EXTI_SWIER)
	// Position of SWIER0 field.
	EXTI_SWIER_SWIER0_Pos = 0x0
	// Bit mask of SWIER0 field.
	EXTI_SWIER_SWIER0_Msk = 0x1
	// Bit SWIER0.
	EXTI_SWIER_SWIER0 = 0x1
	// Generates an interrupt request
	EXTI_SWIER_SWIER0_Pend = 0x1
	// Position of SWIER1 field.
	EXTI_SWIER_SWIER1_Pos = 0x1
	// Bit mask of SWIER1 field.
	EXTI_SWIER_SWIER1_Msk = 0x2
	// Bit SWIER1.
	EXTI_SWIER_SWIER1 = 0x2
	// Generates an interrupt request
	EXTI_SWIER_SWIER1_Pend = 0x1
	// Position of SWIER2 field.
	EXTI_SWIER_SWIER2_Pos = 0x2
	// Bit mask of SWIER2 field.
	EXTI_SWIER_SWIER2_Msk = 0x4
	// Bit SWIER2.
	EXTI_SWIER_SWIER2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER_SWIER2_Pend = 0x1
	// Position of SWIER3 field.
	EXTI_SWIER_SWIER3_Pos = 0x3
	// Bit mask of SWIER3 field.
	EXTI_SWIER_SWIER3_Msk = 0x8
	// Bit SWIER3.
	EXTI_SWIER_SWIER3 = 0x8
	// Generates an interrupt request
	EXTI_SWIER_SWIER3_Pend = 0x1
	// Position of SWIER4 field.
	EXTI_SWIER_SWIER4_Pos = 0x4
	// Bit mask of SWIER4 field.
	EXTI_SWIER_SWIER4_Msk = 0x10
	// Bit SWIER4.
	EXTI_SWIER_SWIER4 = 0x10
	// Generates an interrupt request
	EXTI_SWIER_SWIER4_Pend = 0x1
	// Position of SWIER5 field.
	EXTI_SWIER_SWIER5_Pos = 0x5
	// Bit mask of SWIER5 field.
	EXTI_SWIER_SWIER5_Msk = 0x20
	// Bit SWIER5.
	EXTI_SWIER_SWIER5 = 0x20
	// Generates an interrupt request
	EXTI_SWIER_SWIER5_Pend = 0x1
	// Position of SWIER6 field.
	EXTI_SWIER_SWIER6_Pos = 0x6
	// Bit mask of SWIER6 field.
	EXTI_SWIER_SWIER6_Msk = 0x40
	// Bit SWIER6.
	EXTI_SWIER_SWIER6 = 0x40
	// Generates an interrupt request
	EXTI_SWIER_SWIER6_Pend = 0x1
	// Position of SWIER7 field.
	EXTI_SWIER_SWIER7_Pos = 0x7
	// Bit mask of SWIER7 field.
	EXTI_SWIER_SWIER7_Msk = 0x80
	// Bit SWIER7.
	EXTI_SWIER_SWIER7 = 0x80
	// Generates an interrupt request
	EXTI_SWIER_SWIER7_Pend = 0x1
	// Position of SWIER8 field.
	EXTI_SWIER_SWIER8_Pos = 0x8
	// Bit mask of SWIER8 field.
	EXTI_SWIER_SWIER8_Msk = 0x100
	// Bit SWIER8.
	EXTI_SWIER_SWIER8 = 0x100
	// Generates an interrupt request
	EXTI_SWIER_SWIER8_Pend = 0x1
	// Position of SWIER9 field.
	EXTI_SWIER_SWIER9_Pos = 0x9
	// Bit mask of SWIER9 field.
	EXTI_SWIER_SWIER9_Msk = 0x200
	// Bit SWIER9.
	EXTI_SWIER_SWIER9 = 0x200
	// Generates an interrupt request
	EXTI_SWIER_SWIER9_Pend = 0x1
	// Position of SWIER10 field.
	EXTI_SWIER_SWIER10_Pos = 0xa
	// Bit mask of SWIER10 field.
	EXTI_SWIER_SWIER10_Msk = 0x400
	// Bit SWIER10.
	EXTI_SWIER_SWIER10 = 0x400
	// Generates an interrupt request
	EXTI_SWIER_SWIER10_Pend = 0x1
	// Position of SWIER11 field.
	EXTI_SWIER_SWIER11_Pos = 0xb
	// Bit mask of SWIER11 field.
	EXTI_SWIER_SWIER11_Msk = 0x800
	// Bit SWIER11.
	EXTI_SWIER_SWIER11 = 0x800
	// Generates an interrupt request
	EXTI_SWIER_SWIER11_Pend = 0x1
	// Position of SWIER12 field.
	EXTI_SWIER_SWIER12_Pos = 0xc
	// Bit mask of SWIER12 field.
	EXTI_SWIER_SWIER12_Msk = 0x1000
	// Bit SWIER12.
	EXTI_SWIER_SWIER12 = 0x1000
	// Generates an interrupt request
	EXTI_SWIER_SWIER12_Pend = 0x1
	// Position of SWIER13 field.
	EXTI_SWIER_SWIER13_Pos = 0xd
	// Bit mask of SWIER13 field.
	EXTI_SWIER_SWIER13_Msk = 0x2000
	// Bit SWIER13.
	EXTI_SWIER_SWIER13 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER_SWIER13_Pend = 0x1
	// Position of SWIER14 field.
	EXTI_SWIER_SWIER14_Pos = 0xe
	// Bit mask of SWIER14 field.
	EXTI_SWIER_SWIER14_Msk = 0x4000
	// Bit SWIER14.
	EXTI_SWIER_SWIER14 = 0x4000
	// Generates an interrupt request
	EXTI_SWIER_SWIER14_Pend = 0x1
	// Position of SWIER15 field.
	EXTI_SWIER_SWIER15_Pos = 0xf
	// Bit mask of SWIER15 field.
	EXTI_SWIER_SWIER15_Msk = 0x8000
	// Bit SWIER15.
	EXTI_SWIER_SWIER15 = 0x8000
	// Generates an interrupt request
	EXTI_SWIER_SWIER15_Pend = 0x1
	// Position of SWIER16 field.
	EXTI_SWIER_SWIER16_Pos = 0x10
	// Bit mask of SWIER16 field.
	EXTI_SWIER_SWIER16_Msk = 0x10000
	// Bit SWIER16.
	EXTI_SWIER_SWIER16 = 0x10000
	// Generates an interrupt request
	EXTI_SWIER_SWIER16_Pend = 0x1
	// Position of SWIER17 field.
	EXTI_SWIER_SWIER17_Pos = 0x11
	// Bit mask of SWIER17 field.
	EXTI_SWIER_SWIER17_Msk = 0x20000
	// Bit SWIER17.
	EXTI_SWIER_SWIER17 = 0x20000
	// Generates an interrupt request
	EXTI_SWIER_SWIER17_Pend = 0x1
	// Position of SWIER18 field.
	EXTI_SWIER_SWIER18_Pos = 0x12
	// Bit mask of SWIER18 field.
	EXTI_SWIER_SWIER18_Msk = 0x40000
	// Bit SWIER18.
	EXTI_SWIER_SWIER18 = 0x40000
	// Generates an interrupt request
	EXTI_SWIER_SWIER18_Pend = 0x1
	// Position of SWIER19 field.
	EXTI_SWIER_SWIER19_Pos = 0x13
	// Bit mask of SWIER19 field.
	EXTI_SWIER_SWIER19_Msk = 0x80000
	// Bit SWIER19.
	EXTI_SWIER_SWIER19 = 0x80000
	// Generates an interrupt request
	EXTI_SWIER_SWIER19_Pend = 0x1
	// Position of SWIER20 field.
	EXTI_SWIER_SWIER20_Pos = 0x14
	// Bit mask of SWIER20 field.
	EXTI_SWIER_SWIER20_Msk = 0x100000
	// Bit SWIER20.
	EXTI_SWIER_SWIER20 = 0x100000
	// Generates an interrupt request
	EXTI_SWIER_SWIER20_Pend = 0x1
	// Position of SWIER21 field.
	EXTI_SWIER_SWIER21_Pos = 0x15
	// Bit mask of SWIER21 field.
	EXTI_SWIER_SWIER21_Msk = 0x200000
	// Bit SWIER21.
	EXTI_SWIER_SWIER21 = 0x200000
	// Generates an interrupt request
	EXTI_SWIER_SWIER21_Pend = 0x1
	// Position of SWIER22 field.
	EXTI_SWIER_SWIER22_Pos = 0x16
	// Bit mask of SWIER22 field.
	EXTI_SWIER_SWIER22_Msk = 0x400000
	// Bit SWIER22.
	EXTI_SWIER_SWIER22 = 0x400000
	// Generates an interrupt request
	EXTI_SWIER_SWIER22_Pend = 0x1

	// PR: Pending register (EXTI_PR)
	// Position of PR0 field.
	EXTI_PR_PR0_Pos = 0x0
	// Bit mask of PR0 field.
	EXTI_PR_PR0_Msk = 0x1
	// Bit PR0.
	EXTI_PR_PR0 = 0x1
	// No trigger request occurred
	EXTI_PR_PR0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR0_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR0_Clear = 0x1
	// Position of PR1 field.
	EXTI_PR_PR1_Pos = 0x1
	// Bit mask of PR1 field.
	EXTI_PR_PR1_Msk = 0x2
	// Bit PR1.
	EXTI_PR_PR1 = 0x2
	// No trigger request occurred
	EXTI_PR_PR1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR1_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR1_Clear = 0x1
	// Position of PR2 field.
	EXTI_PR_PR2_Pos = 0x2
	// Bit mask of PR2 field.
	EXTI_PR_PR2_Msk = 0x4
	// Bit PR2.
	EXTI_PR_PR2 = 0x4
	// No trigger request occurred
	EXTI_PR_PR2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR2_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR2_Clear = 0x1
	// Position of PR3 field.
	EXTI_PR_PR3_Pos = 0x3
	// Bit mask of PR3 field.
	EXTI_PR_PR3_Msk = 0x8
	// Bit PR3.
	EXTI_PR_PR3 = 0x8
	// No trigger request occurred
	EXTI_PR_PR3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR3_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR3_Clear = 0x1
	// Position of PR4 field.
	EXTI_PR_PR4_Pos = 0x4
	// Bit mask of PR4 field.
	EXTI_PR_PR4_Msk = 0x10
	// Bit PR4.
	EXTI_PR_PR4 = 0x10
	// No trigger request occurred
	EXTI_PR_PR4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR4_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR4_Clear = 0x1
	// Position of PR5 field.
	EXTI_PR_PR5_Pos = 0x5
	// Bit mask of PR5 field.
	EXTI_PR_PR5_Msk = 0x20
	// Bit PR5.
	EXTI_PR_PR5 = 0x20
	// No trigger request occurred
	EXTI_PR_PR5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR5_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR5_Clear = 0x1
	// Position of PR6 field.
	EXTI_PR_PR6_Pos = 0x6
	// Bit mask of PR6 field.
	EXTI_PR_PR6_Msk = 0x40
	// Bit PR6.
	EXTI_PR_PR6 = 0x40
	// No trigger request occurred
	EXTI_PR_PR6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR6_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR6_Clear = 0x1
	// Position of PR7 field.
	EXTI_PR_PR7_Pos = 0x7
	// Bit mask of PR7 field.
	EXTI_PR_PR7_Msk = 0x80
	// Bit PR7.
	EXTI_PR_PR7 = 0x80
	// No trigger request occurred
	EXTI_PR_PR7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR7_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR7_Clear = 0x1
	// Position of PR8 field.
	EXTI_PR_PR8_Pos = 0x8
	// Bit mask of PR8 field.
	EXTI_PR_PR8_Msk = 0x100
	// Bit PR8.
	EXTI_PR_PR8 = 0x100
	// No trigger request occurred
	EXTI_PR_PR8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR8_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR8_Clear = 0x1
	// Position of PR9 field.
	EXTI_PR_PR9_Pos = 0x9
	// Bit mask of PR9 field.
	EXTI_PR_PR9_Msk = 0x200
	// Bit PR9.
	EXTI_PR_PR9 = 0x200
	// No trigger request occurred
	EXTI_PR_PR9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR9_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR9_Clear = 0x1
	// Position of PR10 field.
	EXTI_PR_PR10_Pos = 0xa
	// Bit mask of PR10 field.
	EXTI_PR_PR10_Msk = 0x400
	// Bit PR10.
	EXTI_PR_PR10 = 0x400
	// No trigger request occurred
	EXTI_PR_PR10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR10_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR10_Clear = 0x1
	// Position of PR11 field.
	EXTI_PR_PR11_Pos = 0xb
	// Bit mask of PR11 field.
	EXTI_PR_PR11_Msk = 0x800
	// Bit PR11.
	EXTI_PR_PR11 = 0x800
	// No trigger request occurred
	EXTI_PR_PR11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR11_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR11_Clear = 0x1
	// Position of PR12 field.
	EXTI_PR_PR12_Pos = 0xc
	// Bit mask of PR12 field.
	EXTI_PR_PR12_Msk = 0x1000
	// Bit PR12.
	EXTI_PR_PR12 = 0x1000
	// No trigger request occurred
	EXTI_PR_PR12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR12_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR12_Clear = 0x1
	// Position of PR13 field.
	EXTI_PR_PR13_Pos = 0xd
	// Bit mask of PR13 field.
	EXTI_PR_PR13_Msk = 0x2000
	// Bit PR13.
	EXTI_PR_PR13 = 0x2000
	// No trigger request occurred
	EXTI_PR_PR13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR13_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR13_Clear = 0x1
	// Position of PR14 field.
	EXTI_PR_PR14_Pos = 0xe
	// Bit mask of PR14 field.
	EXTI_PR_PR14_Msk = 0x4000
	// Bit PR14.
	EXTI_PR_PR14 = 0x4000
	// No trigger request occurred
	EXTI_PR_PR14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR14_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR14_Clear = 0x1
	// Position of PR15 field.
	EXTI_PR_PR15_Pos = 0xf
	// Bit mask of PR15 field.
	EXTI_PR_PR15_Msk = 0x8000
	// Bit PR15.
	EXTI_PR_PR15 = 0x8000
	// No trigger request occurred
	EXTI_PR_PR15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR15_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR15_Clear = 0x1
	// Position of PR16 field.
	EXTI_PR_PR16_Pos = 0x10
	// Bit mask of PR16 field.
	EXTI_PR_PR16_Msk = 0x10000
	// Bit PR16.
	EXTI_PR_PR16 = 0x10000
	// No trigger request occurred
	EXTI_PR_PR16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR16_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR16_Clear = 0x1
	// Position of PR17 field.
	EXTI_PR_PR17_Pos = 0x11
	// Bit mask of PR17 field.
	EXTI_PR_PR17_Msk = 0x20000
	// Bit PR17.
	EXTI_PR_PR17 = 0x20000
	// No trigger request occurred
	EXTI_PR_PR17_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR17_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR17_Clear = 0x1
	// Position of PR18 field.
	EXTI_PR_PR18_Pos = 0x12
	// Bit mask of PR18 field.
	EXTI_PR_PR18_Msk = 0x40000
	// Bit PR18.
	EXTI_PR_PR18 = 0x40000
	// No trigger request occurred
	EXTI_PR_PR18_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR18_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR18_Clear = 0x1
	// Position of PR19 field.
	EXTI_PR_PR19_Pos = 0x13
	// Bit mask of PR19 field.
	EXTI_PR_PR19_Msk = 0x80000
	// Bit PR19.
	EXTI_PR_PR19 = 0x80000
	// No trigger request occurred
	EXTI_PR_PR19_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR19_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR19_Clear = 0x1
	// Position of PR20 field.
	EXTI_PR_PR20_Pos = 0x14
	// Bit mask of PR20 field.
	EXTI_PR_PR20_Msk = 0x100000
	// Bit PR20.
	EXTI_PR_PR20 = 0x100000
	// No trigger request occurred
	EXTI_PR_PR20_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR20_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR20_Clear = 0x1
	// Position of PR21 field.
	EXTI_PR_PR21_Pos = 0x15
	// Bit mask of PR21 field.
	EXTI_PR_PR21_Msk = 0x200000
	// Bit PR21.
	EXTI_PR_PR21 = 0x200000
	// No trigger request occurred
	EXTI_PR_PR21_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR21_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR21_Clear = 0x1
	// Position of PR22 field.
	EXTI_PR_PR22_Pos = 0x16
	// Bit mask of PR22 field.
	EXTI_PR_PR22_Msk = 0x400000
	// Bit PR22.
	EXTI_PR_PR22 = 0x400000
	// No trigger request occurred
	EXTI_PR_PR22_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR22_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR22_Clear = 0x1
)

// Constants for FLASH: FLASH
const (
	// ACR: Flash access control register
	// Position of LATENCY field.
	FLASH_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	FLASH_ACR_LATENCY_Msk = 0xf
	// 0 wait states
	FLASH_ACR_LATENCY_WS0 = 0x0
	// 1 wait states
	FLASH_ACR_LATENCY_WS1 = 0x1
	// 2 wait states
	FLASH_ACR_LATENCY_WS2 = 0x2
	// 3 wait states
	FLASH_ACR_LATENCY_WS3 = 0x3
	// 4 wait states
	FLASH_ACR_LATENCY_WS4 = 0x4
	// 5 wait states
	FLASH_ACR_LATENCY_WS5 = 0x5
	// 6 wait states
	FLASH_ACR_LATENCY_WS6 = 0x6
	// 7 wait states
	FLASH_ACR_LATENCY_WS7 = 0x7
	// 8 wait states
	FLASH_ACR_LATENCY_WS8 = 0x8
	// 9 wait states
	FLASH_ACR_LATENCY_WS9 = 0x9
	// 10 wait states
	FLASH_ACR_LATENCY_WS10 = 0xa
	// 11 wait states
	FLASH_ACR_LATENCY_WS11 = 0xb
	// 12 wait states
	FLASH_ACR_LATENCY_WS12 = 0xc
	// 13 wait states
	FLASH_ACR_LATENCY_WS13 = 0xd
	// 14 wait states
	FLASH_ACR_LATENCY_WS14 = 0xe
	// 15 wait states
	FLASH_ACR_LATENCY_WS15 = 0xf
	// Position of PRFTEN field.
	FLASH_ACR_PRFTEN_Pos = 0x8
	// Bit mask of PRFTEN field.
	FLASH_ACR_PRFTEN_Msk = 0x100
	// Bit PRFTEN.
	FLASH_ACR_PRFTEN = 0x100
	// Prefetch is disabled
	FLASH_ACR_PRFTEN_Disabled = 0x0
	// Prefetch is enabled
	FLASH_ACR_PRFTEN_Enabled = 0x1
	// Position of ICEN field.
	FLASH_ACR_ICEN_Pos = 0x9
	// Bit mask of ICEN field.
	FLASH_ACR_ICEN_Msk = 0x200
	// Bit ICEN.
	FLASH_ACR_ICEN = 0x200
	// Instruction cache is disabled
	FLASH_ACR_ICEN_Disabled = 0x0
	// Instruction cache is enabled
	FLASH_ACR_ICEN_Enabled = 0x1
	// Position of DCEN field.
	FLASH_ACR_DCEN_Pos = 0xa
	// Bit mask of DCEN field.
	FLASH_ACR_DCEN_Msk = 0x400
	// Bit DCEN.
	FLASH_ACR_DCEN = 0x400
	// Data cache is disabled
	FLASH_ACR_DCEN_Disabled = 0x0
	// Data cache is enabled
	FLASH_ACR_DCEN_Enabled = 0x1
	// Position of ICRST field.
	FLASH_ACR_ICRST_Pos = 0xb
	// Bit mask of ICRST field.
	FLASH_ACR_ICRST_Msk = 0x800
	// Bit ICRST.
	FLASH_ACR_ICRST = 0x800
	// Instruction cache is not reset
	FLASH_ACR_ICRST_NotReset = 0x0
	// Instruction cache is reset
	FLASH_ACR_ICRST_Reset = 0x1
	// Position of DCRST field.
	FLASH_ACR_DCRST_Pos = 0xc
	// Bit mask of DCRST field.
	FLASH_ACR_DCRST_Msk = 0x1000
	// Bit DCRST.
	FLASH_ACR_DCRST = 0x1000
	// Data cache is not reset
	FLASH_ACR_DCRST_NotReset = 0x0
	// Data cache is reset
	FLASH_ACR_DCRST_Reset = 0x1

	// KEYR: Flash key register
	// Position of KEY field.
	FLASH_KEYR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	FLASH_KEYR_KEY_Msk = 0xffffffff

	// OPTKEYR: Flash option key register
	// Position of OPTKEY field.
	FLASH_OPTKEYR_OPTKEY_Pos = 0x0
	// Bit mask of OPTKEY field.
	FLASH_OPTKEYR_OPTKEY_Msk = 0xffffffff

	// SR: Status register
	// Position of EOP field.
	FLASH_SR_EOP_Pos = 0x0
	// Bit mask of EOP field.
	FLASH_SR_EOP_Msk = 0x1
	// Bit EOP.
	FLASH_SR_EOP = 0x1
	// Position of OPERR field.
	FLASH_SR_OPERR_Pos = 0x1
	// Bit mask of OPERR field.
	FLASH_SR_OPERR_Msk = 0x2
	// Bit OPERR.
	FLASH_SR_OPERR = 0x2
	// Position of WRPERR field.
	FLASH_SR_WRPERR_Pos = 0x4
	// Bit mask of WRPERR field.
	FLASH_SR_WRPERR_Msk = 0x10
	// Bit WRPERR.
	FLASH_SR_WRPERR = 0x10
	// Position of PGAERR field.
	FLASH_SR_PGAERR_Pos = 0x5
	// Bit mask of PGAERR field.
	FLASH_SR_PGAERR_Msk = 0x20
	// Bit PGAERR.
	FLASH_SR_PGAERR = 0x20
	// Position of PGPERR field.
	FLASH_SR_PGPERR_Pos = 0x6
	// Bit mask of PGPERR field.
	FLASH_SR_PGPERR_Msk = 0x40
	// Bit PGPERR.
	FLASH_SR_PGPERR = 0x40
	// Position of PGSERR field.
	FLASH_SR_PGSERR_Pos = 0x7
	// Bit mask of PGSERR field.
	FLASH_SR_PGSERR_Msk = 0x80
	// Bit PGSERR.
	FLASH_SR_PGSERR = 0x80
	// Position of BSY field.
	FLASH_SR_BSY_Pos = 0x10
	// Bit mask of BSY field.
	FLASH_SR_BSY_Msk = 0x10000
	// Bit BSY.
	FLASH_SR_BSY = 0x10000

	// CR: Control register
	// Position of PG field.
	FLASH_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	FLASH_CR_PG_Msk = 0x1
	// Bit PG.
	FLASH_CR_PG = 0x1
	// Flash programming activated
	FLASH_CR_PG_Program = 0x1
	// Position of SER field.
	FLASH_CR_SER_Pos = 0x1
	// Bit mask of SER field.
	FLASH_CR_SER_Msk = 0x2
	// Bit SER.
	FLASH_CR_SER = 0x2
	// Erase activated for selected sector
	FLASH_CR_SER_SectorErase = 0x1
	// Position of MER field.
	FLASH_CR_MER_Pos = 0x2
	// Bit mask of MER field.
	FLASH_CR_MER_Msk = 0x4
	// Bit MER.
	FLASH_CR_MER = 0x4
	// Erase activated for all user sectors
	FLASH_CR_MER_MassErase = 0x1
	// Position of SNB field.
	FLASH_CR_SNB_Pos = 0x3
	// Bit mask of SNB field.
	FLASH_CR_SNB_Msk = 0x78
	// Position of PSIZE field.
	FLASH_CR_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	FLASH_CR_PSIZE_Msk = 0x300
	// Program x8
	FLASH_CR_PSIZE_PSIZE8 = 0x0
	// Program x16
	FLASH_CR_PSIZE_PSIZE16 = 0x1
	// Program x32
	FLASH_CR_PSIZE_PSIZE32 = 0x2
	// Program x64
	FLASH_CR_PSIZE_PSIZE64 = 0x3
	// Position of STRT field.
	FLASH_CR_STRT_Pos = 0x10
	// Bit mask of STRT field.
	FLASH_CR_STRT_Msk = 0x10000
	// Bit STRT.
	FLASH_CR_STRT = 0x10000
	// Trigger an erase operation
	FLASH_CR_STRT_Start = 0x1
	// Position of EOPIE field.
	FLASH_CR_EOPIE_Pos = 0x18
	// Bit mask of EOPIE field.
	FLASH_CR_EOPIE_Msk = 0x1000000
	// Bit EOPIE.
	FLASH_CR_EOPIE = 0x1000000
	// End of operation interrupt disabled
	FLASH_CR_EOPIE_Disabled = 0x0
	// End of operation interrupt enabled
	FLASH_CR_EOPIE_Enabled = 0x1
	// Position of ERRIE field.
	FLASH_CR_ERRIE_Pos = 0x19
	// Bit mask of ERRIE field.
	FLASH_CR_ERRIE_Msk = 0x2000000
	// Bit ERRIE.
	FLASH_CR_ERRIE = 0x2000000
	// Error interrupt generation disabled
	FLASH_CR_ERRIE_Disabled = 0x0
	// Error interrupt generation enabled
	FLASH_CR_ERRIE_Enabled = 0x1
	// Position of LOCK field.
	FLASH_CR_LOCK_Pos = 0x1f
	// Bit mask of LOCK field.
	FLASH_CR_LOCK_Msk = 0x80000000
	// Bit LOCK.
	FLASH_CR_LOCK = 0x80000000
	// FLASH_CR register is unlocked
	FLASH_CR_LOCK_Unlocked = 0x0
	// FLASH_CR register is locked
	FLASH_CR_LOCK_Locked = 0x1

	// OPTCR: Flash option control register
	// Position of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK_Pos = 0x0
	// Bit mask of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK_Msk = 0x1
	// Bit OPTLOCK.
	FLASH_OPTCR_OPTLOCK = 0x1
	// Position of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT_Pos = 0x1
	// Bit mask of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT_Msk = 0x2
	// Bit OPTSTRT.
	FLASH_OPTCR_OPTSTRT = 0x2
	// Position of BOR_LEV field.
	FLASH_OPTCR_BOR_LEV_Pos = 0x2
	// Bit mask of BOR_LEV field.
	FLASH_OPTCR_BOR_LEV_Msk = 0xc
	// Position of WDG_SW field.
	FLASH_OPTCR_WDG_SW_Pos = 0x5
	// Bit mask of WDG_SW field.
	FLASH_OPTCR_WDG_SW_Msk = 0x20
	// Bit WDG_SW.
	FLASH_OPTCR_WDG_SW = 0x20
	// Position of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP_Pos = 0x6
	// Bit mask of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP_Msk = 0x40
	// Bit NRST_STOP.
	FLASH_OPTCR_NRST_STOP = 0x40
	// Position of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY_Pos = 0x7
	// Bit mask of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY_Msk = 0x80
	// Bit NRST_STDBY.
	FLASH_OPTCR_NRST_STDBY = 0x80
	// Position of RDP field.
	FLASH_OPTCR_RDP_Pos = 0x8
	// Bit mask of RDP field.
	FLASH_OPTCR_RDP_Msk = 0xff00
	// Position of NWRP field.
	FLASH_OPTCR_NWRP_Pos = 0x10
	// Bit mask of NWRP field.
	FLASH_OPTCR_NWRP_Msk = 0xfff0000
)

// Constants for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff
	// Enable access to PR, RLR and WINR registers (0x5555)
	IWDG_KR_KEY_Enable = 0x5555
	// Reset the watchdog value (0xAAAA)
	IWDG_KR_KEY_Reset = 0xaaaa
	// Start the watchdog (0xCCCC)
	IWDG_KR_KEY_Start = 0xcccc

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// Divider /4
	IWDG_PR_PR_DivideBy4 = 0x0
	// Divider /8
	IWDG_PR_PR_DivideBy8 = 0x1
	// Divider /16
	IWDG_PR_PR_DivideBy16 = 0x2
	// Divider /32
	IWDG_PR_PR_DivideBy32 = 0x3
	// Divider /64
	IWDG_PR_PR_DivideBy64 = 0x4
	// Divider /128
	IWDG_PR_PR_DivideBy128 = 0x5
	// Divider /256
	IWDG_PR_PR_DivideBy256 = 0x6
	// Divider /256
	IWDG_PR_PR_DivideBy256bis = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1
)

// Constants for OTG_FS_DEVICE: USB on the go full speed
const (
	// DCFG: OTG_FS device configuration register (OTG_FS_DCFG)
	// Position of DSPD field.
	USB_OTG_FS_DCFG_DSPD_Pos = 0x0
	// Bit mask of DSPD field.
	USB_OTG_FS_DCFG_DSPD_Msk = 0x3
	// Position of NZLSOHSK field.
	USB_OTG_FS_DCFG_NZLSOHSK_Pos = 0x2
	// Bit mask of NZLSOHSK field.
	USB_OTG_FS_DCFG_NZLSOHSK_Msk = 0x4
	// Bit NZLSOHSK.
	USB_OTG_FS_DCFG_NZLSOHSK = 0x4
	// Position of DAD field.
	USB_OTG_FS_DCFG_DAD_Pos = 0x4
	// Bit mask of DAD field.
	USB_OTG_FS_DCFG_DAD_Msk = 0x7f0
	// Position of PFIVL field.
	USB_OTG_FS_DCFG_PFIVL_Pos = 0xb
	// Bit mask of PFIVL field.
	USB_OTG_FS_DCFG_PFIVL_Msk = 0x1800

	// DCTL: OTG_FS device control register (OTG_FS_DCTL)
	// Position of RWUSIG field.
	USB_OTG_FS_DCTL_RWUSIG_Pos = 0x0
	// Bit mask of RWUSIG field.
	USB_OTG_FS_DCTL_RWUSIG_Msk = 0x1
	// Bit RWUSIG.
	USB_OTG_FS_DCTL_RWUSIG = 0x1
	// Position of SDIS field.
	USB_OTG_FS_DCTL_SDIS_Pos = 0x1
	// Bit mask of SDIS field.
	USB_OTG_FS_DCTL_SDIS_Msk = 0x2
	// Bit SDIS.
	USB_OTG_FS_DCTL_SDIS = 0x2
	// Position of GINSTS field.
	USB_OTG_FS_DCTL_GINSTS_Pos = 0x2
	// Bit mask of GINSTS field.
	USB_OTG_FS_DCTL_GINSTS_Msk = 0x4
	// Bit GINSTS.
	USB_OTG_FS_DCTL_GINSTS = 0x4
	// Position of GONSTS field.
	USB_OTG_FS_DCTL_GONSTS_Pos = 0x3
	// Bit mask of GONSTS field.
	USB_OTG_FS_DCTL_GONSTS_Msk = 0x8
	// Bit GONSTS.
	USB_OTG_FS_DCTL_GONSTS = 0x8
	// Position of TCTL field.
	USB_OTG_FS_DCTL_TCTL_Pos = 0x4
	// Bit mask of TCTL field.
	USB_OTG_FS_DCTL_TCTL_Msk = 0x70
	// Position of SGINAK field.
	USB_OTG_FS_DCTL_SGINAK_Pos = 0x7
	// Bit mask of SGINAK field.
	USB_OTG_FS_DCTL_SGINAK_Msk = 0x80
	// Bit SGINAK.
	USB_OTG_FS_DCTL_SGINAK = 0x80
	// Position of CGINAK field.
	USB_OTG_FS_DCTL_CGINAK_Pos = 0x8
	// Bit mask of CGINAK field.
	USB_OTG_FS_DCTL_CGINAK_Msk = 0x100
	// Bit CGINAK.
	USB_OTG_FS_DCTL_CGINAK = 0x100
	// Position of SGONAK field.
	USB_OTG_FS_DCTL_SGONAK_Pos = 0x9
	// Bit mask of SGONAK field.
	USB_OTG_FS_DCTL_SGONAK_Msk = 0x200
	// Bit SGONAK.
	USB_OTG_FS_DCTL_SGONAK = 0x200
	// Position of CGONAK field.
	USB_OTG_FS_DCTL_CGONAK_Pos = 0xa
	// Bit mask of CGONAK field.
	USB_OTG_FS_DCTL_CGONAK_Msk = 0x400
	// Bit CGONAK.
	USB_OTG_FS_DCTL_CGONAK = 0x400
	// Position of POPRGDNE field.
	USB_OTG_FS_DCTL_POPRGDNE_Pos = 0xb
	// Bit mask of POPRGDNE field.
	USB_OTG_FS_DCTL_POPRGDNE_Msk = 0x800
	// Bit POPRGDNE.
	USB_OTG_FS_DCTL_POPRGDNE = 0x800

	// DSTS: OTG_FS device status register (OTG_FS_DSTS)
	// Position of SUSPSTS field.
	USB_OTG_FS_DSTS_SUSPSTS_Pos = 0x0
	// Bit mask of SUSPSTS field.
	USB_OTG_FS_DSTS_SUSPSTS_Msk = 0x1
	// Bit SUSPSTS.
	USB_OTG_FS_DSTS_SUSPSTS = 0x1
	// Position of ENUMSPD field.
	USB_OTG_FS_DSTS_ENUMSPD_Pos = 0x1
	// Bit mask of ENUMSPD field.
	USB_OTG_FS_DSTS_ENUMSPD_Msk = 0x6
	// Position of EERR field.
	USB_OTG_FS_DSTS_EERR_Pos = 0x3
	// Bit mask of EERR field.
	USB_OTG_FS_DSTS_EERR_Msk = 0x8
	// Bit EERR.
	USB_OTG_FS_DSTS_EERR = 0x8
	// Position of FNSOF field.
	USB_OTG_FS_DSTS_FNSOF_Pos = 0x8
	// Bit mask of FNSOF field.
	USB_OTG_FS_DSTS_FNSOF_Msk = 0x3fff00

	// DIEPMSK: OTG_FS device IN endpoint common interrupt mask register (OTG_FS_DIEPMSK)
	// Position of XFRCM field.
	USB_OTG_FS_DIEPMSK_XFRCM_Pos = 0x0
	// Bit mask of XFRCM field.
	USB_OTG_FS_DIEPMSK_XFRCM_Msk = 0x1
	// Bit XFRCM.
	USB_OTG_FS_DIEPMSK_XFRCM = 0x1
	// Position of EPDM field.
	USB_OTG_FS_DIEPMSK_EPDM_Pos = 0x1
	// Bit mask of EPDM field.
	USB_OTG_FS_DIEPMSK_EPDM_Msk = 0x2
	// Bit EPDM.
	USB_OTG_FS_DIEPMSK_EPDM = 0x2
	// Position of TOM field.
	USB_OTG_FS_DIEPMSK_TOM_Pos = 0x3
	// Bit mask of TOM field.
	USB_OTG_FS_DIEPMSK_TOM_Msk = 0x8
	// Bit TOM.
	USB_OTG_FS_DIEPMSK_TOM = 0x8
	// Position of ITTXFEMSK field.
	USB_OTG_FS_DIEPMSK_ITTXFEMSK_Pos = 0x4
	// Bit mask of ITTXFEMSK field.
	USB_OTG_FS_DIEPMSK_ITTXFEMSK_Msk = 0x10
	// Bit ITTXFEMSK.
	USB_OTG_FS_DIEPMSK_ITTXFEMSK = 0x10
	// Position of INEPNMM field.
	USB_OTG_FS_DIEPMSK_INEPNMM_Pos = 0x5
	// Bit mask of INEPNMM field.
	USB_OTG_FS_DIEPMSK_INEPNMM_Msk = 0x20
	// Bit INEPNMM.
	USB_OTG_FS_DIEPMSK_INEPNMM = 0x20
	// Position of INEPNEM field.
	USB_OTG_FS_DIEPMSK_INEPNEM_Pos = 0x6
	// Bit mask of INEPNEM field.
	USB_OTG_FS_DIEPMSK_INEPNEM_Msk = 0x40
	// Bit INEPNEM.
	USB_OTG_FS_DIEPMSK_INEPNEM = 0x40

	// DOEPMSK: OTG_FS device OUT endpoint common interrupt mask register (OTG_FS_DOEPMSK)
	// Position of XFRCM field.
	USB_OTG_FS_DOEPMSK_XFRCM_Pos = 0x0
	// Bit mask of XFRCM field.
	USB_OTG_FS_DOEPMSK_XFRCM_Msk = 0x1
	// Bit XFRCM.
	USB_OTG_FS_DOEPMSK_XFRCM = 0x1
	// Position of EPDM field.
	USB_OTG_FS_DOEPMSK_EPDM_Pos = 0x1
	// Bit mask of EPDM field.
	USB_OTG_FS_DOEPMSK_EPDM_Msk = 0x2
	// Bit EPDM.
	USB_OTG_FS_DOEPMSK_EPDM = 0x2
	// Position of STUPM field.
	USB_OTG_FS_DOEPMSK_STUPM_Pos = 0x3
	// Bit mask of STUPM field.
	USB_OTG_FS_DOEPMSK_STUPM_Msk = 0x8
	// Bit STUPM.
	USB_OTG_FS_DOEPMSK_STUPM = 0x8
	// Position of OTEPDM field.
	USB_OTG_FS_DOEPMSK_OTEPDM_Pos = 0x4
	// Bit mask of OTEPDM field.
	USB_OTG_FS_DOEPMSK_OTEPDM_Msk = 0x10
	// Bit OTEPDM.
	USB_OTG_FS_DOEPMSK_OTEPDM = 0x10

	// DAINT: OTG_FS device all endpoints interrupt register (OTG_FS_DAINT)
	// Position of IEPINT field.
	USB_OTG_FS_DAINT_IEPINT_Pos = 0x0
	// Bit mask of IEPINT field.
	USB_OTG_FS_DAINT_IEPINT_Msk = 0xffff
	// Position of OEPINT field.
	USB_OTG_FS_DAINT_OEPINT_Pos = 0x10
	// Bit mask of OEPINT field.
	USB_OTG_FS_DAINT_OEPINT_Msk = 0xffff0000

	// DAINTMSK: OTG_FS all endpoints interrupt mask register (OTG_FS_DAINTMSK)
	// Position of IEPM field.
	USB_OTG_FS_DAINTMSK_IEPM_Pos = 0x0
	// Bit mask of IEPM field.
	USB_OTG_FS_DAINTMSK_IEPM_Msk = 0xffff
	// Position of OEPM field.
	USB_OTG_FS_DAINTMSK_OEPM_Pos = 0x10
	// Bit mask of OEPM field.
	USB_OTG_FS_DAINTMSK_OEPM_Msk = 0xffff0000

	// DVBUSDIS: OTG_FS device VBUS discharge time register
	// Position of VBUSDT field.
	USB_OTG_FS_DVBUSDIS_VBUSDT_Pos = 0x0
	// Bit mask of VBUSDT field.
	USB_OTG_FS_DVBUSDIS_VBUSDT_Msk = 0xffff

	// DVBUSPULSE: OTG_FS device VBUS pulsing time register
	// Position of DVBUSP field.
	USB_OTG_FS_DVBUSPULSE_DVBUSP_Pos = 0x0
	// Bit mask of DVBUSP field.
	USB_OTG_FS_DVBUSPULSE_DVBUSP_Msk = 0xfff

	// DIEPEMPMSK: OTG_FS device IN endpoint FIFO empty interrupt mask register
	// Position of INEPTXFEM field.
	USB_OTG_FS_DIEPEMPMSK_INEPTXFEM_Pos = 0x0
	// Bit mask of INEPTXFEM field.
	USB_OTG_FS_DIEPEMPMSK_INEPTXFEM_Msk = 0xffff

	// DIEPCTL0: OTG_FS device control IN endpoint 0 control register (OTG_FS_DIEPCTL0)
	// Position of MPSIZ field.
	USB_OTG_FS_DIEPCTL0_MPSIZ_Pos = 0x0
	// Bit mask of MPSIZ field.
	USB_OTG_FS_DIEPCTL0_MPSIZ_Msk = 0x3
	// Position of USBAEP field.
	USB_OTG_FS_DIEPCTL0_USBAEP_Pos = 0xf
	// Bit mask of USBAEP field.
	USB_OTG_FS_DIEPCTL0_USBAEP_Msk = 0x8000
	// Bit USBAEP.
	USB_OTG_FS_DIEPCTL0_USBAEP = 0x8000
	// Position of NAKSTS field.
	USB_OTG_FS_DIEPCTL0_NAKSTS_Pos = 0x11
	// Bit mask of NAKSTS field.
	USB_OTG_FS_DIEPCTL0_NAKSTS_Msk = 0x20000
	// Bit NAKSTS.
	USB_OTG_FS_DIEPCTL0_NAKSTS = 0x20000
	// Position of EPTYP field.
	USB_OTG_FS_DIEPCTL0_EPTYP_Pos = 0x12
	// Bit mask of EPTYP field.
	USB_OTG_FS_DIEPCTL0_EPTYP_Msk = 0xc0000
	// Position of STALL field.
	USB_OTG_FS_DIEPCTL0_STALL_Pos = 0x15
	// Bit mask of STALL field.
	USB_OTG_FS_DIEPCTL0_STALL_Msk = 0x200000
	// Bit STALL.
	USB_OTG_FS_DIEPCTL0_STALL = 0x200000
	// Position of TXFNUM field.
	USB_OTG_FS_DIEPCTL0_TXFNUM_Pos = 0x16
	// Bit mask of TXFNUM field.
	USB_OTG_FS_DIEPCTL0_TXFNUM_Msk = 0x3c00000
	// Position of CNAK field.
	USB_OTG_FS_DIEPCTL0_CNAK_Pos = 0x1a
	// Bit mask of CNAK field.
	USB_OTG_FS_DIEPCTL0_CNAK_Msk = 0x4000000
	// Bit CNAK.
	USB_OTG_FS_DIEPCTL0_CNAK = 0x4000000
	// Position of SNAK field.
	USB_OTG_FS_DIEPCTL0_SNAK_Pos = 0x1b
	// Bit mask of SNAK field.
	USB_OTG_FS_DIEPCTL0_SNAK_Msk = 0x8000000
	// Bit SNAK.
	USB_OTG_FS_DIEPCTL0_SNAK = 0x8000000
	// Position of EPDIS field.
	USB_OTG_FS_DIEPCTL0_EPDIS_Pos = 0x1e
	// Bit mask of EPDIS field.
	USB_OTG_FS_DIEPCTL0_EPDIS_Msk = 0x40000000
	// Bit EPDIS.
	USB_OTG_FS_DIEPCTL0_EPDIS = 0x40000000
	// Position of EPENA field.
	USB_OTG_FS_DIEPCTL0_EPENA_Pos = 0x1f
	// Bit mask of EPENA field.
	USB_OTG_FS_DIEPCTL0_EPENA_Msk = 0x80000000
	// Bit EPENA.
	USB_OTG_FS_DIEPCTL0_EPENA = 0x80000000

	// DIEPINT0: device endpoint-x interrupt register
	// Position of TXFE field.
	USB_OTG_FS_DIEPINT0_TXFE_Pos = 0x7
	// Bit mask of TXFE field.
	USB_OTG_FS_DIEPINT0_TXFE_Msk = 0x80
	// Bit TXFE.
	USB_OTG_FS_DIEPINT0_TXFE = 0x80
	// Position of INEPNE field.
	USB_OTG_FS_DIEPINT0_INEPNE_Pos = 0x6
	// Bit mask of INEPNE field.
	USB_OTG_FS_DIEPINT0_INEPNE_Msk = 0x40
	// Bit INEPNE.
	USB_OTG_FS_DIEPINT0_INEPNE = 0x40
	// Position of ITTXFE field.
	USB_OTG_FS_DIEPINT0_ITTXFE_Pos = 0x4
	// Bit mask of ITTXFE field.
	USB_OTG_FS_DIEPINT0_ITTXFE_Msk = 0x10
	// Bit ITTXFE.
	USB_OTG_FS_DIEPINT0_ITTXFE = 0x10
	// Position of TOC field.
	USB_OTG_FS_DIEPINT0_TOC_Pos = 0x3
	// Bit mask of TOC field.
	USB_OTG_FS_DIEPINT0_TOC_Msk = 0x8
	// Bit TOC.
	USB_OTG_FS_DIEPINT0_TOC = 0x8
	// Position of EPDISD field.
	USB_OTG_FS_DIEPINT0_EPDISD_Pos = 0x1
	// Bit mask of EPDISD field.
	USB_OTG_FS_DIEPINT0_EPDISD_Msk = 0x2
	// Bit EPDISD.
	USB_OTG_FS_DIEPINT0_EPDISD = 0x2
	// Position of XFRC field.
	USB_OTG_FS_DIEPINT0_XFRC_Pos = 0x0
	// Bit mask of XFRC field.
	USB_OTG_FS_DIEPINT0_XFRC_Msk = 0x1
	// Bit XFRC.
	USB_OTG_FS_DIEPINT0_XFRC = 0x1

	// DIEPTSIZ0: device endpoint-0 transfer size register
	// Position of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ0_PKTCNT_Pos = 0x13
	// Bit mask of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ0_PKTCNT_Msk = 0x180000
	// Position of XFRSIZ field.
	USB_OTG_FS_DIEPTSIZ0_XFRSIZ_Pos = 0x0
	// Bit mask of XFRSIZ field.
	USB_OTG_FS_DIEPTSIZ0_XFRSIZ_Msk = 0x7f

	// DTXFSTS0: OTG_FS device IN endpoint transmit FIFO status register
	// Position of INEPTFSAV field.
	USB_OTG_FS_DTXFSTS0_INEPTFSAV_Pos = 0x0
	// Bit mask of INEPTFSAV field.
	USB_OTG_FS_DTXFSTS0_INEPTFSAV_Msk = 0xffff

	// DIEPCTL1: OTG device endpoint-1 control register
	// Position of EPENA field.
	USB_OTG_FS_DIEPCTL_EPENA_Pos = 0x1f
	// Bit mask of EPENA field.
	USB_OTG_FS_DIEPCTL_EPENA_Msk = 0x80000000
	// Bit EPENA.
	USB_OTG_FS_DIEPCTL_EPENA = 0x80000000
	// Position of EPDIS field.
	USB_OTG_FS_DIEPCTL_EPDIS_Pos = 0x1e
	// Bit mask of EPDIS field.
	USB_OTG_FS_DIEPCTL_EPDIS_Msk = 0x40000000
	// Bit EPDIS.
	USB_OTG_FS_DIEPCTL_EPDIS = 0x40000000
	// Position of SODDFRM_SD1PID field.
	USB_OTG_FS_DIEPCTL_SODDFRM_SD1PID_Pos = 0x1d
	// Bit mask of SODDFRM_SD1PID field.
	USB_OTG_FS_DIEPCTL_SODDFRM_SD1PID_Msk = 0x20000000
	// Bit SODDFRM_SD1PID.
	USB_OTG_FS_DIEPCTL_SODDFRM_SD1PID = 0x20000000
	// Position of SD0PID_SEVNFRM field.
	USB_OTG_FS_DIEPCTL_SD0PID_SEVNFRM_Pos = 0x1c
	// Bit mask of SD0PID_SEVNFRM field.
	USB_OTG_FS_DIEPCTL_SD0PID_SEVNFRM_Msk = 0x10000000
	// Bit SD0PID_SEVNFRM.
	USB_OTG_FS_DIEPCTL_SD0PID_SEVNFRM = 0x10000000
	// Position of SNAK field.
	USB_OTG_FS_DIEPCTL_SNAK_Pos = 0x1b
	// Bit mask of SNAK field.
	USB_OTG_FS_DIEPCTL_SNAK_Msk = 0x8000000
	// Bit SNAK.
	USB_OTG_FS_DIEPCTL_SNAK = 0x8000000
	// Position of CNAK field.
	USB_OTG_FS_DIEPCTL_CNAK_Pos = 0x1a
	// Bit mask of CNAK field.
	USB_OTG_FS_DIEPCTL_CNAK_Msk = 0x4000000
	// Bit CNAK.
	USB_OTG_FS_DIEPCTL_CNAK = 0x4000000
	// Position of TXFNUM field.
	USB_OTG_FS_DIEPCTL_TXFNUM_Pos = 0x16
	// Bit mask of TXFNUM field.
	USB_OTG_FS_DIEPCTL_TXFNUM_Msk = 0x3c00000
	// Position of STALL field.
	USB_OTG_FS_DIEPCTL_STALL_Pos = 0x15
	// Bit mask of STALL field.
	USB_OTG_FS_DIEPCTL_STALL_Msk = 0x200000
	// Bit STALL.
	USB_OTG_FS_DIEPCTL_STALL = 0x200000
	// Position of EPTYP field.
	USB_OTG_FS_DIEPCTL_EPTYP_Pos = 0x12
	// Bit mask of EPTYP field.
	USB_OTG_FS_DIEPCTL_EPTYP_Msk = 0xc0000
	// Position of NAKSTS field.
	USB_OTG_FS_DIEPCTL_NAKSTS_Pos = 0x11
	// Bit mask of NAKSTS field.
	USB_OTG_FS_DIEPCTL_NAKSTS_Msk = 0x20000
	// Bit NAKSTS.
	USB_OTG_FS_DIEPCTL_NAKSTS = 0x20000
	// Position of EONUM_DPID field.
	USB_OTG_FS_DIEPCTL_EONUM_DPID_Pos = 0x10
	// Bit mask of EONUM_DPID field.
	USB_OTG_FS_DIEPCTL_EONUM_DPID_Msk = 0x10000
	// Bit EONUM_DPID.
	USB_OTG_FS_DIEPCTL_EONUM_DPID = 0x10000
	// Position of USBAEP field.
	USB_OTG_FS_DIEPCTL_USBAEP_Pos = 0xf
	// Bit mask of USBAEP field.
	USB_OTG_FS_DIEPCTL_USBAEP_Msk = 0x8000
	// Bit USBAEP.
	USB_OTG_FS_DIEPCTL_USBAEP = 0x8000
	// Position of MPSIZ field.
	USB_OTG_FS_DIEPCTL_MPSIZ_Pos = 0x0
	// Bit mask of MPSIZ field.
	USB_OTG_FS_DIEPCTL_MPSIZ_Msk = 0x7ff

	// DIEPINT1: device endpoint-1 interrupt register
	// Position of TXFE field.
	USB_OTG_FS_DIEPINT1_TXFE_Pos = 0x7
	// Bit mask of TXFE field.
	USB_OTG_FS_DIEPINT1_TXFE_Msk = 0x80
	// Bit TXFE.
	USB_OTG_FS_DIEPINT1_TXFE = 0x80
	// Position of INEPNE field.
	USB_OTG_FS_DIEPINT1_INEPNE_Pos = 0x6
	// Bit mask of INEPNE field.
	USB_OTG_FS_DIEPINT1_INEPNE_Msk = 0x40
	// Bit INEPNE.
	USB_OTG_FS_DIEPINT1_INEPNE = 0x40
	// Position of ITTXFE field.
	USB_OTG_FS_DIEPINT1_ITTXFE_Pos = 0x4
	// Bit mask of ITTXFE field.
	USB_OTG_FS_DIEPINT1_ITTXFE_Msk = 0x10
	// Bit ITTXFE.
	USB_OTG_FS_DIEPINT1_ITTXFE = 0x10
	// Position of TOC field.
	USB_OTG_FS_DIEPINT1_TOC_Pos = 0x3
	// Bit mask of TOC field.
	USB_OTG_FS_DIEPINT1_TOC_Msk = 0x8
	// Bit TOC.
	USB_OTG_FS_DIEPINT1_TOC = 0x8
	// Position of EPDISD field.
	USB_OTG_FS_DIEPINT1_EPDISD_Pos = 0x1
	// Bit mask of EPDISD field.
	USB_OTG_FS_DIEPINT1_EPDISD_Msk = 0x2
	// Bit EPDISD.
	USB_OTG_FS_DIEPINT1_EPDISD = 0x2
	// Position of XFRC field.
	USB_OTG_FS_DIEPINT1_XFRC_Pos = 0x0
	// Bit mask of XFRC field.
	USB_OTG_FS_DIEPINT1_XFRC_Msk = 0x1
	// Bit XFRC.
	USB_OTG_FS_DIEPINT1_XFRC = 0x1

	// DIEPTSIZ1: device endpoint-1 transfer size register
	// Position of MCNT field.
	USB_OTG_FS_DIEPTSIZ1_MCNT_Pos = 0x1d
	// Bit mask of MCNT field.
	USB_OTG_FS_DIEPTSIZ1_MCNT_Msk = 0x60000000
	// Position of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ1_PKTCNT_Pos = 0x13
	// Bit mask of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ1_PKTCNT_Msk = 0x1ff80000
	// Position of XFRSIZ field.
	USB_OTG_FS_DIEPTSIZ1_XFRSIZ_Pos = 0x0
	// Bit mask of XFRSIZ field.
	USB_OTG_FS_DIEPTSIZ1_XFRSIZ_Msk = 0x7ffff

	// DTXFSTS1: OTG_FS device IN endpoint transmit FIFO status register
	// Position of INEPTFSAV field.
	USB_OTG_FS_DTXFSTS1_INEPTFSAV_Pos = 0x0
	// Bit mask of INEPTFSAV field.
	USB_OTG_FS_DTXFSTS1_INEPTFSAV_Msk = 0xffff

	// DIEPINT2: device endpoint-2 interrupt register
	// Position of TXFE field.
	USB_OTG_FS_DIEPINT2_TXFE_Pos = 0x7
	// Bit mask of TXFE field.
	USB_OTG_FS_DIEPINT2_TXFE_Msk = 0x80
	// Bit TXFE.
	USB_OTG_FS_DIEPINT2_TXFE = 0x80
	// Position of INEPNE field.
	USB_OTG_FS_DIEPINT2_INEPNE_Pos = 0x6
	// Bit mask of INEPNE field.
	USB_OTG_FS_DIEPINT2_INEPNE_Msk = 0x40
	// Bit INEPNE.
	USB_OTG_FS_DIEPINT2_INEPNE = 0x40
	// Position of ITTXFE field.
	USB_OTG_FS_DIEPINT2_ITTXFE_Pos = 0x4
	// Bit mask of ITTXFE field.
	USB_OTG_FS_DIEPINT2_ITTXFE_Msk = 0x10
	// Bit ITTXFE.
	USB_OTG_FS_DIEPINT2_ITTXFE = 0x10
	// Position of TOC field.
	USB_OTG_FS_DIEPINT2_TOC_Pos = 0x3
	// Bit mask of TOC field.
	USB_OTG_FS_DIEPINT2_TOC_Msk = 0x8
	// Bit TOC.
	USB_OTG_FS_DIEPINT2_TOC = 0x8
	// Position of EPDISD field.
	USB_OTG_FS_DIEPINT2_EPDISD_Pos = 0x1
	// Bit mask of EPDISD field.
	USB_OTG_FS_DIEPINT2_EPDISD_Msk = 0x2
	// Bit EPDISD.
	USB_OTG_FS_DIEPINT2_EPDISD = 0x2
	// Position of XFRC field.
	USB_OTG_FS_DIEPINT2_XFRC_Pos = 0x0
	// Bit mask of XFRC field.
	USB_OTG_FS_DIEPINT2_XFRC_Msk = 0x1
	// Bit XFRC.
	USB_OTG_FS_DIEPINT2_XFRC = 0x1

	// DIEPTSIZ2: device endpoint-2 transfer size register
	// Position of MCNT field.
	USB_OTG_FS_DIEPTSIZ2_MCNT_Pos = 0x1d
	// Bit mask of MCNT field.
	USB_OTG_FS_DIEPTSIZ2_MCNT_Msk = 0x60000000
	// Position of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ2_PKTCNT_Pos = 0x13
	// Bit mask of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ2_PKTCNT_Msk = 0x1ff80000
	// Position of XFRSIZ field.
	USB_OTG_FS_DIEPTSIZ2_XFRSIZ_Pos = 0x0
	// Bit mask of XFRSIZ field.
	USB_OTG_FS_DIEPTSIZ2_XFRSIZ_Msk = 0x7ffff

	// DTXFSTS2: OTG_FS device IN endpoint transmit FIFO status register
	// Position of INEPTFSAV field.
	USB_OTG_FS_DTXFSTS2_INEPTFSAV_Pos = 0x0
	// Bit mask of INEPTFSAV field.
	USB_OTG_FS_DTXFSTS2_INEPTFSAV_Msk = 0xffff

	// DIEPINT3: device endpoint-3 interrupt register
	// Position of TXFE field.
	USB_OTG_FS_DIEPINT3_TXFE_Pos = 0x7
	// Bit mask of TXFE field.
	USB_OTG_FS_DIEPINT3_TXFE_Msk = 0x80
	// Bit TXFE.
	USB_OTG_FS_DIEPINT3_TXFE = 0x80
	// Position of INEPNE field.
	USB_OTG_FS_DIEPINT3_INEPNE_Pos = 0x6
	// Bit mask of INEPNE field.
	USB_OTG_FS_DIEPINT3_INEPNE_Msk = 0x40
	// Bit INEPNE.
	USB_OTG_FS_DIEPINT3_INEPNE = 0x40
	// Position of ITTXFE field.
	USB_OTG_FS_DIEPINT3_ITTXFE_Pos = 0x4
	// Bit mask of ITTXFE field.
	USB_OTG_FS_DIEPINT3_ITTXFE_Msk = 0x10
	// Bit ITTXFE.
	USB_OTG_FS_DIEPINT3_ITTXFE = 0x10
	// Position of TOC field.
	USB_OTG_FS_DIEPINT3_TOC_Pos = 0x3
	// Bit mask of TOC field.
	USB_OTG_FS_DIEPINT3_TOC_Msk = 0x8
	// Bit TOC.
	USB_OTG_FS_DIEPINT3_TOC = 0x8
	// Position of EPDISD field.
	USB_OTG_FS_DIEPINT3_EPDISD_Pos = 0x1
	// Bit mask of EPDISD field.
	USB_OTG_FS_DIEPINT3_EPDISD_Msk = 0x2
	// Bit EPDISD.
	USB_OTG_FS_DIEPINT3_EPDISD = 0x2
	// Position of XFRC field.
	USB_OTG_FS_DIEPINT3_XFRC_Pos = 0x0
	// Bit mask of XFRC field.
	USB_OTG_FS_DIEPINT3_XFRC_Msk = 0x1
	// Bit XFRC.
	USB_OTG_FS_DIEPINT3_XFRC = 0x1

	// DIEPTSIZ3: device endpoint-3 transfer size register
	// Position of MCNT field.
	USB_OTG_FS_DIEPTSIZ3_MCNT_Pos = 0x1d
	// Bit mask of MCNT field.
	USB_OTG_FS_DIEPTSIZ3_MCNT_Msk = 0x60000000
	// Position of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ3_PKTCNT_Pos = 0x13
	// Bit mask of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ3_PKTCNT_Msk = 0x1ff80000
	// Position of XFRSIZ field.
	USB_OTG_FS_DIEPTSIZ3_XFRSIZ_Pos = 0x0
	// Bit mask of XFRSIZ field.
	USB_OTG_FS_DIEPTSIZ3_XFRSIZ_Msk = 0x7ffff

	// DTXFSTS3: OTG_FS device IN endpoint transmit FIFO status register
	// Position of INEPTFSAV field.
	USB_OTG_FS_DTXFSTS3_INEPTFSAV_Pos = 0x0
	// Bit mask of INEPTFSAV field.
	USB_OTG_FS_DTXFSTS3_INEPTFSAV_Msk = 0xffff

	// DOEPCTL0: device endpoint-0 control register
	// Position of EPENA field.
	USB_OTG_FS_DOEPCTL0_EPENA_Pos = 0x1f
	// Bit mask of EPENA field.
	USB_OTG_FS_DOEPCTL0_EPENA_Msk = 0x80000000
	// Bit EPENA.
	USB_OTG_FS_DOEPCTL0_EPENA = 0x80000000
	// Position of EPDIS field.
	USB_OTG_FS_DOEPCTL0_EPDIS_Pos = 0x1e
	// Bit mask of EPDIS field.
	USB_OTG_FS_DOEPCTL0_EPDIS_Msk = 0x40000000
	// Bit EPDIS.
	USB_OTG_FS_DOEPCTL0_EPDIS = 0x40000000
	// Position of SNAK field.
	USB_OTG_FS_DOEPCTL0_SNAK_Pos = 0x1b
	// Bit mask of SNAK field.
	USB_OTG_FS_DOEPCTL0_SNAK_Msk = 0x8000000
	// Bit SNAK.
	USB_OTG_FS_DOEPCTL0_SNAK = 0x8000000
	// Position of CNAK field.
	USB_OTG_FS_DOEPCTL0_CNAK_Pos = 0x1a
	// Bit mask of CNAK field.
	USB_OTG_FS_DOEPCTL0_CNAK_Msk = 0x4000000
	// Bit CNAK.
	USB_OTG_FS_DOEPCTL0_CNAK = 0x4000000
	// Position of STALL field.
	USB_OTG_FS_DOEPCTL0_STALL_Pos = 0x15
	// Bit mask of STALL field.
	USB_OTG_FS_DOEPCTL0_STALL_Msk = 0x200000
	// Bit STALL.
	USB_OTG_FS_DOEPCTL0_STALL = 0x200000
	// Position of SNPM field.
	USB_OTG_FS_DOEPCTL0_SNPM_Pos = 0x14
	// Bit mask of SNPM field.
	USB_OTG_FS_DOEPCTL0_SNPM_Msk = 0x100000
	// Bit SNPM.
	USB_OTG_FS_DOEPCTL0_SNPM = 0x100000
	// Position of EPTYP field.
	USB_OTG_FS_DOEPCTL0_EPTYP_Pos = 0x12
	// Bit mask of EPTYP field.
	USB_OTG_FS_DOEPCTL0_EPTYP_Msk = 0xc0000
	// Position of NAKSTS field.
	USB_OTG_FS_DOEPCTL0_NAKSTS_Pos = 0x11
	// Bit mask of NAKSTS field.
	USB_OTG_FS_DOEPCTL0_NAKSTS_Msk = 0x20000
	// Bit NAKSTS.
	USB_OTG_FS_DOEPCTL0_NAKSTS = 0x20000
	// Position of USBAEP field.
	USB_OTG_FS_DOEPCTL0_USBAEP_Pos = 0xf
	// Bit mask of USBAEP field.
	USB_OTG_FS_DOEPCTL0_USBAEP_Msk = 0x8000
	// Bit USBAEP.
	USB_OTG_FS_DOEPCTL0_USBAEP = 0x8000
	// Position of MPSIZ field.
	USB_OTG_FS_DOEPCTL0_MPSIZ_Pos = 0x0
	// Bit mask of MPSIZ field.
	USB_OTG_FS_DOEPCTL0_MPSIZ_Msk = 0x3

	// DOEPINT0: device endpoint-0 interrupt register
	// Position of B2BSTUP field.
	USB_OTG_FS_DOEPINT0_B2BSTUP_Pos = 0x6
	// Bit mask of B2BSTUP field.
	USB_OTG_FS_DOEPINT0_B2BSTUP_Msk = 0x40
	// Bit B2BSTUP.
	USB_OTG_FS_DOEPINT0_B2BSTUP = 0x40
	// Position of OTEPDIS field.
	USB_OTG_FS_DOEPINT0_OTEPDIS_Pos = 0x4
	// Bit mask of OTEPDIS field.
	USB_OTG_FS_DOEPINT0_OTEPDIS_Msk = 0x10
	// Bit OTEPDIS.
	USB_OTG_FS_DOEPINT0_OTEPDIS = 0x10
	// Position of STUP field.
	USB_OTG_FS_DOEPINT0_STUP_Pos = 0x3
	// Bit mask of STUP field.
	USB_OTG_FS_DOEPINT0_STUP_Msk = 0x8
	// Bit STUP.
	USB_OTG_FS_DOEPINT0_STUP = 0x8
	// Position of EPDISD field.
	USB_OTG_FS_DOEPINT0_EPDISD_Pos = 0x1
	// Bit mask of EPDISD field.
	USB_OTG_FS_DOEPINT0_EPDISD_Msk = 0x2
	// Bit EPDISD.
	USB_OTG_FS_DOEPINT0_EPDISD = 0x2
	// Position of XFRC field.
	USB_OTG_FS_DOEPINT0_XFRC_Pos = 0x0
	// Bit mask of XFRC field.
	USB_OTG_FS_DOEPINT0_XFRC_Msk = 0x1
	// Bit XFRC.
	USB_OTG_FS_DOEPINT0_XFRC = 0x1

	// DOEPTSIZ0: device OUT endpoint-0 transfer size register
	// Position of STUPCNT field.
	USB_OTG_FS_DOEPTSIZ0_STUPCNT_Pos = 0x1d
	// Bit mask of STUPCNT field.
	USB_OTG_FS_DOEPTSIZ0_STUPCNT_Msk = 0x60000000
	// Position of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ0_PKTCNT_Pos = 0x13
	// Bit mask of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ0_PKTCNT_Msk = 0x80000
	// Bit PKTCNT.
	USB_OTG_FS_DOEPTSIZ0_PKTCNT = 0x80000
	// Position of XFRSIZ field.
	USB_OTG_FS_DOEPTSIZ0_XFRSIZ_Pos = 0x0
	// Bit mask of XFRSIZ field.
	USB_OTG_FS_DOEPTSIZ0_XFRSIZ_Msk = 0x7f

	// DOEPCTL1: device endpoint-1 control register
	// Position of EPENA field.
	USB_OTG_FS_DOEPCTL_EPENA_Pos = 0x1f
	// Bit mask of EPENA field.
	USB_OTG_FS_DOEPCTL_EPENA_Msk = 0x80000000
	// Bit EPENA.
	USB_OTG_FS_DOEPCTL_EPENA = 0x80000000
	// Position of EPDIS field.
	USB_OTG_FS_DOEPCTL_EPDIS_Pos = 0x1e
	// Bit mask of EPDIS field.
	USB_OTG_FS_DOEPCTL_EPDIS_Msk = 0x40000000
	// Bit EPDIS.
	USB_OTG_FS_DOEPCTL_EPDIS = 0x40000000
	// Position of SODDFRM field.
	USB_OTG_FS_DOEPCTL_SODDFRM_Pos = 0x1d
	// Bit mask of SODDFRM field.
	USB_OTG_FS_DOEPCTL_SODDFRM_Msk = 0x20000000
	// Bit SODDFRM.
	USB_OTG_FS_DOEPCTL_SODDFRM = 0x20000000
	// Position of SD0PID_SEVNFRM field.
	USB_OTG_FS_DOEPCTL_SD0PID_SEVNFRM_Pos = 0x1c
	// Bit mask of SD0PID_SEVNFRM field.
	USB_OTG_FS_DOEPCTL_SD0PID_SEVNFRM_Msk = 0x10000000
	// Bit SD0PID_SEVNFRM.
	USB_OTG_FS_DOEPCTL_SD0PID_SEVNFRM = 0x10000000
	// Position of SNAK field.
	USB_OTG_FS_DOEPCTL_SNAK_Pos = 0x1b
	// Bit mask of SNAK field.
	USB_OTG_FS_DOEPCTL_SNAK_Msk = 0x8000000
	// Bit SNAK.
	USB_OTG_FS_DOEPCTL_SNAK = 0x8000000
	// Position of CNAK field.
	USB_OTG_FS_DOEPCTL_CNAK_Pos = 0x1a
	// Bit mask of CNAK field.
	USB_OTG_FS_DOEPCTL_CNAK_Msk = 0x4000000
	// Bit CNAK.
	USB_OTG_FS_DOEPCTL_CNAK = 0x4000000
	// Position of STALL field.
	USB_OTG_FS_DOEPCTL_STALL_Pos = 0x15
	// Bit mask of STALL field.
	USB_OTG_FS_DOEPCTL_STALL_Msk = 0x200000
	// Bit STALL.
	USB_OTG_FS_DOEPCTL_STALL = 0x200000
	// Position of SNPM field.
	USB_OTG_FS_DOEPCTL_SNPM_Pos = 0x14
	// Bit mask of SNPM field.
	USB_OTG_FS_DOEPCTL_SNPM_Msk = 0x100000
	// Bit SNPM.
	USB_OTG_FS_DOEPCTL_SNPM = 0x100000
	// Position of EPTYP field.
	USB_OTG_FS_DOEPCTL_EPTYP_Pos = 0x12
	// Bit mask of EPTYP field.
	USB_OTG_FS_DOEPCTL_EPTYP_Msk = 0xc0000
	// Position of NAKSTS field.
	USB_OTG_FS_DOEPCTL_NAKSTS_Pos = 0x11
	// Bit mask of NAKSTS field.
	USB_OTG_FS_DOEPCTL_NAKSTS_Msk = 0x20000
	// Bit NAKSTS.
	USB_OTG_FS_DOEPCTL_NAKSTS = 0x20000
	// Position of EONUM_DPID field.
	USB_OTG_FS_DOEPCTL_EONUM_DPID_Pos = 0x10
	// Bit mask of EONUM_DPID field.
	USB_OTG_FS_DOEPCTL_EONUM_DPID_Msk = 0x10000
	// Bit EONUM_DPID.
	USB_OTG_FS_DOEPCTL_EONUM_DPID = 0x10000
	// Position of USBAEP field.
	USB_OTG_FS_DOEPCTL_USBAEP_Pos = 0xf
	// Bit mask of USBAEP field.
	USB_OTG_FS_DOEPCTL_USBAEP_Msk = 0x8000
	// Bit USBAEP.
	USB_OTG_FS_DOEPCTL_USBAEP = 0x8000
	// Position of MPSIZ field.
	USB_OTG_FS_DOEPCTL_MPSIZ_Pos = 0x0
	// Bit mask of MPSIZ field.
	USB_OTG_FS_DOEPCTL_MPSIZ_Msk = 0x7ff

	// DOEPINT1: device endpoint-1 interrupt register
	// Position of B2BSTUP field.
	USB_OTG_FS_DOEPINT1_B2BSTUP_Pos = 0x6
	// Bit mask of B2BSTUP field.
	USB_OTG_FS_DOEPINT1_B2BSTUP_Msk = 0x40
	// Bit B2BSTUP.
	USB_OTG_FS_DOEPINT1_B2BSTUP = 0x40
	// Position of OTEPDIS field.
	USB_OTG_FS_DOEPINT1_OTEPDIS_Pos = 0x4
	// Bit mask of OTEPDIS field.
	USB_OTG_FS_DOEPINT1_OTEPDIS_Msk = 0x10
	// Bit OTEPDIS.
	USB_OTG_FS_DOEPINT1_OTEPDIS = 0x10
	// Position of STUP field.
	USB_OTG_FS_DOEPINT1_STUP_Pos = 0x3
	// Bit mask of STUP field.
	USB_OTG_FS_DOEPINT1_STUP_Msk = 0x8
	// Bit STUP.
	USB_OTG_FS_DOEPINT1_STUP = 0x8
	// Position of EPDISD field.
	USB_OTG_FS_DOEPINT1_EPDISD_Pos = 0x1
	// Bit mask of EPDISD field.
	USB_OTG_FS_DOEPINT1_EPDISD_Msk = 0x2
	// Bit EPDISD.
	USB_OTG_FS_DOEPINT1_EPDISD = 0x2
	// Position of XFRC field.
	USB_OTG_FS_DOEPINT1_XFRC_Pos = 0x0
	// Bit mask of XFRC field.
	USB_OTG_FS_DOEPINT1_XFRC_Msk = 0x1
	// Bit XFRC.
	USB_OTG_FS_DOEPINT1_XFRC = 0x1

	// DOEPTSIZ1: device OUT endpoint-1 transfer size register
	// Position of RXDPID_STUPCNT field.
	USB_OTG_FS_DOEPTSIZ1_RXDPID_STUPCNT_Pos = 0x1d
	// Bit mask of RXDPID_STUPCNT field.
	USB_OTG_FS_DOEPTSIZ1_RXDPID_STUPCNT_Msk = 0x60000000
	// Position of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ1_PKTCNT_Pos = 0x13
	// Bit mask of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ1_PKTCNT_Msk = 0x1ff80000
	// Position of XFRSIZ field.
	USB_OTG_FS_DOEPTSIZ1_XFRSIZ_Pos = 0x0
	// Bit mask of XFRSIZ field.
	USB_OTG_FS_DOEPTSIZ1_XFRSIZ_Msk = 0x7ffff

	// DOEPINT2: device endpoint-2 interrupt register
	// Position of B2BSTUP field.
	USB_OTG_FS_DOEPINT2_B2BSTUP_Pos = 0x6
	// Bit mask of B2BSTUP field.
	USB_OTG_FS_DOEPINT2_B2BSTUP_Msk = 0x40
	// Bit B2BSTUP.
	USB_OTG_FS_DOEPINT2_B2BSTUP = 0x40
	// Position of OTEPDIS field.
	USB_OTG_FS_DOEPINT2_OTEPDIS_Pos = 0x4
	// Bit mask of OTEPDIS field.
	USB_OTG_FS_DOEPINT2_OTEPDIS_Msk = 0x10
	// Bit OTEPDIS.
	USB_OTG_FS_DOEPINT2_OTEPDIS = 0x10
	// Position of STUP field.
	USB_OTG_FS_DOEPINT2_STUP_Pos = 0x3
	// Bit mask of STUP field.
	USB_OTG_FS_DOEPINT2_STUP_Msk = 0x8
	// Bit STUP.
	USB_OTG_FS_DOEPINT2_STUP = 0x8
	// Position of EPDISD field.
	USB_OTG_FS_DOEPINT2_EPDISD_Pos = 0x1
	// Bit mask of EPDISD field.
	USB_OTG_FS_DOEPINT2_EPDISD_Msk = 0x2
	// Bit EPDISD.
	USB_OTG_FS_DOEPINT2_EPDISD = 0x2
	// Position of XFRC field.
	USB_OTG_FS_DOEPINT2_XFRC_Pos = 0x0
	// Bit mask of XFRC field.
	USB_OTG_FS_DOEPINT2_XFRC_Msk = 0x1
	// Bit XFRC.
	USB_OTG_FS_DOEPINT2_XFRC = 0x1

	// DOEPTSIZ2: device OUT endpoint-2 transfer size register
	// Position of RXDPID_STUPCNT field.
	USB_OTG_FS_DOEPTSIZ2_RXDPID_STUPCNT_Pos = 0x1d
	// Bit mask of RXDPID_STUPCNT field.
	USB_OTG_FS_DOEPTSIZ2_RXDPID_STUPCNT_Msk = 0x60000000
	// Position of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ2_PKTCNT_Pos = 0x13
	// Bit mask of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ2_PKTCNT_Msk = 0x1ff80000
	// Position of XFRSIZ field.
	USB_OTG_FS_DOEPTSIZ2_XFRSIZ_Pos = 0x0
	// Bit mask of XFRSIZ field.
	USB_OTG_FS_DOEPTSIZ2_XFRSIZ_Msk = 0x7ffff

	// DOEPINT3: device endpoint-3 interrupt register
	// Position of B2BSTUP field.
	USB_OTG_FS_DOEPINT3_B2BSTUP_Pos = 0x6
	// Bit mask of B2BSTUP field.
	USB_OTG_FS_DOEPINT3_B2BSTUP_Msk = 0x40
	// Bit B2BSTUP.
	USB_OTG_FS_DOEPINT3_B2BSTUP = 0x40
	// Position of OTEPDIS field.
	USB_OTG_FS_DOEPINT3_OTEPDIS_Pos = 0x4
	// Bit mask of OTEPDIS field.
	USB_OTG_FS_DOEPINT3_OTEPDIS_Msk = 0x10
	// Bit OTEPDIS.
	USB_OTG_FS_DOEPINT3_OTEPDIS = 0x10
	// Position of STUP field.
	USB_OTG_FS_DOEPINT3_STUP_Pos = 0x3
	// Bit mask of STUP field.
	USB_OTG_FS_DOEPINT3_STUP_Msk = 0x8
	// Bit STUP.
	USB_OTG_FS_DOEPINT3_STUP = 0x8
	// Position of EPDISD field.
	USB_OTG_FS_DOEPINT3_EPDISD_Pos = 0x1
	// Bit mask of EPDISD field.
	USB_OTG_FS_DOEPINT3_EPDISD_Msk = 0x2
	// Bit EPDISD.
	USB_OTG_FS_DOEPINT3_EPDISD = 0x2
	// Position of XFRC field.
	USB_OTG_FS_DOEPINT3_XFRC_Pos = 0x0
	// Bit mask of XFRC field.
	USB_OTG_FS_DOEPINT3_XFRC_Msk = 0x1
	// Bit XFRC.
	USB_OTG_FS_DOEPINT3_XFRC = 0x1

	// DOEPTSIZ3: device OUT endpoint-3 transfer size register
	// Position of RXDPID_STUPCNT field.
	USB_OTG_FS_DOEPTSIZ3_RXDPID_STUPCNT_Pos = 0x1d
	// Bit mask of RXDPID_STUPCNT field.
	USB_OTG_FS_DOEPTSIZ3_RXDPID_STUPCNT_Msk = 0x60000000
	// Position of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ3_PKTCNT_Pos = 0x13
	// Bit mask of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ3_PKTCNT_Msk = 0x1ff80000
	// Position of XFRSIZ field.
	USB_OTG_FS_DOEPTSIZ3_XFRSIZ_Pos = 0x0
	// Bit mask of XFRSIZ field.
	USB_OTG_FS_DOEPTSIZ3_XFRSIZ_Msk = 0x7ffff
)

// Constants for PWR: Power control
const (
	// CR: power control register
	// Position of VOS field.
	PWR_CR_VOS_Pos = 0xe
	// Bit mask of VOS field.
	PWR_CR_VOS_Msk = 0xc000
	// Position of ADCDC1 field.
	PWR_CR_ADCDC1_Pos = 0xd
	// Bit mask of ADCDC1 field.
	PWR_CR_ADCDC1_Msk = 0x2000
	// Bit ADCDC1.
	PWR_CR_ADCDC1 = 0x2000
	// Position of FPDS field.
	PWR_CR_FPDS_Pos = 0x9
	// Bit mask of FPDS field.
	PWR_CR_FPDS_Msk = 0x200
	// Bit FPDS.
	PWR_CR_FPDS = 0x200
	// Position of DBP field.
	PWR_CR_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR_DBP = 0x100
	// Position of PLS field.
	PWR_CR_PLS_Pos = 0x5
	// Bit mask of PLS field.
	PWR_CR_PLS_Msk = 0xe0
	// Position of PVDE field.
	PWR_CR_PVDE_Pos = 0x4
	// Bit mask of PVDE field.
	PWR_CR_PVDE_Msk = 0x10
	// Bit PVDE.
	PWR_CR_PVDE = 0x10
	// Position of CSBF field.
	PWR_CR_CSBF_Pos = 0x3
	// Bit mask of CSBF field.
	PWR_CR_CSBF_Msk = 0x8
	// Bit CSBF.
	PWR_CR_CSBF = 0x8
	// Position of CWUF field.
	PWR_CR_CWUF_Pos = 0x2
	// Bit mask of CWUF field.
	PWR_CR_CWUF_Msk = 0x4
	// Bit CWUF.
	PWR_CR_CWUF = 0x4
	// Position of PDDS field.
	PWR_CR_PDDS_Pos = 0x1
	// Bit mask of PDDS field.
	PWR_CR_PDDS_Msk = 0x2
	// Bit PDDS.
	PWR_CR_PDDS = 0x2
	// Position of LPDS field.
	PWR_CR_LPDS_Pos = 0x0
	// Bit mask of LPDS field.
	PWR_CR_LPDS_Msk = 0x1
	// Bit LPDS.
	PWR_CR_LPDS = 0x1

	// CSR: power control/status register
	// Position of WUF field.
	PWR_CSR_WUF_Pos = 0x0
	// Bit mask of WUF field.
	PWR_CSR_WUF_Msk = 0x1
	// Bit WUF.
	PWR_CSR_WUF = 0x1
	// Position of SBF field.
	PWR_CSR_SBF_Pos = 0x1
	// Bit mask of SBF field.
	PWR_CSR_SBF_Msk = 0x2
	// Bit SBF.
	PWR_CSR_SBF = 0x2
	// Position of PVDO field.
	PWR_CSR_PVDO_Pos = 0x2
	// Bit mask of PVDO field.
	PWR_CSR_PVDO_Msk = 0x4
	// Bit PVDO.
	PWR_CSR_PVDO = 0x4
	// Position of BRR field.
	PWR_CSR_BRR_Pos = 0x3
	// Bit mask of BRR field.
	PWR_CSR_BRR_Msk = 0x8
	// Bit BRR.
	PWR_CSR_BRR = 0x8
	// Position of EWUP field.
	PWR_CSR_EWUP_Pos = 0x8
	// Bit mask of EWUP field.
	PWR_CSR_EWUP_Msk = 0x100
	// Bit EWUP.
	PWR_CSR_EWUP = 0x100
	// Position of BRE field.
	PWR_CSR_BRE_Pos = 0x9
	// Bit mask of BRE field.
	PWR_CSR_BRE_Msk = 0x200
	// Bit BRE.
	PWR_CSR_BRE = 0x200
	// Position of VOSRDY field.
	PWR_CSR_VOSRDY_Pos = 0xe
	// Bit mask of VOSRDY field.
	PWR_CSR_VOSRDY_Msk = 0x4000
	// Bit VOSRDY.
	PWR_CSR_VOSRDY = 0x4000
)

// Constants for RCC: Reset and clock control
const (
	// CR: clock control register
	// Position of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Pos = 0x1b
	// Bit mask of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Msk = 0x8000000
	// Bit PLLI2SRDY.
	RCC_CR_PLLI2SRDY = 0x8000000
	// Clock not ready
	RCC_CR_PLLI2SRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLI2SRDY_Ready = 0x1
	// Position of PLLI2SON field.
	RCC_CR_PLLI2SON_Pos = 0x1a
	// Bit mask of PLLI2SON field.
	RCC_CR_PLLI2SON_Msk = 0x4000000
	// Bit PLLI2SON.
	RCC_CR_PLLI2SON = 0x4000000
	// Clock Off
	RCC_CR_PLLI2SON_Off = 0x0
	// Clock On
	RCC_CR_PLLI2SON_On = 0x1
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Clock not ready
	RCC_CR_PLLRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLRDY_Ready = 0x1
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Clock Off
	RCC_CR_PLLON_Off = 0x0
	// Clock On
	RCC_CR_PLLON_On = 0x1
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Clock security system disabled (clock detector OFF)
	RCC_CR_CSSON_Off = 0x0
	// Clock security system enable (clock detector ON if the HSE is ready, OFF if not)
	RCC_CR_CSSON_On = 0x1
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// HSE crystal oscillator not bypassed
	RCC_CR_HSEBYP_NotBypassed = 0x0
	// HSE crystal oscillator bypassed with external clock
	RCC_CR_HSEBYP_Bypassed = 0x1
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Clock not ready
	RCC_CR_HSERDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSERDY_Ready = 0x1
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Clock Off
	RCC_CR_HSEON_Off = 0x0
	// Clock On
	RCC_CR_HSEON_On = 0x1
	// Position of HSICAL field.
	RCC_CR_HSICAL_Pos = 0x8
	// Bit mask of HSICAL field.
	RCC_CR_HSICAL_Msk = 0xff00
	// Position of HSITRIM field.
	RCC_CR_HSITRIM_Pos = 0x3
	// Bit mask of HSITRIM field.
	RCC_CR_HSITRIM_Msk = 0xf8
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0x1
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x2
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x2
	// Clock not ready
	RCC_CR_HSIRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSIRDY_Ready = 0x1
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x0
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x1
	// Bit HSION.
	RCC_CR_HSION = 0x1
	// Clock Off
	RCC_CR_HSION_Off = 0x0
	// Clock On
	RCC_CR_HSION_On = 0x1

	// PLLCFGR: PLL configuration register
	// Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Pos = 0x16
	// Bit mask of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk = 0x400000
	// Bit PLLSRC.
	RCC_PLLCFGR_PLLSRC = 0x400000
	// HSI clock selected as PLL and PLLI2S clock entry
	RCC_PLLCFGR_PLLSRC_HSI = 0x0
	// HSE oscillator clock selected as PLL and PLLI2S clock entry
	RCC_PLLCFGR_PLLSRC_HSE = 0x1
	// Position of PLLM field.
	RCC_PLLCFGR_PLLM_Pos = 0x0
	// Bit mask of PLLM field.
	RCC_PLLCFGR_PLLM_Msk = 0x3f
	// Position of PLLN field.
	RCC_PLLCFGR_PLLN_Pos = 0x6
	// Bit mask of PLLN field.
	RCC_PLLCFGR_PLLN_Msk = 0x7fc0
	// Position of PLLP field.
	RCC_PLLCFGR_PLLP_Pos = 0x10
	// Bit mask of PLLP field.
	RCC_PLLCFGR_PLLP_Msk = 0x30000
	// PLLP=2
	RCC_PLLCFGR_PLLP_Div2 = 0x0
	// PLLP=4
	RCC_PLLCFGR_PLLP_Div4 = 0x1
	// PLLP=6
	RCC_PLLCFGR_PLLP_Div6 = 0x2
	// PLLP=8
	RCC_PLLCFGR_PLLP_Div8 = 0x3
	// Position of PLLQ field.
	RCC_PLLCFGR_PLLQ_Pos = 0x18
	// Bit mask of PLLQ field.
	RCC_PLLCFGR_PLLQ_Msk = 0xf000000

	// CFGR: clock configuration register
	// Position of MCO2 field.
	RCC_CFGR_MCO2_Pos = 0x1e
	// Bit mask of MCO2 field.
	RCC_CFGR_MCO2_Msk = 0xc0000000
	// System clock (SYSCLK) selected
	RCC_CFGR_MCO2_SYSCLK = 0x0
	// PLLI2S clock selected
	RCC_CFGR_MCO2_PLLI2S = 0x1
	// HSE oscillator clock selected
	RCC_CFGR_MCO2_HSE = 0x2
	// PLL clock selected
	RCC_CFGR_MCO2_PLL = 0x3
	// Position of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Pos = 0x1b
	// Bit mask of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Msk = 0x38000000
	// No division
	RCC_CFGR_MCO2PRE_Div1 = 0x0
	// Division by 2
	RCC_CFGR_MCO2PRE_Div2 = 0x4
	// Division by 3
	RCC_CFGR_MCO2PRE_Div3 = 0x5
	// Division by 4
	RCC_CFGR_MCO2PRE_Div4 = 0x6
	// Division by 5
	RCC_CFGR_MCO2PRE_Div5 = 0x7
	// Position of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Pos = 0x18
	// Bit mask of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Msk = 0x7000000
	// No division
	RCC_CFGR_MCO1PRE_Div1 = 0x0
	// Division by 2
	RCC_CFGR_MCO1PRE_Div2 = 0x4
	// Division by 3
	RCC_CFGR_MCO1PRE_Div3 = 0x5
	// Division by 4
	RCC_CFGR_MCO1PRE_Div4 = 0x6
	// Division by 5
	RCC_CFGR_MCO1PRE_Div5 = 0x7
	// Position of I2SSRC field.
	RCC_CFGR_I2SSRC_Pos = 0x17
	// Bit mask of I2SSRC field.
	RCC_CFGR_I2SSRC_Msk = 0x800000
	// Bit I2SSRC.
	RCC_CFGR_I2SSRC = 0x800000
	// PLLI2S clock used as I2S clock source
	RCC_CFGR_I2SSRC_PLLI2S = 0x0
	// External clock mapped on the I2S_CKIN pin used as I2S clock source
	RCC_CFGR_I2SSRC_CKIN = 0x1
	// Position of MCO1 field.
	RCC_CFGR_MCO1_Pos = 0x15
	// Bit mask of MCO1 field.
	RCC_CFGR_MCO1_Msk = 0x600000
	// HSI clock selected
	RCC_CFGR_MCO1_HSI = 0x0
	// LSE oscillator selected
	RCC_CFGR_MCO1_LSE = 0x1
	// HSE oscillator clock selected
	RCC_CFGR_MCO1_HSE = 0x2
	// PLL clock selected
	RCC_CFGR_MCO1_PLL = 0x3
	// Position of RTCPRE field.
	RCC_CFGR_RTCPRE_Pos = 0x10
	// Bit mask of RTCPRE field.
	RCC_CFGR_RTCPRE_Msk = 0x1f0000
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xd
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0xe000
	// HCLK not divided
	RCC_CFGR_PPRE2_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE2_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE2_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE2_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE2_Div16 = 0x7
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0xa
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x1c00
	// HCLK not divided
	RCC_CFGR_PPRE1_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE1_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE1_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE1_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE1_Div16 = 0x7
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// SYSCLK not divided
	RCC_CFGR_HPRE_Div1 = 0x0
	// SYSCLK divided by 2
	RCC_CFGR_HPRE_Div2 = 0x8
	// SYSCLK divided by 4
	RCC_CFGR_HPRE_Div4 = 0x9
	// SYSCLK divided by 8
	RCC_CFGR_HPRE_Div8 = 0xa
	// SYSCLK divided by 16
	RCC_CFGR_HPRE_Div16 = 0xb
	// SYSCLK divided by 64
	RCC_CFGR_HPRE_Div64 = 0xc
	// SYSCLK divided by 128
	RCC_CFGR_HPRE_Div128 = 0xd
	// SYSCLK divided by 256
	RCC_CFGR_HPRE_Div256 = 0xe
	// SYSCLK divided by 512
	RCC_CFGR_HPRE_Div512 = 0xf
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3
	// HSI selected as system clock
	RCC_CFGR_SW_HSI = 0x0
	// HSE selected as system clock
	RCC_CFGR_SW_HSE = 0x1
	// PLL selected as system clock
	RCC_CFGR_SW_PLL = 0x2
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// HSI oscillator used as system clock
	RCC_CFGR_SWS_HSI = 0x0
	// HSE oscillator used as system clock
	RCC_CFGR_SWS_HSE = 0x1
	// PLL used as system clock
	RCC_CFGR_SWS_PLL = 0x2

	// CIR: clock interrupt register
	// Position of CSSC field.
	RCC_CIR_CSSC_Pos = 0x17
	// Bit mask of CSSC field.
	RCC_CIR_CSSC_Msk = 0x800000
	// Bit CSSC.
	RCC_CIR_CSSC = 0x800000
	// Clear CSSF flag
	RCC_CIR_CSSC_Clear = 0x1
	// Position of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Pos = 0x15
	// Bit mask of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Msk = 0x200000
	// Bit PLLI2SRDYC.
	RCC_CIR_PLLI2SRDYC = 0x200000
	// Clear interrupt flag
	RCC_CIR_PLLI2SRDYC_Clear = 0x1
	// Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Pos = 0x14
	// Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk = 0x100000
	// Bit PLLRDYC.
	RCC_CIR_PLLRDYC = 0x100000
	// Clear interrupt flag
	RCC_CIR_PLLRDYC_Clear = 0x1
	// Position of HSERDYC field.
	RCC_CIR_HSERDYC_Pos = 0x13
	// Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC_Msk = 0x80000
	// Bit HSERDYC.
	RCC_CIR_HSERDYC = 0x80000
	// Clear interrupt flag
	RCC_CIR_HSERDYC_Clear = 0x1
	// Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Pos = 0x12
	// Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk = 0x40000
	// Bit HSIRDYC.
	RCC_CIR_HSIRDYC = 0x40000
	// Clear interrupt flag
	RCC_CIR_HSIRDYC_Clear = 0x1
	// Position of LSERDYC field.
	RCC_CIR_LSERDYC_Pos = 0x11
	// Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC_Msk = 0x20000
	// Bit LSERDYC.
	RCC_CIR_LSERDYC = 0x20000
	// Clear interrupt flag
	RCC_CIR_LSERDYC_Clear = 0x1
	// Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Pos = 0x10
	// Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk = 0x10000
	// Bit LSIRDYC.
	RCC_CIR_LSIRDYC = 0x10000
	// Clear interrupt flag
	RCC_CIR_LSIRDYC_Clear = 0x1
	// Position of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE_Pos = 0xd
	// Bit mask of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE_Msk = 0x2000
	// Bit PLLI2SRDYIE.
	RCC_CIR_PLLI2SRDYIE = 0x2000
	// Interrupt disabled
	RCC_CIR_PLLI2SRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLI2SRDYIE_Enabled = 0x1
	// Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Pos = 0xc
	// Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk = 0x1000
	// Bit PLLRDYIE.
	RCC_CIR_PLLRDYIE = 0x1000
	// Interrupt disabled
	RCC_CIR_PLLRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLRDYIE_Enabled = 0x1
	// Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Pos = 0xb
	// Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk = 0x800
	// Bit HSERDYIE.
	RCC_CIR_HSERDYIE = 0x800
	// Interrupt disabled
	RCC_CIR_HSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSERDYIE_Enabled = 0x1
	// Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Pos = 0xa
	// Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk = 0x400
	// Bit HSIRDYIE.
	RCC_CIR_HSIRDYIE = 0x400
	// Interrupt disabled
	RCC_CIR_HSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSIRDYIE_Enabled = 0x1
	// Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Pos = 0x9
	// Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk = 0x200
	// Bit LSERDYIE.
	RCC_CIR_LSERDYIE = 0x200
	// Interrupt disabled
	RCC_CIR_LSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSERDYIE_Enabled = 0x1
	// Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Pos = 0x8
	// Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk = 0x100
	// Bit LSIRDYIE.
	RCC_CIR_LSIRDYIE = 0x100
	// Interrupt disabled
	RCC_CIR_LSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSIRDYIE_Enabled = 0x1
	// Position of CSSF field.
	RCC_CIR_CSSF_Pos = 0x7
	// Bit mask of CSSF field.
	RCC_CIR_CSSF_Msk = 0x80
	// Bit CSSF.
	RCC_CIR_CSSF = 0x80
	// No clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_NotInterrupted = 0x0
	// Clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_Interrupted = 0x1
	// Position of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF_Pos = 0x5
	// Bit mask of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF_Msk = 0x20
	// Bit PLLI2SRDYF.
	RCC_CIR_PLLI2SRDYF = 0x20
	// No clock ready interrupt
	RCC_CIR_PLLI2SRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLI2SRDYF_Interrupted = 0x1
	// Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Pos = 0x4
	// Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk = 0x10
	// Bit PLLRDYF.
	RCC_CIR_PLLRDYF = 0x10
	// No clock ready interrupt
	RCC_CIR_PLLRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLRDYF_Interrupted = 0x1
	// Position of HSERDYF field.
	RCC_CIR_HSERDYF_Pos = 0x3
	// Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF_Msk = 0x8
	// Bit HSERDYF.
	RCC_CIR_HSERDYF = 0x8
	// No clock ready interrupt
	RCC_CIR_HSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSERDYF_Interrupted = 0x1
	// Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Pos = 0x2
	// Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk = 0x4
	// Bit HSIRDYF.
	RCC_CIR_HSIRDYF = 0x4
	// No clock ready interrupt
	RCC_CIR_HSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSIRDYF_Interrupted = 0x1
	// Position of LSERDYF field.
	RCC_CIR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIR_LSERDYF = 0x2
	// No clock ready interrupt
	RCC_CIR_LSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSERDYF_Interrupted = 0x1
	// Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIR_LSIRDYF = 0x1
	// No clock ready interrupt
	RCC_CIR_LSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSIRDYF_Interrupted = 0x1

	// AHB1RSTR: AHB1 peripheral reset register
	// Position of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Pos = 0x16
	// Bit mask of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Msk = 0x400000
	// Bit DMA2RST.
	RCC_AHB1RSTR_DMA2RST = 0x400000
	// Reset the selected module
	RCC_AHB1RSTR_DMA2RST_Reset = 0x1
	// Position of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Pos = 0x15
	// Bit mask of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Msk = 0x200000
	// Bit DMA1RST.
	RCC_AHB1RSTR_DMA1RST = 0x200000
	// Reset the selected module
	RCC_AHB1RSTR_DMA1RST_Reset = 0x1
	// Position of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Pos = 0xc
	// Bit mask of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Msk = 0x1000
	// Bit CRCRST.
	RCC_AHB1RSTR_CRCRST = 0x1000
	// Reset the selected module
	RCC_AHB1RSTR_CRCRST_Reset = 0x1
	// Position of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST_Pos = 0x7
	// Bit mask of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST_Msk = 0x80
	// Bit GPIOHRST.
	RCC_AHB1RSTR_GPIOHRST = 0x80
	// Reset the selected module
	RCC_AHB1RSTR_GPIOHRST_Reset = 0x1
	// Position of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST_Pos = 0x4
	// Bit mask of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST_Msk = 0x10
	// Bit GPIOERST.
	RCC_AHB1RSTR_GPIOERST = 0x10
	// Reset the selected module
	RCC_AHB1RSTR_GPIOERST_Reset = 0x1
	// Position of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST_Pos = 0x3
	// Bit mask of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST_Msk = 0x8
	// Bit GPIODRST.
	RCC_AHB1RSTR_GPIODRST = 0x8
	// Reset the selected module
	RCC_AHB1RSTR_GPIODRST_Reset = 0x1
	// Position of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST_Pos = 0x2
	// Bit mask of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST_Msk = 0x4
	// Bit GPIOCRST.
	RCC_AHB1RSTR_GPIOCRST = 0x4
	// Reset the selected module
	RCC_AHB1RSTR_GPIOCRST_Reset = 0x1
	// Position of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST_Pos = 0x1
	// Bit mask of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST_Msk = 0x2
	// Bit GPIOBRST.
	RCC_AHB1RSTR_GPIOBRST = 0x2
	// Reset the selected module
	RCC_AHB1RSTR_GPIOBRST_Reset = 0x1
	// Position of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST_Pos = 0x0
	// Bit mask of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST_Msk = 0x1
	// Bit GPIOARST.
	RCC_AHB1RSTR_GPIOARST = 0x1
	// Reset the selected module
	RCC_AHB1RSTR_GPIOARST_Reset = 0x1

	// AHB2RSTR: AHB2 peripheral reset register
	// Position of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Pos = 0x7
	// Bit mask of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Msk = 0x80
	// Bit OTGFSRST.
	RCC_AHB2RSTR_OTGFSRST = 0x80
	// Reset the selected module
	RCC_AHB2RSTR_OTGFSRST_Reset = 0x1

	// APB1RSTR: APB1 peripheral reset register
	// Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Pos = 0x1c
	// Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk = 0x10000000
	// Bit PWRRST.
	RCC_APB1RSTR_PWRRST = 0x10000000
	// Reset the selected module
	RCC_APB1RSTR_PWRRST_Reset = 0x1
	// Position of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Pos = 0x17
	// Bit mask of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Msk = 0x800000
	// Bit I2C3RST.
	RCC_APB1RSTR_I2C3RST = 0x800000
	// Reset the selected module
	RCC_APB1RSTR_I2C3RST_Reset = 0x1
	// Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APB1RSTR_I2C2RST = 0x400000
	// Reset the selected module
	RCC_APB1RSTR_I2C2RST_Reset = 0x1
	// Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR_I2C1RST = 0x200000
	// Reset the selected module
	RCC_APB1RSTR_I2C1RST_Reset = 0x1
	// Position of USART2RST field.
	RCC_APB1RSTR_USART2RST_Pos = 0x11
	// Bit mask of USART2RST field.
	RCC_APB1RSTR_USART2RST_Msk = 0x20000
	// Bit USART2RST.
	RCC_APB1RSTR_USART2RST = 0x20000
	// Reset the selected module
	RCC_APB1RSTR_USART2RST_Reset = 0x1
	// Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Pos = 0xf
	// Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk = 0x8000
	// Bit SPI3RST.
	RCC_APB1RSTR_SPI3RST = 0x8000
	// Reset the selected module
	RCC_APB1RSTR_SPI3RST_Reset = 0x1
	// Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APB1RSTR_SPI2RST = 0x4000
	// Reset the selected module
	RCC_APB1RSTR_SPI2RST_Reset = 0x1
	// Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Pos = 0xb
	// Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk = 0x800
	// Bit WWDGRST.
	RCC_APB1RSTR_WWDGRST = 0x800
	// Reset the selected module
	RCC_APB1RSTR_WWDGRST_Reset = 0x1
	// Position of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Pos = 0x3
	// Bit mask of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Msk = 0x8
	// Bit TIM5RST.
	RCC_APB1RSTR_TIM5RST = 0x8
	// Reset the selected module
	RCC_APB1RSTR_TIM5RST_Reset = 0x1
	// Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Pos = 0x2
	// Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk = 0x4
	// Bit TIM4RST.
	RCC_APB1RSTR_TIM4RST = 0x4
	// Reset the selected module
	RCC_APB1RSTR_TIM4RST_Reset = 0x1
	// Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Pos = 0x1
	// Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk = 0x2
	// Bit TIM3RST.
	RCC_APB1RSTR_TIM3RST = 0x2
	// Reset the selected module
	RCC_APB1RSTR_TIM3RST_Reset = 0x1
	// Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR_TIM2RST = 0x1
	// Reset the selected module
	RCC_APB1RSTR_TIM2RST_Reset = 0x1

	// APB2RSTR: APB2 peripheral reset register
	// Position of TIM11RST field.
	RCC_APB2RSTR_TIM11RST_Pos = 0x12
	// Bit mask of TIM11RST field.
	RCC_APB2RSTR_TIM11RST_Msk = 0x40000
	// Bit TIM11RST.
	RCC_APB2RSTR_TIM11RST = 0x40000
	// Reset the selected module
	RCC_APB2RSTR_TIM11RST_Reset = 0x1
	// Position of TIM10RST field.
	RCC_APB2RSTR_TIM10RST_Pos = 0x11
	// Bit mask of TIM10RST field.
	RCC_APB2RSTR_TIM10RST_Msk = 0x20000
	// Bit TIM10RST.
	RCC_APB2RSTR_TIM10RST = 0x20000
	// Reset the selected module
	RCC_APB2RSTR_TIM10RST_Reset = 0x1
	// Position of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Pos = 0x10
	// Bit mask of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Msk = 0x10000
	// Bit TIM9RST.
	RCC_APB2RSTR_TIM9RST = 0x10000
	// Reset the selected module
	RCC_APB2RSTR_TIM9RST_Reset = 0x1
	// Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0xe
	// Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x4000
	// Bit SYSCFGRST.
	RCC_APB2RSTR_SYSCFGRST = 0x4000
	// Reset the selected module
	RCC_APB2RSTR_SYSCFGRST_Reset = 0x1
	// Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APB2RSTR_SPI1RST = 0x1000
	// Reset the selected module
	RCC_APB2RSTR_SPI1RST_Reset = 0x1
	// Position of SDIORST field.
	RCC_APB2RSTR_SDIORST_Pos = 0xb
	// Bit mask of SDIORST field.
	RCC_APB2RSTR_SDIORST_Msk = 0x800
	// Bit SDIORST.
	RCC_APB2RSTR_SDIORST = 0x800
	// Reset the selected module
	RCC_APB2RSTR_SDIORST_Reset = 0x1
	// Position of ADCRST field.
	RCC_APB2RSTR_ADCRST_Pos = 0x8
	// Bit mask of ADCRST field.
	RCC_APB2RSTR_ADCRST_Msk = 0x100
	// Bit ADCRST.
	RCC_APB2RSTR_ADCRST = 0x100
	// Reset the selected module
	RCC_APB2RSTR_ADCRST_Reset = 0x1
	// Position of USART6RST field.
	RCC_APB2RSTR_USART6RST_Pos = 0x5
	// Bit mask of USART6RST field.
	RCC_APB2RSTR_USART6RST_Msk = 0x20
	// Bit USART6RST.
	RCC_APB2RSTR_USART6RST = 0x20
	// Reset the selected module
	RCC_APB2RSTR_USART6RST_Reset = 0x1
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0x4
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x10
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x10
	// Reset the selected module
	RCC_APB2RSTR_USART1RST_Reset = 0x1
	// Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Pos = 0x0
	// Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk = 0x1
	// Bit TIM1RST.
	RCC_APB2RSTR_TIM1RST = 0x1
	// Reset the selected module
	RCC_APB2RSTR_TIM1RST_Reset = 0x1
	// Position of SPI4RST field.
	RCC_APB2RSTR_SPI4RST_Pos = 0xd
	// Bit mask of SPI4RST field.
	RCC_APB2RSTR_SPI4RST_Msk = 0x2000
	// Bit SPI4RST.
	RCC_APB2RSTR_SPI4RST = 0x2000
	// Reset the selected module
	RCC_APB2RSTR_SPI4RST_Reset = 0x1
	// Position of SPI5RST field.
	RCC_APB2RSTR_SPI5RST_Pos = 0x14
	// Bit mask of SPI5RST field.
	RCC_APB2RSTR_SPI5RST_Msk = 0x100000
	// Bit SPI5RST.
	RCC_APB2RSTR_SPI5RST = 0x100000
	// Reset the selected module
	RCC_APB2RSTR_SPI5RST_Reset = 0x1

	// AHB1ENR: AHB1 peripheral clock register
	// Position of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Pos = 0x16
	// Bit mask of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Msk = 0x400000
	// Bit DMA2EN.
	RCC_AHB1ENR_DMA2EN = 0x400000
	// The selected clock is disabled
	RCC_AHB1ENR_DMA2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DMA2EN_Enabled = 0x1
	// Position of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Pos = 0x15
	// Bit mask of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Msk = 0x200000
	// Bit DMA1EN.
	RCC_AHB1ENR_DMA1EN = 0x200000
	// The selected clock is disabled
	RCC_AHB1ENR_DMA1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_DMA1EN_Enabled = 0x1
	// Position of CRCEN field.
	RCC_AHB1ENR_CRCEN_Pos = 0xc
	// Bit mask of CRCEN field.
	RCC_AHB1ENR_CRCEN_Msk = 0x1000
	// Bit CRCEN.
	RCC_AHB1ENR_CRCEN = 0x1000
	// The selected clock is disabled
	RCC_AHB1ENR_CRCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_CRCEN_Enabled = 0x1
	// Position of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN_Pos = 0x7
	// Bit mask of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN_Msk = 0x80
	// Bit GPIOHEN.
	RCC_AHB1ENR_GPIOHEN = 0x80
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOHEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOHEN_Enabled = 0x1
	// Position of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN_Pos = 0x4
	// Bit mask of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN_Msk = 0x10
	// Bit GPIOEEN.
	RCC_AHB1ENR_GPIOEEN = 0x10
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOEEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOEEN_Enabled = 0x1
	// Position of GPIODEN field.
	RCC_AHB1ENR_GPIODEN_Pos = 0x3
	// Bit mask of GPIODEN field.
	RCC_AHB1ENR_GPIODEN_Msk = 0x8
	// Bit GPIODEN.
	RCC_AHB1ENR_GPIODEN = 0x8
	// The selected clock is disabled
	RCC_AHB1ENR_GPIODEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIODEN_Enabled = 0x1
	// Position of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN_Pos = 0x2
	// Bit mask of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN_Msk = 0x4
	// Bit GPIOCEN.
	RCC_AHB1ENR_GPIOCEN = 0x4
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOCEN_Enabled = 0x1
	// Position of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN_Pos = 0x1
	// Bit mask of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN_Msk = 0x2
	// Bit GPIOBEN.
	RCC_AHB1ENR_GPIOBEN = 0x2
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOBEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOBEN_Enabled = 0x1
	// Position of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN_Pos = 0x0
	// Bit mask of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN_Msk = 0x1
	// Bit GPIOAEN.
	RCC_AHB1ENR_GPIOAEN = 0x1
	// The selected clock is disabled
	RCC_AHB1ENR_GPIOAEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB1ENR_GPIOAEN_Enabled = 0x1

	// AHB2ENR: AHB2 peripheral clock enable register
	// Position of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Pos = 0x7
	// Bit mask of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Msk = 0x80
	// Bit OTGFSEN.
	RCC_AHB2ENR_OTGFSEN = 0x80
	// The selected clock is disabled
	RCC_AHB2ENR_OTGFSEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHB2ENR_OTGFSEN_Enabled = 0x1

	// APB1ENR: APB1 peripheral clock enable register
	// Position of PWREN field.
	RCC_APB1ENR_PWREN_Pos = 0x1c
	// Bit mask of PWREN field.
	RCC_APB1ENR_PWREN_Msk = 0x10000000
	// Bit PWREN.
	RCC_APB1ENR_PWREN = 0x10000000
	// The selected clock is disabled
	RCC_APB1ENR_PWREN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_PWREN_Enabled = 0x1
	// Position of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Pos = 0x17
	// Bit mask of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Msk = 0x800000
	// Bit I2C3EN.
	RCC_APB1ENR_I2C3EN = 0x800000
	// The selected clock is disabled
	RCC_APB1ENR_I2C3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C3EN_Enabled = 0x1
	// Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APB1ENR_I2C2EN = 0x400000
	// The selected clock is disabled
	RCC_APB1ENR_I2C2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C2EN_Enabled = 0x1
	// Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR_I2C1EN = 0x200000
	// The selected clock is disabled
	RCC_APB1ENR_I2C1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C1EN_Enabled = 0x1
	// Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APB1ENR_USART2EN = 0x20000
	// The selected clock is disabled
	RCC_APB1ENR_USART2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART2EN_Enabled = 0x1
	// Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Pos = 0xf
	// Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk = 0x8000
	// Bit SPI3EN.
	RCC_APB1ENR_SPI3EN = 0x8000
	// The selected clock is disabled
	RCC_APB1ENR_SPI3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI3EN_Enabled = 0x1
	// Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APB1ENR_SPI2EN = 0x4000
	// The selected clock is disabled
	RCC_APB1ENR_SPI2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI2EN_Enabled = 0x1
	// Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR_WWDGEN = 0x800
	// The selected clock is disabled
	RCC_APB1ENR_WWDGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_WWDGEN_Enabled = 0x1
	// Position of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Pos = 0x3
	// Bit mask of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Msk = 0x8
	// Bit TIM5EN.
	RCC_APB1ENR_TIM5EN = 0x8
	// The selected clock is disabled
	RCC_APB1ENR_TIM5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM5EN_Enabled = 0x1
	// Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Pos = 0x2
	// Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk = 0x4
	// Bit TIM4EN.
	RCC_APB1ENR_TIM4EN = 0x4
	// The selected clock is disabled
	RCC_APB1ENR_TIM4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM4EN_Enabled = 0x1
	// Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Pos = 0x1
	// Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk = 0x2
	// Bit TIM3EN.
	RCC_APB1ENR_TIM3EN = 0x2
	// The selected clock is disabled
	RCC_APB1ENR_TIM3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM3EN_Enabled = 0x1
	// Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR_TIM2EN = 0x1
	// The selected clock is disabled
	RCC_APB1ENR_TIM2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM2EN_Enabled = 0x1

	// APB2ENR: APB2 peripheral clock enable register
	// Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Pos = 0x0
	// Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk = 0x1
	// Bit TIM1EN.
	RCC_APB2ENR_TIM1EN = 0x1
	// The selected clock is disabled
	RCC_APB2ENR_TIM1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM1EN_Enabled = 0x1
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0x4
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x10
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x10
	// The selected clock is disabled
	RCC_APB2ENR_USART1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_USART1EN_Enabled = 0x1
	// Position of USART6EN field.
	RCC_APB2ENR_USART6EN_Pos = 0x5
	// Bit mask of USART6EN field.
	RCC_APB2ENR_USART6EN_Msk = 0x20
	// Bit USART6EN.
	RCC_APB2ENR_USART6EN = 0x20
	// The selected clock is disabled
	RCC_APB2ENR_USART6EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_USART6EN_Enabled = 0x1
	// Position of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Pos = 0x8
	// Bit mask of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Msk = 0x100
	// Bit ADC1EN.
	RCC_APB2ENR_ADC1EN = 0x100
	// The selected clock is disabled
	RCC_APB2ENR_ADC1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_ADC1EN_Enabled = 0x1
	// Position of SDIOEN field.
	RCC_APB2ENR_SDIOEN_Pos = 0xb
	// Bit mask of SDIOEN field.
	RCC_APB2ENR_SDIOEN_Msk = 0x800
	// Bit SDIOEN.
	RCC_APB2ENR_SDIOEN = 0x800
	// The selected clock is disabled
	RCC_APB2ENR_SDIOEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SDIOEN_Enabled = 0x1
	// Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APB2ENR_SPI1EN = 0x1000
	// The selected clock is disabled
	RCC_APB2ENR_SPI1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI1EN_Enabled = 0x1
	// Position of SPI4EN field.
	RCC_APB2ENR_SPI4EN_Pos = 0xd
	// Bit mask of SPI4EN field.
	RCC_APB2ENR_SPI4EN_Msk = 0x2000
	// Bit SPI4EN.
	RCC_APB2ENR_SPI4EN = 0x2000
	// The selected clock is disabled
	RCC_APB2ENR_SPI4EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI4EN_Enabled = 0x1
	// Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Pos = 0xe
	// Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x4000
	// Bit SYSCFGEN.
	RCC_APB2ENR_SYSCFGEN = 0x4000
	// The selected clock is disabled
	RCC_APB2ENR_SYSCFGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SYSCFGEN_Enabled = 0x1
	// Position of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Pos = 0x10
	// Bit mask of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Msk = 0x10000
	// Bit TIM9EN.
	RCC_APB2ENR_TIM9EN = 0x10000
	// The selected clock is disabled
	RCC_APB2ENR_TIM9EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM9EN_Enabled = 0x1
	// Position of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Pos = 0x11
	// Bit mask of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Msk = 0x20000
	// Bit TIM10EN.
	RCC_APB2ENR_TIM10EN = 0x20000
	// The selected clock is disabled
	RCC_APB2ENR_TIM10EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM10EN_Enabled = 0x1
	// Position of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Pos = 0x12
	// Bit mask of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Msk = 0x40000
	// Bit TIM11EN.
	RCC_APB2ENR_TIM11EN = 0x40000
	// The selected clock is disabled
	RCC_APB2ENR_TIM11EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM11EN_Enabled = 0x1
	// Position of SPI5EN field.
	RCC_APB2ENR_SPI5EN_Pos = 0x14
	// Bit mask of SPI5EN field.
	RCC_APB2ENR_SPI5EN_Msk = 0x100000
	// Bit SPI5EN.
	RCC_APB2ENR_SPI5EN = 0x100000
	// The selected clock is disabled
	RCC_APB2ENR_SPI5EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SPI5EN_Enabled = 0x1

	// AHB1LPENR: AHB1 peripheral clock enable in low power mode register
	// Position of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN_Pos = 0x16
	// Bit mask of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN_Msk = 0x400000
	// Bit DMA2LPEN.
	RCC_AHB1LPENR_DMA2LPEN = 0x400000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_DMA2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_DMA2LPEN_EnabledInSleep = 0x1
	// Position of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN_Pos = 0x15
	// Bit mask of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN_Msk = 0x200000
	// Bit DMA1LPEN.
	RCC_AHB1LPENR_DMA1LPEN = 0x200000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_DMA1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_DMA1LPEN_EnabledInSleep = 0x1
	// Position of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN_Pos = 0x10
	// Bit mask of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN_Msk = 0x10000
	// Bit SRAM1LPEN.
	RCC_AHB1LPENR_SRAM1LPEN = 0x10000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_SRAM1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_SRAM1LPEN_EnabledInSleep = 0x1
	// Position of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN_Pos = 0xf
	// Bit mask of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN_Msk = 0x8000
	// Bit FLITFLPEN.
	RCC_AHB1LPENR_FLITFLPEN = 0x8000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_FLITFLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_FLITFLPEN_EnabledInSleep = 0x1
	// Position of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN_Pos = 0xc
	// Bit mask of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN_Msk = 0x1000
	// Bit CRCLPEN.
	RCC_AHB1LPENR_CRCLPEN = 0x1000
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_CRCLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_CRCLPEN_EnabledInSleep = 0x1
	// Position of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN_Pos = 0x7
	// Bit mask of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN_Msk = 0x80
	// Bit GPIOHLPEN.
	RCC_AHB1LPENR_GPIOHLPEN = 0x80
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOHLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOHLPEN_EnabledInSleep = 0x1
	// Position of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN_Pos = 0x4
	// Bit mask of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN_Msk = 0x10
	// Bit GPIOELPEN.
	RCC_AHB1LPENR_GPIOELPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOELPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOELPEN_EnabledInSleep = 0x1
	// Position of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN_Pos = 0x3
	// Bit mask of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN_Msk = 0x8
	// Bit GPIODLPEN.
	RCC_AHB1LPENR_GPIODLPEN = 0x8
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIODLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIODLPEN_EnabledInSleep = 0x1
	// Position of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN_Pos = 0x2
	// Bit mask of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN_Msk = 0x4
	// Bit GPIOCLPEN.
	RCC_AHB1LPENR_GPIOCLPEN = 0x4
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOCLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOCLPEN_EnabledInSleep = 0x1
	// Position of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN_Pos = 0x1
	// Bit mask of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN_Msk = 0x2
	// Bit GPIOBLPEN.
	RCC_AHB1LPENR_GPIOBLPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOBLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOBLPEN_EnabledInSleep = 0x1
	// Position of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN_Pos = 0x0
	// Bit mask of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN_Msk = 0x1
	// Bit GPIOALPEN.
	RCC_AHB1LPENR_GPIOALPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_AHB1LPENR_GPIOALPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB1LPENR_GPIOALPEN_EnabledInSleep = 0x1

	// AHB2LPENR: AHB2 peripheral clock enable in low power mode register
	// Position of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN_Pos = 0x7
	// Bit mask of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN_Msk = 0x80
	// Bit OTGFSLPEN.
	RCC_AHB2LPENR_OTGFSLPEN = 0x80
	// Selected module is disabled during Sleep mode
	RCC_AHB2LPENR_OTGFSLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_AHB2LPENR_OTGFSLPEN_EnabledInSleep = 0x1

	// APB1LPENR: APB1 peripheral clock enable in low power mode register
	// Position of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Pos = 0x1c
	// Bit mask of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Msk = 0x10000000
	// Bit PWRLPEN.
	RCC_APB1LPENR_PWRLPEN = 0x10000000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_PWRLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_PWRLPEN_EnabledInSleep = 0x1
	// Position of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN_Pos = 0x17
	// Bit mask of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN_Msk = 0x800000
	// Bit I2C3LPEN.
	RCC_APB1LPENR_I2C3LPEN = 0x800000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C3LPEN_EnabledInSleep = 0x1
	// Position of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Pos = 0x16
	// Bit mask of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Msk = 0x400000
	// Bit I2C2LPEN.
	RCC_APB1LPENR_I2C2LPEN = 0x400000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C2LPEN_EnabledInSleep = 0x1
	// Position of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Pos = 0x15
	// Bit mask of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Msk = 0x200000
	// Bit I2C1LPEN.
	RCC_APB1LPENR_I2C1LPEN = 0x200000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_I2C1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_I2C1LPEN_EnabledInSleep = 0x1
	// Position of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Pos = 0x11
	// Bit mask of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Msk = 0x20000
	// Bit USART2LPEN.
	RCC_APB1LPENR_USART2LPEN = 0x20000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_USART2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_USART2LPEN_EnabledInSleep = 0x1
	// Position of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN_Pos = 0xf
	// Bit mask of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN_Msk = 0x8000
	// Bit SPI3LPEN.
	RCC_APB1LPENR_SPI3LPEN = 0x8000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_SPI3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_SPI3LPEN_EnabledInSleep = 0x1
	// Position of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Pos = 0xe
	// Bit mask of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Msk = 0x4000
	// Bit SPI2LPEN.
	RCC_APB1LPENR_SPI2LPEN = 0x4000
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_SPI2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_SPI2LPEN_EnabledInSleep = 0x1
	// Position of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Pos = 0xb
	// Bit mask of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Msk = 0x800
	// Bit WWDGLPEN.
	RCC_APB1LPENR_WWDGLPEN = 0x800
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_WWDGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_WWDGLPEN_EnabledInSleep = 0x1
	// Position of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN_Pos = 0x3
	// Bit mask of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN_Msk = 0x8
	// Bit TIM5LPEN.
	RCC_APB1LPENR_TIM5LPEN = 0x8
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM5LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM5LPEN_EnabledInSleep = 0x1
	// Position of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Pos = 0x2
	// Bit mask of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Msk = 0x4
	// Bit TIM4LPEN.
	RCC_APB1LPENR_TIM4LPEN = 0x4
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM4LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM4LPEN_EnabledInSleep = 0x1
	// Position of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Pos = 0x1
	// Bit mask of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Msk = 0x2
	// Bit TIM3LPEN.
	RCC_APB1LPENR_TIM3LPEN = 0x2
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM3LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM3LPEN_EnabledInSleep = 0x1
	// Position of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Pos = 0x0
	// Bit mask of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Msk = 0x1
	// Bit TIM2LPEN.
	RCC_APB1LPENR_TIM2LPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_APB1LPENR_TIM2LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB1LPENR_TIM2LPEN_EnabledInSleep = 0x1

	// APB2LPENR: APB2 peripheral clock enabled in low power mode register
	// Position of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN_Pos = 0x0
	// Bit mask of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN_Msk = 0x1
	// Bit TIM1LPEN.
	RCC_APB2LPENR_TIM1LPEN = 0x1
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM1LPEN_EnabledInSleep = 0x1
	// Position of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Pos = 0x4
	// Bit mask of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Msk = 0x10
	// Bit USART1LPEN.
	RCC_APB2LPENR_USART1LPEN = 0x10
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_USART1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_USART1LPEN_EnabledInSleep = 0x1
	// Position of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN_Pos = 0x5
	// Bit mask of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN_Msk = 0x20
	// Bit USART6LPEN.
	RCC_APB2LPENR_USART6LPEN = 0x20
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_USART6LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_USART6LPEN_EnabledInSleep = 0x1
	// Position of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Pos = 0x8
	// Bit mask of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Msk = 0x100
	// Bit ADC1LPEN.
	RCC_APB2LPENR_ADC1LPEN = 0x100
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_ADC1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_ADC1LPEN_EnabledInSleep = 0x1
	// Position of SDIOLPEN field.
	RCC_APB2LPENR_SDIOLPEN_Pos = 0xb
	// Bit mask of SDIOLPEN field.
	RCC_APB2LPENR_SDIOLPEN_Msk = 0x800
	// Bit SDIOLPEN.
	RCC_APB2LPENR_SDIOLPEN = 0x800
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SDIOLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SDIOLPEN_EnabledInSleep = 0x1
	// Position of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Pos = 0xc
	// Bit mask of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Msk = 0x1000
	// Bit SPI1LPEN.
	RCC_APB2LPENR_SPI1LPEN = 0x1000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SPI1LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SPI1LPEN_EnabledInSleep = 0x1
	// Position of SPI4LPEN field.
	RCC_APB2LPENR_SPI4LPEN_Pos = 0xd
	// Bit mask of SPI4LPEN field.
	RCC_APB2LPENR_SPI4LPEN_Msk = 0x2000
	// Bit SPI4LPEN.
	RCC_APB2LPENR_SPI4LPEN = 0x2000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SPI4LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SPI4LPEN_EnabledInSleep = 0x1
	// Position of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Pos = 0xe
	// Bit mask of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Msk = 0x4000
	// Bit SYSCFGLPEN.
	RCC_APB2LPENR_SYSCFGLPEN = 0x4000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SYSCFGLPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SYSCFGLPEN_EnabledInSleep = 0x1
	// Position of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Pos = 0x10
	// Bit mask of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Msk = 0x10000
	// Bit TIM9LPEN.
	RCC_APB2LPENR_TIM9LPEN = 0x10000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM9LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM9LPEN_EnabledInSleep = 0x1
	// Position of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Pos = 0x11
	// Bit mask of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Msk = 0x20000
	// Bit TIM10LPEN.
	RCC_APB2LPENR_TIM10LPEN = 0x20000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM10LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM10LPEN_EnabledInSleep = 0x1
	// Position of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Pos = 0x12
	// Bit mask of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Msk = 0x40000
	// Bit TIM11LPEN.
	RCC_APB2LPENR_TIM11LPEN = 0x40000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_TIM11LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_TIM11LPEN_EnabledInSleep = 0x1
	// Position of SPI5LPEN field.
	RCC_APB2LPENR_SPI5LPEN_Pos = 0x14
	// Bit mask of SPI5LPEN field.
	RCC_APB2LPENR_SPI5LPEN_Msk = 0x100000
	// Bit SPI5LPEN.
	RCC_APB2LPENR_SPI5LPEN = 0x100000
	// Selected module is disabled during Sleep mode
	RCC_APB2LPENR_SPI5LPEN_DisabledInSleep = 0x0
	// Selected module is enabled during Sleep mode
	RCC_APB2LPENR_SPI5LPEN_EnabledInSleep = 0x1

	// BDCR: Backup domain control register
	// Position of BDRST field.
	RCC_BDCR_BDRST_Pos = 0x10
	// Bit mask of BDRST field.
	RCC_BDCR_BDRST_Msk = 0x10000
	// Bit BDRST.
	RCC_BDCR_BDRST = 0x10000
	// Reset not activated
	RCC_BDCR_BDRST_Disabled = 0x0
	// Reset the entire RTC domain
	RCC_BDCR_BDRST_Enabled = 0x1
	// Position of RTCEN field.
	RCC_BDCR_RTCEN_Pos = 0xf
	// Bit mask of RTCEN field.
	RCC_BDCR_RTCEN_Msk = 0x8000
	// Bit RTCEN.
	RCC_BDCR_RTCEN = 0x8000
	// RTC clock disabled
	RCC_BDCR_RTCEN_Disabled = 0x0
	// RTC clock enabled
	RCC_BDCR_RTCEN_Enabled = 0x1
	// Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Pos = 0x2
	// Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4
	// Bit LSEBYP.
	RCC_BDCR_LSEBYP = 0x4
	// LSE crystal oscillator not bypassed
	RCC_BDCR_LSEBYP_NotBypassed = 0x0
	// LSE crystal oscillator bypassed with external clock
	RCC_BDCR_LSEBYP_Bypassed = 0x1
	// Position of LSERDY field.
	RCC_BDCR_LSERDY_Pos = 0x1
	// Bit mask of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2
	// Bit LSERDY.
	RCC_BDCR_LSERDY = 0x2
	// LSE oscillator not ready
	RCC_BDCR_LSERDY_NotReady = 0x0
	// LSE oscillator ready
	RCC_BDCR_LSERDY_Ready = 0x1
	// Position of LSEON field.
	RCC_BDCR_LSEON_Pos = 0x0
	// Bit mask of LSEON field.
	RCC_BDCR_LSEON_Msk = 0x1
	// Bit LSEON.
	RCC_BDCR_LSEON = 0x1
	// LSE oscillator Off
	RCC_BDCR_LSEON_Off = 0x0
	// LSE oscillator On
	RCC_BDCR_LSEON_On = 0x1
	// Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Pos = 0x8
	// Bit mask of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300
	// No clock
	RCC_BDCR_RTCSEL_NoClock = 0x0
	// LSE oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSE = 0x1
	// LSI oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSI = 0x2
	// HSE oscillator clock divided by a prescaler used as RTC clock
	RCC_BDCR_RTCSEL_HSE = 0x3

	// CSR: clock control & status register
	// Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Pos = 0x1f
	// Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000
	// Bit LPWRRSTF.
	RCC_CSR_LPWRRSTF = 0x80000000
	// No reset has occured
	RCC_CSR_LPWRRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_LPWRRSTF_Reset = 0x1
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// No reset has occured
	RCC_CSR_WWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WWDGRSTF_Reset = 0x1
	// Position of WDGRSTF field.
	RCC_CSR_WDGRSTF_Pos = 0x1d
	// Bit mask of WDGRSTF field.
	RCC_CSR_WDGRSTF_Msk = 0x20000000
	// Bit WDGRSTF.
	RCC_CSR_WDGRSTF = 0x20000000
	// No reset has occured
	RCC_CSR_WDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WDGRSTF_Reset = 0x1
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// No reset has occured
	RCC_CSR_SFTRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_SFTRSTF_Reset = 0x1
	// Position of PORRSTF field.
	RCC_CSR_PORRSTF_Pos = 0x1b
	// Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF_Msk = 0x8000000
	// Bit PORRSTF.
	RCC_CSR_PORRSTF = 0x8000000
	// No reset has occured
	RCC_CSR_PORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PORRSTF_Reset = 0x1
	// Position of PADRSTF field.
	RCC_CSR_PADRSTF_Pos = 0x1a
	// Bit mask of PADRSTF field.
	RCC_CSR_PADRSTF_Msk = 0x4000000
	// Bit PADRSTF.
	RCC_CSR_PADRSTF = 0x4000000
	// No reset has occured
	RCC_CSR_PADRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PADRSTF_Reset = 0x1
	// Position of BORRSTF field.
	RCC_CSR_BORRSTF_Pos = 0x19
	// Bit mask of BORRSTF field.
	RCC_CSR_BORRSTF_Msk = 0x2000000
	// Bit BORRSTF.
	RCC_CSR_BORRSTF = 0x2000000
	// No reset has occured
	RCC_CSR_BORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_BORRSTF_Reset = 0x1
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x18
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x1000000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x1000000
	// Clears the reset flag
	RCC_CSR_RMVF_Clear = 0x1
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// LSI oscillator not ready
	RCC_CSR_LSIRDY_NotReady = 0x0
	// LSI oscillator ready
	RCC_CSR_LSIRDY_Ready = 0x1
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1
	// LSI oscillator Off
	RCC_CSR_LSION_Off = 0x0
	// LSI oscillator On
	RCC_CSR_LSION_On = 0x1

	// SSCGR: spread spectrum clock generation register
	// Position of SSCGEN field.
	RCC_SSCGR_SSCGEN_Pos = 0x1f
	// Bit mask of SSCGEN field.
	RCC_SSCGR_SSCGEN_Msk = 0x80000000
	// Bit SSCGEN.
	RCC_SSCGR_SSCGEN = 0x80000000
	// Spread spectrum modulation disabled
	RCC_SSCGR_SSCGEN_Disabled = 0x0
	// Spread spectrum modulation enabled
	RCC_SSCGR_SSCGEN_Enabled = 0x1
	// Position of SPREADSEL field.
	RCC_SSCGR_SPREADSEL_Pos = 0x1e
	// Bit mask of SPREADSEL field.
	RCC_SSCGR_SPREADSEL_Msk = 0x40000000
	// Bit SPREADSEL.
	RCC_SSCGR_SPREADSEL = 0x40000000
	// Center spread
	RCC_SSCGR_SPREADSEL_Center = 0x0
	// Down spread
	RCC_SSCGR_SPREADSEL_Down = 0x1
	// Position of INCSTEP field.
	RCC_SSCGR_INCSTEP_Pos = 0xd
	// Bit mask of INCSTEP field.
	RCC_SSCGR_INCSTEP_Msk = 0xfffe000
	// Position of MODPER field.
	RCC_SSCGR_MODPER_Pos = 0x0
	// Bit mask of MODPER field.
	RCC_SSCGR_MODPER_Msk = 0x1fff

	// PLLI2SCFGR: PLLI2S configuration register
	// Position of PLLI2SR field.
	RCC_PLLI2SCFGR_PLLI2SR_Pos = 0x1c
	// Bit mask of PLLI2SR field.
	RCC_PLLI2SCFGR_PLLI2SR_Msk = 0x70000000
	// Position of PLLI2SN field.
	RCC_PLLI2SCFGR_PLLI2SN_Pos = 0x6
	// Bit mask of PLLI2SN field.
	RCC_PLLI2SCFGR_PLLI2SN_Msk = 0x7fc0
	// Position of PLLI2SM field.
	RCC_PLLI2SCFGR_PLLI2SM_Pos = 0x0
	// Bit mask of PLLI2SM field.
	RCC_PLLI2SCFGR_PLLI2SM_Msk = 0x3f

	// DCKCFGR: RCC Dedicated Clock Configuration Register
	// Position of TIMPRE field.
	RCC_DCKCFGR_TIMPRE_Pos = 0x18
	// Bit mask of TIMPRE field.
	RCC_DCKCFGR_TIMPRE_Msk = 0x1000000
	// Bit TIMPRE.
	RCC_DCKCFGR_TIMPRE = 0x1000000
	// If the APB prescaler is configured 1, TIMxCLK = PCLKx. Otherwise, TIMxCLK = 2xPCLKx
	RCC_DCKCFGR_TIMPRE_Mul2 = 0x0
	// If the APB prescaler is configured 1, 2 or 4, TIMxCLK = HCLK. Otherwise, TIMxCLK = 4xPCLKx
	RCC_DCKCFGR_TIMPRE_Mul4 = 0x1
)

// Constants for RTC: Real-time clock
const (
	// TR: time register
	// Position of PM field.
	RTC_TR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TR_PM = 0x400000
	// AM or 24-hour format
	RTC_TR_PM_AM = 0x0
	// PM
	RTC_TR_PM_PM = 0x1
	// Position of HT field.
	RTC_TR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TR_SU_Msk = 0xf

	// DR: date register
	// Position of YT field.
	RTC_DR_YT_Pos = 0x14
	// Bit mask of YT field.
	RTC_DR_YT_Msk = 0xf00000
	// Position of YU field.
	RTC_DR_YU_Pos = 0x10
	// Bit mask of YU field.
	RTC_DR_YU_Msk = 0xf0000
	// Position of WDU field.
	RTC_DR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_DR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_DR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_DR_MT_Msk = 0x1000
	// Bit MT.
	RTC_DR_MT = 0x1000
	// Position of MU field.
	RTC_DR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_DR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_DR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_DR_DT_Msk = 0x30
	// Position of DU field.
	RTC_DR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_DR_DU_Msk = 0xf

	// CR: control register
	// Position of COE field.
	RTC_CR_COE_Pos = 0x17
	// Bit mask of COE field.
	RTC_CR_COE_Msk = 0x800000
	// Bit COE.
	RTC_CR_COE = 0x800000
	// Calibration output disabled
	RTC_CR_COE_Disabled = 0x0
	// Calibration output enabled
	RTC_CR_COE_Enabled = 0x1
	// Position of OSEL field.
	RTC_CR_OSEL_Pos = 0x15
	// Bit mask of OSEL field.
	RTC_CR_OSEL_Msk = 0x600000
	// Output disabled
	RTC_CR_OSEL_Disabled = 0x0
	// Alarm A output enabled
	RTC_CR_OSEL_AlarmA = 0x1
	// Alarm B output enabled
	RTC_CR_OSEL_AlarmB = 0x2
	// Wakeup output enabled
	RTC_CR_OSEL_Wakeup = 0x3
	// Position of POL field.
	RTC_CR_POL_Pos = 0x14
	// Bit mask of POL field.
	RTC_CR_POL_Msk = 0x100000
	// Bit POL.
	RTC_CR_POL = 0x100000
	// The pin is high when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])
	RTC_CR_POL_High = 0x0
	// The pin is low when ALRAF/ALRBF/WUTF is asserted (depending on OSEL[1:0])
	RTC_CR_POL_Low = 0x1
	// Position of COSEL field.
	RTC_CR_COSEL_Pos = 0x13
	// Bit mask of COSEL field.
	RTC_CR_COSEL_Msk = 0x80000
	// Bit COSEL.
	RTC_CR_COSEL = 0x80000
	// Calibration output is 512 Hz (with default prescaler setting)
	RTC_CR_COSEL_CalFreq_512Hz = 0x0
	// Calibration output is 1 Hz (with default prescaler setting)
	RTC_CR_COSEL_CalFreq_1Hz = 0x1
	// Position of BKP field.
	RTC_CR_BKP_Pos = 0x12
	// Bit mask of BKP field.
	RTC_CR_BKP_Msk = 0x40000
	// Bit BKP.
	RTC_CR_BKP = 0x40000
	// Daylight Saving Time change has not been performed
	RTC_CR_BKP_DST_Not_Changed = 0x0
	// Daylight Saving Time change has been performed
	RTC_CR_BKP_DST_Changed = 0x1
	// Position of SUB1H field.
	RTC_CR_SUB1H_Pos = 0x11
	// Bit mask of SUB1H field.
	RTC_CR_SUB1H_Msk = 0x20000
	// Bit SUB1H.
	RTC_CR_SUB1H = 0x20000
	// Subtracts 1 hour to the current time. This can be used for winter time change outside initialization mode
	RTC_CR_SUB1H_Sub1 = 0x1
	// Position of ADD1H field.
	RTC_CR_ADD1H_Pos = 0x10
	// Bit mask of ADD1H field.
	RTC_CR_ADD1H_Msk = 0x10000
	// Bit ADD1H.
	RTC_CR_ADD1H = 0x10000
	// Adds 1 hour to the current time. This can be used for summer time change outside initialization mode
	RTC_CR_ADD1H_Add1 = 0x1
	// Position of TSIE field.
	RTC_CR_TSIE_Pos = 0xf
	// Bit mask of TSIE field.
	RTC_CR_TSIE_Msk = 0x8000
	// Bit TSIE.
	RTC_CR_TSIE = 0x8000
	// Time-stamp Interrupt disabled
	RTC_CR_TSIE_Disabled = 0x0
	// Time-stamp Interrupt enabled
	RTC_CR_TSIE_Enabled = 0x1
	// Position of WUTIE field.
	RTC_CR_WUTIE_Pos = 0xe
	// Bit mask of WUTIE field.
	RTC_CR_WUTIE_Msk = 0x4000
	// Bit WUTIE.
	RTC_CR_WUTIE = 0x4000
	// Wakeup timer interrupt disabled
	RTC_CR_WUTIE_Disabled = 0x0
	// Wakeup timer interrupt enabled
	RTC_CR_WUTIE_Enabled = 0x1
	// Position of ALRBIE field.
	RTC_CR_ALRBIE_Pos = 0xd
	// Bit mask of ALRBIE field.
	RTC_CR_ALRBIE_Msk = 0x2000
	// Bit ALRBIE.
	RTC_CR_ALRBIE = 0x2000
	// Alarm B Interrupt disabled
	RTC_CR_ALRBIE_Disabled = 0x0
	// Alarm B Interrupt enabled
	RTC_CR_ALRBIE_Enabled = 0x1
	// Position of ALRAIE field.
	RTC_CR_ALRAIE_Pos = 0xc
	// Bit mask of ALRAIE field.
	RTC_CR_ALRAIE_Msk = 0x1000
	// Bit ALRAIE.
	RTC_CR_ALRAIE = 0x1000
	// Alarm A interrupt disabled
	RTC_CR_ALRAIE_Disabled = 0x0
	// Alarm A interrupt enabled
	RTC_CR_ALRAIE_Enabled = 0x1
	// Position of TSE field.
	RTC_CR_TSE_Pos = 0xb
	// Bit mask of TSE field.
	RTC_CR_TSE_Msk = 0x800
	// Bit TSE.
	RTC_CR_TSE = 0x800
	// Timestamp disabled
	RTC_CR_TSE_Disabled = 0x0
	// Timestamp enabled
	RTC_CR_TSE_Enabled = 0x1
	// Position of WUTE field.
	RTC_CR_WUTE_Pos = 0xa
	// Bit mask of WUTE field.
	RTC_CR_WUTE_Msk = 0x400
	// Bit WUTE.
	RTC_CR_WUTE = 0x400
	// Wakeup timer disabled
	RTC_CR_WUTE_Disabled = 0x0
	// Wakeup timer enabled
	RTC_CR_WUTE_Enabled = 0x1
	// Position of ALRBE field.
	RTC_CR_ALRBE_Pos = 0x9
	// Bit mask of ALRBE field.
	RTC_CR_ALRBE_Msk = 0x200
	// Bit ALRBE.
	RTC_CR_ALRBE = 0x200
	// Alarm B disabled
	RTC_CR_ALRBE_Disabled = 0x0
	// Alarm B enabled
	RTC_CR_ALRBE_Enabled = 0x1
	// Position of ALRAE field.
	RTC_CR_ALRAE_Pos = 0x8
	// Bit mask of ALRAE field.
	RTC_CR_ALRAE_Msk = 0x100
	// Bit ALRAE.
	RTC_CR_ALRAE = 0x100
	// Alarm A disabled
	RTC_CR_ALRAE_Disabled = 0x0
	// Alarm A enabled
	RTC_CR_ALRAE_Enabled = 0x1
	// Position of DCE field.
	RTC_CR_DCE_Pos = 0x7
	// Bit mask of DCE field.
	RTC_CR_DCE_Msk = 0x80
	// Bit DCE.
	RTC_CR_DCE = 0x80
	// Position of FMT field.
	RTC_CR_FMT_Pos = 0x6
	// Bit mask of FMT field.
	RTC_CR_FMT_Msk = 0x40
	// Bit FMT.
	RTC_CR_FMT = 0x40
	// 24 hour/day format
	RTC_CR_FMT_Twenty_Four_Hour = 0x0
	// AM/PM hour format
	RTC_CR_FMT_AM_PM = 0x1
	// Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Pos = 0x5
	// Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20
	// Bit BYPSHAD.
	RTC_CR_BYPSHAD = 0x20
	// Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken from the shadow registers, which are updated once every two RTCCLK cycles
	RTC_CR_BYPSHAD_ShadowReg = 0x0
	// Calendar values (when reading from RTC_SSR, RTC_TR, and RTC_DR) are taken directly from the calendar counters
	RTC_CR_BYPSHAD_BypassShadowReg = 0x1
	// Position of REFCKON field.
	RTC_CR_REFCKON_Pos = 0x4
	// Bit mask of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10
	// Bit REFCKON.
	RTC_CR_REFCKON = 0x10
	// RTC_REFIN detection disabled
	RTC_CR_REFCKON_Disabled = 0x0
	// RTC_REFIN detection enabled
	RTC_CR_REFCKON_Enabled = 0x1
	// Position of TSEDGE field.
	RTC_CR_TSEDGE_Pos = 0x3
	// Bit mask of TSEDGE field.
	RTC_CR_TSEDGE_Msk = 0x8
	// Bit TSEDGE.
	RTC_CR_TSEDGE = 0x8
	// RTC_TS input rising edge generates a time-stamp event
	RTC_CR_TSEDGE_RisingEdge = 0x0
	// RTC_TS input falling edge generates a time-stamp event
	RTC_CR_TSEDGE_FallingEdge = 0x1
	// Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Pos = 0x0
	// Bit mask of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7
	// RTC/16 clock is selected
	RTC_CR_WUCKSEL_Div16 = 0x0
	// RTC/8 clock is selected
	RTC_CR_WUCKSEL_Div8 = 0x1
	// RTC/4 clock is selected
	RTC_CR_WUCKSEL_Div4 = 0x2
	// RTC/2 clock is selected
	RTC_CR_WUCKSEL_Div2 = 0x3
	// ck_spre (usually 1 Hz) clock is selected
	RTC_CR_WUCKSEL_ClockSpare = 0x4
	// ck_spre (usually 1 Hz) clock is selected and 2^16 is added to the WUT counter value
	RTC_CR_WUCKSEL_ClockSpareWithOffset = 0x6

	// ISR: initialization and status register
	// Position of ALRAWF field.
	RTC_ISR_ALRAWF_Pos = 0x0
	// Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF_Msk = 0x1
	// Bit ALRAWF.
	RTC_ISR_ALRAWF = 0x1
	// Alarm update not allowed
	RTC_ISR_ALRAWF_UpdateNotAllowed = 0x0
	// Alarm update allowed
	RTC_ISR_ALRAWF_UpdateAllowed = 0x1
	// Position of ALRBWF field.
	RTC_ISR_ALRBWF_Pos = 0x1
	// Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF_Msk = 0x2
	// Bit ALRBWF.
	RTC_ISR_ALRBWF = 0x2
	// Alarm update not allowed
	RTC_ISR_ALRBWF_UpdateNotAllowed = 0x0
	// Alarm update allowed
	RTC_ISR_ALRBWF_UpdateAllowed = 0x1
	// Position of WUTWF field.
	RTC_ISR_WUTWF_Pos = 0x2
	// Bit mask of WUTWF field.
	RTC_ISR_WUTWF_Msk = 0x4
	// Bit WUTWF.
	RTC_ISR_WUTWF = 0x4
	// Wakeup timer configuration update not allowed
	RTC_ISR_WUTWF_UpdateNotAllowed = 0x0
	// Wakeup timer configuration update allowed
	RTC_ISR_WUTWF_UpdateAllowed = 0x1
	// Position of SHPF field.
	RTC_ISR_SHPF_Pos = 0x3
	// Bit mask of SHPF field.
	RTC_ISR_SHPF_Msk = 0x8
	// Bit SHPF.
	RTC_ISR_SHPF = 0x8
	// No shift operation is pending
	RTC_ISR_SHPF_NoShiftPending = 0x0
	// A shift operation is pending
	RTC_ISR_SHPF_ShiftPending = 0x1
	// Position of INITS field.
	RTC_ISR_INITS_Pos = 0x4
	// Bit mask of INITS field.
	RTC_ISR_INITS_Msk = 0x10
	// Bit INITS.
	RTC_ISR_INITS = 0x10
	// Calendar has not been initialized
	RTC_ISR_INITS_NotInitalized = 0x0
	// Calendar has been initialized
	RTC_ISR_INITS_Initalized = 0x1
	// Position of RSF field.
	RTC_ISR_RSF_Pos = 0x5
	// Bit mask of RSF field.
	RTC_ISR_RSF_Msk = 0x20
	// Bit RSF.
	RTC_ISR_RSF = 0x20
	// Calendar shadow registers not yet synchronized
	RTC_ISR_RSF_NotSynced = 0x0
	// Calendar shadow registers synchronized
	RTC_ISR_RSF_Synced = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_RSF_Clear = 0x0
	// Position of INITF field.
	RTC_ISR_INITF_Pos = 0x6
	// Bit mask of INITF field.
	RTC_ISR_INITF_Msk = 0x40
	// Bit INITF.
	RTC_ISR_INITF = 0x40
	// Calendar registers update is not allowed
	RTC_ISR_INITF_NotAllowed = 0x0
	// Calendar registers update is allowed
	RTC_ISR_INITF_Allowed = 0x1
	// Position of INIT field.
	RTC_ISR_INIT_Pos = 0x7
	// Bit mask of INIT field.
	RTC_ISR_INIT_Msk = 0x80
	// Bit INIT.
	RTC_ISR_INIT = 0x80
	// Free running mode
	RTC_ISR_INIT_FreeRunningMode = 0x0
	// Initialization mode used to program time and date register (RTC_TR and RTC_DR), and prescaler register (RTC_PRER). Counters are stopped and start counting from the new value when INIT is reset.
	RTC_ISR_INIT_InitMode = 0x1
	// Position of ALRAF field.
	RTC_ISR_ALRAF_Pos = 0x8
	// Bit mask of ALRAF field.
	RTC_ISR_ALRAF_Msk = 0x100
	// Bit ALRAF.
	RTC_ISR_ALRAF = 0x100
	// This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm A register (RTC_ALRMAR)
	RTC_ISR_ALRAF_Match = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_ALRAF_Clear = 0x0
	// Position of ALRBF field.
	RTC_ISR_ALRBF_Pos = 0x9
	// Bit mask of ALRBF field.
	RTC_ISR_ALRBF_Msk = 0x200
	// Bit ALRBF.
	RTC_ISR_ALRBF = 0x200
	// This flag is set by hardware when the time/date registers (RTC_TR and RTC_DR) match the Alarm B register (RTC_ALRMBR)
	RTC_ISR_ALRBF_Match = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_ALRBF_Clear = 0x0
	// Position of WUTF field.
	RTC_ISR_WUTF_Pos = 0xa
	// Bit mask of WUTF field.
	RTC_ISR_WUTF_Msk = 0x400
	// Bit WUTF.
	RTC_ISR_WUTF = 0x400
	// This flag is set by hardware when the wakeup auto-reload counter reaches 0
	RTC_ISR_WUTF_Zero = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_WUTF_Clear = 0x0
	// Position of TSF field.
	RTC_ISR_TSF_Pos = 0xb
	// Bit mask of TSF field.
	RTC_ISR_TSF_Msk = 0x800
	// Bit TSF.
	RTC_ISR_TSF = 0x800
	// This flag is set by hardware when a time-stamp event occurs
	RTC_ISR_TSF_TimestampEvent = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_TSF_Clear = 0x0
	// Position of TSOVF field.
	RTC_ISR_TSOVF_Pos = 0xc
	// Bit mask of TSOVF field.
	RTC_ISR_TSOVF_Msk = 0x1000
	// Bit TSOVF.
	RTC_ISR_TSOVF = 0x1000
	// This flag is set by hardware when a time-stamp event occurs while TSF is already set
	RTC_ISR_TSOVF_Overflow = 0x1
	// This flag is cleared by software by writing 0
	RTC_ISR_TSOVF_Clear = 0x0
	// Position of TAMP1F field.
	RTC_ISR_TAMP1F_Pos = 0xd
	// Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F_Msk = 0x2000
	// Bit TAMP1F.
	RTC_ISR_TAMP1F = 0x2000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP1F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP1F_Clear = 0x0
	// Position of TAMP2F field.
	RTC_ISR_TAMP2F_Pos = 0xe
	// Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F_Msk = 0x4000
	// Bit TAMP2F.
	RTC_ISR_TAMP2F = 0x4000
	// This flag is set by hardware when a tamper detection event is detected on the RTC_TAMPx input
	RTC_ISR_TAMP2F_Tampered = 0x1
	// Flag cleared by software writing 0
	RTC_ISR_TAMP2F_Clear = 0x0
	// Position of RECALPF field.
	RTC_ISR_RECALPF_Pos = 0x10
	// Bit mask of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000
	// Bit RECALPF.
	RTC_ISR_RECALPF = 0x10000
	// The RECALPF status flag is automatically set to 1 when software writes to the RTC_CALR register, indicating that the RTC_CALR register is blocked. When the new calibration settings are taken into account, this bit returns to 0
	RTC_ISR_RECALPF_Pending = 0x1

	// PRER: prescaler register
	// Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Pos = 0x10
	// Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000
	// Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Pos = 0x0
	// Bit mask of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff

	// WUTR: wakeup timer register
	// Position of WUT field.
	RTC_WUTR_WUT_Pos = 0x0
	// Bit mask of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff

	// CALIBR: calibration register
	// Position of DCS field.
	RTC_CALIBR_DCS_Pos = 0x7
	// Bit mask of DCS field.
	RTC_CALIBR_DCS_Msk = 0x80
	// Bit DCS.
	RTC_CALIBR_DCS = 0x80
	// Position of DC field.
	RTC_CALIBR_DC_Pos = 0x0
	// Bit mask of DC field.
	RTC_CALIBR_DC_Msk = 0x1f

	// ALRMAR: alarm A register
	// Position of MSK4 field.
	RTC_ALRMAR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMAR_MSK4 = 0x80000000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK4_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK4_NotMask = 0x1
	// Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMAR_WDSEL = 0x40000000
	// DU[3:0] represents the date units
	RTC_ALRMAR_WDSEL_DateUnits = 0x0
	// DU[3:0] represents the week day. DT[1:0] is don’t care.
	RTC_ALRMAR_WDSEL_WeekDay = 0x1
	// Position of DT field.
	RTC_ALRMAR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMAR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMAR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMAR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMAR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMAR_MSK3 = 0x800000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK3_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK3_NotMask = 0x1
	// Position of PM field.
	RTC_ALRMAR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMAR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMAR_PM = 0x400000
	// AM or 24-hour format
	RTC_ALRMAR_PM_AM = 0x0
	// PM
	RTC_ALRMAR_PM_PM = 0x1
	// Position of HT field.
	RTC_ALRMAR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMAR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMAR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMAR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMAR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMAR_MSK2 = 0x8000
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK2_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK2_NotMask = 0x1
	// Position of MNT field.
	RTC_ALRMAR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMAR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMAR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMAR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMAR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMAR_MSK1 = 0x80
	// Alarm set if the date/day match
	RTC_ALRMAR_MSK1_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMAR_MSK1_NotMask = 0x1
	// Position of ST field.
	RTC_ALRMAR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMAR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMAR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMAR_SU_Msk = 0xf

	// ALRMBR: alarm B register
	// Position of MSK4 field.
	RTC_ALRMBR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMBR_MSK4 = 0x80000000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK4_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK4_NotMask = 0x1
	// Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMBR_WDSEL = 0x40000000
	// DU[3:0] represents the date units
	RTC_ALRMBR_WDSEL_DateUnits = 0x0
	// DU[3:0] represents the week day. DT[1:0] is don’t care.
	RTC_ALRMBR_WDSEL_WeekDay = 0x1
	// Position of DT field.
	RTC_ALRMBR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMBR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMBR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMBR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMBR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMBR_MSK3 = 0x800000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK3_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK3_NotMask = 0x1
	// Position of PM field.
	RTC_ALRMBR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMBR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMBR_PM = 0x400000
	// AM or 24-hour format
	RTC_ALRMBR_PM_AM = 0x0
	// PM
	RTC_ALRMBR_PM_PM = 0x1
	// Position of HT field.
	RTC_ALRMBR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMBR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMBR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMBR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMBR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMBR_MSK2 = 0x8000
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK2_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK2_NotMask = 0x1
	// Position of MNT field.
	RTC_ALRMBR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMBR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMBR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMBR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMBR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMBR_MSK1 = 0x80
	// Alarm set if the date/day match
	RTC_ALRMBR_MSK1_Mask = 0x0
	// Date/day don’t care in Alarm comparison
	RTC_ALRMBR_MSK1_NotMask = 0x1
	// Position of ST field.
	RTC_ALRMBR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMBR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMBR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMBR_SU_Msk = 0xf

	// WPR: write protection register
	// Position of KEY field.
	RTC_WPR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	RTC_WPR_KEY_Msk = 0xff

	// SSR: sub second register
	// Position of SS field.
	RTC_SSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_SSR_SS_Msk = 0xffff

	// SHIFTR: shift control register
	// Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Pos = 0x1f
	// Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000
	// Bit ADD1S.
	RTC_SHIFTR_ADD1S = 0x80000000
	// Add one second to the clock/calendar
	RTC_SHIFTR_ADD1S_Add1 = 0x1
	// Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Pos = 0x0
	// Bit mask of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff

	// TSTR: time stamp time register
	// Position of PM field.
	RTC_TSTR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TSTR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TSTR_PM = 0x400000
	// Position of HT field.
	RTC_TSTR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TSTR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TSTR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TSTR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TSTR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TSTR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TSTR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TSTR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TSTR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TSTR_SU_Msk = 0xf

	// TSDR: time stamp date register
	// Position of WDU field.
	RTC_TSDR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_TSDR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_TSDR_MT_Msk = 0x1000
	// Bit MT.
	RTC_TSDR_MT = 0x1000
	// Position of MU field.
	RTC_TSDR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_TSDR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_TSDR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_TSDR_DT_Msk = 0x30
	// Position of DU field.
	RTC_TSDR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_TSDR_DU_Msk = 0xf

	// TSSSR: timestamp sub second register
	// Position of SS field.
	RTC_TSSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_TSSSR_SS_Msk = 0xffff

	// CALR: calibration register
	// Position of CALP field.
	RTC_CALR_CALP_Pos = 0xf
	// Bit mask of CALP field.
	RTC_CALR_CALP_Msk = 0x8000
	// Bit CALP.
	RTC_CALR_CALP = 0x8000
	// No RTCCLK pulses are added
	RTC_CALR_CALP_NoChange = 0x0
	// One RTCCLK pulse is effectively inserted every 2^11 pulses (frequency increased by 488.5 ppm)
	RTC_CALR_CALP_IncreaseFreq = 0x1
	// Position of CALW8 field.
	RTC_CALR_CALW8_Pos = 0xe
	// Bit mask of CALW8 field.
	RTC_CALR_CALW8_Msk = 0x4000
	// Bit CALW8.
	RTC_CALR_CALW8 = 0x4000
	// When CALW8 is set to ‘1’, the 8-second calibration cycle period is selected
	RTC_CALR_CALW8_Eight_Second = 0x1
	// Position of CALW16 field.
	RTC_CALR_CALW16_Pos = 0xd
	// Bit mask of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000
	// Bit CALW16.
	RTC_CALR_CALW16 = 0x2000
	// When CALW16 is set to ‘1’, the 16-second calibration cycle period is selected.This bit must not be set to ‘1’ if CALW8=1
	RTC_CALR_CALW16_Sixteen_Second = 0x1
	// Position of CALM field.
	RTC_CALR_CALM_Pos = 0x0
	// Bit mask of CALM field.
	RTC_CALR_CALM_Msk = 0x1ff

	// TAFCR: tamper and alternate function configuration register
	// Position of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Pos = 0x12
	// Bit mask of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Msk = 0x40000
	// Bit ALARMOUTTYPE.
	RTC_TAFCR_ALARMOUTTYPE = 0x40000
	// Position of TSINSEL field.
	RTC_TAFCR_TSINSEL_Pos = 0x11
	// Bit mask of TSINSEL field.
	RTC_TAFCR_TSINSEL_Msk = 0x20000
	// Bit TSINSEL.
	RTC_TAFCR_TSINSEL = 0x20000
	// Position of TAMP1INSEL field.
	RTC_TAFCR_TAMP1INSEL_Pos = 0x10
	// Bit mask of TAMP1INSEL field.
	RTC_TAFCR_TAMP1INSEL_Msk = 0x10000
	// Bit TAMP1INSEL.
	RTC_TAFCR_TAMP1INSEL = 0x10000
	// Position of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Pos = 0xf
	// Bit mask of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Msk = 0x8000
	// Bit TAMPPUDIS.
	RTC_TAFCR_TAMPPUDIS = 0x8000
	// Position of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Pos = 0xd
	// Bit mask of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Msk = 0x6000
	// Position of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Pos = 0xb
	// Bit mask of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Msk = 0x1800
	// Position of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Pos = 0x8
	// Bit mask of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Msk = 0x700
	// Position of TAMPTS field.
	RTC_TAFCR_TAMPTS_Pos = 0x7
	// Bit mask of TAMPTS field.
	RTC_TAFCR_TAMPTS_Msk = 0x80
	// Bit TAMPTS.
	RTC_TAFCR_TAMPTS = 0x80
	// Position of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Pos = 0x4
	// Bit mask of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Msk = 0x10
	// Bit TAMP2TRG.
	RTC_TAFCR_TAMP2TRG = 0x10
	// Position of TAMP2E field.
	RTC_TAFCR_TAMP2E_Pos = 0x3
	// Bit mask of TAMP2E field.
	RTC_TAFCR_TAMP2E_Msk = 0x8
	// Bit TAMP2E.
	RTC_TAFCR_TAMP2E = 0x8
	// Position of TAMPIE field.
	RTC_TAFCR_TAMPIE_Pos = 0x2
	// Bit mask of TAMPIE field.
	RTC_TAFCR_TAMPIE_Msk = 0x4
	// Bit TAMPIE.
	RTC_TAFCR_TAMPIE = 0x4
	// Position of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Pos = 0x1
	// Bit mask of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Msk = 0x2
	// Bit TAMP1TRG.
	RTC_TAFCR_TAMP1TRG = 0x2
	// Position of TAMP1E field.
	RTC_TAFCR_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	RTC_TAFCR_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	RTC_TAFCR_TAMP1E = 0x1

	// ALRMASSR: alarm A sub second register
	// Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMASSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMASSR_SS_Msk = 0x7fff

	// ALRMBSSR: alarm B sub second register
	// Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMBSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMBSSR_SS_Msk = 0x7fff

	// BKP0R: backup register
	// Position of BKP field.
	RTC_BKPR_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKPR_BKP_Msk = 0xffffffff
)

// Constants for SDIO: Secure digital input/output interface
const (
	// POWER: power control register
	// Position of PWRCTRL field.
	SDIO_POWER_PWRCTRL_Pos = 0x0
	// Bit mask of PWRCTRL field.
	SDIO_POWER_PWRCTRL_Msk = 0x3
	// Power off
	SDIO_POWER_PWRCTRL_PowerOff = 0x0
	// Power on
	SDIO_POWER_PWRCTRL_PowerOn = 0x3

	// CLKCR: SDI clock control register
	// Position of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN_Pos = 0xe
	// Bit mask of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN_Msk = 0x4000
	// Bit HWFC_EN.
	SDIO_CLKCR_HWFC_EN = 0x4000
	// HW Flow Control is disabled
	SDIO_CLKCR_HWFC_EN_Disabled = 0x0
	// HW Flow Control is enabled
	SDIO_CLKCR_HWFC_EN_Enabled = 0x1
	// Position of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE_Pos = 0xd
	// Bit mask of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE_Msk = 0x2000
	// Bit NEGEDGE.
	SDIO_CLKCR_NEGEDGE = 0x2000
	// SDIO_CK generated on the rising edge
	SDIO_CLKCR_NEGEDGE_Rising = 0x0
	// SDIO_CK generated on the falling edge
	SDIO_CLKCR_NEGEDGE_Falling = 0x1
	// Position of WIDBUS field.
	SDIO_CLKCR_WIDBUS_Pos = 0xb
	// Bit mask of WIDBUS field.
	SDIO_CLKCR_WIDBUS_Msk = 0x1800
	// 1 lane wide bus
	SDIO_CLKCR_WIDBUS_BusWidth1 = 0x0
	// 4 lane wide bus
	SDIO_CLKCR_WIDBUS_BusWidth4 = 0x1
	// 8 lane wide bus
	SDIO_CLKCR_WIDBUS_BusWidth8 = 0x2
	// Position of BYPASS field.
	SDIO_CLKCR_BYPASS_Pos = 0xa
	// Bit mask of BYPASS field.
	SDIO_CLKCR_BYPASS_Msk = 0x400
	// Bit BYPASS.
	SDIO_CLKCR_BYPASS = 0x400
	// SDIOCLK is divided according to the CLKDIV value before driving the SDIO_CK output signal.
	SDIO_CLKCR_BYPASS_Disabled = 0x0
	// SDIOCLK directly drives the SDIO_CK output signal
	SDIO_CLKCR_BYPASS_Enabled = 0x1
	// Position of PWRSAV field.
	SDIO_CLKCR_PWRSAV_Pos = 0x9
	// Bit mask of PWRSAV field.
	SDIO_CLKCR_PWRSAV_Msk = 0x200
	// Bit PWRSAV.
	SDIO_CLKCR_PWRSAV = 0x200
	// SDIO_CK is only enabled when the bus is active
	SDIO_CLKCR_PWRSAV_Disabled = 0x1
	// SDIO_CK clock is always enabled
	SDIO_CLKCR_PWRSAV_Enabled = 0x0
	// Position of CLKEN field.
	SDIO_CLKCR_CLKEN_Pos = 0x8
	// Bit mask of CLKEN field.
	SDIO_CLKCR_CLKEN_Msk = 0x100
	// Bit CLKEN.
	SDIO_CLKCR_CLKEN = 0x100
	// Disable clock
	SDIO_CLKCR_CLKEN_Disabled = 0x0
	// Enable clock
	SDIO_CLKCR_CLKEN_Enabled = 0x1
	// Position of CLKDIV field.
	SDIO_CLKCR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	SDIO_CLKCR_CLKDIV_Msk = 0xff

	// ARG: argument register
	// Position of CMDARG field.
	SDIO_ARG_CMDARG_Pos = 0x0
	// Bit mask of CMDARG field.
	SDIO_ARG_CMDARG_Msk = 0xffffffff

	// CMD: command register
	// Position of CE_ATACMD field.
	SDIO_CMD_CE_ATACMD_Pos = 0xe
	// Bit mask of CE_ATACMD field.
	SDIO_CMD_CE_ATACMD_Msk = 0x4000
	// Bit CE_ATACMD.
	SDIO_CMD_CE_ATACMD = 0x4000
	// CE-ATA command disabled
	SDIO_CMD_CE_ATACMD_Disabled = 0x0
	// CE-ATA command enabled
	SDIO_CMD_CE_ATACMD_Enabled = 0x1
	// Position of NIEN field.
	SDIO_CMD_NIEN_Pos = 0xd
	// Bit mask of NIEN field.
	SDIO_CMD_NIEN_Msk = 0x2000
	// Bit NIEN.
	SDIO_CMD_NIEN = 0x2000
	// Interrupts to the CE-ATA not disabled
	SDIO_CMD_NIEN_Disabled = 0x0
	// Interrupt to the CE-ATA are disabled
	SDIO_CMD_NIEN_Enabled = 0x1
	// Position of ENCMDcompl field.
	SDIO_CMD_ENCMDcompl_Pos = 0xc
	// Bit mask of ENCMDcompl field.
	SDIO_CMD_ENCMDcompl_Msk = 0x1000
	// Bit ENCMDcompl.
	SDIO_CMD_ENCMDcompl = 0x1000
	// Command complete signal disabled
	SDIO_CMD_ENCMDcompl_Disabled = 0x0
	// Command complete signal enabled
	SDIO_CMD_ENCMDcompl_Enabled = 0x1
	// Position of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend_Pos = 0xb
	// Bit mask of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend_Msk = 0x800
	// Bit SDIOSuspend.
	SDIO_CMD_SDIOSuspend = 0x800
	// Next command is not a SDIO suspend command
	SDIO_CMD_SDIOSuspend_Disabled = 0x0
	// Next command send is a SDIO suspend command
	SDIO_CMD_SDIOSuspend_Enabled = 0x1
	// Position of CPSMEN field.
	SDIO_CMD_CPSMEN_Pos = 0xa
	// Bit mask of CPSMEN field.
	SDIO_CMD_CPSMEN_Msk = 0x400
	// Bit CPSMEN.
	SDIO_CMD_CPSMEN = 0x400
	// Command path state machine disabled
	SDIO_CMD_CPSMEN_Disabled = 0x0
	// Command path state machine enabled
	SDIO_CMD_CPSMEN_Enabled = 0x1
	// Position of WAITPEND field.
	SDIO_CMD_WAITPEND_Pos = 0x9
	// Bit mask of WAITPEND field.
	SDIO_CMD_WAITPEND_Msk = 0x200
	// Bit WAITPEND.
	SDIO_CMD_WAITPEND = 0x200
	// Don't wait for data end
	SDIO_CMD_WAITPEND_Disabled = 0x0
	// Wait for end of data transfer signal before sending command
	SDIO_CMD_WAITPEND_Enabled = 0x1
	// Position of WAITINT field.
	SDIO_CMD_WAITINT_Pos = 0x8
	// Bit mask of WAITINT field.
	SDIO_CMD_WAITINT_Msk = 0x100
	// Bit WAITINT.
	SDIO_CMD_WAITINT = 0x100
	// Don't wait for interrupt request
	SDIO_CMD_WAITINT_Disabled = 0x0
	// Wait for interrupt request
	SDIO_CMD_WAITINT_Enabled = 0x1
	// Position of WAITRESP field.
	SDIO_CMD_WAITRESP_Pos = 0x6
	// Bit mask of WAITRESP field.
	SDIO_CMD_WAITRESP_Msk = 0xc0
	// No response
	SDIO_CMD_WAITRESP_NoResponse = 0x0
	// Short response
	SDIO_CMD_WAITRESP_ShortResponse = 0x1
	// No reponse
	SDIO_CMD_WAITRESP_NoResponse2 = 0x2
	// Long reponse
	SDIO_CMD_WAITRESP_LongResponse = 0x3
	// Position of CMDINDEX field.
	SDIO_CMD_CMDINDEX_Pos = 0x0
	// Bit mask of CMDINDEX field.
	SDIO_CMD_CMDINDEX_Msk = 0x3f

	// RESPCMD: command response register
	// Position of RESPCMD field.
	SDIO_RESPCMD_RESPCMD_Pos = 0x0
	// Bit mask of RESPCMD field.
	SDIO_RESPCMD_RESPCMD_Msk = 0x3f

	// RESP1: response 1..4 register
	// Position of CARDSTATUS1 field.
	SDIO_RESP1_CARDSTATUS1_Pos = 0x0
	// Bit mask of CARDSTATUS1 field.
	SDIO_RESP1_CARDSTATUS1_Msk = 0xffffffff

	// RESP2: response 1..4 register
	// Position of CARDSTATUS2 field.
	SDIO_RESP2_CARDSTATUS2_Pos = 0x0
	// Bit mask of CARDSTATUS2 field.
	SDIO_RESP2_CARDSTATUS2_Msk = 0xffffffff

	// RESP3: response 1..4 register
	// Position of CARDSTATUS3 field.
	SDIO_RESP3_CARDSTATUS3_Pos = 0x0
	// Bit mask of CARDSTATUS3 field.
	SDIO_RESP3_CARDSTATUS3_Msk = 0xffffffff

	// RESP4: response 1..4 register
	// Position of CARDSTATUS4 field.
	SDIO_RESP4_CARDSTATUS4_Pos = 0x0
	// Bit mask of CARDSTATUS4 field.
	SDIO_RESP4_CARDSTATUS4_Msk = 0xffffffff

	// DTIMER: data timer register
	// Position of DATATIME field.
	SDIO_DTIMER_DATATIME_Pos = 0x0
	// Bit mask of DATATIME field.
	SDIO_DTIMER_DATATIME_Msk = 0xffffffff

	// DLEN: data length register
	// Position of DATALENGTH field.
	SDIO_DLEN_DATALENGTH_Pos = 0x0
	// Bit mask of DATALENGTH field.
	SDIO_DLEN_DATALENGTH_Msk = 0x1ffffff

	// DCTRL: data control register
	// Position of SDIOEN field.
	SDIO_DCTRL_SDIOEN_Pos = 0xb
	// Bit mask of SDIOEN field.
	SDIO_DCTRL_SDIOEN_Msk = 0x800
	// Bit SDIOEN.
	SDIO_DCTRL_SDIOEN = 0x800
	// SDIO operations disabled
	SDIO_DCTRL_SDIOEN_Disabled = 0x0
	// SDIO operations enabled
	SDIO_DCTRL_SDIOEN_Enabled = 0x1
	// Position of RWMOD field.
	SDIO_DCTRL_RWMOD_Pos = 0xa
	// Bit mask of RWMOD field.
	SDIO_DCTRL_RWMOD_Msk = 0x400
	// Bit RWMOD.
	SDIO_DCTRL_RWMOD = 0x400
	// Read wait control stopping using SDIO_D2
	SDIO_DCTRL_RWMOD_D2 = 0x0
	// Read wait control using SDIO_CK
	SDIO_DCTRL_RWMOD_Ck = 0x1
	// Position of RWSTOP field.
	SDIO_DCTRL_RWSTOP_Pos = 0x9
	// Bit mask of RWSTOP field.
	SDIO_DCTRL_RWSTOP_Msk = 0x200
	// Bit RWSTOP.
	SDIO_DCTRL_RWSTOP = 0x200
	// Read wait in progress if RWSTART is enabled
	SDIO_DCTRL_RWSTOP_Disabled = 0x0
	// Enable for read wait stop if RWSTART is enabled
	SDIO_DCTRL_RWSTOP_Enabled = 0x1
	// Position of RWSTART field.
	SDIO_DCTRL_RWSTART_Pos = 0x8
	// Bit mask of RWSTART field.
	SDIO_DCTRL_RWSTART_Msk = 0x100
	// Bit RWSTART.
	SDIO_DCTRL_RWSTART = 0x100
	// Don't start read wait operation
	SDIO_DCTRL_RWSTART_Disabled = 0x0
	// Read wait operation starts
	SDIO_DCTRL_RWSTART_Enabled = 0x1
	// Position of DBLOCKSIZE field.
	SDIO_DCTRL_DBLOCKSIZE_Pos = 0x4
	// Bit mask of DBLOCKSIZE field.
	SDIO_DCTRL_DBLOCKSIZE_Msk = 0xf0
	// Position of DMAEN field.
	SDIO_DCTRL_DMAEN_Pos = 0x3
	// Bit mask of DMAEN field.
	SDIO_DCTRL_DMAEN_Msk = 0x8
	// Bit DMAEN.
	SDIO_DCTRL_DMAEN = 0x8
	// Dma disabled
	SDIO_DCTRL_DMAEN_Disabled = 0x0
	// Dma enabled
	SDIO_DCTRL_DMAEN_Enabled = 0x1
	// Position of DTMODE field.
	SDIO_DCTRL_DTMODE_Pos = 0x2
	// Bit mask of DTMODE field.
	SDIO_DCTRL_DTMODE_Msk = 0x4
	// Bit DTMODE.
	SDIO_DCTRL_DTMODE = 0x4
	// Bloack data transfer
	SDIO_DCTRL_DTMODE_BlockMode = 0x0
	// Stream or SDIO multibyte data transfer
	SDIO_DCTRL_DTMODE_StreamMode = 0x1
	// Position of DTDIR field.
	SDIO_DCTRL_DTDIR_Pos = 0x1
	// Bit mask of DTDIR field.
	SDIO_DCTRL_DTDIR_Msk = 0x2
	// Bit DTDIR.
	SDIO_DCTRL_DTDIR = 0x2
	// From controller to card
	SDIO_DCTRL_DTDIR_ControllerToCard = 0x0
	// From card to controller
	SDIO_DCTRL_DTDIR_CardToController = 0x1
	// Position of DTEN field.
	SDIO_DCTRL_DTEN_Pos = 0x0
	// Bit mask of DTEN field.
	SDIO_DCTRL_DTEN_Msk = 0x1
	// Bit DTEN.
	SDIO_DCTRL_DTEN = 0x1
	// Disabled
	SDIO_DCTRL_DTEN_Disabled = 0x0
	// Start transfer
	SDIO_DCTRL_DTEN_Enabled = 0x1

	// DCOUNT: data counter register
	// Position of DATACOUNT field.
	SDIO_DCOUNT_DATACOUNT_Pos = 0x0
	// Bit mask of DATACOUNT field.
	SDIO_DCOUNT_DATACOUNT_Msk = 0x1ffffff

	// STA: status register
	// Position of CEATAEND field.
	SDIO_STA_CEATAEND_Pos = 0x17
	// Bit mask of CEATAEND field.
	SDIO_STA_CEATAEND_Msk = 0x800000
	// Bit CEATAEND.
	SDIO_STA_CEATAEND = 0x800000
	// Completion signal not received
	SDIO_STA_CEATAEND_NotReceived = 0x0
	// CE-ATA command completion signal received for CMD61
	SDIO_STA_CEATAEND_Received = 0x1
	// Position of SDIOIT field.
	SDIO_STA_SDIOIT_Pos = 0x16
	// Bit mask of SDIOIT field.
	SDIO_STA_SDIOIT_Msk = 0x400000
	// Bit SDIOIT.
	SDIO_STA_SDIOIT = 0x400000
	// SDIO interrupt not receieved
	SDIO_STA_SDIOIT_NotReceived = 0x0
	// SDIO interrupt received
	SDIO_STA_SDIOIT_Received = 0x1
	// Position of RXDAVL field.
	SDIO_STA_RXDAVL_Pos = 0x15
	// Bit mask of RXDAVL field.
	SDIO_STA_RXDAVL_Msk = 0x200000
	// Bit RXDAVL.
	SDIO_STA_RXDAVL = 0x200000
	// Data not available in receive FIFO
	SDIO_STA_RXDAVL_NotAvailable = 0x0
	// Data available in receive FIFO
	SDIO_STA_RXDAVL_Available = 0x1
	// Position of TXDAVL field.
	SDIO_STA_TXDAVL_Pos = 0x14
	// Bit mask of TXDAVL field.
	SDIO_STA_TXDAVL_Msk = 0x100000
	// Bit TXDAVL.
	SDIO_STA_TXDAVL = 0x100000
	// Data not available in transmit FIFO
	SDIO_STA_TXDAVL_NotAvailable = 0x0
	// Data available in transmit FIFO
	SDIO_STA_TXDAVL_Available = 0x1
	// Position of RXFIFOE field.
	SDIO_STA_RXFIFOE_Pos = 0x13
	// Bit mask of RXFIFOE field.
	SDIO_STA_RXFIFOE_Msk = 0x80000
	// Bit RXFIFOE.
	SDIO_STA_RXFIFOE = 0x80000
	// Receive FIFO not empty
	SDIO_STA_RXFIFOE_NotEmpty = 0x0
	// Receive FIFO empty
	SDIO_STA_RXFIFOE_Empty = 0x1
	// Position of TXFIFOE field.
	SDIO_STA_TXFIFOE_Pos = 0x12
	// Bit mask of TXFIFOE field.
	SDIO_STA_TXFIFOE_Msk = 0x40000
	// Bit TXFIFOE.
	SDIO_STA_TXFIFOE = 0x40000
	// Transmit FIFO not empty
	SDIO_STA_TXFIFOE_NotEmpty = 0x0
	// Transmit FIFO empty. When HW Flow Control is enabled, TXFIFOE signals becomes activated when the FIFO contains 2 words.
	SDIO_STA_TXFIFOE_Empty = 0x1
	// Position of RXFIFOF field.
	SDIO_STA_RXFIFOF_Pos = 0x11
	// Bit mask of RXFIFOF field.
	SDIO_STA_RXFIFOF_Msk = 0x20000
	// Bit RXFIFOF.
	SDIO_STA_RXFIFOF = 0x20000
	// Transmit FIFO not full
	SDIO_STA_RXFIFOF_NotFull = 0x0
	// Receive FIFO full. When HW Flow Control is enabled, RXFIFOF signals becomes activated 2 words before the FIFO is full.
	SDIO_STA_RXFIFOF_Full = 0x1
	// Position of TXFIFOF field.
	SDIO_STA_TXFIFOF_Pos = 0x10
	// Bit mask of TXFIFOF field.
	SDIO_STA_TXFIFOF_Msk = 0x10000
	// Bit TXFIFOF.
	SDIO_STA_TXFIFOF = 0x10000
	// Transmit FIFO not full
	SDIO_STA_TXFIFOF_NotFull = 0x0
	// Transmit FIFO full
	SDIO_STA_TXFIFOF_Full = 0x1
	// Position of RXFIFOHF field.
	SDIO_STA_RXFIFOHF_Pos = 0xf
	// Bit mask of RXFIFOHF field.
	SDIO_STA_RXFIFOHF_Msk = 0x8000
	// Bit RXFIFOHF.
	SDIO_STA_RXFIFOHF = 0x8000
	// Receive FIFO not half full
	SDIO_STA_RXFIFOHF_NotHalfFull = 0x0
	// Receive FIFO half full. At least 8 words in the FIFO
	SDIO_STA_RXFIFOHF_HalfFull = 0x1
	// Position of TXFIFOHE field.
	SDIO_STA_TXFIFOHE_Pos = 0xe
	// Bit mask of TXFIFOHE field.
	SDIO_STA_TXFIFOHE_Msk = 0x4000
	// Bit TXFIFOHE.
	SDIO_STA_TXFIFOHE = 0x4000
	// Transmit FIFO not half empty
	SDIO_STA_TXFIFOHE_NotHalfEmpty = 0x0
	// Transmit FIFO half empty. At least 8 words can be written into the FIFO
	SDIO_STA_TXFIFOHE_HalfEmpty = 0x1
	// Position of RXACT field.
	SDIO_STA_RXACT_Pos = 0xd
	// Bit mask of RXACT field.
	SDIO_STA_RXACT_Msk = 0x2000
	// Bit RXACT.
	SDIO_STA_RXACT = 0x2000
	// Data receive not in progress
	SDIO_STA_RXACT_NotInProgress = 0x0
	// Data receive in progress
	SDIO_STA_RXACT_InProgress = 0x1
	// Position of TXACT field.
	SDIO_STA_TXACT_Pos = 0xc
	// Bit mask of TXACT field.
	SDIO_STA_TXACT_Msk = 0x1000
	// Bit TXACT.
	SDIO_STA_TXACT = 0x1000
	// Data transmit is not in progress
	SDIO_STA_TXACT_NotInProgress = 0x0
	// Data transmit in progress
	SDIO_STA_TXACT_InProgress = 0x1
	// Position of CMDACT field.
	SDIO_STA_CMDACT_Pos = 0xb
	// Bit mask of CMDACT field.
	SDIO_STA_CMDACT_Msk = 0x800
	// Bit CMDACT.
	SDIO_STA_CMDACT = 0x800
	// Command transfer not in progress
	SDIO_STA_CMDACT_NotInProgress = 0x0
	// Command tranfer in progress
	SDIO_STA_CMDACT_InProgress = 0x1
	// Position of DBCKEND field.
	SDIO_STA_DBCKEND_Pos = 0xa
	// Bit mask of DBCKEND field.
	SDIO_STA_DBCKEND_Msk = 0x400
	// Bit DBCKEND.
	SDIO_STA_DBCKEND = 0x400
	// Data block not sent/received (CRC check failed)
	SDIO_STA_DBCKEND_NotTransferred = 0x0
	// Data block sent/received (CRC check passed)
	SDIO_STA_DBCKEND_Transferred = 0x1
	// Position of STBITERR field.
	SDIO_STA_STBITERR_Pos = 0x9
	// Bit mask of STBITERR field.
	SDIO_STA_STBITERR_Msk = 0x200
	// Bit STBITERR.
	SDIO_STA_STBITERR = 0x200
	// No start bit detected error
	SDIO_STA_STBITERR_Detected = 0x0
	// Start bit not detected error
	SDIO_STA_STBITERR_NotDetected = 0x1
	// Position of DATAEND field.
	SDIO_STA_DATAEND_Pos = 0x8
	// Bit mask of DATAEND field.
	SDIO_STA_DATAEND_Msk = 0x100
	// Bit DATAEND.
	SDIO_STA_DATAEND = 0x100
	// Data end (DCOUNT, is zero)
	SDIO_STA_DATAEND_Done = 0x1
	// Not done
	SDIO_STA_DATAEND_NotDone = 0x0
	// Position of CMDSENT field.
	SDIO_STA_CMDSENT_Pos = 0x7
	// Bit mask of CMDSENT field.
	SDIO_STA_CMDSENT_Msk = 0x80
	// Bit CMDSENT.
	SDIO_STA_CMDSENT = 0x80
	// Command not sent
	SDIO_STA_CMDSENT_NotSent = 0x0
	// Command sent (no response required)
	SDIO_STA_CMDSENT_Sent = 0x1
	// Position of CMDREND field.
	SDIO_STA_CMDREND_Pos = 0x6
	// Bit mask of CMDREND field.
	SDIO_STA_CMDREND_Msk = 0x40
	// Bit CMDREND.
	SDIO_STA_CMDREND = 0x40
	// Command not done
	SDIO_STA_CMDREND_NotDone = 0x0
	// Command response received (CRC check passed)
	SDIO_STA_CMDREND_Done = 0x1
	// Position of RXOVERR field.
	SDIO_STA_RXOVERR_Pos = 0x5
	// Bit mask of RXOVERR field.
	SDIO_STA_RXOVERR_Msk = 0x20
	// Bit RXOVERR.
	SDIO_STA_RXOVERR = 0x20
	// No FIFO overrun error
	SDIO_STA_RXOVERR_NoOverrun = 0x0
	// Receive FIFO overrun error
	SDIO_STA_RXOVERR_Overrun = 0x1
	// Position of TXUNDERR field.
	SDIO_STA_TXUNDERR_Pos = 0x4
	// Bit mask of TXUNDERR field.
	SDIO_STA_TXUNDERR_Msk = 0x10
	// Bit TXUNDERR.
	SDIO_STA_TXUNDERR = 0x10
	// No transmit FIFO underrun error
	SDIO_STA_TXUNDERR_NoUnderrun = 0x0
	// Transmit FIFO underrun error
	SDIO_STA_TXUNDERR_Underrun = 0x1
	// Position of DTIMEOUT field.
	SDIO_STA_DTIMEOUT_Pos = 0x3
	// Bit mask of DTIMEOUT field.
	SDIO_STA_DTIMEOUT_Msk = 0x8
	// Bit DTIMEOUT.
	SDIO_STA_DTIMEOUT = 0x8
	// No data timeout
	SDIO_STA_DTIMEOUT_NoTimeout = 0x0
	// Data timeout
	SDIO_STA_DTIMEOUT_Timeout = 0x1
	// Position of CTIMEOUT field.
	SDIO_STA_CTIMEOUT_Pos = 0x2
	// Bit mask of CTIMEOUT field.
	SDIO_STA_CTIMEOUT_Msk = 0x4
	// Bit CTIMEOUT.
	SDIO_STA_CTIMEOUT = 0x4
	// No Command timeout
	SDIO_STA_CTIMEOUT_NoTimeout = 0x0
	// Command timeout
	SDIO_STA_CTIMEOUT_Timeout = 0x1
	// Position of DCRCFAIL field.
	SDIO_STA_DCRCFAIL_Pos = 0x1
	// Bit mask of DCRCFAIL field.
	SDIO_STA_DCRCFAIL_Msk = 0x2
	// Bit DCRCFAIL.
	SDIO_STA_DCRCFAIL = 0x2
	// No Data block sent/received crc check fail
	SDIO_STA_DCRCFAIL_NotFailed = 0x0
	// Data block sent/received crc failed
	SDIO_STA_DCRCFAIL_Failed = 0x1
	// Position of CCRCFAIL field.
	SDIO_STA_CCRCFAIL_Pos = 0x0
	// Bit mask of CCRCFAIL field.
	SDIO_STA_CCRCFAIL_Msk = 0x1
	// Bit CCRCFAIL.
	SDIO_STA_CCRCFAIL = 0x1
	// Command response received, crc check passed
	SDIO_STA_CCRCFAIL_NotFailed = 0x0
	// Command response received, crc check failed
	SDIO_STA_CCRCFAIL_Failed = 0x1

	// ICR: interrupt clear register
	// Position of CEATAENDC field.
	SDIO_ICR_CEATAENDC_Pos = 0x17
	// Bit mask of CEATAENDC field.
	SDIO_ICR_CEATAENDC_Msk = 0x800000
	// Bit CEATAENDC.
	SDIO_ICR_CEATAENDC = 0x800000
	// Clear flag
	SDIO_ICR_CEATAENDC_Clear = 0x1
	// Position of SDIOITC field.
	SDIO_ICR_SDIOITC_Pos = 0x16
	// Bit mask of SDIOITC field.
	SDIO_ICR_SDIOITC_Msk = 0x400000
	// Bit SDIOITC.
	SDIO_ICR_SDIOITC = 0x400000
	// Clear flag
	SDIO_ICR_SDIOITC_Clear = 0x1
	// Position of DBCKENDC field.
	SDIO_ICR_DBCKENDC_Pos = 0xa
	// Bit mask of DBCKENDC field.
	SDIO_ICR_DBCKENDC_Msk = 0x400
	// Bit DBCKENDC.
	SDIO_ICR_DBCKENDC = 0x400
	// Clear flag
	SDIO_ICR_DBCKENDC_Clear = 0x1
	// Position of STBITERRC field.
	SDIO_ICR_STBITERRC_Pos = 0x9
	// Bit mask of STBITERRC field.
	SDIO_ICR_STBITERRC_Msk = 0x200
	// Bit STBITERRC.
	SDIO_ICR_STBITERRC = 0x200
	// Clear flag
	SDIO_ICR_STBITERRC_Clear = 0x1
	// Position of DATAENDC field.
	SDIO_ICR_DATAENDC_Pos = 0x8
	// Bit mask of DATAENDC field.
	SDIO_ICR_DATAENDC_Msk = 0x100
	// Bit DATAENDC.
	SDIO_ICR_DATAENDC = 0x100
	// Clear flag
	SDIO_ICR_DATAENDC_Clear = 0x1
	// Position of CMDSENTC field.
	SDIO_ICR_CMDSENTC_Pos = 0x7
	// Bit mask of CMDSENTC field.
	SDIO_ICR_CMDSENTC_Msk = 0x80
	// Bit CMDSENTC.
	SDIO_ICR_CMDSENTC = 0x80
	// Clear flag
	SDIO_ICR_CMDSENTC_Clear = 0x1
	// Position of CMDRENDC field.
	SDIO_ICR_CMDRENDC_Pos = 0x6
	// Bit mask of CMDRENDC field.
	SDIO_ICR_CMDRENDC_Msk = 0x40
	// Bit CMDRENDC.
	SDIO_ICR_CMDRENDC = 0x40
	// Clear flag
	SDIO_ICR_CMDRENDC_Clear = 0x1
	// Position of RXOVERRC field.
	SDIO_ICR_RXOVERRC_Pos = 0x5
	// Bit mask of RXOVERRC field.
	SDIO_ICR_RXOVERRC_Msk = 0x20
	// Bit RXOVERRC.
	SDIO_ICR_RXOVERRC = 0x20
	// Clear flag
	SDIO_ICR_RXOVERRC_Clear = 0x1
	// Position of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC_Pos = 0x4
	// Bit mask of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC_Msk = 0x10
	// Bit TXUNDERRC.
	SDIO_ICR_TXUNDERRC = 0x10
	// Clear flag
	SDIO_ICR_TXUNDERRC_Clear = 0x1
	// Position of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC_Pos = 0x3
	// Bit mask of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC_Msk = 0x8
	// Bit DTIMEOUTC.
	SDIO_ICR_DTIMEOUTC = 0x8
	// Clear flag
	SDIO_ICR_DTIMEOUTC_Clear = 0x1
	// Position of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC_Pos = 0x2
	// Bit mask of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC_Msk = 0x4
	// Bit CTIMEOUTC.
	SDIO_ICR_CTIMEOUTC = 0x4
	// Clear flag
	SDIO_ICR_CTIMEOUTC_Clear = 0x1
	// Position of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC_Pos = 0x1
	// Bit mask of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC_Msk = 0x2
	// Bit DCRCFAILC.
	SDIO_ICR_DCRCFAILC = 0x2
	// Clear flag
	SDIO_ICR_DCRCFAILC_Clear = 0x1
	// Position of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC_Pos = 0x0
	// Bit mask of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC_Msk = 0x1
	// Bit CCRCFAILC.
	SDIO_ICR_CCRCFAILC = 0x1
	// Clear flag
	SDIO_ICR_CCRCFAILC_Clear = 0x1

	// MASK: mask register
	// Position of CEATAENDIE field.
	SDIO_MASK_CEATAENDIE_Pos = 0x17
	// Bit mask of CEATAENDIE field.
	SDIO_MASK_CEATAENDIE_Msk = 0x800000
	// Bit CEATAENDIE.
	SDIO_MASK_CEATAENDIE = 0x800000
	// Interrupt disabled
	SDIO_MASK_CEATAENDIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_CEATAENDIE_Enabled = 0x1
	// Position of SDIOITIE field.
	SDIO_MASK_SDIOITIE_Pos = 0x16
	// Bit mask of SDIOITIE field.
	SDIO_MASK_SDIOITIE_Msk = 0x400000
	// Bit SDIOITIE.
	SDIO_MASK_SDIOITIE = 0x400000
	// Interrupt disabled
	SDIO_MASK_SDIOITIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_SDIOITIE_Enabled = 0x1
	// Position of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE_Pos = 0x15
	// Bit mask of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE_Msk = 0x200000
	// Bit RXDAVLIE.
	SDIO_MASK_RXDAVLIE = 0x200000
	// Interrupt disabled
	SDIO_MASK_RXDAVLIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_RXDAVLIE_Enabled = 0x1
	// Position of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE_Pos = 0x14
	// Bit mask of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE_Msk = 0x100000
	// Bit TXDAVLIE.
	SDIO_MASK_TXDAVLIE = 0x100000
	// Interrupt disabled
	SDIO_MASK_TXDAVLIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_TXDAVLIE_Enabled = 0x1
	// Position of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE_Pos = 0x13
	// Bit mask of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE_Msk = 0x80000
	// Bit RXFIFOEIE.
	SDIO_MASK_RXFIFOEIE = 0x80000
	// Interrupt disabled
	SDIO_MASK_RXFIFOEIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_RXFIFOEIE_Enabled = 0x1
	// Position of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE_Pos = 0x12
	// Bit mask of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE_Msk = 0x40000
	// Bit TXFIFOEIE.
	SDIO_MASK_TXFIFOEIE = 0x40000
	// Interrupt disabled
	SDIO_MASK_TXFIFOEIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_TXFIFOEIE_Enabled = 0x1
	// Position of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE_Pos = 0x11
	// Bit mask of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE_Msk = 0x20000
	// Bit RXFIFOFIE.
	SDIO_MASK_RXFIFOFIE = 0x20000
	// Interrupt disabled
	SDIO_MASK_RXFIFOFIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_RXFIFOFIE_Enabled = 0x1
	// Position of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE_Pos = 0x10
	// Bit mask of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE_Msk = 0x10000
	// Bit TXFIFOFIE.
	SDIO_MASK_TXFIFOFIE = 0x10000
	// Interrupt disabled
	SDIO_MASK_TXFIFOFIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_TXFIFOFIE_Enabled = 0x1
	// Position of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE_Pos = 0xf
	// Bit mask of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE_Msk = 0x8000
	// Bit RXFIFOHFIE.
	SDIO_MASK_RXFIFOHFIE = 0x8000
	// Interrupt disabled
	SDIO_MASK_RXFIFOHFIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_RXFIFOHFIE_Enabled = 0x1
	// Position of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE_Pos = 0xe
	// Bit mask of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE_Msk = 0x4000
	// Bit TXFIFOHEIE.
	SDIO_MASK_TXFIFOHEIE = 0x4000
	// Interrupt disabled
	SDIO_MASK_TXFIFOHEIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_TXFIFOHEIE_Enabled = 0x1
	// Position of RXACTIE field.
	SDIO_MASK_RXACTIE_Pos = 0xd
	// Bit mask of RXACTIE field.
	SDIO_MASK_RXACTIE_Msk = 0x2000
	// Bit RXACTIE.
	SDIO_MASK_RXACTIE = 0x2000
	// Interrupt disabled
	SDIO_MASK_RXACTIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_RXACTIE_Enabled = 0x1
	// Position of TXACTIE field.
	SDIO_MASK_TXACTIE_Pos = 0xc
	// Bit mask of TXACTIE field.
	SDIO_MASK_TXACTIE_Msk = 0x1000
	// Bit TXACTIE.
	SDIO_MASK_TXACTIE = 0x1000
	// Interrupt disabled
	SDIO_MASK_TXACTIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_TXACTIE_Enabled = 0x1
	// Position of CMDACTIE field.
	SDIO_MASK_CMDACTIE_Pos = 0xb
	// Bit mask of CMDACTIE field.
	SDIO_MASK_CMDACTIE_Msk = 0x800
	// Bit CMDACTIE.
	SDIO_MASK_CMDACTIE = 0x800
	// Interrupt disabled
	SDIO_MASK_CMDACTIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_CMDACTIE_Enabled = 0x1
	// Position of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE_Pos = 0xa
	// Bit mask of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE_Msk = 0x400
	// Bit DBCKENDIE.
	SDIO_MASK_DBCKENDIE = 0x400
	// Interrupt disabled
	SDIO_MASK_DBCKENDIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_DBCKENDIE_Enabled = 0x1
	// Position of STBITERRIE field.
	SDIO_MASK_STBITERRIE_Pos = 0x9
	// Bit mask of STBITERRIE field.
	SDIO_MASK_STBITERRIE_Msk = 0x200
	// Bit STBITERRIE.
	SDIO_MASK_STBITERRIE = 0x200
	// Interrupt disabled
	SDIO_MASK_STBITERRIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_STBITERRIE_Enabled = 0x1
	// Position of DATAENDIE field.
	SDIO_MASK_DATAENDIE_Pos = 0x8
	// Bit mask of DATAENDIE field.
	SDIO_MASK_DATAENDIE_Msk = 0x100
	// Bit DATAENDIE.
	SDIO_MASK_DATAENDIE = 0x100
	// Interrupt disabled
	SDIO_MASK_DATAENDIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_DATAENDIE_Enabled = 0x1
	// Position of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE_Pos = 0x7
	// Bit mask of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE_Msk = 0x80
	// Bit CMDSENTIE.
	SDIO_MASK_CMDSENTIE = 0x80
	// Interrupt disabled
	SDIO_MASK_CMDSENTIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_CMDSENTIE_Enabled = 0x1
	// Position of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE_Pos = 0x6
	// Bit mask of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE_Msk = 0x40
	// Bit CMDRENDIE.
	SDIO_MASK_CMDRENDIE = 0x40
	// Interrupt disabled
	SDIO_MASK_CMDRENDIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_CMDRENDIE_Enabled = 0x1
	// Position of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE_Pos = 0x5
	// Bit mask of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE_Msk = 0x20
	// Bit RXOVERRIE.
	SDIO_MASK_RXOVERRIE = 0x20
	// Interrupt disabled
	SDIO_MASK_RXOVERRIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_RXOVERRIE_Enabled = 0x1
	// Position of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE_Pos = 0x4
	// Bit mask of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE_Msk = 0x10
	// Bit TXUNDERRIE.
	SDIO_MASK_TXUNDERRIE = 0x10
	// Interrupt disabled
	SDIO_MASK_TXUNDERRIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_TXUNDERRIE_Enabled = 0x1
	// Position of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE_Pos = 0x3
	// Bit mask of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE_Msk = 0x8
	// Bit DTIMEOUTIE.
	SDIO_MASK_DTIMEOUTIE = 0x8
	// Interrupt disabled
	SDIO_MASK_DTIMEOUTIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_DTIMEOUTIE_Enabled = 0x1
	// Position of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE_Pos = 0x2
	// Bit mask of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE_Msk = 0x4
	// Bit CTIMEOUTIE.
	SDIO_MASK_CTIMEOUTIE = 0x4
	// Interrupt disabled
	SDIO_MASK_CTIMEOUTIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_CTIMEOUTIE_Enabled = 0x1
	// Position of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE_Pos = 0x1
	// Bit mask of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE_Msk = 0x2
	// Bit DCRCFAILIE.
	SDIO_MASK_DCRCFAILIE = 0x2
	// Interrupt disabled
	SDIO_MASK_DCRCFAILIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_DCRCFAILIE_Enabled = 0x1
	// Position of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE_Pos = 0x0
	// Bit mask of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE_Msk = 0x1
	// Bit CCRCFAILIE.
	SDIO_MASK_CCRCFAILIE = 0x1
	// Interrupt disabled
	SDIO_MASK_CCRCFAILIE_Disabled = 0x0
	// Interrupt enabled
	SDIO_MASK_CCRCFAILIE_Enabled = 0x1

	// FIFOCNT: FIFO counter register
	// Position of FIFOCOUNT field.
	SDIO_FIFOCNT_FIFOCOUNT_Pos = 0x0
	// Bit mask of FIFOCOUNT field.
	SDIO_FIFOCNT_FIFOCOUNT_Msk = 0xffffff

	// FIFO: data FIFO register
	// Position of FIFOData field.
	SDIO_FIFO_FIFOData_Pos = 0x0
	// Bit mask of FIFOData field.
	SDIO_FIFO_FIFOData_Msk = 0xffffffff
)

// Constants for SYSCFG: System configuration controller
const (
	// MEMRM: memory remap register
	// Position of MEM_MODE field.
	SYSCFG_MEMRM_MEM_MODE_Pos = 0x0
	// Bit mask of MEM_MODE field.
	SYSCFG_MEMRM_MEM_MODE_Msk = 0x3

	// PMC: peripheral mode configuration register
	// Position of ADC1DC2 field.
	SYSCFG_PMC_ADC1DC2_Pos = 0x10
	// Bit mask of ADC1DC2 field.
	SYSCFG_PMC_ADC1DC2_Msk = 0x10000
	// Bit ADC1DC2.
	SYSCFG_PMC_ADC1DC2 = 0x10000

	// EXTICR1: external interrupt configuration register 1
	// Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc
	// Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000
	// Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8
	// Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00
	// Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4
	// Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0
	// Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0
	// Bit mask of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf

	// EXTICR2: external interrupt configuration register 2
	// Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc
	// Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000
	// Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8
	// Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00
	// Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4
	// Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0
	// Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0
	// Bit mask of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf

	// EXTICR3: external interrupt configuration register 3
	// Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc
	// Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000
	// Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8
	// Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00
	// Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Pos = 0x4
	// Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk = 0xf0
	// Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Pos = 0x0
	// Bit mask of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk = 0xf

	// EXTICR4: external interrupt configuration register 4
	// Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc
	// Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000
	// Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8
	// Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00
	// Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4
	// Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0
	// Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0
	// Bit mask of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf

	// CMPCR: Compensation cell control register
	// Position of READY field.
	SYSCFG_CMPCR_READY_Pos = 0x8
	// Bit mask of READY field.
	SYSCFG_CMPCR_READY_Msk = 0x100
	// Bit READY.
	SYSCFG_CMPCR_READY = 0x100
	// Position of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD_Pos = 0x0
	// Bit mask of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD_Msk = 0x1
	// Bit CMP_PD.
	SYSCFG_CMPCR_CMP_PD = 0x1
)

// Constants for TIM1: Advanced-timers
const (
	// CR1: control register 1
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// t_DTS = t_CK_INT
	TIM_CR1_CKD_Div1 = 0x0
	// t_DTS = 2 × t_CK_INT
	TIM_CR1_CKD_Div2 = 0x1
	// t_DTS = 4 × t_CK_INT
	TIM_CR1_CKD_Div4 = 0x2
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// TIMx_APRR register is not buffered
	TIM_CR1_ARPE_Disabled = 0x0
	// TIMx_APRR register is buffered
	TIM_CR1_ARPE_Enabled = 0x1
	// Position of CMS field.
	TIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_CR1_CMS_Msk = 0x60
	// The counter counts up or down depending on the direction bit
	TIM_CR1_CMS_EdgeAligned = 0x0
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting down.
	TIM_CR1_CMS_CenterAligned1 = 0x1
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting up.
	TIM_CR1_CMS_CenterAligned2 = 0x2
	// The counter counts up and down alternatively. Output compare interrupt flags are set both when the counter is counting up or down.
	TIM_CR1_CMS_CenterAligned3 = 0x3
	// Position of DIR field.
	TIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_CR1_DIR = 0x10
	// Counter used as upcounter
	TIM_CR1_DIR_Up = 0x0
	// Counter used as downcounter
	TIM_CR1_DIR_Down = 0x1
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIM_CR1_OPM_Disabled = 0x0
	// Counter stops counting at the next update event (clearing the CEN bit)
	TIM_CR1_OPM_Enabled = 0x1
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request
	TIM_CR1_URS_AnyEvent = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request
	TIM_CR1_URS_CounterOnly = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Update event enabled
	TIM_CR1_UDIS_Enabled = 0x0
	// Update event disabled
	TIM_CR1_UDIS_Disabled = 0x1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Counter disabled
	TIM_CR1_CEN_Disabled = 0x0
	// Counter enabled
	TIM_CR1_CEN_Enabled = 0x1

	// CR2: control register 2
	// Position of OIS4 field.
	TIM_CR2_OIS4_Pos = 0xe
	// Bit mask of OIS4 field.
	TIM_CR2_OIS4_Msk = 0x4000
	// Bit OIS4.
	TIM_CR2_OIS4 = 0x4000
	// Position of OIS3N field.
	TIM_CR2_OIS3N_Pos = 0xd
	// Bit mask of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000
	// Bit OIS3N.
	TIM_CR2_OIS3N = 0x2000
	// Position of OIS3 field.
	TIM_CR2_OIS3_Pos = 0xc
	// Bit mask of OIS3 field.
	TIM_CR2_OIS3_Msk = 0x1000
	// Bit OIS3.
	TIM_CR2_OIS3 = 0x1000
	// Position of OIS2N field.
	TIM_CR2_OIS2N_Pos = 0xb
	// Bit mask of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800
	// Bit OIS2N.
	TIM_CR2_OIS2N = 0x800
	// Position of OIS2 field.
	TIM_CR2_OIS2_Pos = 0xa
	// Bit mask of OIS2 field.
	TIM_CR2_OIS2_Msk = 0x400
	// Bit OIS2.
	TIM_CR2_OIS2 = 0x400
	// Position of OIS1N field.
	TIM_CR2_OIS1N_Pos = 0x9
	// Bit mask of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200
	// Bit OIS1N.
	TIM_CR2_OIS1N = 0x200
	// Position of OIS1 field.
	TIM_CR2_OIS1_Pos = 0x8
	// Bit mask of OIS1 field.
	TIM_CR2_OIS1_Msk = 0x100
	// Bit OIS1.
	TIM_CR2_OIS1 = 0x100
	// Position of TI1S field.
	TIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIM_CR2_TI1S_Normal = 0x0
	// The TIMx_CH1, CH2, CH3 pins are connected to TI1 input
	TIM_CR2_TI1S_XOR = 0x1
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70
	// The UG bit from the TIMx_EGR register is used as trigger output
	TIM_CR2_MMS_Reset = 0x0
	// The counter enable signal, CNT_EN, is used as trigger output
	TIM_CR2_MMS_Enable = 0x1
	// The update event is selected as trigger output
	TIM_CR2_MMS_Update = 0x2
	// The trigger output send a positive pulse when the CC1IF flag it to be set, as soon as a capture or a compare match occurred
	TIM_CR2_MMS_ComparePulse = 0x3
	// OC1REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC1 = 0x4
	// OC2REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC2 = 0x5
	// OC3REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC3 = 0x6
	// OC4REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC4 = 0x7
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIM_CR2_CCDS_OnCompare = 0x0
	// CCx DMA request sent when update event occurs
	TIM_CR2_CCDS_OnUpdate = 0x1
	// Position of CCUS field.
	TIM_CR2_CCUS_Pos = 0x2
	// Bit mask of CCUS field.
	TIM_CR2_CCUS_Msk = 0x4
	// Bit CCUS.
	TIM_CR2_CCUS = 0x4
	// Position of CCPC field.
	TIM_CR2_CCPC_Pos = 0x0
	// Bit mask of CCPC field.
	TIM_CR2_CCPC_Msk = 0x1
	// Bit CCPC.
	TIM_CR2_CCPC = 0x1

	// SMCR: slave mode control register
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000
	// ETR is noninverted, active at high level or rising edge
	TIM_SMCR_ETP_NotInverted = 0x0
	// ETR is inverted, active at low level or falling edge
	TIM_SMCR_ETP_Inverted = 0x1
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIM_SMCR_ECE_Disabled = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIM_SMCR_ECE_Enabled = 0x1
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIM_SMCR_ETPS_Div1 = 0x0
	// ETRP frequency divided by 2
	TIM_SMCR_ETPS_Div2 = 0x1
	// ETRP frequency divided by 4
	TIM_SMCR_ETPS_Div4 = 0x2
	// ETRP frequency divided by 8
	TIM_SMCR_ETPS_Div8 = 0x3
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIM_SMCR_ETF_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_SMCR_ETF_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_SMCR_ETF_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_SMCR_ETF_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_SMCR_ETF_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_SMCR_ETF_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_SMCR_ETF_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_SMCR_ETF_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_SMCR_ETF_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_SMCR_ETF_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_SMCR_ETF_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_SMCR_ETF_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_SMCR_ETF_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_SMCR_ETF_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_SMCR_ETF_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_SMCR_ETF_FDTS_Div32_N8 = 0xf
	// Position of MSM field.
	TIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_SMCR_MSM = 0x80
	// No action
	TIM_SMCR_MSM_NoSync = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIM_SMCR_MSM_Sync = 0x1
	// Position of TS field.
	TIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	TIM_SMCR_TS_Msk = 0x70
	// Internal Trigger 0 (ITR0)
	TIM_SMCR_TS_ITR0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIM_SMCR_TS_ITR1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIM_SMCR_TS_ITR2 = 0x2
	// TI1 Edge Detector (TI1F_ED)
	TIM_SMCR_TS_TI1F_ED = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIM_SMCR_TS_TI1FP1 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIM_SMCR_TS_TI2FP2 = 0x6
	// External Trigger input (ETRF)
	TIM_SMCR_TS_ETRF = 0x7
	// Position of SMS field.
	TIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	TIM_SMCR_SMS_Msk = 0x7
	// Slave mode disabled - if CEN = ‘1 then the prescaler is clocked directly by the internal clock.
	TIM_SMCR_SMS_Disabled = 0x0
	// Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2 level.
	TIM_SMCR_SMS_Encoder_Mode_1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1 level.
	TIM_SMCR_SMS_Encoder_Mode_2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIM_SMCR_SMS_Encoder_Mode_3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIM_SMCR_SMS_Reset_Mode = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIM_SMCR_SMS_Gated_Mode = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIM_SMCR_SMS_Trigger_Mode = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIM_SMCR_SMS_Ext_Clock_Mode = 0x7

	// DIER: DMA/Interrupt enable register
	// Position of TDE field.
	TIM_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIM_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIM_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIM_DIER_TDE_Disabled = 0x0
	// Trigger DMA request enabled
	TIM_DIER_TDE_Enabled = 0x1
	// Position of COMDE field.
	TIM_DIER_COMDE_Pos = 0xd
	// Bit mask of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000
	// Bit COMDE.
	TIM_DIER_COMDE = 0x2000
	// Position of CC4DE field.
	TIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_DIER_CC4DE = 0x1000
	// CCx DMA request disabled
	TIM_DIER_CC4DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC4DE_Enabled = 0x1
	// Position of CC3DE field.
	TIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_DIER_CC3DE = 0x800
	// CCx DMA request disabled
	TIM_DIER_CC3DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC3DE_Enabled = 0x1
	// Position of CC2DE field.
	TIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_DIER_CC2DE = 0x400
	// CCx DMA request disabled
	TIM_DIER_CC2DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC2DE_Enabled = 0x1
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// CCx DMA request disabled
	TIM_DIER_CC1DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC1DE_Enabled = 0x1
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Update DMA request disabled
	TIM_DIER_UDE_Disabled = 0x0
	// Update DMA request enabled
	TIM_DIER_UDE_Enabled = 0x1
	// Position of BIE field.
	TIM_DIER_BIE_Pos = 0x7
	// Bit mask of BIE field.
	TIM_DIER_BIE_Msk = 0x80
	// Bit BIE.
	TIM_DIER_BIE = 0x80
	// Position of TIE field.
	TIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIM_DIER_TIE_Disabled = 0x0
	// Trigger interrupt enabled
	TIM_DIER_TIE_Enabled = 0x1
	// Position of COMIE field.
	TIM_DIER_COMIE_Pos = 0x5
	// Bit mask of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20
	// Bit COMIE.
	TIM_DIER_COMIE = 0x20
	// Position of CC4IE field.
	TIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_DIER_CC4IE = 0x10
	// CCx interrupt disabled
	TIM_DIER_CC4IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC4IE_Enabled = 0x1
	// Position of CC3IE field.
	TIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_DIER_CC3IE = 0x8
	// CCx interrupt disabled
	TIM_DIER_CC3IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC3IE_Enabled = 0x1
	// Position of CC2IE field.
	TIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_DIER_CC2IE = 0x4
	// CCx interrupt disabled
	TIM_DIER_CC2IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC2IE_Enabled = 0x1
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// CCx interrupt disabled
	TIM_DIER_CC1IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC1IE_Enabled = 0x1
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_DIER_UIE_Disabled = 0x0
	// Update interrupt enabled
	TIM_DIER_UIE_Enabled = 0x1

	// SR: status register
	// Position of CC4OF field.
	TIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_SR_CC4OF = 0x1000
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC4OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC4OF_Clear = 0x0
	// Position of CC3OF field.
	TIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_SR_CC3OF = 0x800
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC3OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC3OF_Clear = 0x0
	// Position of CC2OF field.
	TIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_SR_CC2OF = 0x400
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC2OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC2OF_Clear = 0x0
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC1OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC1OF_Clear = 0x0
	// Position of BIF field.
	TIM_SR_BIF_Pos = 0x7
	// Bit mask of BIF field.
	TIM_SR_BIF_Msk = 0x80
	// Bit BIF.
	TIM_SR_BIF = 0x80
	// Position of TIF field.
	TIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_SR_TIF = 0x40
	// No trigger event occurred
	TIM_SR_TIF_NoTrigger = 0x0
	// Trigger interrupt pending
	TIM_SR_TIF_Trigger = 0x1
	// Clear flag
	TIM_SR_TIF_Clear = 0x0
	// Position of COMIF field.
	TIM_SR_COMIF_Pos = 0x5
	// Bit mask of COMIF field.
	TIM_SR_COMIF_Msk = 0x20
	// Bit COMIF.
	TIM_SR_COMIF = 0x20
	// Position of CC4IF field.
	TIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_SR_CC4IF = 0x10
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC4IF_Match = 0x1
	// Clear flag
	TIM_SR_CC4IF_Clear = 0x0
	// Position of CC3IF field.
	TIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_SR_CC3IF = 0x8
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC3IF_Match = 0x1
	// Clear flag
	TIM_SR_CC3IF_Clear = 0x0
	// Position of CC2IF field.
	TIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_SR_CC2IF = 0x4
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC2IF_Match = 0x1
	// Clear flag
	TIM_SR_CC2IF_Clear = 0x0
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC1IF_Match = 0x1
	// Clear flag
	TIM_SR_CC1IF_Clear = 0x0
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1
	// No update occurred
	TIM_SR_UIF_Clear = 0x0
	// Update interrupt pending.
	TIM_SR_UIF_UpdatePending = 0x1

	// EGR: event generation register
	// Position of BG field.
	TIM_EGR_BG_Pos = 0x7
	// Bit mask of BG field.
	TIM_EGR_BG_Msk = 0x80
	// Bit BG.
	TIM_EGR_BG = 0x80
	// Position of TG field.
	TIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_EGR_TG = 0x40
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIM_EGR_TG_Trigger = 0x1
	// Position of COMG field.
	TIM_EGR_COMG_Pos = 0x5
	// Bit mask of COMG field.
	TIM_EGR_COMG_Msk = 0x20
	// Bit COMG.
	TIM_EGR_COMG = 0x20
	// Position of CC4G field.
	TIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_EGR_CC4G = 0x10
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC4G_Trigger = 0x1
	// Position of CC3G field.
	TIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_EGR_CC3G = 0x8
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC3G_Trigger = 0x1
	// Position of CC2G field.
	TIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_EGR_CC2G = 0x4
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC2G_Trigger = 0x1
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC1G_Trigger = 0x1
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1
	// Re-initializes the timer counter and generates an update of the registers.
	TIM_EGR_UG_Update = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC2M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC2M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC2M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC2M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC2M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC2M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC2M_PwmMode2 = 0x7
	// Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIM_CCMR1_Output_OC2PE = 0x800
	// Preload register on CCR2 disabled. New values written to CCR2 are taken into account immediately
	TIM_CCMR1_Output_OC2PE_Disabled = 0x0
	// Preload register on CCR2 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC2PE_Enabled = 0x1
	// Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIM_CCMR1_Output_OC2FE = 0x400
	// Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Output_CC2S_Output = 0x0
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80
	// Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC1M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC1M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC1M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC1M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC1M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC1M_PwmMode2 = 0x7
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Preload register on CCR1 disabled. New values written to CCR1 are taken into account immediately
	TIM_CCMR1_Output_OC1PE_Disabled = 0x0
	// Preload register on CCR1 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC1PE_Enabled = 0x1
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Output_CC1S_Output = 0x0

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk = 0xf000
	// Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk = 0x300
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Input_CC2S_TI2 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Input_CC2S_TI1 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC
	TIM_CCMR1_Input_CC2S_TRC = 0x3
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// No filter, sampling is done at fDTS
	TIM_CCMR1_Input_IC1F_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_CCMR1_Input_IC1F_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_CCMR1_Input_IC1F_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_CCMR1_Input_IC1F_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N8 = 0xf
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Input_CC1S_TI1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Input_CC1S_TI2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC
	TIM_CCMR1_Input_CC1S_TRC = 0x3

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC4M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC4M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC4M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC4M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC4M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC4M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC4M_PwmMode2 = 0x7
	// Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIM_CCMR2_Output_OC4PE = 0x800
	// Preload register on CCR4 disabled. New values written to CCR4 are taken into account immediately
	TIM_CCMR2_Output_OC4PE_Disabled = 0x0
	// Preload register on CCR4 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC4PE_Enabled = 0x1
	// Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIM_CCMR2_Output_OC4FE = 0x400
	// Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Output_CC4S_Output = 0x0
	// Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIM_CCMR2_Output_OC3CE = 0x80
	// Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR2_Output_OC3M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR2_Output_OC3M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR2_Output_OC3M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR2_Output_OC3M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR2_Output_OC3M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR2_Output_OC3M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR2_Output_OC3M_PwmMode2 = 0x7
	// Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIM_CCMR2_Output_OC3PE = 0x8
	// Preload register on CCR3 disabled. New values written to CCR3 are taken into account immediately
	TIM_CCMR2_Output_OC3PE_Disabled = 0x0
	// Preload register on CCR3 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC3PE_Enabled = 0x1
	// Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIM_CCMR2_Output_OC3FE = 0x4
	// Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Output_CC3S_Output = 0x0

	// CCMR2_Input: capture/compare mode register 2 (input mode)
	// Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk = 0xf000
	// Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk = 0x300
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Input_CC4S_TI4 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Input_CC4S_TI3 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC
	TIM_CCMR2_Input_CC4S_TRC = 0x3
	// Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk = 0x3
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Input_CC3S_TI3 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Input_CC3S_TI4 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC
	TIM_CCMR2_Input_CC3S_TRC = 0x3

	// CCER: capture/compare enable register
	// Position of CC4P field.
	TIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIM_CCER_CC4P = 0x2000
	// Position of CC4E field.
	TIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIM_CCER_CC4E = 0x1000
	// Position of CC3NP field.
	TIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIM_CCER_CC3NP = 0x800
	// Position of CC3NE field.
	TIM_CCER_CC3NE_Pos = 0xa
	// Bit mask of CC3NE field.
	TIM_CCER_CC3NE_Msk = 0x400
	// Bit CC3NE.
	TIM_CCER_CC3NE = 0x400
	// Position of CC3P field.
	TIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIM_CCER_CC3P = 0x200
	// Position of CC3E field.
	TIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIM_CCER_CC3E = 0x100
	// Position of CC2NP field.
	TIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIM_CCER_CC2NP = 0x80
	// Position of CC2NE field.
	TIM_CCER_CC2NE_Pos = 0x6
	// Bit mask of CC2NE field.
	TIM_CCER_CC2NE_Msk = 0x40
	// Bit CC2NE.
	TIM_CCER_CC2NE = 0x40
	// Position of CC2P field.
	TIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIM_CCER_CC2P = 0x20
	// Position of CC2E field.
	TIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIM_CCER_CC2E = 0x10
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// Position of CC1NE field.
	TIM_CCER_CC1NE_Pos = 0x2
	// Bit mask of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4
	// Bit CC1NE.
	TIM_CCER_CC1NE = 0x4
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1

	// CNT: counter
	// Position of CNT field.
	TIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_CNT_CNT_Msk = 0xffff

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	TIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_ARR_ARR_Msk = 0xffff

	// RCR: repetition counter register
	// Position of REP field.
	TIM_RCR_REP_Pos = 0x0
	// Bit mask of REP field.
	TIM_RCR_REP_Msk = 0xff

	// CCR1: capture/compare register
	// Position of CCR field.
	TIM_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR_CCR_Msk = 0xffff

	// BDTR: break and dead-time register
	// Position of MOE field.
	TIM_BDTR_MOE_Pos = 0xf
	// Bit mask of MOE field.
	TIM_BDTR_MOE_Msk = 0x8000
	// Bit MOE.
	TIM_BDTR_MOE = 0x8000
	// Position of AOE field.
	TIM_BDTR_AOE_Pos = 0xe
	// Bit mask of AOE field.
	TIM_BDTR_AOE_Msk = 0x4000
	// Bit AOE.
	TIM_BDTR_AOE = 0x4000
	// Position of BKP field.
	TIM_BDTR_BKP_Pos = 0xd
	// Bit mask of BKP field.
	TIM_BDTR_BKP_Msk = 0x2000
	// Bit BKP.
	TIM_BDTR_BKP = 0x2000
	// Position of BKE field.
	TIM_BDTR_BKE_Pos = 0xc
	// Bit mask of BKE field.
	TIM_BDTR_BKE_Msk = 0x1000
	// Bit BKE.
	TIM_BDTR_BKE = 0x1000
	// Position of OSSR field.
	TIM_BDTR_OSSR_Pos = 0xb
	// Bit mask of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800
	// Bit OSSR.
	TIM_BDTR_OSSR = 0x800
	// Position of OSSI field.
	TIM_BDTR_OSSI_Pos = 0xa
	// Bit mask of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400
	// Bit OSSI.
	TIM_BDTR_OSSI = 0x400
	// Position of LOCK field.
	TIM_BDTR_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300
	// Position of DTG field.
	TIM_BDTR_DTG_Pos = 0x0
	// Bit mask of DTG field.
	TIM_BDTR_DTG_Msk = 0xff

	// DCR: DMA control register
	// Position of DBL field.
	TIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	TIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff
)

// Constants for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// SR: Status register
	// Position of CTS field.
	USART_SR_CTS_Pos = 0x9
	// Bit mask of CTS field.
	USART_SR_CTS_Msk = 0x200
	// Bit CTS.
	USART_SR_CTS = 0x200
	// Position of LBD field.
	USART_SR_LBD_Pos = 0x8
	// Bit mask of LBD field.
	USART_SR_LBD_Msk = 0x100
	// Bit LBD.
	USART_SR_LBD = 0x100
	// Position of TXE field.
	USART_SR_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_SR_TXE_Msk = 0x80
	// Bit TXE.
	USART_SR_TXE = 0x80
	// Position of TC field.
	USART_SR_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_SR_TC_Msk = 0x40
	// Bit TC.
	USART_SR_TC = 0x40
	// Position of RXNE field.
	USART_SR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_SR_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_SR_RXNE = 0x20
	// Position of IDLE field.
	USART_SR_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_SR_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_SR_IDLE = 0x10
	// Position of ORE field.
	USART_SR_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_SR_ORE_Msk = 0x8
	// Bit ORE.
	USART_SR_ORE = 0x8
	// Position of NF field.
	USART_SR_NF_Pos = 0x2
	// Bit mask of NF field.
	USART_SR_NF_Msk = 0x4
	// Bit NF.
	USART_SR_NF = 0x4
	// Position of FE field.
	USART_SR_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_SR_FE_Msk = 0x2
	// Bit FE.
	USART_SR_FE = 0x2
	// Position of PE field.
	USART_SR_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_SR_PE_Msk = 0x1
	// Bit PE.
	USART_SR_PE = 0x1

	// DR: Data register
	// Position of DR field.
	USART_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	USART_DR_DR_Msk = 0x1ff

	// BRR: Baud rate register
	// Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Pos = 0x4
	// Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0
	// Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Pos = 0x0
	// Bit mask of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf

	// CR1: Control register 1
	// Position of OVER8 field.
	USART_CR1_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_OVER8 = 0x8000
	// Oversampling by 16
	USART_CR1_OVER8_Oversample16 = 0x0
	// Oversampling by 8
	USART_CR1_OVER8_Oversample8 = 0x1
	// Position of UE field.
	USART_CR1_UE_Pos = 0xd
	// Bit mask of UE field.
	USART_CR1_UE_Msk = 0x2000
	// Bit UE.
	USART_CR1_UE = 0x2000
	// USART prescaler and outputs disabled
	USART_CR1_UE_Disabled = 0x0
	// USART enabled
	USART_CR1_UE_Enabled = 0x1
	// Position of M field.
	USART_CR1_M_Pos = 0xc
	// Bit mask of M field.
	USART_CR1_M_Msk = 0x1000
	// Bit M.
	USART_CR1_M = 0x1000
	// 8 data bits
	USART_CR1_M_M8 = 0x0
	// 9 data bits
	USART_CR1_M_M9 = 0x1
	// Position of WAKE field.
	USART_CR1_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_WAKE = 0x800
	// USART wakeup on idle line
	USART_CR1_WAKE_IdleLine = 0x0
	// USART wakeup on address mark
	USART_CR1_WAKE_AddressMark = 0x1
	// Position of PCE field.
	USART_CR1_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_PCE = 0x400
	// Parity control disabled
	USART_CR1_PCE_Disabled = 0x0
	// Parity control enabled
	USART_CR1_PCE_Enabled = 0x1
	// Position of PS field.
	USART_CR1_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_PS = 0x200
	// Even parity
	USART_CR1_PS_Even = 0x0
	// Odd parity
	USART_CR1_PS_Odd = 0x1
	// Position of PEIE field.
	USART_CR1_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_PEIE = 0x100
	// PE interrupt disabled
	USART_CR1_PEIE_Disabled = 0x0
	// PE interrupt enabled
	USART_CR1_PEIE_Enabled = 0x1
	// Position of TXEIE field.
	USART_CR1_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_TXEIE = 0x80
	// TXE interrupt disabled
	USART_CR1_TXEIE_Disabled = 0x0
	// TXE interrupt enabled
	USART_CR1_TXEIE_Enabled = 0x1
	// Position of TCIE field.
	USART_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_TCIE = 0x40
	// TC interrupt disabled
	USART_CR1_TCIE_Disabled = 0x0
	// TC interrupt enabled
	USART_CR1_TCIE_Enabled = 0x1
	// Position of RXNEIE field.
	USART_CR1_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_RXNEIE = 0x20
	// RXNE interrupt disabled
	USART_CR1_RXNEIE_Disabled = 0x0
	// RXNE interrupt enabled
	USART_CR1_RXNEIE_Enabled = 0x1
	// Position of IDLEIE field.
	USART_CR1_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_IDLEIE = 0x10
	// IDLE interrupt disabled
	USART_CR1_IDLEIE_Disabled = 0x0
	// IDLE interrupt enabled
	USART_CR1_IDLEIE_Enabled = 0x1
	// Position of TE field.
	USART_CR1_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_TE = 0x8
	// Transmitter disabled
	USART_CR1_TE_Disabled = 0x0
	// Transmitter enabled
	USART_CR1_TE_Enabled = 0x1
	// Position of RE field.
	USART_CR1_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_RE = 0x4
	// Receiver disabled
	USART_CR1_RE_Disabled = 0x0
	// Receiver enabled
	USART_CR1_RE_Enabled = 0x1
	// Position of RWU field.
	USART_CR1_RWU_Pos = 0x1
	// Bit mask of RWU field.
	USART_CR1_RWU_Msk = 0x2
	// Bit RWU.
	USART_CR1_RWU = 0x2
	// Receiver in active mode
	USART_CR1_RWU_Active = 0x0
	// Receiver in mute mode
	USART_CR1_RWU_Mute = 0x1
	// Position of SBK field.
	USART_CR1_SBK_Pos = 0x0
	// Bit mask of SBK field.
	USART_CR1_SBK_Msk = 0x1
	// Bit SBK.
	USART_CR1_SBK = 0x1
	// No break character is transmitted
	USART_CR1_SBK_NoBreak = 0x0
	// Break character transmitted
	USART_CR1_SBK_Break = 0x1

	// CR2: Control register 2
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// LIN mode disabled
	USART_CR2_LINEN_Disabled = 0x0
	// LIN mode enabled
	USART_CR2_LINEN_Enabled = 0x1
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// 1 stop bit
	USART_CR2_STOP_Stop1 = 0x0
	// 0.5 stop bits
	USART_CR2_STOP_Stop0p5 = 0x1
	// 2 stop bits
	USART_CR2_STOP_Stop2 = 0x2
	// 1.5 stop bits
	USART_CR2_STOP_Stop1p5 = 0x3
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// CK pin disabled
	USART_CR2_CLKEN_Disabled = 0x0
	// CK pin enabled
	USART_CR2_CLKEN_Enabled = 0x1
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Steady low value on CK pin outside transmission window
	USART_CR2_CPOL_Low = 0x0
	// Steady high value on CK pin outside transmission window
	USART_CR2_CPOL_High = 0x1
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// The first clock transition is the first data capture edge
	USART_CR2_CPHA_First = 0x0
	// The second clock transition is the first data capture edge
	USART_CR2_CPHA_Second = 0x1
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// LIN break detection interrupt disabled
	USART_CR2_LBDIE_Disabled = 0x0
	// LIN break detection interrupt enabled
	USART_CR2_LBDIE_Enabled = 0x1
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// 10-bit break detection
	USART_CR2_LBDL_LBDL10 = 0x0
	// 11-bit break detection
	USART_CR2_LBDL_LBDL11 = 0x1
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x0
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xf

	// CR3: Control register 3
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Three sample bit method
	USART_CR3_ONEBIT_Sample3 = 0x0
	// One sample bit method
	USART_CR3_ONEBIT_Sample1 = 0x1
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// CTS interrupt disabled
	USART_CR3_CTSIE_Disabled = 0x0
	// CTS interrupt enabled
	USART_CR3_CTSIE_Enabled = 0x1
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// CTS hardware flow control disabled
	USART_CR3_CTSE_Disabled = 0x0
	// CTS hardware flow control enabled
	USART_CR3_CTSE_Enabled = 0x1
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// RTS hardware flow control disabled
	USART_CR3_RTSE_Disabled = 0x0
	// RTS hardware flow control enabled
	USART_CR3_RTSE_Enabled = 0x1
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// DMA mode is disabled for transmission
	USART_CR3_DMAT_Disabled = 0x0
	// DMA mode is enabled for transmission
	USART_CR3_DMAT_Enabled = 0x1
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// DMA mode is disabled for reception
	USART_CR3_DMAR_Disabled = 0x0
	// DMA mode is enabled for reception
	USART_CR3_DMAR_Enabled = 0x1
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Smartcard mode disabled
	USART_CR3_SCEN_Disabled = 0x0
	// Smartcard mode enabled
	USART_CR3_SCEN_Enabled = 0x1
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// NACK transmission in case of parity error is disabled
	USART_CR3_NACK_Disabled = 0x0
	// NACK transmission during parity error is enabled
	USART_CR3_NACK_Enabled = 0x1
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Half duplex mode is not selected
	USART_CR3_HDSEL_FullDuplex = 0x0
	// Half duplex mode is selected
	USART_CR3_HDSEL_HalfDuplex = 0x1
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Normal mode
	USART_CR3_IRLP_Normal = 0x0
	// Low-power mode
	USART_CR3_IRLP_LowPower = 0x1
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// IrDA disabled
	USART_CR3_IREN_Disabled = 0x0
	// IrDA enabled
	USART_CR3_IREN_Enabled = 0x1
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1
	// Error interrupt disabled
	USART_CR3_EIE_Disabled = 0x0
	// Error interrupt enabled
	USART_CR3_EIE_Enabled = 0x1

	// GTPR: Guard time and prescaler register
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff
)

// Constants for WWDG: Window watchdog
const (
	// CR: Control register
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Watchdog disabled
	WWDG_CR_WDGA_Disabled = 0x0
	// Watchdog enabled
	WWDG_CR_WDGA_Enabled = 0x1
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f

	// CFR: Configuration register
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// interrupt occurs whenever the counter reaches the value 0x40
	WWDG_CFR_EWI_Enable = 0x1
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0x7
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180
	// Counter clock (PCLK1 div 4096) div 1
	WWDG_CFR_WDGTB_Div1 = 0x0
	// Counter clock (PCLK1 div 4096) div 2
	WWDG_CFR_WDGTB_Div2 = 0x1
	// Counter clock (PCLK1 div 4096) div 4
	WWDG_CFR_WDGTB_Div4 = 0x2
	// Counter clock (PCLK1 div 4096) div 8
	WWDG_CFR_WDGTB_Div8 = 0x3

	// SR: Status register
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
	// The EWI Interrupt Service Routine has been triggered
	WWDG_SR_EWIF_Pending = 0x1
	// The EWI Interrupt Service Routine has been serviced
	WWDG_SR_EWIF_Finished = 0x0
)

// Constants for DMA1: DMA controller
const (
	// LISR: low interrupt status register
	// Position of TCIF3 field.
	DMA_LISR_TCIF3_Pos = 0x1b
	// Bit mask of TCIF3 field.
	DMA_LISR_TCIF3_Msk = 0x8000000
	// Bit TCIF3.
	DMA_LISR_TCIF3 = 0x8000000
	// No transfer complete event on stream x
	DMA_LISR_TCIF3_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF3_Complete = 0x1
	// Position of HTIF3 field.
	DMA_LISR_HTIF3_Pos = 0x1a
	// Bit mask of HTIF3 field.
	DMA_LISR_HTIF3_Msk = 0x4000000
	// Bit HTIF3.
	DMA_LISR_HTIF3 = 0x4000000
	// No half transfer event on stream x
	DMA_LISR_HTIF3_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF3_Half = 0x1
	// Position of TEIF3 field.
	DMA_LISR_TEIF3_Pos = 0x19
	// Bit mask of TEIF3 field.
	DMA_LISR_TEIF3_Msk = 0x2000000
	// Bit TEIF3.
	DMA_LISR_TEIF3 = 0x2000000
	// No transfer error on stream x
	DMA_LISR_TEIF3_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF3_Error = 0x1
	// Position of DMEIF3 field.
	DMA_LISR_DMEIF3_Pos = 0x18
	// Bit mask of DMEIF3 field.
	DMA_LISR_DMEIF3_Msk = 0x1000000
	// Bit DMEIF3.
	DMA_LISR_DMEIF3 = 0x1000000
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF3_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF3_Error = 0x1
	// Position of FEIF3 field.
	DMA_LISR_FEIF3_Pos = 0x16
	// Bit mask of FEIF3 field.
	DMA_LISR_FEIF3_Msk = 0x400000
	// Bit FEIF3.
	DMA_LISR_FEIF3 = 0x400000
	// No FIFO error event on stream x
	DMA_LISR_FEIF3_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF3_Error = 0x1
	// Position of TCIF2 field.
	DMA_LISR_TCIF2_Pos = 0x15
	// Bit mask of TCIF2 field.
	DMA_LISR_TCIF2_Msk = 0x200000
	// Bit TCIF2.
	DMA_LISR_TCIF2 = 0x200000
	// No transfer complete event on stream x
	DMA_LISR_TCIF2_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF2_Complete = 0x1
	// Position of HTIF2 field.
	DMA_LISR_HTIF2_Pos = 0x14
	// Bit mask of HTIF2 field.
	DMA_LISR_HTIF2_Msk = 0x100000
	// Bit HTIF2.
	DMA_LISR_HTIF2 = 0x100000
	// No half transfer event on stream x
	DMA_LISR_HTIF2_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF2_Half = 0x1
	// Position of TEIF2 field.
	DMA_LISR_TEIF2_Pos = 0x13
	// Bit mask of TEIF2 field.
	DMA_LISR_TEIF2_Msk = 0x80000
	// Bit TEIF2.
	DMA_LISR_TEIF2 = 0x80000
	// No transfer error on stream x
	DMA_LISR_TEIF2_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF2_Error = 0x1
	// Position of DMEIF2 field.
	DMA_LISR_DMEIF2_Pos = 0x12
	// Bit mask of DMEIF2 field.
	DMA_LISR_DMEIF2_Msk = 0x40000
	// Bit DMEIF2.
	DMA_LISR_DMEIF2 = 0x40000
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF2_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF2_Error = 0x1
	// Position of FEIF2 field.
	DMA_LISR_FEIF2_Pos = 0x10
	// Bit mask of FEIF2 field.
	DMA_LISR_FEIF2_Msk = 0x10000
	// Bit FEIF2.
	DMA_LISR_FEIF2 = 0x10000
	// No FIFO error event on stream x
	DMA_LISR_FEIF2_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF2_Error = 0x1
	// Position of TCIF1 field.
	DMA_LISR_TCIF1_Pos = 0xb
	// Bit mask of TCIF1 field.
	DMA_LISR_TCIF1_Msk = 0x800
	// Bit TCIF1.
	DMA_LISR_TCIF1 = 0x800
	// No transfer complete event on stream x
	DMA_LISR_TCIF1_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF1_Complete = 0x1
	// Position of HTIF1 field.
	DMA_LISR_HTIF1_Pos = 0xa
	// Bit mask of HTIF1 field.
	DMA_LISR_HTIF1_Msk = 0x400
	// Bit HTIF1.
	DMA_LISR_HTIF1 = 0x400
	// No half transfer event on stream x
	DMA_LISR_HTIF1_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF1_Half = 0x1
	// Position of TEIF1 field.
	DMA_LISR_TEIF1_Pos = 0x9
	// Bit mask of TEIF1 field.
	DMA_LISR_TEIF1_Msk = 0x200
	// Bit TEIF1.
	DMA_LISR_TEIF1 = 0x200
	// No transfer error on stream x
	DMA_LISR_TEIF1_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF1_Error = 0x1
	// Position of DMEIF1 field.
	DMA_LISR_DMEIF1_Pos = 0x8
	// Bit mask of DMEIF1 field.
	DMA_LISR_DMEIF1_Msk = 0x100
	// Bit DMEIF1.
	DMA_LISR_DMEIF1 = 0x100
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF1_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF1_Error = 0x1
	// Position of FEIF1 field.
	DMA_LISR_FEIF1_Pos = 0x6
	// Bit mask of FEIF1 field.
	DMA_LISR_FEIF1_Msk = 0x40
	// Bit FEIF1.
	DMA_LISR_FEIF1 = 0x40
	// No FIFO error event on stream x
	DMA_LISR_FEIF1_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF1_Error = 0x1
	// Position of TCIF0 field.
	DMA_LISR_TCIF0_Pos = 0x5
	// Bit mask of TCIF0 field.
	DMA_LISR_TCIF0_Msk = 0x20
	// Bit TCIF0.
	DMA_LISR_TCIF0 = 0x20
	// No transfer complete event on stream x
	DMA_LISR_TCIF0_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_LISR_TCIF0_Complete = 0x1
	// Position of HTIF0 field.
	DMA_LISR_HTIF0_Pos = 0x4
	// Bit mask of HTIF0 field.
	DMA_LISR_HTIF0_Msk = 0x10
	// Bit HTIF0.
	DMA_LISR_HTIF0 = 0x10
	// No half transfer event on stream x
	DMA_LISR_HTIF0_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_LISR_HTIF0_Half = 0x1
	// Position of TEIF0 field.
	DMA_LISR_TEIF0_Pos = 0x3
	// Bit mask of TEIF0 field.
	DMA_LISR_TEIF0_Msk = 0x8
	// Bit TEIF0.
	DMA_LISR_TEIF0 = 0x8
	// No transfer error on stream x
	DMA_LISR_TEIF0_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_LISR_TEIF0_Error = 0x1
	// Position of DMEIF0 field.
	DMA_LISR_DMEIF0_Pos = 0x2
	// Bit mask of DMEIF0 field.
	DMA_LISR_DMEIF0_Msk = 0x4
	// Bit DMEIF0.
	DMA_LISR_DMEIF0 = 0x4
	// No Direct Mode error on stream x
	DMA_LISR_DMEIF0_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_LISR_DMEIF0_Error = 0x1
	// Position of FEIF0 field.
	DMA_LISR_FEIF0_Pos = 0x0
	// Bit mask of FEIF0 field.
	DMA_LISR_FEIF0_Msk = 0x1
	// Bit FEIF0.
	DMA_LISR_FEIF0 = 0x1
	// No FIFO error event on stream x
	DMA_LISR_FEIF0_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_LISR_FEIF0_Error = 0x1

	// HISR: high interrupt status register
	// Position of TCIF7 field.
	DMA_HISR_TCIF7_Pos = 0x1b
	// Bit mask of TCIF7 field.
	DMA_HISR_TCIF7_Msk = 0x8000000
	// Bit TCIF7.
	DMA_HISR_TCIF7 = 0x8000000
	// No transfer complete event on stream x
	DMA_HISR_TCIF7_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF7_Complete = 0x1
	// Position of HTIF7 field.
	DMA_HISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_HISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_HISR_HTIF7 = 0x4000000
	// No half transfer event on stream x
	DMA_HISR_HTIF7_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF7_Half = 0x1
	// Position of TEIF7 field.
	DMA_HISR_TEIF7_Pos = 0x19
	// Bit mask of TEIF7 field.
	DMA_HISR_TEIF7_Msk = 0x2000000
	// Bit TEIF7.
	DMA_HISR_TEIF7 = 0x2000000
	// No transfer error on stream x
	DMA_HISR_TEIF7_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF7_Error = 0x1
	// Position of DMEIF7 field.
	DMA_HISR_DMEIF7_Pos = 0x18
	// Bit mask of DMEIF7 field.
	DMA_HISR_DMEIF7_Msk = 0x1000000
	// Bit DMEIF7.
	DMA_HISR_DMEIF7 = 0x1000000
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF7_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF7_Error = 0x1
	// Position of FEIF7 field.
	DMA_HISR_FEIF7_Pos = 0x16
	// Bit mask of FEIF7 field.
	DMA_HISR_FEIF7_Msk = 0x400000
	// Bit FEIF7.
	DMA_HISR_FEIF7 = 0x400000
	// No FIFO error event on stream x
	DMA_HISR_FEIF7_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF7_Error = 0x1
	// Position of TCIF6 field.
	DMA_HISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_HISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_HISR_TCIF6 = 0x200000
	// No transfer complete event on stream x
	DMA_HISR_TCIF6_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF6_Complete = 0x1
	// Position of HTIF6 field.
	DMA_HISR_HTIF6_Pos = 0x14
	// Bit mask of HTIF6 field.
	DMA_HISR_HTIF6_Msk = 0x100000
	// Bit HTIF6.
	DMA_HISR_HTIF6 = 0x100000
	// No half transfer event on stream x
	DMA_HISR_HTIF6_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF6_Half = 0x1
	// Position of TEIF6 field.
	DMA_HISR_TEIF6_Pos = 0x13
	// Bit mask of TEIF6 field.
	DMA_HISR_TEIF6_Msk = 0x80000
	// Bit TEIF6.
	DMA_HISR_TEIF6 = 0x80000
	// No transfer error on stream x
	DMA_HISR_TEIF6_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF6_Error = 0x1
	// Position of DMEIF6 field.
	DMA_HISR_DMEIF6_Pos = 0x12
	// Bit mask of DMEIF6 field.
	DMA_HISR_DMEIF6_Msk = 0x40000
	// Bit DMEIF6.
	DMA_HISR_DMEIF6 = 0x40000
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF6_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF6_Error = 0x1
	// Position of FEIF6 field.
	DMA_HISR_FEIF6_Pos = 0x10
	// Bit mask of FEIF6 field.
	DMA_HISR_FEIF6_Msk = 0x10000
	// Bit FEIF6.
	DMA_HISR_FEIF6 = 0x10000
	// No FIFO error event on stream x
	DMA_HISR_FEIF6_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF6_Error = 0x1
	// Position of TCIF5 field.
	DMA_HISR_TCIF5_Pos = 0xb
	// Bit mask of TCIF5 field.
	DMA_HISR_TCIF5_Msk = 0x800
	// Bit TCIF5.
	DMA_HISR_TCIF5 = 0x800
	// No transfer complete event on stream x
	DMA_HISR_TCIF5_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF5_Complete = 0x1
	// Position of HTIF5 field.
	DMA_HISR_HTIF5_Pos = 0xa
	// Bit mask of HTIF5 field.
	DMA_HISR_HTIF5_Msk = 0x400
	// Bit HTIF5.
	DMA_HISR_HTIF5 = 0x400
	// No half transfer event on stream x
	DMA_HISR_HTIF5_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF5_Half = 0x1
	// Position of TEIF5 field.
	DMA_HISR_TEIF5_Pos = 0x9
	// Bit mask of TEIF5 field.
	DMA_HISR_TEIF5_Msk = 0x200
	// Bit TEIF5.
	DMA_HISR_TEIF5 = 0x200
	// No transfer error on stream x
	DMA_HISR_TEIF5_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF5_Error = 0x1
	// Position of DMEIF5 field.
	DMA_HISR_DMEIF5_Pos = 0x8
	// Bit mask of DMEIF5 field.
	DMA_HISR_DMEIF5_Msk = 0x100
	// Bit DMEIF5.
	DMA_HISR_DMEIF5 = 0x100
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF5_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF5_Error = 0x1
	// Position of FEIF5 field.
	DMA_HISR_FEIF5_Pos = 0x6
	// Bit mask of FEIF5 field.
	DMA_HISR_FEIF5_Msk = 0x40
	// Bit FEIF5.
	DMA_HISR_FEIF5 = 0x40
	// No FIFO error event on stream x
	DMA_HISR_FEIF5_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF5_Error = 0x1
	// Position of TCIF4 field.
	DMA_HISR_TCIF4_Pos = 0x5
	// Bit mask of TCIF4 field.
	DMA_HISR_TCIF4_Msk = 0x20
	// Bit TCIF4.
	DMA_HISR_TCIF4 = 0x20
	// No transfer complete event on stream x
	DMA_HISR_TCIF4_NotComplete = 0x0
	// A transfer complete event occurred on stream x
	DMA_HISR_TCIF4_Complete = 0x1
	// Position of HTIF4 field.
	DMA_HISR_HTIF4_Pos = 0x4
	// Bit mask of HTIF4 field.
	DMA_HISR_HTIF4_Msk = 0x10
	// Bit HTIF4.
	DMA_HISR_HTIF4 = 0x10
	// No half transfer event on stream x
	DMA_HISR_HTIF4_NotHalf = 0x0
	// A half transfer event occurred on stream x
	DMA_HISR_HTIF4_Half = 0x1
	// Position of TEIF4 field.
	DMA_HISR_TEIF4_Pos = 0x3
	// Bit mask of TEIF4 field.
	DMA_HISR_TEIF4_Msk = 0x8
	// Bit TEIF4.
	DMA_HISR_TEIF4 = 0x8
	// No transfer error on stream x
	DMA_HISR_TEIF4_NoError = 0x0
	// A transfer error occurred on stream x
	DMA_HISR_TEIF4_Error = 0x1
	// Position of DMEIF4 field.
	DMA_HISR_DMEIF4_Pos = 0x2
	// Bit mask of DMEIF4 field.
	DMA_HISR_DMEIF4_Msk = 0x4
	// Bit DMEIF4.
	DMA_HISR_DMEIF4 = 0x4
	// No Direct Mode error on stream x
	DMA_HISR_DMEIF4_NoError = 0x0
	// A Direct Mode error occurred on stream x
	DMA_HISR_DMEIF4_Error = 0x1
	// Position of FEIF4 field.
	DMA_HISR_FEIF4_Pos = 0x0
	// Bit mask of FEIF4 field.
	DMA_HISR_FEIF4_Msk = 0x1
	// Bit FEIF4.
	DMA_HISR_FEIF4 = 0x1
	// No FIFO error event on stream x
	DMA_HISR_FEIF4_NoError = 0x0
	// A FIFO error event occurred on stream x
	DMA_HISR_FEIF4_Error = 0x1

	// LIFCR: low interrupt flag clear register
	// Position of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Pos = 0x1b
	// Bit mask of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Msk = 0x8000000
	// Bit CTCIF3.
	DMA_LIFCR_CTCIF3 = 0x8000000
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF3_Clear = 0x1
	// Position of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Pos = 0x1a
	// Bit mask of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Msk = 0x4000000
	// Bit CHTIF3.
	DMA_LIFCR_CHTIF3 = 0x4000000
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF3_Clear = 0x1
	// Position of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Pos = 0x19
	// Bit mask of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Msk = 0x2000000
	// Bit CTEIF3.
	DMA_LIFCR_CTEIF3 = 0x2000000
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF3_Clear = 0x1
	// Position of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Pos = 0x18
	// Bit mask of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Msk = 0x1000000
	// Bit CDMEIF3.
	DMA_LIFCR_CDMEIF3 = 0x1000000
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF3_Clear = 0x1
	// Position of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Pos = 0x16
	// Bit mask of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Msk = 0x400000
	// Bit CFEIF3.
	DMA_LIFCR_CFEIF3 = 0x400000
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF3_Clear = 0x1
	// Position of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Pos = 0x15
	// Bit mask of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Msk = 0x200000
	// Bit CTCIF2.
	DMA_LIFCR_CTCIF2 = 0x200000
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF2_Clear = 0x1
	// Position of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Pos = 0x14
	// Bit mask of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Msk = 0x100000
	// Bit CHTIF2.
	DMA_LIFCR_CHTIF2 = 0x100000
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF2_Clear = 0x1
	// Position of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Pos = 0x13
	// Bit mask of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Msk = 0x80000
	// Bit CTEIF2.
	DMA_LIFCR_CTEIF2 = 0x80000
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF2_Clear = 0x1
	// Position of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Pos = 0x12
	// Bit mask of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Msk = 0x40000
	// Bit CDMEIF2.
	DMA_LIFCR_CDMEIF2 = 0x40000
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF2_Clear = 0x1
	// Position of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Pos = 0x10
	// Bit mask of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Msk = 0x10000
	// Bit CFEIF2.
	DMA_LIFCR_CFEIF2 = 0x10000
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF2_Clear = 0x1
	// Position of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Pos = 0xb
	// Bit mask of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Msk = 0x800
	// Bit CTCIF1.
	DMA_LIFCR_CTCIF1 = 0x800
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF1_Clear = 0x1
	// Position of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Pos = 0xa
	// Bit mask of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Msk = 0x400
	// Bit CHTIF1.
	DMA_LIFCR_CHTIF1 = 0x400
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF1_Clear = 0x1
	// Position of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Pos = 0x9
	// Bit mask of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Msk = 0x200
	// Bit CTEIF1.
	DMA_LIFCR_CTEIF1 = 0x200
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF1_Clear = 0x1
	// Position of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Pos = 0x8
	// Bit mask of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Msk = 0x100
	// Bit CDMEIF1.
	DMA_LIFCR_CDMEIF1 = 0x100
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF1_Clear = 0x1
	// Position of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Pos = 0x6
	// Bit mask of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Msk = 0x40
	// Bit CFEIF1.
	DMA_LIFCR_CFEIF1 = 0x40
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF1_Clear = 0x1
	// Position of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Pos = 0x5
	// Bit mask of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Msk = 0x20
	// Bit CTCIF0.
	DMA_LIFCR_CTCIF0 = 0x20
	// Clear the corresponding TCIFx flag
	DMA_LIFCR_CTCIF0_Clear = 0x1
	// Position of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Pos = 0x4
	// Bit mask of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Msk = 0x10
	// Bit CHTIF0.
	DMA_LIFCR_CHTIF0 = 0x10
	// Clear the corresponding HTIFx flag
	DMA_LIFCR_CHTIF0_Clear = 0x1
	// Position of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Pos = 0x3
	// Bit mask of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Msk = 0x8
	// Bit CTEIF0.
	DMA_LIFCR_CTEIF0 = 0x8
	// Clear the corresponding TEIFx flag
	DMA_LIFCR_CTEIF0_Clear = 0x1
	// Position of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Pos = 0x2
	// Bit mask of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Msk = 0x4
	// Bit CDMEIF0.
	DMA_LIFCR_CDMEIF0 = 0x4
	// Clear the corresponding DMEIFx flag
	DMA_LIFCR_CDMEIF0_Clear = 0x1
	// Position of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Pos = 0x0
	// Bit mask of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Msk = 0x1
	// Bit CFEIF0.
	DMA_LIFCR_CFEIF0 = 0x1
	// Clear the corresponding CFEIFx flag
	DMA_LIFCR_CFEIF0_Clear = 0x1

	// HIFCR: high interrupt flag clear register
	// Position of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Pos = 0x1b
	// Bit mask of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Msk = 0x8000000
	// Bit CTCIF7.
	DMA_HIFCR_CTCIF7 = 0x8000000
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF7_Clear = 0x1
	// Position of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_HIFCR_CHTIF7 = 0x4000000
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF7_Clear = 0x1
	// Position of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Pos = 0x19
	// Bit mask of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Msk = 0x2000000
	// Bit CTEIF7.
	DMA_HIFCR_CTEIF7 = 0x2000000
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF7_Clear = 0x1
	// Position of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Pos = 0x18
	// Bit mask of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Msk = 0x1000000
	// Bit CDMEIF7.
	DMA_HIFCR_CDMEIF7 = 0x1000000
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF7_Clear = 0x1
	// Position of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Pos = 0x16
	// Bit mask of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Msk = 0x400000
	// Bit CFEIF7.
	DMA_HIFCR_CFEIF7 = 0x400000
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF7_Clear = 0x1
	// Position of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_HIFCR_CTCIF6 = 0x200000
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF6_Clear = 0x1
	// Position of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Pos = 0x14
	// Bit mask of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Msk = 0x100000
	// Bit CHTIF6.
	DMA_HIFCR_CHTIF6 = 0x100000
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF6_Clear = 0x1
	// Position of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Pos = 0x13
	// Bit mask of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Msk = 0x80000
	// Bit CTEIF6.
	DMA_HIFCR_CTEIF6 = 0x80000
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF6_Clear = 0x1
	// Position of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Pos = 0x12
	// Bit mask of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Msk = 0x40000
	// Bit CDMEIF6.
	DMA_HIFCR_CDMEIF6 = 0x40000
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF6_Clear = 0x1
	// Position of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Pos = 0x10
	// Bit mask of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Msk = 0x10000
	// Bit CFEIF6.
	DMA_HIFCR_CFEIF6 = 0x10000
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF6_Clear = 0x1
	// Position of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Pos = 0xb
	// Bit mask of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Msk = 0x800
	// Bit CTCIF5.
	DMA_HIFCR_CTCIF5 = 0x800
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF5_Clear = 0x1
	// Position of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Pos = 0xa
	// Bit mask of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Msk = 0x400
	// Bit CHTIF5.
	DMA_HIFCR_CHTIF5 = 0x400
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF5_Clear = 0x1
	// Position of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Pos = 0x9
	// Bit mask of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Msk = 0x200
	// Bit CTEIF5.
	DMA_HIFCR_CTEIF5 = 0x200
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF5_Clear = 0x1
	// Position of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Pos = 0x8
	// Bit mask of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Msk = 0x100
	// Bit CDMEIF5.
	DMA_HIFCR_CDMEIF5 = 0x100
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF5_Clear = 0x1
	// Position of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Pos = 0x6
	// Bit mask of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Msk = 0x40
	// Bit CFEIF5.
	DMA_HIFCR_CFEIF5 = 0x40
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF5_Clear = 0x1
	// Position of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Pos = 0x5
	// Bit mask of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Msk = 0x20
	// Bit CTCIF4.
	DMA_HIFCR_CTCIF4 = 0x20
	// Clear the corresponding TCIFx flag
	DMA_HIFCR_CTCIF4_Clear = 0x1
	// Position of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Pos = 0x4
	// Bit mask of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Msk = 0x10
	// Bit CHTIF4.
	DMA_HIFCR_CHTIF4 = 0x10
	// Clear the corresponding HTIFx flag
	DMA_HIFCR_CHTIF4_Clear = 0x1
	// Position of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Pos = 0x3
	// Bit mask of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Msk = 0x8
	// Bit CTEIF4.
	DMA_HIFCR_CTEIF4 = 0x8
	// Clear the corresponding TEIFx flag
	DMA_HIFCR_CTEIF4_Clear = 0x1
	// Position of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Pos = 0x2
	// Bit mask of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Msk = 0x4
	// Bit CDMEIF4.
	DMA_HIFCR_CDMEIF4 = 0x4
	// Clear the corresponding DMEIFx flag
	DMA_HIFCR_CDMEIF4_Clear = 0x1
	// Position of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Pos = 0x0
	// Bit mask of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Msk = 0x1
	// Bit CFEIF4.
	DMA_HIFCR_CFEIF4 = 0x1
	// Clear the corresponding CFEIFx flag
	DMA_HIFCR_CFEIF4_Clear = 0x1

	// ST.CR: stream x configuration register
	// Position of CHSEL field.
	DMA_ST_CR_CHSEL_Pos = 0x19
	// Bit mask of CHSEL field.
	DMA_ST_CR_CHSEL_Msk = 0xe000000
	// Position of MBURST field.
	DMA_ST_CR_MBURST_Pos = 0x17
	// Bit mask of MBURST field.
	DMA_ST_CR_MBURST_Msk = 0x1800000
	// Single transfer
	DMA_ST_CR_MBURST_Single = 0x0
	// Incremental burst of 4 beats
	DMA_ST_CR_MBURST_INCR4 = 0x1
	// Incremental burst of 8 beats
	DMA_ST_CR_MBURST_INCR8 = 0x2
	// Incremental burst of 16 beats
	DMA_ST_CR_MBURST_INCR16 = 0x3
	// Position of PBURST field.
	DMA_ST_CR_PBURST_Pos = 0x15
	// Bit mask of PBURST field.
	DMA_ST_CR_PBURST_Msk = 0x600000
	// Single transfer
	DMA_ST_CR_PBURST_Single = 0x0
	// Incremental burst of 4 beats
	DMA_ST_CR_PBURST_INCR4 = 0x1
	// Incremental burst of 8 beats
	DMA_ST_CR_PBURST_INCR8 = 0x2
	// Incremental burst of 16 beats
	DMA_ST_CR_PBURST_INCR16 = 0x3
	// Position of CT field.
	DMA_ST_CR_CT_Pos = 0x13
	// Bit mask of CT field.
	DMA_ST_CR_CT_Msk = 0x80000
	// Bit CT.
	DMA_ST_CR_CT = 0x80000
	// The current target memory is Memory 0
	DMA_ST_CR_CT_Memory0 = 0x0
	// The current target memory is Memory 1
	DMA_ST_CR_CT_Memory1 = 0x1
	// Position of DBM field.
	DMA_ST_CR_DBM_Pos = 0x12
	// Bit mask of DBM field.
	DMA_ST_CR_DBM_Msk = 0x40000
	// Bit DBM.
	DMA_ST_CR_DBM = 0x40000
	// No buffer switching at the end of transfer
	DMA_ST_CR_DBM_Disabled = 0x0
	// Memory target switched at the end of the DMA transfer
	DMA_ST_CR_DBM_Enabled = 0x1
	// Position of PL field.
	DMA_ST_CR_PL_Pos = 0x10
	// Bit mask of PL field.
	DMA_ST_CR_PL_Msk = 0x30000
	// Low
	DMA_ST_CR_PL_Low = 0x0
	// Medium
	DMA_ST_CR_PL_Medium = 0x1
	// High
	DMA_ST_CR_PL_High = 0x2
	// Very high
	DMA_ST_CR_PL_VeryHigh = 0x3
	// Position of PINCOS field.
	DMA_ST_CR_PINCOS_Pos = 0xf
	// Bit mask of PINCOS field.
	DMA_ST_CR_PINCOS_Msk = 0x8000
	// Bit PINCOS.
	DMA_ST_CR_PINCOS = 0x8000
	// The offset size for the peripheral address calculation is linked to the PSIZE
	DMA_ST_CR_PINCOS_PSIZE = 0x0
	// The offset size for the peripheral address calculation is fixed to 4 (32-bit alignment)
	DMA_ST_CR_PINCOS_Fixed4 = 0x1
	// Position of MSIZE field.
	DMA_ST_CR_MSIZE_Pos = 0xd
	// Bit mask of MSIZE field.
	DMA_ST_CR_MSIZE_Msk = 0x6000
	// Byte (8-bit)
	DMA_ST_CR_MSIZE_Bits8 = 0x0
	// Half-word (16-bit)
	DMA_ST_CR_MSIZE_Bits16 = 0x1
	// Word (32-bit)
	DMA_ST_CR_MSIZE_Bits32 = 0x2
	// Position of PSIZE field.
	DMA_ST_CR_PSIZE_Pos = 0xb
	// Bit mask of PSIZE field.
	DMA_ST_CR_PSIZE_Msk = 0x1800
	// Byte (8-bit)
	DMA_ST_CR_PSIZE_Bits8 = 0x0
	// Half-word (16-bit)
	DMA_ST_CR_PSIZE_Bits16 = 0x1
	// Word (32-bit)
	DMA_ST_CR_PSIZE_Bits32 = 0x2
	// Position of MINC field.
	DMA_ST_CR_MINC_Pos = 0xa
	// Bit mask of MINC field.
	DMA_ST_CR_MINC_Msk = 0x400
	// Bit MINC.
	DMA_ST_CR_MINC = 0x400
	// Address pointer is fixed
	DMA_ST_CR_MINC_Fixed = 0x0
	// Address pointer is incremented after each data transfer
	DMA_ST_CR_MINC_Incremented = 0x1
	// Position of PINC field.
	DMA_ST_CR_PINC_Pos = 0x9
	// Bit mask of PINC field.
	DMA_ST_CR_PINC_Msk = 0x200
	// Bit PINC.
	DMA_ST_CR_PINC = 0x200
	// Address pointer is fixed
	DMA_ST_CR_PINC_Fixed = 0x0
	// Address pointer is incremented after each data transfer
	DMA_ST_CR_PINC_Incremented = 0x1
	// Position of CIRC field.
	DMA_ST_CR_CIRC_Pos = 0x8
	// Bit mask of CIRC field.
	DMA_ST_CR_CIRC_Msk = 0x100
	// Bit CIRC.
	DMA_ST_CR_CIRC = 0x100
	// Circular mode disabled
	DMA_ST_CR_CIRC_Disabled = 0x0
	// Circular mode enabled
	DMA_ST_CR_CIRC_Enabled = 0x1
	// Position of DIR field.
	DMA_ST_CR_DIR_Pos = 0x6
	// Bit mask of DIR field.
	DMA_ST_CR_DIR_Msk = 0xc0
	// Peripheral-to-memory
	DMA_ST_CR_DIR_PeripheralToMemory = 0x0
	// Memory-to-peripheral
	DMA_ST_CR_DIR_MemoryToPeripheral = 0x1
	// Memory-to-memory
	DMA_ST_CR_DIR_MemoryToMemory = 0x2
	// Position of PFCTRL field.
	DMA_ST_CR_PFCTRL_Pos = 0x5
	// Bit mask of PFCTRL field.
	DMA_ST_CR_PFCTRL_Msk = 0x20
	// Bit PFCTRL.
	DMA_ST_CR_PFCTRL = 0x20
	// The DMA is the flow controller
	DMA_ST_CR_PFCTRL_DMA = 0x0
	// The peripheral is the flow controller
	DMA_ST_CR_PFCTRL_Peripheral = 0x1
	// Position of TCIE field.
	DMA_ST_CR_TCIE_Pos = 0x4
	// Bit mask of TCIE field.
	DMA_ST_CR_TCIE_Msk = 0x10
	// Bit TCIE.
	DMA_ST_CR_TCIE = 0x10
	// TC interrupt disabled
	DMA_ST_CR_TCIE_Disabled = 0x0
	// TC interrupt enabled
	DMA_ST_CR_TCIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_ST_CR_HTIE_Pos = 0x3
	// Bit mask of HTIE field.
	DMA_ST_CR_HTIE_Msk = 0x8
	// Bit HTIE.
	DMA_ST_CR_HTIE = 0x8
	// HT interrupt disabled
	DMA_ST_CR_HTIE_Disabled = 0x0
	// HT interrupt enabled
	DMA_ST_CR_HTIE_Enabled = 0x1
	// Position of TEIE field.
	DMA_ST_CR_TEIE_Pos = 0x2
	// Bit mask of TEIE field.
	DMA_ST_CR_TEIE_Msk = 0x4
	// Bit TEIE.
	DMA_ST_CR_TEIE = 0x4
	// TE interrupt disabled
	DMA_ST_CR_TEIE_Disabled = 0x0
	// TE interrupt enabled
	DMA_ST_CR_TEIE_Enabled = 0x1
	// Position of DMEIE field.
	DMA_ST_CR_DMEIE_Pos = 0x1
	// Bit mask of DMEIE field.
	DMA_ST_CR_DMEIE_Msk = 0x2
	// Bit DMEIE.
	DMA_ST_CR_DMEIE = 0x2
	// DME interrupt disabled
	DMA_ST_CR_DMEIE_Disabled = 0x0
	// DME interrupt enabled
	DMA_ST_CR_DMEIE_Enabled = 0x1
	// Position of EN field.
	DMA_ST_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_ST_CR_EN_Msk = 0x1
	// Bit EN.
	DMA_ST_CR_EN = 0x1
	// Stream disabled
	DMA_ST_CR_EN_Disabled = 0x0
	// Stream enabled
	DMA_ST_CR_EN_Enabled = 0x1

	// ST.NDTR: stream x number of data register
	// Position of NDT field.
	DMA_ST_NDTR_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_ST_NDTR_NDT_Msk = 0xffff

	// ST.PAR: stream x peripheral address register
	// Position of PA field.
	DMA_ST_PAR_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_ST_PAR_PA_Msk = 0xffffffff

	// ST.M0AR: stream x memory 0 address register
	// Position of M0A field.
	DMA_ST_M0AR_M0A_Pos = 0x0
	// Bit mask of M0A field.
	DMA_ST_M0AR_M0A_Msk = 0xffffffff

	// ST.M1AR: stream x memory 1 address register
	// Position of M1A field.
	DMA_ST_M1AR_M1A_Pos = 0x0
	// Bit mask of M1A field.
	DMA_ST_M1AR_M1A_Msk = 0xffffffff

	// ST.FCR: stream x FIFO control register
	// Position of FEIE field.
	DMA_ST_FCR_FEIE_Pos = 0x7
	// Bit mask of FEIE field.
	DMA_ST_FCR_FEIE_Msk = 0x80
	// Bit FEIE.
	DMA_ST_FCR_FEIE = 0x80
	// FE interrupt disabled
	DMA_ST_FCR_FEIE_Disabled = 0x0
	// FE interrupt enabled
	DMA_ST_FCR_FEIE_Enabled = 0x1
	// Position of FS field.
	DMA_ST_FCR_FS_Pos = 0x3
	// Bit mask of FS field.
	DMA_ST_FCR_FS_Msk = 0x38
	// 0 < fifo_level < 1/4
	DMA_ST_FCR_FS_Quarter1 = 0x0
	// 1/4 <= fifo_level < 1/2
	DMA_ST_FCR_FS_Quarter2 = 0x1
	// 1/2 <= fifo_level < 3/4
	DMA_ST_FCR_FS_Quarter3 = 0x2
	// 3/4 <= fifo_level < full
	DMA_ST_FCR_FS_Quarter4 = 0x3
	// FIFO is empty
	DMA_ST_FCR_FS_Empty = 0x4
	// FIFO is full
	DMA_ST_FCR_FS_Full = 0x5
	// Position of DMDIS field.
	DMA_ST_FCR_DMDIS_Pos = 0x2
	// Bit mask of DMDIS field.
	DMA_ST_FCR_DMDIS_Msk = 0x4
	// Bit DMDIS.
	DMA_ST_FCR_DMDIS = 0x4
	// Direct mode is enabled
	DMA_ST_FCR_DMDIS_Enabled = 0x0
	// Direct mode is disabled
	DMA_ST_FCR_DMDIS_Disabled = 0x1
	// Position of FTH field.
	DMA_ST_FCR_FTH_Pos = 0x0
	// Bit mask of FTH field.
	DMA_ST_FCR_FTH_Msk = 0x3
	// 1/4 full FIFO
	DMA_ST_FCR_FTH_Quarter = 0x0
	// 1/2 full FIFO
	DMA_ST_FCR_FTH_Half = 0x1
	// 3/4 full FIFO
	DMA_ST_FCR_FTH_ThreeQuarters = 0x2
	// Full FIFO
	DMA_ST_FCR_FTH_Full = 0x3
)

// Constants for GPIOH: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Input mode (reset state)
	GPIO_MODER_MODER15_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER15_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER15_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER15_Analog = 0x3
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_MODER_MODER14_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER14_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER14_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER14_Analog = 0x3
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Input mode (reset state)
	GPIO_MODER_MODER13_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER13_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER13_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER13_Analog = 0x3
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_MODER_MODER12_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER12_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER12_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER12_Analog = 0x3
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Input mode (reset state)
	GPIO_MODER_MODER11_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER11_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER11_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER11_Analog = 0x3
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Input mode (reset state)
	GPIO_MODER_MODER10_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER10_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER10_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER10_Analog = 0x3
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Input mode (reset state)
	GPIO_MODER_MODER9_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER9_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER9_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER9_Analog = 0x3
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Input mode (reset state)
	GPIO_MODER_MODER8_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER8_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER8_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER8_Analog = 0x3
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Input mode (reset state)
	GPIO_MODER_MODER7_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER7_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER7_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER7_Analog = 0x3
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Input mode (reset state)
	GPIO_MODER_MODER6_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER6_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER6_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER6_Analog = 0x3
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Input mode (reset state)
	GPIO_MODER_MODER5_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER5_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER5_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER5_Analog = 0x3
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Input mode (reset state)
	GPIO_MODER_MODER4_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER4_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER4_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER4_Analog = 0x3
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Input mode (reset state)
	GPIO_MODER_MODER3_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER3_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER3_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER3_Analog = 0x3
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Input mode (reset state)
	GPIO_MODER_MODER2_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER2_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER2_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER2_Analog = 0x3
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Input mode (reset state)
	GPIO_MODER_MODER1_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER1_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER1_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER1_Analog = 0x3
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3
	// Input mode (reset state)
	GPIO_MODER_MODER0_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER0_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER0_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER0_Analog = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT15_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT15_OpenDrain = 0x1
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT14_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT14_OpenDrain = 0x1
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT13_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT13_OpenDrain = 0x1
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT12_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT12_OpenDrain = 0x1
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Output push-pull (reset state)
	GPIO_OTYPER_OT11_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT11_OpenDrain = 0x1
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Output push-pull (reset state)
	GPIO_OTYPER_OT10_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT10_OpenDrain = 0x1
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Output push-pull (reset state)
	GPIO_OTYPER_OT9_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT9_OpenDrain = 0x1
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Output push-pull (reset state)
	GPIO_OTYPER_OT8_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT8_OpenDrain = 0x1
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Output push-pull (reset state)
	GPIO_OTYPER_OT7_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT7_OpenDrain = 0x1
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Output push-pull (reset state)
	GPIO_OTYPER_OT6_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT6_OpenDrain = 0x1
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Output push-pull (reset state)
	GPIO_OTYPER_OT5_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT5_OpenDrain = 0x1
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Output push-pull (reset state)
	GPIO_OTYPER_OT4_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT4_OpenDrain = 0x1
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Output push-pull (reset state)
	GPIO_OTYPER_OT3_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT3_OpenDrain = 0x1
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Output push-pull (reset state)
	GPIO_OTYPER_OT2_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT2_OpenDrain = 0x1
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Output push-pull (reset state)
	GPIO_OTYPER_OT1_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT1_OpenDrain = 0x1
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1
	// Output push-pull (reset state)
	GPIO_OTYPER_OT0_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT0_OpenDrain = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR15_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR15_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR15_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR15_VeryHighSpeed = 0x3
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR14_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR14_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR14_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR14_VeryHighSpeed = 0x3
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR13_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR13_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR13_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR13_VeryHighSpeed = 0x3
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR12_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR12_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR12_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR12_VeryHighSpeed = 0x3
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR11_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR11_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR11_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR11_VeryHighSpeed = 0x3
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR10_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR10_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR10_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR10_VeryHighSpeed = 0x3
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR9_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR9_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR9_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR9_VeryHighSpeed = 0x3
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR8_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR8_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR8_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR8_VeryHighSpeed = 0x3
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR7_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR7_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR7_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR7_VeryHighSpeed = 0x3
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR6_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR6_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR6_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR6_VeryHighSpeed = 0x3
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Low speed
	GPIO_OSPEEDR_OSPEEDR5_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR5_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR5_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR5_VeryHighSpeed = 0x3
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Low speed
	GPIO_OSPEEDR_OSPEEDR4_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR4_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR4_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR4_VeryHighSpeed = 0x3
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Low speed
	GPIO_OSPEEDR_OSPEEDR3_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR3_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR3_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR3_VeryHighSpeed = 0x3
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Low speed
	GPIO_OSPEEDR_OSPEEDR2_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR2_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR2_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR2_VeryHighSpeed = 0x3
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Low speed
	GPIO_OSPEEDR_OSPEEDR1_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR1_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR1_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR1_VeryHighSpeed = 0x3
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3
	// Low speed
	GPIO_OSPEEDR_OSPEEDR0_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR0_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR0_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR0_VeryHighSpeed = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR15_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR15_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR15_PullDown = 0x2
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR14_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR14_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR14_PullDown = 0x2
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR13_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR13_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR13_PullDown = 0x2
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR12_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR12_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR12_PullDown = 0x2
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR11_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR11_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR11_PullDown = 0x2
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR10_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR10_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR10_PullDown = 0x2
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR9_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR9_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR9_PullDown = 0x2
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR8_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR8_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR8_PullDown = 0x2
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR7_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR7_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR7_PullDown = 0x2
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR6_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR6_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR6_PullDown = 0x2
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR5_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR5_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR5_PullDown = 0x2
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR4_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR4_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR4_PullDown = 0x2
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR3_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR3_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR3_PullDown = 0x2
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR2_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR2_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR2_PullDown = 0x2
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR1_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR1_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR1_PullDown = 0x2
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR0_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR0_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR0_PullDown = 0x2

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Input is logic high
	GPIO_IDR_IDR15_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR15_Low = 0x0
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Input is logic high
	GPIO_IDR_IDR14_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR14_Low = 0x0
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Input is logic high
	GPIO_IDR_IDR13_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR13_Low = 0x0
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Input is logic high
	GPIO_IDR_IDR12_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR12_Low = 0x0
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Input is logic high
	GPIO_IDR_IDR11_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR11_Low = 0x0
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Input is logic high
	GPIO_IDR_IDR10_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR10_Low = 0x0
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Input is logic high
	GPIO_IDR_IDR9_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR9_Low = 0x0
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Input is logic high
	GPIO_IDR_IDR8_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR8_Low = 0x0
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Input is logic high
	GPIO_IDR_IDR7_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR7_Low = 0x0
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Input is logic high
	GPIO_IDR_IDR6_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR6_Low = 0x0
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Input is logic high
	GPIO_IDR_IDR5_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR5_Low = 0x0
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Input is logic high
	GPIO_IDR_IDR4_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR4_Low = 0x0
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Input is logic high
	GPIO_IDR_IDR3_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR3_Low = 0x0
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Input is logic high
	GPIO_IDR_IDR2_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR2_Low = 0x0
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Input is logic high
	GPIO_IDR_IDR1_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR1_Low = 0x0
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1
	// Input is logic high
	GPIO_IDR_IDR0_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR0_Low = 0x0

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Set output to logic high
	GPIO_ODR_ODR15_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR15_Low = 0x0
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Set output to logic high
	GPIO_ODR_ODR14_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR14_Low = 0x0
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Set output to logic high
	GPIO_ODR_ODR13_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR13_Low = 0x0
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Set output to logic high
	GPIO_ODR_ODR12_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR12_Low = 0x0
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Set output to logic high
	GPIO_ODR_ODR11_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR11_Low = 0x0
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Set output to logic high
	GPIO_ODR_ODR10_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR10_Low = 0x0
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Set output to logic high
	GPIO_ODR_ODR9_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR9_Low = 0x0
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Set output to logic high
	GPIO_ODR_ODR8_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR8_Low = 0x0
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Set output to logic high
	GPIO_ODR_ODR7_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR7_Low = 0x0
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Set output to logic high
	GPIO_ODR_ODR6_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR6_Low = 0x0
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Set output to logic high
	GPIO_ODR_ODR5_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR5_Low = 0x0
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Set output to logic high
	GPIO_ODR_ODR4_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR4_Low = 0x0
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Set output to logic high
	GPIO_ODR_ODR3_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR3_Low = 0x0
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Set output to logic high
	GPIO_ODR_ODR2_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR2_Low = 0x0
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Set output to logic high
	GPIO_ODR_ODR1_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR1_Low = 0x0
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1
	// Set output to logic high
	GPIO_ODR_ODR0_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR0_Low = 0x0

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR15_Reset = 0x1
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR14_Reset = 0x1
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR13_Reset = 0x1
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR12_Reset = 0x1
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR11_Reset = 0x1
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR10_Reset = 0x1
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR9_Reset = 0x1
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR8_Reset = 0x1
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR7_Reset = 0x1
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR6_Reset = 0x1
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR5_Reset = 0x1
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR4_Reset = 0x1
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR3_Reset = 0x1
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR2_Reset = 0x1
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR1_Reset = 0x1
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR0_Reset = 0x1
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS15_Set = 0x1
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS14_Set = 0x1
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS13_Set = 0x1
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS12_Set = 0x1
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS11_Set = 0x1
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS10_Set = 0x1
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS9_Set = 0x1
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS8_Set = 0x1
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS7_Set = 0x1
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS6_Set = 0x1
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS5_Set = 0x1
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS4_Set = 0x1
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS3_Set = 0x1
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS2_Set = 0x1
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS1_Set = 0x1
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS0_Set = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Port configuration lock key not active
	GPIO_LCKR_LCKK_NotActive = 0x0
	// Port configuration lock key active
	GPIO_LCKR_LCKK_Active = 0x1
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Port configuration not locked
	GPIO_LCKR_LCK15_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK15_Locked = 0x1
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Port configuration not locked
	GPIO_LCKR_LCK14_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK14_Locked = 0x1
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Port configuration not locked
	GPIO_LCKR_LCK13_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK13_Locked = 0x1
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Port configuration not locked
	GPIO_LCKR_LCK12_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK12_Locked = 0x1
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Port configuration not locked
	GPIO_LCKR_LCK11_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK11_Locked = 0x1
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Port configuration not locked
	GPIO_LCKR_LCK10_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK10_Locked = 0x1
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Port configuration not locked
	GPIO_LCKR_LCK9_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK9_Locked = 0x1
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Port configuration not locked
	GPIO_LCKR_LCK8_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK8_Locked = 0x1
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Port configuration not locked
	GPIO_LCKR_LCK7_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK7_Locked = 0x1
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Port configuration not locked
	GPIO_LCKR_LCK6_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK6_Locked = 0x1
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Port configuration not locked
	GPIO_LCKR_LCK5_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK5_Locked = 0x1
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Port configuration not locked
	GPIO_LCKR_LCK4_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK4_Locked = 0x1
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Port configuration not locked
	GPIO_LCKR_LCK3_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK3_Locked = 0x1
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Port configuration not locked
	GPIO_LCKR_LCK2_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK2_Locked = 0x1
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Port configuration not locked
	GPIO_LCKR_LCK1_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK1_Locked = 0x1
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1
	// Port configuration not locked
	GPIO_LCKR_LCK0_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK0_Locked = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Pos = 0x1c
	// Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000
	// AF0
	GPIO_AFRL_AFRL7_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL7_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL7_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL7_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL7_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL7_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL7_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL7_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL7_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL7_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL7_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL7_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL7_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL7_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL7_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL7_AF15 = 0xf
	// Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Pos = 0x18
	// Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000
	// AF0
	GPIO_AFRL_AFRL6_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL6_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL6_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL6_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL6_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL6_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL6_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL6_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL6_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL6_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL6_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL6_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL6_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL6_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL6_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL6_AF15 = 0xf
	// Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Pos = 0x14
	// Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000
	// AF0
	GPIO_AFRL_AFRL5_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL5_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL5_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL5_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL5_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL5_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL5_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL5_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL5_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL5_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL5_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL5_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL5_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL5_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL5_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL5_AF15 = 0xf
	// Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Pos = 0x10
	// Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000
	// AF0
	GPIO_AFRL_AFRL4_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL4_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL4_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL4_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL4_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL4_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL4_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL4_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL4_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL4_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL4_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL4_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL4_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL4_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL4_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL4_AF15 = 0xf
	// Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Pos = 0xc
	// Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000
	// AF0
	GPIO_AFRL_AFRL3_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL3_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL3_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL3_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL3_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL3_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL3_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL3_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL3_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL3_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL3_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL3_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL3_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL3_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL3_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL3_AF15 = 0xf
	// Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Pos = 0x8
	// Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00
	// AF0
	GPIO_AFRL_AFRL2_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL2_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL2_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL2_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL2_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL2_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL2_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL2_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL2_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL2_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL2_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL2_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL2_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL2_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL2_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL2_AF15 = 0xf
	// Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Pos = 0x4
	// Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0
	// AF0
	GPIO_AFRL_AFRL1_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL1_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL1_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL1_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL1_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL1_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL1_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL1_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL1_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL1_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL1_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL1_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL1_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL1_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL1_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL1_AF15 = 0xf
	// Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Pos = 0x0
	// Bit mask of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf
	// AF0
	GPIO_AFRL_AFRL0_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL0_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL0_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL0_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL0_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL0_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL0_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL0_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL0_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL0_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL0_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL0_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL0_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL0_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL0_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL0_AF15 = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Pos = 0x1c
	// Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000
	// AF0
	GPIO_AFRH_AFRH15_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH15_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH15_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH15_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH15_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH15_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH15_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH15_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH15_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH15_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH15_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH15_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH15_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH15_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH15_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH15_AF15 = 0xf
	// Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Pos = 0x18
	// Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000
	// AF0
	GPIO_AFRH_AFRH14_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH14_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH14_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH14_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH14_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH14_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH14_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH14_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH14_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH14_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH14_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH14_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH14_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH14_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH14_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH14_AF15 = 0xf
	// Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Pos = 0x14
	// Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000
	// AF0
	GPIO_AFRH_AFRH13_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH13_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH13_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH13_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH13_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH13_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH13_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH13_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH13_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH13_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH13_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH13_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH13_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH13_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH13_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH13_AF15 = 0xf
	// Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Pos = 0x10
	// Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000
	// AF0
	GPIO_AFRH_AFRH12_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH12_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH12_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH12_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH12_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH12_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH12_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH12_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH12_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH12_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH12_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH12_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH12_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH12_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH12_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH12_AF15 = 0xf
	// Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Pos = 0xc
	// Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000
	// AF0
	GPIO_AFRH_AFRH11_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH11_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH11_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH11_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH11_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH11_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH11_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH11_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH11_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH11_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH11_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH11_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH11_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH11_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH11_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH11_AF15 = 0xf
	// Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Pos = 0x8
	// Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00
	// AF0
	GPIO_AFRH_AFRH10_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH10_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH10_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH10_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH10_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH10_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH10_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH10_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH10_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH10_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH10_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH10_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH10_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH10_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH10_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH10_AF15 = 0xf
	// Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Pos = 0x4
	// Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk = 0xf0
	// AF0
	GPIO_AFRH_AFRH9_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH9_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH9_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH9_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH9_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH9_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH9_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH9_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH9_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH9_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH9_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH9_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH9_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH9_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH9_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH9_AF15 = 0xf
	// Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Pos = 0x0
	// Bit mask of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk = 0xf
	// AF0
	GPIO_AFRH_AFRH8_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH8_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH8_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH8_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH8_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH8_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH8_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH8_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH8_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH8_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH8_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH8_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH8_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH8_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH8_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH8_AF15 = 0xf
)

// Constants for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	// Position of SWRST field.
	I2C_CR1_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	I2C_CR1_SWRST_Msk = 0x8000
	// Bit SWRST.
	I2C_CR1_SWRST = 0x8000
	// I2C peripheral not under reset
	I2C_CR1_SWRST_NotReset = 0x0
	// I2C peripheral under reset
	I2C_CR1_SWRST_Reset = 0x1
	// Position of ALERT field.
	I2C_CR1_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_CR1_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_CR1_ALERT = 0x2000
	// SMBA pin released high
	I2C_CR1_ALERT_Release = 0x0
	// SMBA pin driven low
	I2C_CR1_ALERT_Drive = 0x1
	// Position of PEC field.
	I2C_CR1_PEC_Pos = 0xc
	// Bit mask of PEC field.
	I2C_CR1_PEC_Msk = 0x1000
	// Bit PEC.
	I2C_CR1_PEC = 0x1000
	// No PEC transfer
	I2C_CR1_PEC_Disabled = 0x0
	// PEC transfer
	I2C_CR1_PEC_Enabled = 0x1
	// Position of POS field.
	I2C_CR1_POS_Pos = 0xb
	// Bit mask of POS field.
	I2C_CR1_POS_Msk = 0x800
	// Bit POS.
	I2C_CR1_POS = 0x800
	// ACK bit controls the (N)ACK of the current byte being received
	I2C_CR1_POS_Current = 0x0
	// ACK bit controls the (N)ACK of the next byte to be received
	I2C_CR1_POS_Next = 0x1
	// Position of ACK field.
	I2C_CR1_ACK_Pos = 0xa
	// Bit mask of ACK field.
	I2C_CR1_ACK_Msk = 0x400
	// Bit ACK.
	I2C_CR1_ACK = 0x400
	// No acknowledge returned
	I2C_CR1_ACK_NAK = 0x0
	// Acknowledge returned after a byte is received
	I2C_CR1_ACK_ACK = 0x1
	// Position of STOP field.
	I2C_CR1_STOP_Pos = 0x9
	// Bit mask of STOP field.
	I2C_CR1_STOP_Msk = 0x200
	// Bit STOP.
	I2C_CR1_STOP = 0x200
	// No Stop generation
	I2C_CR1_STOP_NoStop = 0x0
	// In master mode: stop generation after current byte/start, in slave mode: release SCL and SDA after current byte
	I2C_CR1_STOP_Stop = 0x1
	// Position of START field.
	I2C_CR1_START_Pos = 0x8
	// Bit mask of START field.
	I2C_CR1_START_Msk = 0x100
	// Bit START.
	I2C_CR1_START = 0x100
	// No Start generation
	I2C_CR1_START_NoStart = 0x0
	// In master mode: repeated start generation, in slave mode: start generation when bus is free
	I2C_CR1_START_Start = 0x1
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x7
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x80
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x80
	// Clock stretching enabled
	I2C_CR1_NOSTRETCH_Enabled = 0x0
	// Clock stretching disabled
	I2C_CR1_NOSTRETCH_Disabled = 0x1
	// Position of ENGC field.
	I2C_CR1_ENGC_Pos = 0x6
	// Bit mask of ENGC field.
	I2C_CR1_ENGC_Msk = 0x40
	// Bit ENGC.
	I2C_CR1_ENGC = 0x40
	// General call disabled
	I2C_CR1_ENGC_Disabled = 0x0
	// General call enabled
	I2C_CR1_ENGC_Enabled = 0x1
	// Position of ENPEC field.
	I2C_CR1_ENPEC_Pos = 0x5
	// Bit mask of ENPEC field.
	I2C_CR1_ENPEC_Msk = 0x20
	// Bit ENPEC.
	I2C_CR1_ENPEC = 0x20
	// PEC calculation disabled
	I2C_CR1_ENPEC_Disabled = 0x0
	// PEC calculation enabled
	I2C_CR1_ENPEC_Enabled = 0x1
	// Position of ENARP field.
	I2C_CR1_ENARP_Pos = 0x4
	// Bit mask of ENARP field.
	I2C_CR1_ENARP_Msk = 0x10
	// Bit ENARP.
	I2C_CR1_ENARP = 0x10
	// ARP disabled
	I2C_CR1_ENARP_Disabled = 0x0
	// ARP enabled
	I2C_CR1_ENARP_Enabled = 0x1
	// Position of SMBTYPE field.
	I2C_CR1_SMBTYPE_Pos = 0x3
	// Bit mask of SMBTYPE field.
	I2C_CR1_SMBTYPE_Msk = 0x8
	// Bit SMBTYPE.
	I2C_CR1_SMBTYPE = 0x8
	// SMBus Device
	I2C_CR1_SMBTYPE_Device = 0x0
	// SMBus Host
	I2C_CR1_SMBTYPE_Host = 0x1
	// Position of SMBUS field.
	I2C_CR1_SMBUS_Pos = 0x1
	// Bit mask of SMBUS field.
	I2C_CR1_SMBUS_Msk = 0x2
	// Bit SMBUS.
	I2C_CR1_SMBUS = 0x2
	// I2C Mode
	I2C_CR1_SMBUS_I2C = 0x0
	// SMBus
	I2C_CR1_SMBUS_SMBus = 0x1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Peripheral disabled
	I2C_CR1_PE_Disabled = 0x0
	// Peripheral enabled
	I2C_CR1_PE_Enabled = 0x1

	// CR2: Control register 2
	// Position of LAST field.
	I2C_CR2_LAST_Pos = 0xc
	// Bit mask of LAST field.
	I2C_CR2_LAST_Msk = 0x1000
	// Bit LAST.
	I2C_CR2_LAST = 0x1000
	// Next DMA EOT is not the last transfer
	I2C_CR2_LAST_NotLast = 0x0
	// Next DMA EOT is the last transfer
	I2C_CR2_LAST_Last = 0x1
	// Position of DMAEN field.
	I2C_CR2_DMAEN_Pos = 0xb
	// Bit mask of DMAEN field.
	I2C_CR2_DMAEN_Msk = 0x800
	// Bit DMAEN.
	I2C_CR2_DMAEN = 0x800
	// DMA requests disabled
	I2C_CR2_DMAEN_Disabled = 0x0
	// DMA request enabled when TxE=1 or RxNE=1
	I2C_CR2_DMAEN_Enabled = 0x1
	// Position of ITBUFEN field.
	I2C_CR2_ITBUFEN_Pos = 0xa
	// Bit mask of ITBUFEN field.
	I2C_CR2_ITBUFEN_Msk = 0x400
	// Bit ITBUFEN.
	I2C_CR2_ITBUFEN = 0x400
	// TxE=1 or RxNE=1 does not generate any interrupt
	I2C_CR2_ITBUFEN_Disabled = 0x0
	// TxE=1 or RxNE=1 generates Event interrupt
	I2C_CR2_ITBUFEN_Enabled = 0x1
	// Position of ITEVTEN field.
	I2C_CR2_ITEVTEN_Pos = 0x9
	// Bit mask of ITEVTEN field.
	I2C_CR2_ITEVTEN_Msk = 0x200
	// Bit ITEVTEN.
	I2C_CR2_ITEVTEN = 0x200
	// Event interrupt disabled
	I2C_CR2_ITEVTEN_Disabled = 0x0
	// Event interrupt enabled
	I2C_CR2_ITEVTEN_Enabled = 0x1
	// Position of ITERREN field.
	I2C_CR2_ITERREN_Pos = 0x8
	// Bit mask of ITERREN field.
	I2C_CR2_ITERREN_Msk = 0x100
	// Bit ITERREN.
	I2C_CR2_ITERREN = 0x100
	// Error interrupt disabled
	I2C_CR2_ITERREN_Disabled = 0x0
	// Error interrupt enabled
	I2C_CR2_ITERREN_Enabled = 0x1
	// Position of FREQ field.
	I2C_CR2_FREQ_Pos = 0x0
	// Bit mask of FREQ field.
	I2C_CR2_FREQ_Msk = 0x3f

	// OAR1: Own address register 1
	// Position of ADDMODE field.
	I2C_OAR1_ADDMODE_Pos = 0xf
	// Bit mask of ADDMODE field.
	I2C_OAR1_ADDMODE_Msk = 0x8000
	// Bit ADDMODE.
	I2C_OAR1_ADDMODE = 0x8000
	// 7-bit slave address
	I2C_OAR1_ADDMODE_ADD7 = 0x0
	// 10-bit slave address
	I2C_OAR1_ADDMODE_ADD10 = 0x1
	// Position of ADD field.
	I2C_OAR1_ADD_Pos = 0x0
	// Bit mask of ADD field.
	I2C_OAR1_ADD_Msk = 0x3ff

	// OAR2: Own address register 2
	// Position of ADD2 field.
	I2C_OAR2_ADD2_Pos = 0x1
	// Bit mask of ADD2 field.
	I2C_OAR2_ADD2_Msk = 0xfe
	// Position of ENDUAL field.
	I2C_OAR2_ENDUAL_Pos = 0x0
	// Bit mask of ENDUAL field.
	I2C_OAR2_ENDUAL_Msk = 0x1
	// Bit ENDUAL.
	I2C_OAR2_ENDUAL = 0x1
	// Single addressing mode
	I2C_OAR2_ENDUAL_Single = 0x0
	// Dual addressing mode
	I2C_OAR2_ENDUAL_Dual = 0x1

	// DR: Data register
	// Position of DR field.
	I2C_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	I2C_DR_DR_Msk = 0xff

	// SR1: Status register 1
	// Position of SMBALERT field.
	I2C_SR1_SMBALERT_Pos = 0xf
	// Bit mask of SMBALERT field.
	I2C_SR1_SMBALERT_Msk = 0x8000
	// Bit SMBALERT.
	I2C_SR1_SMBALERT = 0x8000
	// No SMBALERT occured
	I2C_SR1_SMBALERT_NoAlert = 0x0
	// SMBALERT occurred
	I2C_SR1_SMBALERT_Alert = 0x1
	// Position of TIMEOUT field.
	I2C_SR1_TIMEOUT_Pos = 0xe
	// Bit mask of TIMEOUT field.
	I2C_SR1_TIMEOUT_Msk = 0x4000
	// Bit TIMEOUT.
	I2C_SR1_TIMEOUT = 0x4000
	// No Timeout error
	I2C_SR1_TIMEOUT_NoTimeout = 0x0
	// SCL remained LOW for 25 ms
	I2C_SR1_TIMEOUT_Timeout = 0x1
	// Position of PECERR field.
	I2C_SR1_PECERR_Pos = 0xc
	// Bit mask of PECERR field.
	I2C_SR1_PECERR_Msk = 0x1000
	// Bit PECERR.
	I2C_SR1_PECERR = 0x1000
	// no PEC error: receiver returns ACK after PEC reception (if ACK=1)
	I2C_SR1_PECERR_NoError = 0x0
	// PEC error: receiver returns NACK after PEC reception (whatever ACK)
	I2C_SR1_PECERR_Error = 0x1
	// Position of OVR field.
	I2C_SR1_OVR_Pos = 0xb
	// Bit mask of OVR field.
	I2C_SR1_OVR_Msk = 0x800
	// Bit OVR.
	I2C_SR1_OVR = 0x800
	// No overrun/underrun occured
	I2C_SR1_OVR_NoOverrun = 0x0
	// Overrun/underrun occured
	I2C_SR1_OVR_Overrun = 0x1
	// Position of AF field.
	I2C_SR1_AF_Pos = 0xa
	// Bit mask of AF field.
	I2C_SR1_AF_Msk = 0x400
	// Bit AF.
	I2C_SR1_AF = 0x400
	// No acknowledge failure
	I2C_SR1_AF_NoFailure = 0x0
	// Acknowledge failure
	I2C_SR1_AF_Failure = 0x1
	// Position of ARLO field.
	I2C_SR1_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_SR1_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_SR1_ARLO = 0x200
	// No Arbitration Lost detected
	I2C_SR1_ARLO_NoLost = 0x0
	// Arbitration Lost detected
	I2C_SR1_ARLO_Lost = 0x1
	// Position of BERR field.
	I2C_SR1_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_SR1_BERR_Msk = 0x100
	// Bit BERR.
	I2C_SR1_BERR = 0x100
	// No misplaced Start or Stop condition
	I2C_SR1_BERR_NoError = 0x0
	// Misplaced Start or Stop condition
	I2C_SR1_BERR_Error = 0x1
	// Position of TxE field.
	I2C_SR1_TxE_Pos = 0x7
	// Bit mask of TxE field.
	I2C_SR1_TxE_Msk = 0x80
	// Bit TxE.
	I2C_SR1_TxE = 0x80
	// Data register not empty
	I2C_SR1_TxE_NotEmpty = 0x0
	// Data register empty
	I2C_SR1_TxE_Empty = 0x1
	// Position of RxNE field.
	I2C_SR1_RxNE_Pos = 0x6
	// Bit mask of RxNE field.
	I2C_SR1_RxNE_Msk = 0x40
	// Bit RxNE.
	I2C_SR1_RxNE = 0x40
	// Data register empty
	I2C_SR1_RxNE_Empty = 0x0
	// Data register not empty
	I2C_SR1_RxNE_NotEmpty = 0x1
	// Position of STOPF field.
	I2C_SR1_STOPF_Pos = 0x4
	// Bit mask of STOPF field.
	I2C_SR1_STOPF_Msk = 0x10
	// Bit STOPF.
	I2C_SR1_STOPF = 0x10
	// No Stop condition detected
	I2C_SR1_STOPF_NoStop = 0x0
	// Stop condition detected
	I2C_SR1_STOPF_Stop = 0x1
	// Position of ADD10 field.
	I2C_SR1_ADD10_Pos = 0x3
	// Bit mask of ADD10 field.
	I2C_SR1_ADD10_Msk = 0x8
	// Bit ADD10.
	I2C_SR1_ADD10 = 0x8
	// Position of BTF field.
	I2C_SR1_BTF_Pos = 0x2
	// Bit mask of BTF field.
	I2C_SR1_BTF_Msk = 0x4
	// Bit BTF.
	I2C_SR1_BTF = 0x4
	// Data byte transfer not done
	I2C_SR1_BTF_NotFinished = 0x0
	// Data byte transfer successful
	I2C_SR1_BTF_Finished = 0x1
	// Position of ADDR field.
	I2C_SR1_ADDR_Pos = 0x1
	// Bit mask of ADDR field.
	I2C_SR1_ADDR_Msk = 0x2
	// Bit ADDR.
	I2C_SR1_ADDR = 0x2
	// Adress mismatched or not received
	I2C_SR1_ADDR_NotMatch = 0x0
	// Received slave address matched with one of the enabled slave addresses
	I2C_SR1_ADDR_Match = 0x1
	// Position of SB field.
	I2C_SR1_SB_Pos = 0x0
	// Bit mask of SB field.
	I2C_SR1_SB_Msk = 0x1
	// Bit SB.
	I2C_SR1_SB = 0x1
	// No Start condition
	I2C_SR1_SB_NoStart = 0x0
	// Start condition generated
	I2C_SR1_SB_Start = 0x1

	// SR2: Status register 2
	// Position of PEC field.
	I2C_SR2_PEC_Pos = 0x8
	// Bit mask of PEC field.
	I2C_SR2_PEC_Msk = 0xff00
	// Position of DUALF field.
	I2C_SR2_DUALF_Pos = 0x7
	// Bit mask of DUALF field.
	I2C_SR2_DUALF_Msk = 0x80
	// Bit DUALF.
	I2C_SR2_DUALF = 0x80
	// Position of SMBHOST field.
	I2C_SR2_SMBHOST_Pos = 0x6
	// Bit mask of SMBHOST field.
	I2C_SR2_SMBHOST_Msk = 0x40
	// Bit SMBHOST.
	I2C_SR2_SMBHOST = 0x40
	// Position of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Pos = 0x5
	// Bit mask of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Msk = 0x20
	// Bit SMBDEFAULT.
	I2C_SR2_SMBDEFAULT = 0x20
	// Position of GENCALL field.
	I2C_SR2_GENCALL_Pos = 0x4
	// Bit mask of GENCALL field.
	I2C_SR2_GENCALL_Msk = 0x10
	// Bit GENCALL.
	I2C_SR2_GENCALL = 0x10
	// Position of TRA field.
	I2C_SR2_TRA_Pos = 0x2
	// Bit mask of TRA field.
	I2C_SR2_TRA_Msk = 0x4
	// Bit TRA.
	I2C_SR2_TRA = 0x4
	// Position of BUSY field.
	I2C_SR2_BUSY_Pos = 0x1
	// Bit mask of BUSY field.
	I2C_SR2_BUSY_Msk = 0x2
	// Bit BUSY.
	I2C_SR2_BUSY = 0x2
	// Position of MSL field.
	I2C_SR2_MSL_Pos = 0x0
	// Bit mask of MSL field.
	I2C_SR2_MSL_Msk = 0x1
	// Bit MSL.
	I2C_SR2_MSL = 0x1

	// CCR: Clock control register
	// Position of F_S field.
	I2C_CCR_F_S_Pos = 0xf
	// Bit mask of F_S field.
	I2C_CCR_F_S_Msk = 0x8000
	// Bit F_S.
	I2C_CCR_F_S = 0x8000
	// Standard mode I2C
	I2C_CCR_F_S_Standard = 0x0
	// Fast mode I2C
	I2C_CCR_F_S_Fast = 0x1
	// Position of DUTY field.
	I2C_CCR_DUTY_Pos = 0xe
	// Bit mask of DUTY field.
	I2C_CCR_DUTY_Msk = 0x4000
	// Bit DUTY.
	I2C_CCR_DUTY = 0x4000
	// Duty cycle t_low/t_high = 2/1
	I2C_CCR_DUTY_Duty2_1 = 0x0
	// Duty cycle t_low/t_high = 16/9
	I2C_CCR_DUTY_Duty16_9 = 0x1
	// Position of CCR field.
	I2C_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	I2C_CCR_CCR_Msk = 0xfff

	// TRISE: TRISE register
	// Position of TRISE field.
	I2C_TRISE_TRISE_Pos = 0x0
	// Bit mask of TRISE field.
	I2C_TRISE_TRISE_Msk = 0x3f

	// FLTR: FLTR register
	// Position of ANOFF field.
	I2C_FLTR_ANOFF_Pos = 0x4
	// Bit mask of ANOFF field.
	I2C_FLTR_ANOFF_Msk = 0x10
	// Bit ANOFF.
	I2C_FLTR_ANOFF = 0x10
	// Analog noise filter enabled
	I2C_FLTR_ANOFF_Enabled = 0x0
	// Analog noise filter disabled
	I2C_FLTR_ANOFF_Disabled = 0x1
	// Position of DNF field.
	I2C_FLTR_DNF_Pos = 0x0
	// Bit mask of DNF field.
	I2C_FLTR_DNF_Msk = 0xf
	// Digital filter disabled
	I2C_FLTR_DNF_NoFilter = 0x0
	// Digital filter enabled and filtering capability up to 1 tI2CCLK
	I2C_FLTR_DNF_Filter1 = 0x1
	// Digital filter enabled and filtering capability up to 2 tI2CCLK
	I2C_FLTR_DNF_Filter2 = 0x2
	// Digital filter enabled and filtering capability up to 3 tI2CCLK
	I2C_FLTR_DNF_Filter3 = 0x3
	// Digital filter enabled and filtering capability up to 4 tI2CCLK
	I2C_FLTR_DNF_Filter4 = 0x4
	// Digital filter enabled and filtering capability up to 5 tI2CCLK
	I2C_FLTR_DNF_Filter5 = 0x5
	// Digital filter enabled and filtering capability up to 6 tI2CCLK
	I2C_FLTR_DNF_Filter6 = 0x6
	// Digital filter enabled and filtering capability up to 7 tI2CCLK
	I2C_FLTR_DNF_Filter7 = 0x7
	// Digital filter enabled and filtering capability up to 8 tI2CCLK
	I2C_FLTR_DNF_Filter8 = 0x8
	// Digital filter enabled and filtering capability up to 9 tI2CCLK
	I2C_FLTR_DNF_Filter9 = 0x9
	// Digital filter enabled and filtering capability up to 10 tI2CCLK
	I2C_FLTR_DNF_Filter10 = 0xa
	// Digital filter enabled and filtering capability up to 11 tI2CCLK
	I2C_FLTR_DNF_Filter11 = 0xb
	// Digital filter enabled and filtering capability up to 12 tI2CCLK
	I2C_FLTR_DNF_Filter12 = 0xc
	// Digital filter enabled and filtering capability up to 13 tI2CCLK
	I2C_FLTR_DNF_Filter13 = 0xd
	// Digital filter enabled and filtering capability up to 14 tI2CCLK
	I2C_FLTR_DNF_Filter14 = 0xe
	// Digital filter enabled and filtering capability up to 15 tI2CCLK
	I2C_FLTR_DNF_Filter15 = 0xf
)

// Constants for SPI1: Serial peripheral interface
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// 2-line unidirectional data mode selected
	SPI_CR1_BIDIMODE_Unidirectional = 0x0
	// 1-line bidirectional data mode selected
	SPI_CR1_BIDIMODE_Bidirectional = 0x1
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Output disabled (receive-only mode)
	SPI_CR1_BIDIOE_OutputDisabled = 0x0
	// Output enabled (transmit-only mode)
	SPI_CR1_BIDIOE_OutputEnabled = 0x1
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// CRC calculation disabled
	SPI_CR1_CRCEN_Disabled = 0x0
	// CRC calculation enabled
	SPI_CR1_CRCEN_Enabled = 0x1
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Next transmit value is from Tx buffer
	SPI_CR1_CRCNEXT_TxBuffer = 0x0
	// Next transmit value is from Tx CRC register
	SPI_CR1_CRCNEXT_CRC = 0x1
	// Position of DFF field.
	SPI_CR1_DFF_Pos = 0xb
	// Bit mask of DFF field.
	SPI_CR1_DFF_Msk = 0x800
	// Bit DFF.
	SPI_CR1_DFF = 0x800
	// 8-bit data frame format is selected for transmission/reception
	SPI_CR1_DFF_EightBit = 0x0
	// 16-bit data frame format is selected for transmission/reception
	SPI_CR1_DFF_SixteenBit = 0x1
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Full duplex (Transmit and receive)
	SPI_CR1_RXONLY_FullDuplex = 0x0
	// Output disabled (Receive-only mode)
	SPI_CR1_RXONLY_OutputDisabled = 0x1
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Software slave management disabled
	SPI_CR1_SSM_Disabled = 0x0
	// Software slave management enabled
	SPI_CR1_SSM_Enabled = 0x1
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// 0 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveSelected = 0x0
	// 1 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveNotSelected = 0x1
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Data is transmitted/received with the MSB first
	SPI_CR1_LSBFIRST_MSBFirst = 0x0
	// Data is transmitted/received with the LSB first
	SPI_CR1_LSBFIRST_LSBFirst = 0x1
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Peripheral disabled
	SPI_CR1_SPE_Disabled = 0x0
	// Peripheral enabled
	SPI_CR1_SPE_Enabled = 0x1
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// f_PCLK / 2
	SPI_CR1_BR_Div2 = 0x0
	// f_PCLK / 4
	SPI_CR1_BR_Div4 = 0x1
	// f_PCLK / 8
	SPI_CR1_BR_Div8 = 0x2
	// f_PCLK / 16
	SPI_CR1_BR_Div16 = 0x3
	// f_PCLK / 32
	SPI_CR1_BR_Div32 = 0x4
	// f_PCLK / 64
	SPI_CR1_BR_Div64 = 0x5
	// f_PCLK / 128
	SPI_CR1_BR_Div128 = 0x6
	// f_PCLK / 256
	SPI_CR1_BR_Div256 = 0x7
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Slave configuration
	SPI_CR1_MSTR_Slave = 0x0
	// Master configuration
	SPI_CR1_MSTR_Master = 0x1
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// CK to 0 when idle
	SPI_CR1_CPOL_IdleLow = 0x0
	// CK to 1 when idle
	SPI_CR1_CPOL_IdleHigh = 0x1
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1
	// The first clock transition is the first data capture edge
	SPI_CR1_CPHA_FirstEdge = 0x0
	// The second clock transition is the first data capture edge
	SPI_CR1_CPHA_SecondEdge = 0x1

	// CR2: control register 2
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// TXE interrupt masked
	SPI_CR2_TXEIE_Masked = 0x0
	// TXE interrupt not masked
	SPI_CR2_TXEIE_NotMasked = 0x1
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// RXE interrupt masked
	SPI_CR2_RXNEIE_Masked = 0x0
	// RXE interrupt not masked
	SPI_CR2_RXNEIE_NotMasked = 0x1
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Error interrupt masked
	SPI_CR2_ERRIE_Masked = 0x0
	// Error interrupt not masked
	SPI_CR2_ERRIE_NotMasked = 0x1
	// Position of FRF field.
	SPI_CR2_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR2_FRF_Msk = 0x10
	// Bit FRF.
	SPI_CR2_FRF = 0x10
	// SPI Motorola mode
	SPI_CR2_FRF_Motorola = 0x0
	// SPI TI mode
	SPI_CR2_FRF_TI = 0x1
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// SS output is disabled in master mode
	SPI_CR2_SSOE_Disabled = 0x0
	// SS output is enabled in master mode
	SPI_CR2_SSOE_Enabled = 0x1
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Tx buffer DMA disabled
	SPI_CR2_TXDMAEN_Disabled = 0x0
	// Tx buffer DMA enabled
	SPI_CR2_TXDMAEN_Enabled = 0x1
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1
	// Rx buffer DMA disabled
	SPI_CR2_RXDMAEN_Disabled = 0x0
	// Rx buffer DMA enabled
	SPI_CR2_RXDMAEN_Enabled = 0x1

	// SR: status register
	// Position of FRE field.
	SPI_SR_FRE_Pos = 0x8
	// Bit mask of FRE field.
	SPI_SR_FRE_Msk = 0x100
	// Bit FRE.
	SPI_SR_FRE = 0x100
	// No frame format error
	SPI_SR_FRE_NoError = 0x0
	// A frame format error occurred
	SPI_SR_FRE_Error = 0x1
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// SPI not busy
	SPI_SR_BSY_NotBusy = 0x0
	// SPI busy
	SPI_SR_BSY_Busy = 0x1
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// No overrun occurred
	SPI_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	SPI_SR_OVR_Overrun = 0x1
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// No mode fault occurred
	SPI_SR_MODF_NoFault = 0x0
	// Mode fault occurred
	SPI_SR_MODF_Fault = 0x1
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// CRC value received matches the SPIx_RXCRCR value
	SPI_SR_CRCERR_Match = 0x0
	// CRC value received does not match the SPIx_RXCRCR value
	SPI_SR_CRCERR_NoMatch = 0x1
	// Position of UDR field.
	SPI_SR_UDR_Pos = 0x3
	// Bit mask of UDR field.
	SPI_SR_UDR_Msk = 0x8
	// Bit UDR.
	SPI_SR_UDR = 0x8
	// No underrun occurred
	SPI_SR_UDR_NoUnderrun = 0x0
	// Underrun occurred
	SPI_SR_UDR_Underrun = 0x1
	// Position of CHSIDE field.
	SPI_SR_CHSIDE_Pos = 0x2
	// Bit mask of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4
	// Bit CHSIDE.
	SPI_SR_CHSIDE = 0x4
	// Channel left has to be transmitted or has been received
	SPI_SR_CHSIDE_Left = 0x0
	// Channel right has to be transmitted or has been received
	SPI_SR_CHSIDE_Right = 0x1
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Tx buffer not empty
	SPI_SR_TXE_NotEmpty = 0x0
	// Tx buffer empty
	SPI_SR_TXE_Empty = 0x1
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1
	// Rx buffer empty
	SPI_SR_RXNE_Empty = 0x0
	// Rx buffer not empty
	SPI_SR_RXNE_NotEmpty = 0x1

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff

	// I2SCFGR: I2S configuration register
	// Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Pos = 0xb
	// Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk = 0x800
	// Bit I2SMOD.
	SPI_I2SCFGR_I2SMOD = 0x800
	// SPI mode is selected
	SPI_I2SCFGR_I2SMOD_SPIMode = 0x0
	// I2S mode is selected
	SPI_I2SCFGR_I2SMOD_I2SMode = 0x1
	// Position of I2SE field.
	SPI_I2SCFGR_I2SE_Pos = 0xa
	// Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE_Msk = 0x400
	// Bit I2SE.
	SPI_I2SCFGR_I2SE = 0x400
	// I2S peripheral is disabled
	SPI_I2SCFGR_I2SE_Disabled = 0x0
	// I2S peripheral is enabled
	SPI_I2SCFGR_I2SE_Enabled = 0x1
	// Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Pos = 0x8
	// Bit mask of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk = 0x300
	// Slave - transmit
	SPI_I2SCFGR_I2SCFG_SlaveTx = 0x0
	// Slave - receive
	SPI_I2SCFGR_I2SCFG_SlaveRx = 0x1
	// Master - transmit
	SPI_I2SCFGR_I2SCFG_MasterTx = 0x2
	// Master - receive
	SPI_I2SCFGR_I2SCFG_MasterRx = 0x3
	// Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7
	// Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80
	// Bit PCMSYNC.
	SPI_I2SCFGR_PCMSYNC = 0x80
	// Short frame synchronisation
	SPI_I2SCFGR_PCMSYNC_Short = 0x0
	// Long frame synchronisation
	SPI_I2SCFGR_PCMSYNC_Long = 0x1
	// Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Pos = 0x4
	// Bit mask of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk = 0x30
	// I2S Philips standard
	SPI_I2SCFGR_I2SSTD_Philips = 0x0
	// MSB justified standard
	SPI_I2SCFGR_I2SSTD_MSB = 0x1
	// LSB justified standard
	SPI_I2SCFGR_I2SSTD_LSB = 0x2
	// PCM standard
	SPI_I2SCFGR_I2SSTD_PCM = 0x3
	// Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Pos = 0x3
	// Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk = 0x8
	// Bit CKPOL.
	SPI_I2SCFGR_CKPOL = 0x8
	// I2S clock inactive state is low level
	SPI_I2SCFGR_CKPOL_IdleLow = 0x0
	// I2S clock inactive state is high level
	SPI_I2SCFGR_CKPOL_IdleHigh = 0x1
	// Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Pos = 0x1
	// Bit mask of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk = 0x6
	// 16-bit data length
	SPI_I2SCFGR_DATLEN_SixteenBit = 0x0
	// 24-bit data length
	SPI_I2SCFGR_DATLEN_TwentyFourBit = 0x1
	// 32-bit data length
	SPI_I2SCFGR_DATLEN_ThirtyTwoBit = 0x2
	// Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Pos = 0x0
	// Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk = 0x1
	// Bit CHLEN.
	SPI_I2SCFGR_CHLEN = 0x1
	// 16-bit wide
	SPI_I2SCFGR_CHLEN_SixteenBit = 0x0
	// 32-bit wide
	SPI_I2SCFGR_CHLEN_ThirtyTwoBit = 0x1

	// I2SPR: I2S prescaler register
	// Position of MCKOE field.
	SPI_I2SPR_MCKOE_Pos = 0x9
	// Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE_Msk = 0x200
	// Bit MCKOE.
	SPI_I2SPR_MCKOE = 0x200
	// Master clock output is disabled
	SPI_I2SPR_MCKOE_Disabled = 0x0
	// Master clock output is enabled
	SPI_I2SPR_MCKOE_Enabled = 0x1
	// Position of ODD field.
	SPI_I2SPR_ODD_Pos = 0x8
	// Bit mask of ODD field.
	SPI_I2SPR_ODD_Msk = 0x100
	// Bit ODD.
	SPI_I2SPR_ODD = 0x100
	// Real divider value is I2SDIV * 2
	SPI_I2SPR_ODD_Even = 0x0
	// Real divider value is (I2SDIV * 2) + 1
	SPI_I2SPR_ODD_Odd = 0x1
	// Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Pos = 0x0
	// Bit mask of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff
)

// Constants for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER0_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff

	// ISER1: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER1_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff

	// ISER2: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER2_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER2_SETENA_Msk = 0xffffffff

	// ICER0: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER0_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff

	// ICER1: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER1_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff

	// ICER2: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER2_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER2_CLRENA_Msk = 0xffffffff

	// ISPR0: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff

	// ISPR1: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff

	// ISPR2: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR2_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR2_SETPEND_Msk = 0xffffffff

	// ICPR0: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff

	// ICPR1: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff

	// ICPR2: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Msk = 0xffffffff

	// IABR0: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff

	// IABR1: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff

	// IABR2: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR2_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR2_ACTIVE_Msk = 0xffffffff

	// IPR0: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000

	// IPR1: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000

	// IPR2: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000

	// IPR3: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000

	// IPR4: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000

	// IPR5: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000

	// IPR6: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000

	// IPR7: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000

	// IPR8: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000

	// IPR9: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000

	// IPR10: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000

	// IPR11: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000

	// IPR12: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000

	// IPR13: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000

	// IPR14: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Msk = 0xff000000

	// IPR15: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Msk = 0xff000000

	// IPR16: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Msk = 0xff000000

	// IPR17: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Msk = 0xff000000

	// IPR18: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Msk = 0xff000000

	// IPR19: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Msk = 0xff000000
)

// Constants for FPU: Floting point unit
const (
	// FPCCR: Floating-point context control register
	// Position of LSPACT field.
	FPU_FPCCR_LSPACT_Pos = 0x0
	// Bit mask of LSPACT field.
	FPU_FPCCR_LSPACT_Msk = 0x1
	// Bit LSPACT.
	FPU_FPCCR_LSPACT = 0x1
	// Position of USER field.
	FPU_FPCCR_USER_Pos = 0x1
	// Bit mask of USER field.
	FPU_FPCCR_USER_Msk = 0x2
	// Bit USER.
	FPU_FPCCR_USER = 0x2
	// Position of THREAD field.
	FPU_FPCCR_THREAD_Pos = 0x3
	// Bit mask of THREAD field.
	FPU_FPCCR_THREAD_Msk = 0x8
	// Bit THREAD.
	FPU_FPCCR_THREAD = 0x8
	// Position of HFRDY field.
	FPU_FPCCR_HFRDY_Pos = 0x4
	// Bit mask of HFRDY field.
	FPU_FPCCR_HFRDY_Msk = 0x10
	// Bit HFRDY.
	FPU_FPCCR_HFRDY = 0x10
	// Position of MMRDY field.
	FPU_FPCCR_MMRDY_Pos = 0x5
	// Bit mask of MMRDY field.
	FPU_FPCCR_MMRDY_Msk = 0x20
	// Bit MMRDY.
	FPU_FPCCR_MMRDY = 0x20
	// Position of BFRDY field.
	FPU_FPCCR_BFRDY_Pos = 0x6
	// Bit mask of BFRDY field.
	FPU_FPCCR_BFRDY_Msk = 0x40
	// Bit BFRDY.
	FPU_FPCCR_BFRDY = 0x40
	// Position of MONRDY field.
	FPU_FPCCR_MONRDY_Pos = 0x8
	// Bit mask of MONRDY field.
	FPU_FPCCR_MONRDY_Msk = 0x100
	// Bit MONRDY.
	FPU_FPCCR_MONRDY = 0x100
	// Position of LSPEN field.
	FPU_FPCCR_LSPEN_Pos = 0x1e
	// Bit mask of LSPEN field.
	FPU_FPCCR_LSPEN_Msk = 0x40000000
	// Bit LSPEN.
	FPU_FPCCR_LSPEN = 0x40000000
	// Position of ASPEN field.
	FPU_FPCCR_ASPEN_Pos = 0x1f
	// Bit mask of ASPEN field.
	FPU_FPCCR_ASPEN_Msk = 0x80000000
	// Bit ASPEN.
	FPU_FPCCR_ASPEN = 0x80000000

	// FPCAR: Floating-point context address register
	// Position of ADDRESS field.
	FPU_FPCAR_ADDRESS_Pos = 0x3
	// Bit mask of ADDRESS field.
	FPU_FPCAR_ADDRESS_Msk = 0xfffffff8

	// FPSCR: Floating-point status control register
	// Position of IOC field.
	FPU_FPSCR_IOC_Pos = 0x0
	// Bit mask of IOC field.
	FPU_FPSCR_IOC_Msk = 0x1
	// Bit IOC.
	FPU_FPSCR_IOC = 0x1
	// Position of DZC field.
	FPU_FPSCR_DZC_Pos = 0x1
	// Bit mask of DZC field.
	FPU_FPSCR_DZC_Msk = 0x2
	// Bit DZC.
	FPU_FPSCR_DZC = 0x2
	// Position of OFC field.
	FPU_FPSCR_OFC_Pos = 0x2
	// Bit mask of OFC field.
	FPU_FPSCR_OFC_Msk = 0x4
	// Bit OFC.
	FPU_FPSCR_OFC = 0x4
	// Position of UFC field.
	FPU_FPSCR_UFC_Pos = 0x3
	// Bit mask of UFC field.
	FPU_FPSCR_UFC_Msk = 0x8
	// Bit UFC.
	FPU_FPSCR_UFC = 0x8
	// Position of IXC field.
	FPU_FPSCR_IXC_Pos = 0x4
	// Bit mask of IXC field.
	FPU_FPSCR_IXC_Msk = 0x10
	// Bit IXC.
	FPU_FPSCR_IXC = 0x10
	// Position of IDC field.
	FPU_FPSCR_IDC_Pos = 0x7
	// Bit mask of IDC field.
	FPU_FPSCR_IDC_Msk = 0x80
	// Bit IDC.
	FPU_FPSCR_IDC = 0x80
	// Position of RMode field.
	FPU_FPSCR_RMode_Pos = 0x16
	// Bit mask of RMode field.
	FPU_FPSCR_RMode_Msk = 0xc00000
	// Position of FZ field.
	FPU_FPSCR_FZ_Pos = 0x18
	// Bit mask of FZ field.
	FPU_FPSCR_FZ_Msk = 0x1000000
	// Bit FZ.
	FPU_FPSCR_FZ = 0x1000000
	// Position of DN field.
	FPU_FPSCR_DN_Pos = 0x19
	// Bit mask of DN field.
	FPU_FPSCR_DN_Msk = 0x2000000
	// Bit DN.
	FPU_FPSCR_DN = 0x2000000
	// Position of AHP field.
	FPU_FPSCR_AHP_Pos = 0x1a
	// Bit mask of AHP field.
	FPU_FPSCR_AHP_Msk = 0x4000000
	// Bit AHP.
	FPU_FPSCR_AHP = 0x4000000
	// Position of V field.
	FPU_FPSCR_V_Pos = 0x1c
	// Bit mask of V field.
	FPU_FPSCR_V_Msk = 0x10000000
	// Bit V.
	FPU_FPSCR_V = 0x10000000
	// Position of C field.
	FPU_FPSCR_C_Pos = 0x1d
	// Bit mask of C field.
	FPU_FPSCR_C_Msk = 0x20000000
	// Bit C.
	FPU_FPSCR_C = 0x20000000
	// Position of Z field.
	FPU_FPSCR_Z_Pos = 0x1e
	// Bit mask of Z field.
	FPU_FPSCR_Z_Msk = 0x40000000
	// Bit Z.
	FPU_FPSCR_Z = 0x40000000
	// Position of N field.
	FPU_FPSCR_N_Pos = 0x1f
	// Bit mask of N field.
	FPU_FPSCR_N_Msk = 0x80000000
	// Bit N.
	FPU_FPSCR_N = 0x80000000
)

// Constants for MPU: Memory protection unit
const (
	// TYPER: MPU type register
	// Position of SEPARATE field.
	MPU_TYPER_SEPARATE_Pos = 0x0
	// Bit mask of SEPARATE field.
	MPU_TYPER_SEPARATE_Msk = 0x1
	// Bit SEPARATE.
	MPU_TYPER_SEPARATE = 0x1
	// Position of DREGION field.
	MPU_TYPER_DREGION_Pos = 0x8
	// Bit mask of DREGION field.
	MPU_TYPER_DREGION_Msk = 0xff00
	// Position of IREGION field.
	MPU_TYPER_IREGION_Pos = 0x10
	// Bit mask of IREGION field.
	MPU_TYPER_IREGION_Msk = 0xff0000

	// CTRL: MPU control register
	// Position of ENABLE field.
	MPU_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_CTRL_ENABLE = 0x1
	// Position of HFNMIENA field.
	MPU_CTRL_HFNMIENA_Pos = 0x1
	// Bit mask of HFNMIENA field.
	MPU_CTRL_HFNMIENA_Msk = 0x2
	// Bit HFNMIENA.
	MPU_CTRL_HFNMIENA = 0x2
	// Position of PRIVDEFENA field.
	MPU_CTRL_PRIVDEFENA_Pos = 0x2
	// Bit mask of PRIVDEFENA field.
	MPU_CTRL_PRIVDEFENA_Msk = 0x4
	// Bit PRIVDEFENA.
	MPU_CTRL_PRIVDEFENA = 0x4

	// RNR: MPU region number register
	// Position of REGION field.
	MPU_RNR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_RNR_REGION_Msk = 0xff

	// RBAR: MPU region base address register
	// Position of REGION field.
	MPU_RBAR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_RBAR_REGION_Msk = 0xf
	// Position of VALID field.
	MPU_RBAR_VALID_Pos = 0x4
	// Bit mask of VALID field.
	MPU_RBAR_VALID_Msk = 0x10
	// Bit VALID.
	MPU_RBAR_VALID = 0x10
	// Position of ADDR field.
	MPU_RBAR_ADDR_Pos = 0x5
	// Bit mask of ADDR field.
	MPU_RBAR_ADDR_Msk = 0xffffffe0

	// RASR: MPU region attribute and size register
	// Position of ENABLE field.
	MPU_RASR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_RASR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_RASR_ENABLE = 0x1
	// Position of SIZE field.
	MPU_RASR_SIZE_Pos = 0x1
	// Bit mask of SIZE field.
	MPU_RASR_SIZE_Msk = 0x3e
	// Position of SRD field.
	MPU_RASR_SRD_Pos = 0x8
	// Bit mask of SRD field.
	MPU_RASR_SRD_Msk = 0xff00
	// Position of B field.
	MPU_RASR_B_Pos = 0x10
	// Bit mask of B field.
	MPU_RASR_B_Msk = 0x10000
	// Bit B.
	MPU_RASR_B = 0x10000
	// Position of C field.
	MPU_RASR_C_Pos = 0x11
	// Bit mask of C field.
	MPU_RASR_C_Msk = 0x20000
	// Bit C.
	MPU_RASR_C = 0x20000
	// Position of S field.
	MPU_RASR_S_Pos = 0x12
	// Bit mask of S field.
	MPU_RASR_S_Msk = 0x40000
	// Bit S.
	MPU_RASR_S = 0x40000
	// Position of TEX field.
	MPU_RASR_TEX_Pos = 0x13
	// Bit mask of TEX field.
	MPU_RASR_TEX_Msk = 0x380000
	// Position of AP field.
	MPU_RASR_AP_Pos = 0x18
	// Bit mask of AP field.
	MPU_RASR_AP_Msk = 0x7000000
	// Position of XN field.
	MPU_RASR_XN_Pos = 0x1c
	// Bit mask of XN field.
	MPU_RASR_XN_Msk = 0x10000000
	// Bit XN.
	MPU_RASR_XN = 0x10000000
)

// Constants for STK: SysTick timer
const (
	// CTRL: SysTick control and status register
	// Position of ENABLE field.
	STK_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	STK_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	STK_CTRL_ENABLE = 0x1
	// Position of TICKINT field.
	STK_CTRL_TICKINT_Pos = 0x1
	// Bit mask of TICKINT field.
	STK_CTRL_TICKINT_Msk = 0x2
	// Bit TICKINT.
	STK_CTRL_TICKINT = 0x2
	// Position of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Pos = 0x2
	// Bit mask of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Msk = 0x4
	// Bit CLKSOURCE.
	STK_CTRL_CLKSOURCE = 0x4
	// Position of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Pos = 0x10
	// Bit mask of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Msk = 0x10000
	// Bit COUNTFLAG.
	STK_CTRL_COUNTFLAG = 0x10000

	// LOAD: SysTick reload value register
	// Position of RELOAD field.
	STK_LOAD_RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	STK_LOAD_RELOAD_Msk = 0xffffff

	// VAL: SysTick current value register
	// Position of CURRENT field.
	STK_VAL_CURRENT_Pos = 0x0
	// Bit mask of CURRENT field.
	STK_VAL_CURRENT_Msk = 0xffffff

	// CALIB: SysTick calibration value register
	// Position of TENMS field.
	STK_CALIB_TENMS_Pos = 0x0
	// Bit mask of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff
	// Position of SKEW field.
	STK_CALIB_SKEW_Pos = 0x1e
	// Bit mask of SKEW field.
	STK_CALIB_SKEW_Msk = 0x40000000
	// Bit SKEW.
	STK_CALIB_SKEW = 0x40000000
	// Position of NOREF field.
	STK_CALIB_NOREF_Pos = 0x1f
	// Bit mask of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000
	// Bit NOREF.
	STK_CALIB_NOREF = 0x80000000
)

// Constants for SCB: System control block
const (
	// CPUID: CPUID base register
	// Position of Revision field.
	SCB_CPUID_Revision_Pos = 0x0
	// Bit mask of Revision field.
	SCB_CPUID_Revision_Msk = 0xf
	// Position of PartNo field.
	SCB_CPUID_PartNo_Pos = 0x4
	// Bit mask of PartNo field.
	SCB_CPUID_PartNo_Msk = 0xfff0
	// Position of Constant field.
	SCB_CPUID_Constant_Pos = 0x10
	// Bit mask of Constant field.
	SCB_CPUID_Constant_Msk = 0xf0000
	// Position of Variant field.
	SCB_CPUID_Variant_Pos = 0x14
	// Bit mask of Variant field.
	SCB_CPUID_Variant_Msk = 0xf00000
	// Position of Implementer field.
	SCB_CPUID_Implementer_Pos = 0x18
	// Bit mask of Implementer field.
	SCB_CPUID_Implementer_Msk = 0xff000000

	// ICSR: Interrupt control and state register
	// Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Pos = 0x0
	// Bit mask of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk = 0x1ff
	// Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Pos = 0xb
	// Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk = 0x800
	// Bit RETTOBASE.
	SCB_ICSR_RETTOBASE = 0x800
	// Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Pos = 0xc
	// Bit mask of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000
	// Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Pos = 0x16
	// Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk = 0x400000
	// Bit ISRPENDING.
	SCB_ICSR_ISRPENDING = 0x400000
	// Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Pos = 0x19
	// Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk = 0x2000000
	// Bit PENDSTCLR.
	SCB_ICSR_PENDSTCLR = 0x2000000
	// Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Pos = 0x1a
	// Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk = 0x4000000
	// Bit PENDSTSET.
	SCB_ICSR_PENDSTSET = 0x4000000
	// Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Pos = 0x1b
	// Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk = 0x8000000
	// Bit PENDSVCLR.
	SCB_ICSR_PENDSVCLR = 0x8000000
	// Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Pos = 0x1c
	// Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk = 0x10000000
	// Bit PENDSVSET.
	SCB_ICSR_PENDSVSET = 0x10000000
	// Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Pos = 0x1f
	// Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk = 0x80000000
	// Bit NMIPENDSET.
	SCB_ICSR_NMIPENDSET = 0x80000000

	// VTOR: Vector table offset register
	// Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Pos = 0x9
	// Bit mask of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0x3ffffe00

	// AIRCR: Application interrupt and reset control register
	// Position of VECTRESET field.
	SCB_AIRCR_VECTRESET_Pos = 0x0
	// Bit mask of VECTRESET field.
	SCB_AIRCR_VECTRESET_Msk = 0x1
	// Bit VECTRESET.
	SCB_AIRCR_VECTRESET = 0x1
	// Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1
	// Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2
	// Bit VECTCLRACTIVE.
	SCB_AIRCR_VECTCLRACTIVE = 0x2
	// Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Pos = 0x2
	// Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk = 0x4
	// Bit SYSRESETREQ.
	SCB_AIRCR_SYSRESETREQ = 0x4
	// Position of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Pos = 0x8
	// Bit mask of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Msk = 0x700
	// Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Pos = 0xf
	// Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk = 0x8000
	// Bit ENDIANESS.
	SCB_AIRCR_ENDIANESS = 0x8000
	// Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Pos = 0x10
	// Bit mask of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk = 0xffff0000

	// SCR: System control register
	// Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Pos = 0x1
	// Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2
	// Bit SLEEPONEXIT.
	SCB_SCR_SLEEPONEXIT = 0x2
	// Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Pos = 0x2
	// Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk = 0x4
	// Bit SLEEPDEEP.
	SCB_SCR_SLEEPDEEP = 0x4
	// Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Pos = 0x4
	// Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk = 0x10
	// Bit SEVEONPEND.
	SCB_SCR_SEVEONPEND = 0x10

	// CCR: Configuration and control register
	// Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Pos = 0x0
	// Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1
	// Bit NONBASETHRDENA.
	SCB_CCR_NONBASETHRDENA = 0x1
	// Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Pos = 0x1
	// Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk = 0x2
	// Bit USERSETMPEND.
	SCB_CCR_USERSETMPEND = 0x2
	// Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Pos = 0x3
	// Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk = 0x8
	// Bit UNALIGN__TRP.
	SCB_CCR_UNALIGN__TRP = 0x8
	// Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Pos = 0x4
	// Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk = 0x10
	// Bit DIV_0_TRP.
	SCB_CCR_DIV_0_TRP = 0x10
	// Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Pos = 0x8
	// Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk = 0x100
	// Bit BFHFNMIGN.
	SCB_CCR_BFHFNMIGN = 0x100
	// Position of STKALIGN field.
	SCB_CCR_STKALIGN_Pos = 0x9
	// Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN_Msk = 0x200
	// Bit STKALIGN.
	SCB_CCR_STKALIGN = 0x200

	// SHPR1: System handler priority registers
	// Position of PRI_4 field.
	SCB_SHPR1_PRI_4_Pos = 0x0
	// Bit mask of PRI_4 field.
	SCB_SHPR1_PRI_4_Msk = 0xff
	// Position of PRI_5 field.
	SCB_SHPR1_PRI_5_Pos = 0x8
	// Bit mask of PRI_5 field.
	SCB_SHPR1_PRI_5_Msk = 0xff00
	// Position of PRI_6 field.
	SCB_SHPR1_PRI_6_Pos = 0x10
	// Bit mask of PRI_6 field.
	SCB_SHPR1_PRI_6_Msk = 0xff0000

	// SHPR2: System handler priority registers
	// Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Pos = 0x18
	// Bit mask of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000

	// SHPR3: System handler priority registers
	// Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Pos = 0x10
	// Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000
	// Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Pos = 0x18
	// Bit mask of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000

	// SHCRS: System handler control and state register
	// Position of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Pos = 0x0
	// Bit mask of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Msk = 0x1
	// Bit MEMFAULTACT.
	SCB_SHCRS_MEMFAULTACT = 0x1
	// Position of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Pos = 0x1
	// Bit mask of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Msk = 0x2
	// Bit BUSFAULTACT.
	SCB_SHCRS_BUSFAULTACT = 0x2
	// Position of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Pos = 0x3
	// Bit mask of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Msk = 0x8
	// Bit USGFAULTACT.
	SCB_SHCRS_USGFAULTACT = 0x8
	// Position of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Pos = 0x7
	// Bit mask of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Msk = 0x80
	// Bit SVCALLACT.
	SCB_SHCRS_SVCALLACT = 0x80
	// Position of MONITORACT field.
	SCB_SHCRS_MONITORACT_Pos = 0x8
	// Bit mask of MONITORACT field.
	SCB_SHCRS_MONITORACT_Msk = 0x100
	// Bit MONITORACT.
	SCB_SHCRS_MONITORACT = 0x100
	// Position of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Pos = 0xa
	// Bit mask of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Msk = 0x400
	// Bit PENDSVACT.
	SCB_SHCRS_PENDSVACT = 0x400
	// Position of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Pos = 0xb
	// Bit mask of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Msk = 0x800
	// Bit SYSTICKACT.
	SCB_SHCRS_SYSTICKACT = 0x800
	// Position of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Pos = 0xc
	// Bit mask of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Msk = 0x1000
	// Bit USGFAULTPENDED.
	SCB_SHCRS_USGFAULTPENDED = 0x1000
	// Position of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Pos = 0xd
	// Bit mask of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Msk = 0x2000
	// Bit MEMFAULTPENDED.
	SCB_SHCRS_MEMFAULTPENDED = 0x2000
	// Position of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Pos = 0xe
	// Bit mask of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Msk = 0x4000
	// Bit BUSFAULTPENDED.
	SCB_SHCRS_BUSFAULTPENDED = 0x4000
	// Position of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Pos = 0xf
	// Bit mask of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Msk = 0x8000
	// Bit SVCALLPENDED.
	SCB_SHCRS_SVCALLPENDED = 0x8000
	// Position of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Pos = 0x10
	// Bit mask of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Msk = 0x10000
	// Bit MEMFAULTENA.
	SCB_SHCRS_MEMFAULTENA = 0x10000
	// Position of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Pos = 0x11
	// Bit mask of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Msk = 0x20000
	// Bit BUSFAULTENA.
	SCB_SHCRS_BUSFAULTENA = 0x20000
	// Position of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Pos = 0x12
	// Bit mask of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Msk = 0x40000
	// Bit USGFAULTENA.
	SCB_SHCRS_USGFAULTENA = 0x40000

	// CFSR_UFSR_BFSR_MMFSR: Configurable fault status register
	// Position of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Pos = 0x1
	// Bit mask of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Msk = 0x2
	// Bit IACCVIOL.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL = 0x2
	// Position of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Pos = 0x3
	// Bit mask of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Msk = 0x8
	// Bit MUNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR = 0x8
	// Position of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Pos = 0x4
	// Bit mask of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Msk = 0x10
	// Bit MSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR = 0x10
	// Position of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Pos = 0x5
	// Bit mask of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Msk = 0x20
	// Bit MLSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR = 0x20
	// Position of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Pos = 0x7
	// Bit mask of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Msk = 0x80
	// Bit MMARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID = 0x80
	// Position of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Pos = 0x8
	// Bit mask of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Msk = 0x100
	// Bit IBUSERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR = 0x100
	// Position of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Pos = 0x9
	// Bit mask of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Msk = 0x200
	// Bit PRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR = 0x200
	// Position of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Pos = 0xa
	// Bit mask of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Msk = 0x400
	// Bit IMPRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR = 0x400
	// Position of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Pos = 0xb
	// Bit mask of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Msk = 0x800
	// Bit UNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR = 0x800
	// Position of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Pos = 0xc
	// Bit mask of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Msk = 0x1000
	// Bit STKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR = 0x1000
	// Position of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Pos = 0xd
	// Bit mask of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Msk = 0x2000
	// Bit LSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR = 0x2000
	// Position of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Pos = 0xf
	// Bit mask of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Msk = 0x8000
	// Bit BFARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID = 0x8000
	// Position of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Pos = 0x10
	// Bit mask of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Msk = 0x10000
	// Bit UNDEFINSTR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR = 0x10000
	// Position of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Pos = 0x11
	// Bit mask of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Msk = 0x20000
	// Bit INVSTATE.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE = 0x20000
	// Position of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Pos = 0x12
	// Bit mask of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Msk = 0x40000
	// Bit INVPC.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC = 0x40000
	// Position of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Pos = 0x13
	// Bit mask of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Msk = 0x80000
	// Bit NOCP.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP = 0x80000
	// Position of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Pos = 0x18
	// Bit mask of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Msk = 0x1000000
	// Bit UNALIGNED.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED = 0x1000000
	// Position of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Pos = 0x19
	// Bit mask of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Msk = 0x2000000
	// Bit DIVBYZERO.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO = 0x2000000

	// HFSR: Hard fault status register
	// Position of VECTTBL field.
	SCB_HFSR_VECTTBL_Pos = 0x1
	// Bit mask of VECTTBL field.
	SCB_HFSR_VECTTBL_Msk = 0x2
	// Bit VECTTBL.
	SCB_HFSR_VECTTBL = 0x2
	// Position of FORCED field.
	SCB_HFSR_FORCED_Pos = 0x1e
	// Bit mask of FORCED field.
	SCB_HFSR_FORCED_Msk = 0x40000000
	// Bit FORCED.
	SCB_HFSR_FORCED = 0x40000000
	// Position of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Pos = 0x1f
	// Bit mask of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Msk = 0x80000000
	// Bit DEBUG_VT.
	SCB_HFSR_DEBUG_VT = 0x80000000

	// MMFAR: Memory management fault address register
	// Position of MMFAR field.
	SCB_MMFAR_MMFAR_Pos = 0x0
	// Bit mask of MMFAR field.
	SCB_MMFAR_MMFAR_Msk = 0xffffffff

	// BFAR: Bus fault address register
	// Position of BFAR field.
	SCB_BFAR_BFAR_Pos = 0x0
	// Bit mask of BFAR field.
	SCB_BFAR_BFAR_Msk = 0xffffffff

	// AFSR: Auxiliary fault status register
	// Position of IMPDEF field.
	SCB_AFSR_IMPDEF_Pos = 0x0
	// Bit mask of IMPDEF field.
	SCB_AFSR_IMPDEF_Msk = 0xffffffff
)
