/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership.cloud;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.cloud.CloudMembershipProvider;
import org.apache.catalina.tribes.membership.cloud.CloudMembershipService;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class DNSMembershipProvider
extends CloudMembershipProvider {
    private static final Log log = LogFactory.getLog(DNSMembershipProvider.class);
    private String dnsServiceName;

    @Override
    public void start(int n) throws Exception {
        if ((n & 4) == 0) {
            return;
        }
        super.start(n);
        this.dnsServiceName = DNSMembershipProvider.getEnv("DNS_MEMBERSHIP_SERVICE_NAME");
        if (this.dnsServiceName == null) {
            this.dnsServiceName = this.getNamespace();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("cloudMembershipProvider.start", this.dnsServiceName));
        }
        this.dnsServiceName = URLEncoder.encode(this.dnsServiceName, StandardCharsets.UTF_8);
        this.heartbeat();
    }

    @Override
    public boolean stop(int n) throws Exception {
        return super.stop(n);
    }

    @Override
    protected Member[] fetchMembers() {
        ArrayList<MemberImpl> arrayList = new ArrayList<MemberImpl>();
        InetAddress[] inetAddressArray = null;
        try {
            inetAddressArray = InetAddress.getAllByName(this.dnsServiceName);
        }
        catch (UnknownHostException unknownHostException) {
            log.warn((Object)sm.getString("dnsMembershipProvider.dnsError", this.dnsServiceName), (Throwable)unknownHostException);
        }
        if (inetAddressArray != null) {
            for (InetAddress inetAddress : inetAddressArray) {
                MemberImpl memberImpl;
                String string = inetAddress.getHostAddress();
                byte[] byArray = this.md5.digest(string.getBytes());
                if (string.equals(this.localIp)) {
                    Member member = this.service.getLocalMember(false);
                    if (member.getUniqueId() != CloudMembershipService.INITIAL_ID || !(member instanceof MemberImpl)) continue;
                    ((MemberImpl)member).setUniqueId(byArray);
                    continue;
                }
                long l = -1L;
                try {
                    memberImpl = new MemberImpl(string, this.port, l);
                }
                catch (IOException iOException) {
                    log.error((Object)sm.getString("kubernetesMembershipProvider.memberError"), (Throwable)iOException);
                    continue;
                }
                memberImpl.setUniqueId(byArray);
                arrayList.add(memberImpl);
            }
        }
        return arrayList.toArray(new Member[0]);
    }

    @Override
    public boolean accept(Serializable serializable, Member member) {
        boolean bl = false;
        Member[] memberArray = this.membership.getMembers();
        if (memberArray != null) {
            for (Member object : memberArray) {
                if (!Arrays.equals(member.getHost(), object.getHost()) || member.getPort() != object.getPort()) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            MemberImpl memberImpl = new MemberImpl();
            memberImpl.setHost(member.getHost());
            memberImpl.setPort(member.getPort());
            byte[] byArray = member.getHost();
            int n = 0;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(byArray[n++] & 0xFF);
            while (n < byArray.length) {
                stringBuilder.append('.').append(byArray[n] & 0xFF);
                ++n;
            }
            byte[] byArray2 = this.md5.digest(stringBuilder.toString().getBytes());
            memberImpl.setUniqueId(byArray2);
            memberImpl.setMemberAliveTime(-1L);
            this.updateMember(memberImpl, true);
        }
        return false;
    }
}

