/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager.util;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import javax.security.auth.Subject;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Session;
import org.apache.tomcat.util.ExceptionUtils;

public class SessionUtils {
    private static final String STRUTS_LOCALE_KEY = "org.apache.struts.action.LOCALE";
    private static final String JSTL_LOCALE_KEY = "javax.servlet.jsp.jstl.fmt.locale";
    private static final String SPRING_LOCALE_KEY = "org.springframework.web.servlet.i18n.SessionLocaleResolver.LOCALE";
    private static final String[] LOCALE_TEST_ATTRIBUTES = new String[]{"org.apache.struts.action.LOCALE", "org.springframework.web.servlet.i18n.SessionLocaleResolver.LOCALE", "javax.servlet.jsp.jstl.fmt.locale", "Locale", "java.util.Locale"};
    private static final String[] USER_TEST_ATTRIBUTES = new String[]{"Login", "User", "userName", "UserName", "Utilisateur", "SPRING_SECURITY_LAST_USERNAME"};

    private SessionUtils() {
    }

    public static Locale guessLocaleFromSession(Session session) {
        return SessionUtils.guessLocaleFromSession(session.getSession());
    }

    public static Locale guessLocaleFromSession(HttpSession httpSession) {
        if (null == httpSession) {
            return null;
        }
        try {
            Object object;
            Locale locale = null;
            for (String object22 : LOCALE_TEST_ATTRIBUTES) {
                object = httpSession.getAttribute(object22);
                if (object instanceof Locale) {
                    locale = (Locale)object;
                    break;
                }
                object = httpSession.getAttribute(object22.toLowerCase(Locale.ENGLISH));
                if (object instanceof Locale) {
                    locale = (Locale)object;
                    break;
                }
                object = httpSession.getAttribute(object22.toUpperCase(Locale.ENGLISH));
                if (!(object instanceof Locale)) continue;
                locale = (Locale)object;
                break;
            }
            if (null != locale) {
                return locale;
            }
            ArrayList arrayList = new ArrayList();
            Object object3 = httpSession.getAttributeNames();
            while (object3.hasMoreElements()) {
                String string = (String)object3.nextElement();
                if (!string.contains("tapestry") || !string.contains("engine") || null == httpSession.getAttribute(string)) continue;
                arrayList.add(httpSession.getAttribute(string));
            }
            if (arrayList.size() == 1 && null != (object3 = arrayList.get(0))) {
                try {
                    Method method = object3.getClass().getMethod("getLocale", null);
                    Object object2 = method.invoke(object3, (Object[])null);
                    if (object2 instanceof Locale) {
                        locale = (Locale)object2;
                    }
                }
                catch (Exception exception) {
                    Throwable throwable = ExceptionUtils.unwrapInvocationTargetException((Throwable)exception);
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
            }
            if (null != locale) {
                return locale;
            }
            object3 = new ArrayList();
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                object = httpSession.getAttribute(string);
                if (!(object instanceof Locale)) continue;
                object3.add(object);
            }
            if (object3.size() == 1) {
                locale = (Locale)object3.get(0);
            }
            return locale;
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    public static Object guessUserFromSession(Session session) {
        if (null == session) {
            return null;
        }
        if (session.getPrincipal() != null) {
            return session.getPrincipal().getName();
        }
        HttpSession httpSession = session.getSession();
        if (httpSession == null) {
            return null;
        }
        try {
            Object object = null;
            for (String object2 : USER_TEST_ATTRIBUTES) {
                Object object3 = httpSession.getAttribute(object2);
                if (null != object3) {
                    object = object3;
                    break;
                }
                object3 = httpSession.getAttribute(object2.toLowerCase(Locale.ENGLISH));
                if (null != object3) {
                    object = object3;
                    break;
                }
                object3 = httpSession.getAttribute(object2.toUpperCase(Locale.ENGLISH));
                if (null == object3) continue;
                object = object3;
                break;
            }
            if (null != object) {
                return object;
            }
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object4 = httpSession.getAttribute(string);
                if (!(object4 instanceof Principal) && !(object4 instanceof Subject)) continue;
                arrayList.add(object4);
            }
            if (arrayList.size() == 1) {
                object = arrayList.get(0);
            }
            if (null != object) {
                return object;
            }
            return object;
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    public static long getUsedTimeForSession(Session session) {
        try {
            long l = session.getThisAccessedTime() - session.getCreationTime();
            return l;
        }
        catch (IllegalStateException illegalStateException) {
            return -1L;
        }
    }

    public static long getTTLForSession(Session session) {
        try {
            long l = (long)(1000 * session.getMaxInactiveInterval()) - (System.currentTimeMillis() - session.getThisAccessedTime());
            return l;
        }
        catch (IllegalStateException illegalStateException) {
            return -1L;
        }
    }

    public static long getInactiveTimeForSession(Session session) {
        try {
            long l = System.currentTimeMillis() - session.getThisAccessedTime();
            return l;
        }
        catch (IllegalStateException illegalStateException) {
            return -1L;
        }
    }
}

