/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_7_2;

import java.util.List;
import org.virtualbox_7_2.Helper;
import org.virtualbox_7_2.IEvent;
import org.virtualbox_7_2.IEventListener;
import org.virtualbox_7_2.IUnknown;
import org.virtualbox_7_2.ObjectRefManager;
import org.virtualbox_7_2.VBoxEventType;
import org.virtualbox_7_2.VBoxException;
import org.virtualbox_7_2.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_7_2.jaxws.RuntimeFaultMsg;
import org.virtualbox_7_2.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IEventSource
extends IUnknown {
    public IEventSource(String string, ObjectRefManager objectRefManager, VboxPortType vboxPortType) {
        super(string, objectRefManager, vboxPortType);
    }

    public static IEventSource queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IEventSource(iUnknown.getWrapped(), iUnknown.getObjMgr(), iUnknown.getRemoteWSPort());
    }

    public IEventListener createListener() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iEventSourceCreateListener(this.obj);
            IEventListener iEventListener = string.length() > 0 ? new IEventListener(string, this.getObjMgr(), this.port) : null;
            return iEventListener;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IEventSource createAggregator(List<IEventSource> list) {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iEventSourceCreateAggregator(this.obj, Helper.unwrap(list));
            IEventSource iEventSource = string.length() > 0 ? new IEventSource(string, this.getObjMgr(), this.port) : null;
            return iEventSource;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public void registerListener(IEventListener iEventListener, List<VBoxEventType> list, Boolean bl) {
        try {
            this.port.iEventSourceRegisterListener(this.obj, iEventListener == null ? null : iEventListener.getWrapped(), Helper.convertEnums(VBoxEventType.class, org.virtualbox_7_2.jaxws.VBoxEventType.class, list), bl);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void unregisterListener(IEventListener iEventListener) {
        try {
            this.port.iEventSourceUnregisterListener(this.obj, iEventListener == null ? null : iEventListener.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Boolean fireEvent(IEvent iEvent, Integer n) {
        try {
            Boolean bl = this.port.iEventSourceFireEvent(this.obj, iEvent == null ? null : iEvent.getWrapped(), n);
            return bl;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IEvent getEvent(IEventListener iEventListener, Integer n) {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iEventSourceGetEvent(this.obj, iEventListener == null ? null : iEventListener.getWrapped(), n);
            IEvent iEvent = string.length() > 0 ? new IEvent(string, this.getObjMgr(), this.port) : null;
            return iEvent;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public void eventProcessed(IEventListener iEventListener, IEvent iEvent) {
        try {
            this.port.iEventSourceEventProcessed(this.obj, iEventListener == null ? null : iEventListener.getWrapped(), iEvent == null ? null : iEvent.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }
}

