/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import org.graalvm.visualvm.heapviewer.java.Bundle;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;

public class ThreadNode
extends InstanceNode
implements CCTNode.DoNotSortChildren {
    private final String name;
    private final boolean isOOME;
    private final Thread.State state;

    public ThreadNode(String name, Instance instance) {
        this(name, null, false, instance);
    }

    public ThreadNode(String name, Thread.State state, Instance instance) {
        this(name, state, false, instance);
    }

    public ThreadNode(String name, Thread.State state, boolean isOOME, Instance instance) {
        super(instance);
        this.name = name;
        this.isOOME = isOOME;
        this.state = state;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isOOMEThread() {
        return this.isOOME;
    }

    public Thread.State getState() {
        return this.state;
    }

    public static class Unknown
    extends ThreadNode {
        public Unknown() {
            super(Bundle.ThreadNode_UnknownThread(), null, null);
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode((Object)this);
        }

        @Override
        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.OWN_SIZE) {
                return DataType.OWN_SIZE.getNoValue();
            }
            if (type == DataType.RETAINED_SIZE) {
                return DataType.RETAINED_SIZE.getNoValue();
            }
            if (type == DataType.INSTANCE) {
                return DataType.INSTANCE.getNoValue();
            }
            if (type == DataType.CLASS) {
                return DataType.CLASS.getNoValue();
            }
            if (type == DataType.LOGICAL_VALUE) {
                return DataType.LOGICAL_VALUE.getNoValue();
            }
            if (type == DataType.NAME) {
                return DataType.NAME.getNoValue();
            }
            return super.getValue(type, heap);
        }
    }
}

