/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zaproxy.zap.authentication.AuthenticationCredentials;

public abstract class TotpAuthenticationCredentials
implements AuthenticationCredentials {
    private static final Logger LOGGER = LogManager.getLogger(TotpAuthenticationCredentials.class);
    private static final String TOTP_ALGORITHM = "totpAlgorithm";
    private static final String TOTP_DIGITS = "totpDigits";
    private static final String TOTP_PERIOD = "totpPeriod";
    private static final String TOTP_SECRET = "totpSecret";
    private static final List<String> API_PARAMETERS = List.of("totpAlgorithm", "totpDigits", "totpPeriod", "totpSecret");
    private static TotpGenerator generator;
    private final boolean enabled;
    private TotpData totpData;

    protected TotpAuthenticationCredentials(boolean enabled) {
        this.enabled = enabled;
        this.totpData = TotpData.EMPTY;
    }

    public boolean isTotpEnabled() {
        return generator != null && this.enabled;
    }

    public TotpData getTotpData() {
        return this.totpData;
    }

    public void setTotpData(TotpData totpData) {
        this.totpData = totpData == null ? TotpData.EMPTY : totpData;
    }

    @Override
    public String getTotpCode(Instant when) {
        if (!this.enabled) {
            return null;
        }
        if (when == null) {
            throw new IllegalArgumentException("Parameter when must not be null.");
        }
        TotpGenerator impl = generator;
        if (impl != null) {
            try {
                return impl.generate(this.totpData, when);
            }
            catch (Exception e) {
                LOGGER.warn("An error occurred while generating the code:", (Throwable)e);
            }
        }
        return null;
    }

    protected void setTotpData(Map<String, Object> map) {
        if (!this.enabled) {
            return;
        }
        map.put(TOTP_SECRET, this.totpData.secret());
        map.put(TOTP_PERIOD, this.totpData.period());
        map.put(TOTP_DIGITS, this.totpData.digits());
        map.put(TOTP_ALGORITHM, this.totpData.algorithm());
    }

    protected void readTotpData(JSONObject params) {
        if (!this.enabled) {
            return;
        }
        String secret = params.optString(TOTP_SECRET);
        if (secret.isEmpty()) {
            return;
        }
        this.setTotpData(new TotpData(secret, params.optInt(TOTP_PERIOD, TotpData.EMPTY.period()), params.optInt(TOTP_DIGITS, TotpData.EMPTY.digits()), params.optString(TOTP_ALGORITHM, TotpData.EMPTY.algorithm())));
    }

    protected void encodeTotpData(StringBuilder out, String separator) {
        if (!this.enabled) {
            return;
        }
        out.append(TotpAuthenticationCredentials.base64Encode(this.totpData.secret())).append(separator).append(this.totpData.period()).append(separator).append(this.totpData.digits()).append(separator).append(TotpAuthenticationCredentials.base64Encode(this.totpData.algorithm())).append(separator);
    }

    private static String base64Encode(String value) {
        return Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
    }

    protected void decodeTotpData(List<String> data) {
        if (!this.enabled || data.size() != 4) {
            return;
        }
        this.setTotpData(new TotpData(TotpAuthenticationCredentials.base64Decode(data.get(0)), TotpAuthenticationCredentials.getInt(data.get(1), TotpData.EMPTY.period()), TotpAuthenticationCredentials.getInt(data.get(2), TotpData.EMPTY.digits()), TotpAuthenticationCredentials.base64Decode(data.get(3))));
    }

    private static String base64Decode(String value) {
        return new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
    }

    private static int getInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("An error occurred while parsing: {}", (Object)value, (Object)e);
            return defaultValue;
        }
    }

    public static List<String> getApiParameters() {
        return API_PARAMETERS;
    }

    public static void setTotpGenerator(TotpGenerator generator) {
        TotpAuthenticationCredentials.generator = generator;
    }

    static TotpGenerator getGenerator() {
        return generator;
    }

    public record TotpData(String secret, int period, int digits, String algorithm) {
        public static final TotpData EMPTY = new TotpData("");

        public TotpData(String secret) {
            this(secret, 30, 6, "SHA1");
        }
    }

    public static interface TotpGenerator {
        public String generate(TotpData var1, Instant var2);

        public List<String> getSupportedAlgorithms();
    }
}

