/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.eventBus;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.eventBus.EventBus;
import org.zaproxy.zap.eventBus.EventConsumer;
import org.zaproxy.zap.eventBus.EventPublisher;

public class SimpleEventBus
implements EventBus {
    private Map<String, RegisteredPublisher> nameToPublisher = new HashMap<String, RegisteredPublisher>();
    private List<RegisteredConsumer> danglingConsumers = new ArrayList<RegisteredConsumer>();
    private final Lock regMgmtLock = new ReentrantLock(true);
    private static final Logger LOGGER = LogManager.getLogger(SimpleEventBus.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPublisher(EventPublisher publisher, String ... eventTypes) {
        if (publisher == null) {
            throw new InvalidParameterException("Publisher must not be null");
        }
        if (eventTypes == null || eventTypes.length == 0) {
            throw new InvalidParameterException("At least one event type must be specified");
        }
        this.regMgmtLock.lock();
        try {
            String publisherName = publisher.getPublisherName();
            if (this.nameToPublisher.get(publisherName) != null) {
                throw new InvalidParameterException("Publisher with name " + publisherName + " already registered by " + this.nameToPublisher.get(publisherName).getPublisher().getClass().getCanonicalName());
            }
            LOGGER.debug("registerPublisher {}", (Object)publisherName);
            RegisteredPublisher regProd = new RegisteredPublisher(publisher, new HashSet<String>(Arrays.asList(eventTypes)));
            ArrayList<RegisteredConsumer> consumers = new ArrayList<RegisteredConsumer>();
            SimpleEventBus.moveConsumers(this.danglingConsumers, consumer -> consumer.getPublisherName().equals(publisherName), consumers::add);
            regProd.addConsumers(consumers);
            this.nameToPublisher.put(publisherName, regProd);
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    private static void moveConsumers(Collection<RegisteredConsumer> source, Predicate<RegisteredConsumer> condition, Consumer<RegisteredConsumer> sink) {
        source.removeIf(item -> {
            if (condition.test((RegisteredConsumer)item)) {
                sink.accept((RegisteredConsumer)item);
                return true;
            }
            return false;
        });
    }

    @Override
    public void unregisterPublisher(EventPublisher publisher) {
        if (publisher == null) {
            throw new InvalidParameterException("Publisher must not be null");
        }
        this.regMgmtLock.lock();
        try {
            String publisherName = publisher.getPublisherName();
            LOGGER.debug("unregisterPublisher {}", (Object)publisherName);
            if (this.nameToPublisher.remove(publisherName) == null) {
                throw new InvalidParameterException("Publisher with name " + publisherName + " not registered");
            }
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    @Override
    public void registerConsumer(EventConsumer consumer, String publisherName) {
        this.registerConsumer(consumer, publisherName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConsumer(EventConsumer consumer, String publisherName, String ... eventTypes) {
        if (consumer == null) {
            throw new InvalidParameterException("Consumer must not be null");
        }
        HashSet<String> eventTypesSet = eventTypes == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(eventTypes));
        this.regMgmtLock.lock();
        try {
            LOGGER.debug("registerConsumer {} for {}", (Object)consumer.getClass().getCanonicalName(), (Object)publisherName);
            RegisteredPublisher publisher = this.nameToPublisher.get(publisherName);
            if (publisher == null) {
                this.danglingConsumers.add(new RegisteredConsumer(consumer, eventTypesSet, publisherName));
            } else {
                publisher.addConsumer(new RegisteredConsumer(consumer, eventTypesSet));
            }
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    @Override
    public void unregisterConsumer(EventConsumer consumer) {
        if (consumer == null) {
            throw new InvalidParameterException("Consumer must not be null");
        }
        this.regMgmtLock.lock();
        try {
            LOGGER.debug("unregisterConsumer {}", (Object)consumer.getClass().getCanonicalName());
            this.nameToPublisher.values().forEach(publisher -> publisher.removeConsumer(consumer));
            this.removeDanglingConsumer(consumer);
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    private void removeDanglingConsumer(EventConsumer consumer) {
        this.danglingConsumers.removeIf(registeredConsumer -> registeredConsumer.getConsumer().equals(consumer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConsumer(EventConsumer consumer, String publisherName) {
        if (consumer == null) {
            throw new InvalidParameterException("Consumer must not be null");
        }
        this.regMgmtLock.lock();
        try {
            LOGGER.debug("unregisterConsumer {} for {}", (Object)consumer.getClass().getCanonicalName(), (Object)publisherName);
            RegisteredPublisher publisher = this.nameToPublisher.get(publisherName);
            if (publisher == null) {
                this.removeDanglingConsumer(consumer);
            } else {
                publisher.removeConsumer(consumer);
            }
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    @Override
    public void publishSyncEvent(EventPublisher publisher, Event event) {
        if (publisher == null) {
            throw new InvalidParameterException("Publisher must not be null");
        }
        String publisherName = publisher.getPublisherName();
        String eventType = event.getEventType();
        RegisteredPublisher regPublisher = this.nameToPublisher.get(publisherName);
        if (regPublisher == null) {
            throw new InvalidParameterException("Publisher not registered: " + publisherName);
        }
        LOGGER.debug("publishSyncEvent {} from {}", (Object)eventType, (Object)publisherName);
        if (!regPublisher.isEventRegistered(eventType)) {
            throw new InvalidParameterException("Event type: " + eventType + " not registered for publisher: " + publisherName);
        }
        regPublisher.getConsumers().filter(consumer -> consumer.wantsEvent(eventType)).forEach(regCon -> {
            try {
                regCon.getConsumer().eventReceived(event);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    @Override
    public Set<String> getPublisherNames() {
        return Collections.unmodifiableSet(this.nameToPublisher.keySet());
    }

    @Override
    public Set<String> getEventTypesForPublisher(String publisherName) {
        RegisteredPublisher publisher = this.nameToPublisher.get(publisherName);
        if (publisher != null) {
            return Collections.unmodifiableSet(publisher.getEventTypes());
        }
        return Collections.emptySet();
    }

    private static class RegisteredPublisher {
        private EventPublisher publisher;
        private Set<String> eventTypes = new HashSet<String>();
        private List<RegisteredConsumer> consumers = new CopyOnWriteArrayList<RegisteredConsumer>();

        RegisteredPublisher(EventPublisher publisher, Set<String> eventTypes) {
            this.publisher = publisher;
            this.eventTypes.addAll(eventTypes);
        }

        EventPublisher getPublisher() {
            return this.publisher;
        }

        boolean isEventRegistered(String eventType) {
            return this.eventTypes.contains(eventType);
        }

        Stream<RegisteredConsumer> getConsumers() {
            return this.consumers.stream();
        }

        void addConsumer(RegisteredConsumer consumer) {
            this.consumers.add(consumer);
        }

        void addConsumers(List<RegisteredConsumer> registeredConsumers) {
            this.consumers.addAll(registeredConsumers);
        }

        void removeConsumer(EventConsumer consumer) {
            this.consumers.removeIf(registeredConsumer -> registeredConsumer.getConsumer().equals(consumer));
        }

        public Set<String> getEventTypes() {
            return this.eventTypes;
        }
    }

    private static class RegisteredConsumer {
        private EventConsumer consumer;
        private Set<String> eventTypes = new HashSet<String>();
        private String publisherName;

        RegisteredConsumer(EventConsumer consumer, Set<String> eventTypes) {
            this.consumer = consumer;
            this.eventTypes.addAll(eventTypes);
        }

        RegisteredConsumer(EventConsumer consumer, Set<String> eventTypes, String publisherName) {
            this(consumer, eventTypes);
            this.publisherName = publisherName;
        }

        EventConsumer getConsumer() {
            return this.consumer;
        }

        boolean wantsEvent(String eventType) {
            return this.eventTypes.isEmpty() || this.eventTypes.contains(eventType);
        }

        String getPublisherName() {
            return this.publisherName;
        }
    }
}

