/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authorization;

import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.authorization.BasicAuthorizationDetectionMethod;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.utils.ApiUtils;

public class AuthorizationAPI
extends ApiImplementor {
    private static final Logger LOGGER = LogManager.getLogger(AuthorizationAPI.class);
    private static final String PREFIX = "authorization";
    private static final String VIEW_GET_AUTHORIZATION_METHOD = "getAuthorizationDetectionMethod";
    private static final String ACTION_SET_AUTHORIZATION_METHOD = "setBasicAuthorizationDetectionMethod";
    public static final String PARAM_CONTEXT_ID = "contextId";
    public static final String PARAM_HEADER_REGEX = "headerRegex";
    public static final String PARAM_BODY_REGEX = "bodyRegex";
    public static final String PARAM_STATUS_CODE = "statusCode";
    public static final String PARAM_LOGICAL_OPERATOR = "logicalOperator";
    public static final String RESPONSE_TYPE = "methodType";
    public static final String RESPONSE_TAG = "authorizationDetectionMethod";

    public AuthorizationAPI() {
        this.addApiView(new ApiView(VIEW_GET_AUTHORIZATION_METHOD, new String[]{PARAM_CONTEXT_ID}));
        this.addApiAction(new ApiAction(ACTION_SET_AUTHORIZATION_METHOD, new String[]{PARAM_CONTEXT_ID}, new String[]{PARAM_HEADER_REGEX, PARAM_BODY_REGEX, PARAM_STATUS_CODE, PARAM_LOGICAL_OPERATOR}));
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        LOGGER.debug("handleApiView {} {}", (Object)name, (Object)params);
        switch (name) {
            case "getAuthorizationDetectionMethod": {
                Context context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                return new ApiResponseElement(context.getAuthorizationDetectionMethod().getApiResponseRepresentation());
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        LOGGER.debug("handleApiAction {} {}", (Object)name, (Object)params);
        switch (name) {
            case "setBasicAuthorizationDetectionMethod": {
                Context context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                String headerRegex = params.optString(PARAM_HEADER_REGEX, null);
                String bodyRegex = params.optString(PARAM_BODY_REGEX, null);
                BasicAuthorizationDetectionMethod.LogicalOperator logicalOperator = ApiUtils.getOptionalEnumParam(params, PARAM_LOGICAL_OPERATOR, BasicAuthorizationDetectionMethod.LogicalOperator.class);
                if (logicalOperator == null) {
                    logicalOperator = BasicAuthorizationDetectionMethod.LogicalOperator.AND;
                }
                int statusCode = params.optInt(PARAM_STATUS_CODE, -1);
                LOGGER.debug("Setting basic authorization detection to: {} / {} / {} / {}", (Object)headerRegex, (Object)bodyRegex, (Object)statusCode, (Object)logicalOperator);
                BasicAuthorizationDetectionMethod method = new BasicAuthorizationDetectionMethod((Integer)statusCode, headerRegex, bodyRegex, logicalOperator);
                context.setAuthorizationDetectionMethod(method);
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }
}

