/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.spider.DialogAddDomainAlwaysInScope;
import org.zaproxy.zap.extension.spider.DialogModifyDomainAlwaysInScope;
import org.zaproxy.zap.extension.spider.DomainsAlwaysInScopeTableModel;
import org.zaproxy.zap.spider.DomainAlwaysInScopeMatcher;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.PositiveValuesSlider;

@Deprecated
public class OptionsSpiderPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = -5623691753271231473L;
    private JPanel panelSpider = null;
    private JSlider sliderMaxDepth = null;
    private JSlider sliderThreads = null;
    private ZapNumberSpinner durationNumberSpinner = null;
    private ZapNumberSpinner maxChildrenNumberSpinner;
    private ZapNumberSpinner maxParseSizeBytesNumberSpinner;
    private JCheckBox chkPostForm = null;
    private JCheckBox chkProcessForm = null;
    private JCheckBox parseComments = null;
    private JCheckBox parseRobotsTxt = null;
    private JCheckBox parseSitemapXml = null;
    private JCheckBox parseSVNEntries = null;
    private JCheckBox parseGit = null;
    private JCheckBox handleODataSpecificParameters = null;
    private JCheckBox chkSendRefererHeader;
    private JCheckBox chkAcceptCookies;
    private DomainsAlwaysInScopeMultipleOptionsPanel domainsAlwaysInScopePanel;
    private DomainsAlwaysInScopeTableModel domainsAlwaysInScopeTableModel;
    private ZapTextArea irrelevantUrlParameters;
    private JComboBox<SpiderParam.HandleParametersOption> handleParameters = null;

    public OptionsSpiderPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("spider.options.title"));
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(314, 245);
        }
        this.add((Component)this.getPanelSpider(), this.getPanelSpider().getName());
    }

    private JPanel getPanelSpider() {
        if (this.panelSpider == null) {
            Insets insets;
            this.panelSpider = new JPanel(new BorderLayout());
            if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
                this.panelSpider.setSize(114, 150);
            }
            this.panelSpider.setName("");
            JLabel domainsLabel = new JLabel();
            JLabel noThreadsLabel = new JLabel();
            JLabel maxDuration = new JLabel();
            JLabel maxDepthLabel = new JLabel();
            JLabel handleParametersLabel = new JLabel();
            maxDepthLabel.setText(Constant.messages.getString("spider.options.label.depth"));
            noThreadsLabel.setText(Constant.messages.getString("spider.options.label.threads"));
            maxDuration.setText(Constant.messages.getString("spider.options.label.duration"));
            domainsLabel.setText(Constant.messages.getString("spider.options.label.domains"));
            handleParametersLabel.setText(Constant.messages.getString("spider.options.label.handleparameters"));
            JPanel innerPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.anchor = 18;
            gbc.insets = insets = new Insets(2, 2, 2, 2);
            innerPanel.add((Component)maxDepthLabel, gbc);
            innerPanel.add((Component)this.getSliderMaxDepth(), gbc);
            innerPanel.add((Component)noThreadsLabel, gbc);
            innerPanel.add((Component)this.getSliderThreads(), gbc);
            JPanel inlineOptionsPanel = new JPanel(new GridBagLayout());
            inlineOptionsPanel.add((Component)maxDuration, LayoutHelper.getGBC(0, 0, 1, 1.0));
            inlineOptionsPanel.add((Component)this.getDurationNumberSpinner(), LayoutHelper.getGBC(1, 0, 1, 1.0));
            inlineOptionsPanel.add((Component)new JLabel(Constant.messages.getString("spider.options.label.maxChildren")), LayoutHelper.getGBC(0, 1, 1, 1.0));
            inlineOptionsPanel.add((Component)this.getMaxChildrenNumberSpinner(), LayoutHelper.getGBC(1, 1, 1, 1.0));
            inlineOptionsPanel.add((Component)new JLabel(Constant.messages.getString("spider.options.label.maxParseSizeBytes")), LayoutHelper.getGBC(0, 2, 1, 1.0));
            inlineOptionsPanel.add((Component)this.getMaxParseSizeBytesNumberSpinner(), LayoutHelper.getGBC(1, 2, 1, 1.0));
            innerPanel.add((Component)inlineOptionsPanel, gbc);
            innerPanel.add((Component)domainsLabel, gbc);
            gbc.fill = 1;
            gbc.weighty = 1.0;
            innerPanel.add((Component)this.getDomainsAlwaysInScopePanel(), gbc);
            gbc.fill = 2;
            gbc.weighty = 0.0;
            innerPanel.add((Component)this.getChkSendRefererHeader(), gbc);
            innerPanel.add((Component)this.getChkAcceptCookies(), gbc);
            innerPanel.add((Component)handleParametersLabel, gbc);
            innerPanel.add(this.getComboHandleParameters(), gbc);
            innerPanel.add((Component)this.getChkProcessForm(), gbc);
            insets.left = 15;
            innerPanel.add((Component)this.getChkPostForm(), gbc);
            insets.left = 2;
            innerPanel.add((Component)this.getChkParseComments(), gbc);
            innerPanel.add((Component)this.getChkParseRobotsTxt(), gbc);
            innerPanel.add((Component)this.getChkParseSitemapXml(), gbc);
            innerPanel.add((Component)this.getChkParseSVNEntries(), gbc);
            innerPanel.add((Component)this.getChkParseGit(), gbc);
            innerPanel.add((Component)this.getHandleODataSpecificParameters(), gbc);
            ZapTextArea irrelevantUrlParameters = this.getIrrelevantUrlParameters();
            JLabel label = new JLabel(Constant.messages.getString("spider.options.label.irrelevantUrlParameters"));
            label.setLabelFor(irrelevantUrlParameters);
            JScrollPane irrelevantUrlParametersScrollPane = new JScrollPane();
            irrelevantUrlParametersScrollPane.setVerticalScrollBarPolicy(20);
            irrelevantUrlParametersScrollPane.setViewportView(irrelevantUrlParameters);
            innerPanel.add((Component)label, gbc);
            innerPanel.add((Component)irrelevantUrlParametersScrollPane, gbc);
            JScrollPane scrollPane = new JScrollPane(innerPanel);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.panelSpider.add((Component)scrollPane, "Center");
        }
        return this.panelSpider;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        SpiderParam param = options.getParamSet(SpiderParam.class);
        this.getSliderMaxDepth().setValue(param.getMaxDepth());
        this.getSliderThreads().setValue(param.getThreadCount());
        this.getDurationNumberSpinner().setValue(param.getMaxDuration());
        this.getMaxChildrenNumberSpinner().setValue(param.getMaxChildren());
        this.getMaxParseSizeBytesNumberSpinner().setValue(param.getMaxParseSizeBytes());
        this.getDomainsAlwaysInScopeTableModel().setDomainsAlwaysInScope(param.getDomainsAlwaysInScope());
        this.getDomainsAlwaysInScopePanel().setRemoveWithoutConfirmation(param.isConfirmRemoveDomainAlwaysInScope());
        this.getChkProcessForm().setSelected(param.isProcessForm());
        this.getChkSendRefererHeader().setSelected(param.isSendRefererHeader());
        this.getChkAcceptCookies().setSelected(param.isAcceptCookies());
        this.getChkPostForm().setSelected(param.isPostForm());
        this.getChkParseComments().setSelected(param.isParseComments());
        this.getChkParseRobotsTxt().setSelected(param.isParseRobotsTxt());
        this.getChkParseSitemapXml().setSelected(param.isParseSitemapXml());
        this.getChkParseSVNEntries().setSelected(param.isParseSVNEntries());
        this.getChkParseGit().setSelected(param.isParseGit());
        this.getComboHandleParameters().setSelectedItem((Object)param.getHandleParameters());
        this.getHandleODataSpecificParameters().setSelected(param.isHandleODataParametersVisited());
        this.getIrrelevantUrlParameters().setText(param.getIrrelevantUrlParametersAsString());
        this.getIrrelevantUrlParameters().discardAllEdits();
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        SpiderParam param = options.getParamSet(SpiderParam.class);
        param.setMaxDepth(this.getSliderMaxDepth().getValue());
        param.setThreadCount(this.getSliderThreads().getValue());
        param.setMaxDuration(this.getDurationNumberSpinner().getValue());
        param.setMaxChildren(this.getMaxChildrenNumberSpinner().getValue());
        param.setMaxParseSizeBytes(this.getMaxParseSizeBytesNumberSpinner().getValue());
        param.setDomainsAlwaysInScope(this.getDomainsAlwaysInScopeTableModel().getDomainsAlwaysInScope());
        param.setConfirmRemoveDomainAlwaysInScope(this.getDomainsAlwaysInScopePanel().isRemoveWithoutConfirmation());
        param.setSendRefererHeader(this.getChkSendRefererHeader().isSelected());
        param.setAcceptCookies(this.getChkAcceptCookies().isSelected());
        param.setProcessForm(this.getChkProcessForm().isSelected());
        param.setPostForm(this.getChkPostForm().isSelected());
        param.setParseComments(this.getChkParseComments().isSelected());
        param.setParseRobotsTxt(this.getChkParseRobotsTxt().isSelected());
        param.setParseSitemapXml(this.getChkParseSitemapXml().isSelected());
        param.setParseSVNEntries(this.getChkParseSVNEntries().isSelected());
        param.setParseGit(this.getChkParseGit().isSelected());
        param.setHandleParameters((SpiderParam.HandleParametersOption)((Object)this.getComboHandleParameters().getSelectedItem()));
        param.setHandleODataParametersVisited(this.getHandleODataSpecificParameters().isSelected());
        param.setIrrelevantUrlParameters(this.getIrrelevantUrlParameters().getText());
    }

    private JSlider getSliderMaxDepth() {
        if (this.sliderMaxDepth == null) {
            this.sliderMaxDepth = new JSlider();
            this.sliderMaxDepth.setMaximum(19);
            this.sliderMaxDepth.setMinimum(0);
            this.sliderMaxDepth.setMinorTickSpacing(1);
            this.sliderMaxDepth.setPaintTicks(true);
            this.sliderMaxDepth.setPaintLabels(true);
            this.sliderMaxDepth.setName("");
            this.sliderMaxDepth.setMajorTickSpacing(1);
            this.sliderMaxDepth.setSnapToTicks(true);
            this.sliderMaxDepth.setPaintTrack(true);
        }
        return this.sliderMaxDepth;
    }

    private JSlider getSliderThreads() {
        if (this.sliderThreads == null) {
            this.sliderThreads = new PositiveValuesSlider(50);
        }
        return this.sliderThreads;
    }

    private ZapNumberSpinner getDurationNumberSpinner() {
        if (this.durationNumberSpinner == null) {
            this.durationNumberSpinner = new ZapNumberSpinner(0, 0, Integer.MAX_VALUE);
        }
        return this.durationNumberSpinner;
    }

    private ZapNumberSpinner getMaxChildrenNumberSpinner() {
        if (this.maxChildrenNumberSpinner == null) {
            this.maxChildrenNumberSpinner = new ZapNumberSpinner(0, 0, Integer.MAX_VALUE);
        }
        return this.maxChildrenNumberSpinner;
    }

    private ZapNumberSpinner getMaxParseSizeBytesNumberSpinner() {
        if (this.maxParseSizeBytesNumberSpinner == null) {
            this.maxParseSizeBytesNumberSpinner = new ZapNumberSpinner(0, 0, Integer.MAX_VALUE);
        }
        return this.maxParseSizeBytesNumberSpinner;
    }

    private JCheckBox getChkSendRefererHeader() {
        if (this.chkSendRefererHeader == null) {
            this.chkSendRefererHeader = new JCheckBox(Constant.messages.getString("spider.options.label.sendRefererHeader"));
        }
        return this.chkSendRefererHeader;
    }

    private JCheckBox getChkAcceptCookies() {
        if (this.chkAcceptCookies == null) {
            this.chkAcceptCookies = new JCheckBox(Constant.messages.getString("spider.options.label.acceptcookies"));
        }
        return this.chkAcceptCookies;
    }

    private JCheckBox getChkPostForm() {
        if (this.chkPostForm == null) {
            this.chkPostForm = new JCheckBox();
            this.chkPostForm.setText(Constant.messages.getString("spider.options.label.post"));
            if (!this.getChkProcessForm().isSelected()) {
                this.chkPostForm.setEnabled(false);
            }
        }
        return this.chkPostForm;
    }

    private JCheckBox getChkProcessForm() {
        if (this.chkProcessForm == null) {
            this.chkProcessForm = new JCheckBox();
            this.chkProcessForm.setText(Constant.messages.getString("spider.options.label.processform"));
            this.chkProcessForm.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ev) {
                    if (OptionsSpiderPanel.this.chkProcessForm.isSelected()) {
                        OptionsSpiderPanel.this.chkPostForm.setEnabled(true);
                    } else {
                        OptionsSpiderPanel.this.chkPostForm.setEnabled(false);
                    }
                }
            });
        }
        return this.chkProcessForm;
    }

    private JCheckBox getChkParseComments() {
        if (this.parseComments == null) {
            this.parseComments = new JCheckBox();
            this.parseComments.setText(Constant.messages.getString("spider.options.label.comments"));
        }
        return this.parseComments;
    }

    private JCheckBox getChkParseRobotsTxt() {
        if (this.parseRobotsTxt == null) {
            this.parseRobotsTxt = new JCheckBox();
            this.parseRobotsTxt.setText(Constant.messages.getString("spider.options.label.robotstxt"));
        }
        return this.parseRobotsTxt;
    }

    private JCheckBox getChkParseSitemapXml() {
        if (this.parseSitemapXml == null) {
            this.parseSitemapXml = new JCheckBox();
            this.parseSitemapXml.setText(Constant.messages.getString("spider.options.label.sitemapxml"));
        }
        return this.parseSitemapXml;
    }

    private JCheckBox getChkParseSVNEntries() {
        if (this.parseSVNEntries == null) {
            this.parseSVNEntries = new JCheckBox();
            this.parseSVNEntries.setText(Constant.messages.getString("spider.options.label.svnentries"));
        }
        return this.parseSVNEntries;
    }

    private JCheckBox getChkParseGit() {
        if (this.parseGit == null) {
            this.parseGit = new JCheckBox();
            this.parseGit.setText(Constant.messages.getString("spider.options.label.git"));
        }
        return this.parseGit;
    }

    private JCheckBox getHandleODataSpecificParameters() {
        if (this.handleODataSpecificParameters == null) {
            this.handleODataSpecificParameters = new JCheckBox();
            this.handleODataSpecificParameters.setText(Constant.messages.getString("spider.options.label.handlehodataparameters"));
        }
        return this.handleODataSpecificParameters;
    }

    private JComboBox<SpiderParam.HandleParametersOption> getComboHandleParameters() {
        if (this.handleParameters == null) {
            this.handleParameters = new JComboBox<SpiderParam.HandleParametersOption>(new SpiderParam.HandleParametersOption[]{SpiderParam.HandleParametersOption.USE_ALL, SpiderParam.HandleParametersOption.IGNORE_VALUE, SpiderParam.HandleParametersOption.IGNORE_COMPLETELY});
            this.handleParameters.setRenderer(new HandleParametersOptionRenderer());
        }
        return this.handleParameters;
    }

    private DomainsAlwaysInScopeMultipleOptionsPanel getDomainsAlwaysInScopePanel() {
        if (this.domainsAlwaysInScopePanel == null) {
            this.domainsAlwaysInScopePanel = new DomainsAlwaysInScopeMultipleOptionsPanel(this.getDomainsAlwaysInScopeTableModel());
        }
        return this.domainsAlwaysInScopePanel;
    }

    private DomainsAlwaysInScopeTableModel getDomainsAlwaysInScopeTableModel() {
        if (this.domainsAlwaysInScopeTableModel == null) {
            this.domainsAlwaysInScopeTableModel = new DomainsAlwaysInScopeTableModel();
        }
        return this.domainsAlwaysInScopeTableModel;
    }

    private ZapTextArea getIrrelevantUrlParameters() {
        if (this.irrelevantUrlParameters == null) {
            this.irrelevantUrlParameters = new ZapTextArea();
            this.irrelevantUrlParameters.setLineWrap(true);
        }
        return this.irrelevantUrlParameters;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.spider";
    }

    private static class DomainsAlwaysInScopeMultipleOptionsPanel
    extends AbstractMultipleOptionsTablePanel<DomainAlwaysInScopeMatcher> {
        private static final long serialVersionUID = 2332044353650231701L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("spider.options.domains.in.scope.dialog.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("spider.options.domains.in.scope.dialog.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("spider.options.domains.in.scope.dialog.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("spider.options.domains.in.scope.dialog.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("spider.options.domains.in.scope.dialog.remove.checkbox.label");
        private DialogAddDomainAlwaysInScope addDialog = null;
        private DialogModifyDomainAlwaysInScope modifyDialog = null;

        public DomainsAlwaysInScopeMultipleOptionsPanel(DomainsAlwaysInScopeTableModel model) {
            super(model);
            this.getTable().setVisibleRowCount(5);
            this.getTable().setSortOrder(2, SortOrder.ASCENDING);
        }

        @Override
        public DomainAlwaysInScopeMatcher showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddDomainAlwaysInScope(View.getSingleton().getOptionsDialog(null));
                this.addDialog.pack();
            }
            this.addDialog.setVisible(true);
            DomainAlwaysInScopeMatcher hostAuthentication = this.addDialog.getDomainAlwaysInScope();
            this.addDialog.clear();
            return hostAuthentication;
        }

        @Override
        public DomainAlwaysInScopeMatcher showModifyDialogue(DomainAlwaysInScopeMatcher e) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyDomainAlwaysInScope(View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.setDomainAlwaysInScope(e);
            this.modifyDialog.setVisible(true);
            DomainAlwaysInScopeMatcher excludedDomain = this.modifyDialog.getDomainAlwaysInScope();
            this.modifyDialog.clear();
            if (!excludedDomain.equals(e)) {
                return excludedDomain;
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(DomainAlwaysInScopeMatcher e) {
            JCheckBox removeWithoutConfirmationCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] messages = new Object[]{REMOVE_DIALOG_TEXT, " ", removeWithoutConfirmationCheckBox};
            int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), messages, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (option == 0) {
                this.setRemoveWithoutConfirmation(removeWithoutConfirmationCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }

    private static class HandleParametersOptionRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 3654541772447187317L;
        private static final Border BORDER = new EmptyBorder(2, 3, 3, 3);

        private HandleParametersOptionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                this.setBorder(BORDER);
                SpiderParam.HandleParametersOption item = (SpiderParam.HandleParametersOption)((Object)value);
                this.setText(item.getName());
            }
            return this;
        }
    }
}

