/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.zaproxy.zap.view.LayoutHelper;

public class SummaryAndConfigPanel
extends JPanel {
    private static final long serialVersionUID = 622131593103359244L;
    private JEditorPane summaryArea;
    private String summaryTitleText;
    private JButton configButton;

    public SummaryAndConfigPanel(String summaryTitleText, String configButtonText, ActionListener configButtonActionListener) {
        super(new GridBagLayout());
        this.summaryTitleText = summaryTitleText;
        this.configButton = new JButton(configButtonText);
        this.configButton.setIcon(new ImageIcon(SummaryAndConfigPanel.class.getResource("/resource/icon/16/041.png")));
        this.configButton.addActionListener(configButtonActionListener);
        this.add((Component)this.configButton, LayoutHelper.getGBC(1, 0, 1, 1, 0.0, 0.0));
        this.summaryArea = new JEditorPane();
        this.summaryArea.setContentType("text/html");
        this.summaryArea.setEnabled(false);
        this.setSummaryContent("");
        this.add((Component)this.summaryArea, LayoutHelper.getGBC(0, 0, 1, 2, 1.0, new Insets(3, 3, 3, 3)));
    }

    public void setSummaryContent(String content) {
        LogManager.getRootLogger().info("New summary: {}", (Object)content);
        this.summaryArea.setText("<html><b>" + this.summaryTitleText + "</b><br/><br/>" + content + "</html>");
    }

    public void setConfigButtonEnabled(boolean enabled) {
        this.configButton.setEnabled(enabled);
    }
}

