/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.AbstractFrame;
import org.parosproxy.paros.view.TabbedPanel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.TabbedPanelTab;

public class TabbedPanel2
extends TabbedPanel {
    private static final long serialVersionUID = 1L;
    private static final Comparator<Component> NAME_COMPARATOR = (c1, c2) -> c1.getName().compareTo(c2.getName());
    private List<Component> fullTabList = new ArrayList<Component>();
    private List<Component> hiddenTabs = new ArrayList<Component>();
    private Map<Component, DetachedTabFrame> detachedTabs = new HashMap<Component, DetachedTabFrame>();
    private final List<DetachedTabListener> detachedTabListeners = new ArrayList<DetachedTabListener>();
    private static final Icon PLUS_ICON = TabbedPanel2.getImageIcon("/resource/icon/fugue/plus.png");
    private static final Icon UI_TAB_EXCLAMATION_ICON = TabbedPanel2.getImageIcon("/resource/icon/fugue/ui-tab-exclamation.png");
    private Component hiddenComponent = new JLabel();
    private static final Logger LOGGER = LogManager.getLogger(TabbedPanel2.class);
    private int prevTabIndex = -1;

    public TabbedPanel2() {
        AbstractPanel noVisibleTabsMsgPanel = new AbstractPanel();
        noVisibleTabsMsgPanel.setName(Constant.messages.getString("tab.noVisibleTabs.title"));
        noVisibleTabsMsgPanel.setIcon(UI_TAB_EXCLAMATION_ICON);
        noVisibleTabsMsgPanel.setHideable(false);
        noVisibleTabsMsgPanel.setLayout(new GridBagLayout());
        JTextArea msgPanelTextArea = new JTextArea(2, 20);
        msgPanelTextArea.setWrapStyleWord(true);
        msgPanelTextArea.setLineWrap(true);
        msgPanelTextArea.setEditable(false);
        noVisibleTabsMsgPanel.add(msgPanelTextArea);
        this.addChangeListener(e -> this.toggleNoVisibleTabsMessage(noVisibleTabsMsgPanel, msgPanelTextArea));
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabbedPanel2.this.setCloseButtonStates();
                if (TabbedPanel2.this.getSelectedComponent() != null && TabbedPanel2.this.getSelectedComponent().equals(TabbedPanel2.this.hiddenComponent)) {
                    if (TabbedPanel2.this.prevTabIndex == TabbedPanel2.this.indexOfComponent(TabbedPanel2.this.hiddenComponent)) {
                        TabbedPanel2.this.setSelectedIndex(TabbedPanel2.this.prevTabIndex - 1);
                    }
                } else {
                    TabbedPanel2.this.prevTabIndex = TabbedPanel2.this.getSelectedIndex();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Component tab;
                int tabIndex;
                if (TabbedPanel2.this.hiddenComponent.equals(TabbedPanel2.this.getSelectedComponent())) {
                    TabbedPanel2.this.setSelectedIndex(TabbedPanel2.this.prevTabIndex);
                    TabbedPanel2.this.showHiddenTabPopup();
                }
                if ((tabIndex = TabbedPanel2.this.indexAtLocation(e.getX(), e.getY())) != -1 && SwingUtilities.isRightMouseButton(e) && (tab = TabbedPanel2.this.getTabComponentAt(tabIndex)) instanceof TabbedPanelTab) {
                    JPopupMenu contextMenu = ((TabbedPanelTab)tab).getContextMenu();
                    contextMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.hiddenTabs != null) {
            this.hiddenTabs.forEach(tab -> SwingUtilities.updateComponentTreeUI(tab));
        }
    }

    private void toggleNoVisibleTabsMessage(AbstractPanel panel, JTextArea textArea) {
        SwingUtilities.invokeLater(() -> {
            if (this.getTabCount() == 0) {
                textArea.setText(Constant.messages.getString("tab.noVisibleTabs.allDetachedMsg"));
                this.insertTab(panel.getName(), panel.getIcon(), panel, null, 0);
                this.setSelectedIndex(0);
            } else if (this.indexOfComponent(this.hiddenComponent) == 0) {
                textArea.setText(Constant.messages.getString("tab.noVisibleTabs.detachedOrHiddenMsg"));
                this.insertTab(panel.getName(), panel.getIcon(), panel, null, 0);
                this.setSelectedIndex(0);
            } else if (!this.getVisiblePanels().isEmpty() && this.indexOfComponent(panel) != -1) {
                this.removeTab(panel);
            }
        });
    }

    private void showHiddenTabPopup() {
        JPopupMenu menu = new JPopupMenu();
        if (this.getMousePosition() == null) {
            return;
        }
        Collections.sort(this.hiddenTabs, NAME_COMPARATOR);
        for (Component c : this.hiddenTabs) {
            if (!(c instanceof AbstractPanel)) continue;
            final AbstractPanel ap = (AbstractPanel)c;
            JMenuItem mi = new JMenuItem(ap.getName());
            mi.setIcon(ap.getIcon());
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TabbedPanel2.this.setVisible(ap, true);
                    ap.setTabFocus();
                }
            });
            menu.add(mi);
        }
        menu.show(this, this.getMousePosition().x, this.getMousePosition().y);
    }

    private void setCloseButtonStates() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component tabCom = this.getTabComponentAt(i);
            if (tabCom == null || !(tabCom instanceof TabbedPanelTab)) continue;
            TabbedPanelTab jp = (TabbedPanelTab)tabCom;
            jp.setEnabled(i == this.getSelectedIndex());
        }
    }

    public void pinVisibleTabs() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component tabCom = this.getTabComponentAt(i);
            if (tabCom == null || !(tabCom instanceof TabbedPanelTab) || !tabCom.isVisible()) continue;
            TabbedPanelTab jp = (TabbedPanelTab)tabCom;
            jp.setPinned(true);
            this.saveTabState(jp.getAbstractPanel());
        }
    }

    public void unpinTabs() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component tabCom = this.getTabComponentAt(i);
            if (tabCom == null || !(tabCom instanceof TabbedPanelTab) || !tabCom.isVisible()) continue;
            TabbedPanelTab jp = (TabbedPanelTab)tabCom;
            jp.setPinned(false);
            this.saveTabState(jp.getAbstractPanel());
        }
    }

    private String safeName(String str) {
        return str.replaceAll("[^A-Za-z0-9]", "");
    }

    private boolean isTabPinned(Component c) {
        boolean showByDefault = false;
        if (c instanceof AbstractPanel) {
            showByDefault = ((AbstractPanel)c).isShowByDefault();
        }
        return Model.getSingleton().getOptionsParam().getConfig().getBoolean("view.tab.pin." + this.safeName(c.getName()), showByDefault);
    }

    protected void saveTabState(AbstractPanel ap) {
        if (ap == null) {
            return;
        }
        Model.getSingleton().getOptionsParam().getConfig().setProperty("view.tab.pin." + this.safeName(ap.getName()), (Object)ap.isPinned());
        try {
            Model.getSingleton().getOptionsParam().getConfig().save();
        }
        catch (ConfigurationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isTabVisible(Component c) {
        if (!this.fullTabList.contains(c)) {
            return false;
        }
        return !this.hiddenTabs.contains(c);
    }

    public void setVisible(Component c, boolean visible) {
        if (visible) {
            if (this.hiddenTabs.contains(c)) {
                if (c instanceof AbstractPanel) {
                    AbstractPanel panel = (AbstractPanel)c;
                    this.addTab(c.getName(), panel.getIcon(), panel, panel.isHideable(), true, panel.getTabIndex());
                } else {
                    int index;
                    for (index = this.fullTabList.indexOf(c); index >= 0 && (index <= 0 || this.hiddenTabs.contains(this.fullTabList.get(index - 1))); --index) {
                    }
                    this.addTab(c.getName(), null, c, true, true, index);
                }
                this.hiddenTabs.remove(c);
                this.handleHiddenTabListTab();
            }
            return;
        }
        this.hideTab(c);
    }

    private void hideTab(Component component) {
        if (this.hiddenTabs.contains(component)) {
            return;
        }
        this.hiddenTabs.add(component);
        int index = this.indexOfComponent(component);
        if (index != -1) {
            super.removeTabAt(index);
        }
        this.handleHiddenTabListTab();
    }

    void detachTab(Component component) {
        if (this.detachedTabs.containsKey(component) || !(component instanceof AbstractPanel)) {
            return;
        }
        final DetachedTabFrame frame = new DetachedTabFrame((AbstractPanel)component, this);
        this.detachedTabListeners.forEach(listener -> listener.tabDetached(component));
        this.detachedTabs.put(component, frame);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TabbedPanel2 parent = frame.getDetachedTabParent();
                if (parent == null) {
                    return;
                }
                AbstractPanel panel = frame.getPanel();
                parent.addTab(panel.getName(), panel.getIcon(), panel, panel.isHideable(), true, frame.getLastIndex());
                panel.setTabFocus();
                parent.detachedTabs.remove(panel);
                parent.detachedTabListeners.forEach(listener -> listener.tabReattached(panel));
                if (TabbedPanel2.this != parent) {
                    TabbedPanel2.this.fullTabList.add(panel);
                    TabbedPanel2.this.detachedTabs.remove(panel);
                    TabbedPanel2.this.detachedTabListeners.forEach(listener -> listener.tabReattached(panel));
                }
            }
        });
    }

    @Override
    public void addTab(String title, Icon icon, Component c) {
        if (c instanceof AbstractPanel) {
            this.addTab((AbstractPanel)c);
        } else {
            this.addTab(title, icon, c, false, true, this.getTabCount());
        }
    }

    public void addTab(AbstractPanel panel) {
        this.addTab(panel, panel.getTabIndex());
    }

    public void addTabHidden(AbstractPanel panel) {
        this.addTab(panel.getName(), panel.getIcon(), panel, panel.isHideable(), false, panel.getTabIndex(), false);
    }

    public void addTab(AbstractPanel panel, int index) {
        boolean visible = !panel.isHideable() || this.isTabPinned(panel);
        this.addTab(panel.getName(), panel.getIcon(), panel, panel.isHideable(), visible, index);
    }

    public void addTab(String title, Icon icon, Component c, boolean hideable, boolean visible, int index) {
        this.addTab(title, icon, c, hideable, visible, index, true);
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        if (!(this.isPlusTab(icon) || this.isNoVisibleTabsMessageTab(icon) || this.fullTabList.contains(component))) {
            this.fullTabList.add(component);
        }
    }

    private boolean isPlusTab(Icon icon) {
        return icon == PLUS_ICON;
    }

    private boolean isNoVisibleTabsMessageTab(Icon icon) {
        return icon == UI_TAB_EXCLAMATION_ICON;
    }

    private void addTab(String title, Icon icon, Component c, boolean hideable, boolean visible, int index, boolean reparent) {
        if (!this.fullTabList.contains(c)) {
            this.fullTabList.add(c);
        }
        if (c instanceof AbstractPanel) {
            if (reparent) {
                ((AbstractPanel)c).setParent(this);
            }
            ((AbstractPanel)c).setTabIndex(index);
            ((AbstractPanel)c).setHideable(hideable);
        }
        if (!visible) {
            this.hideTab(c);
            return;
        }
        this.hiddenTabs.remove(c);
        if (index == -1 || index > this.getTabCount()) {
            index = this.getTabCount();
        }
        if (icon instanceof ImageIcon) {
            icon = DisplayUtils.getScaledIcon((ImageIcon)icon);
        }
        super.insertTab(title, icon, c, c.getName(), index);
        int pos = this.indexOfComponent(c);
        this.setTabComponentAt(pos, new TabbedPanelTab(this, title, icon, c, hideable, this.isTabPinned(c)));
        this.handleHiddenTabListTab();
        if ((index == 0 || this.getTabCount() == 1) && this.indexOfComponent(c) != -1) {
            this.setSelectedComponent(c);
        }
    }

    private void handleHiddenTabListTab() {
        if (this.indexOfComponent(this.hiddenComponent) >= 0) {
            super.remove(this.hiddenComponent);
        }
        if (this.hiddenTabs.size() > 0) {
            super.addTab("", PLUS_ICON, this.hiddenComponent);
        }
    }

    public boolean hasDetachedTabs() {
        return !this.detachedTabs.isEmpty();
    }

    public void closeAllDetachedTabs() {
        for (DetachedTabFrame frame : this.detachedTabs.values()) {
            frame.reattach();
        }
    }

    public Map<Component, DetachedTabFrame> getDetachedTabs() {
        return this.detachedTabs;
    }

    public void setDetachedTabs(Set<DetachedTabFrame> detachedTabs) {
        this.fullTabList.addAll(this.detachedTabs.keySet());
        this.detachedTabs.clear();
        for (DetachedTabFrame frame : detachedTabs) {
            this.detachedTabs.put(frame.getPanel(), frame);
            this.removeFromInternalState(frame.getPanel());
            frame.setDetachedTabParent(this);
        }
    }

    public void setTabLocked(AbstractPanel panel, boolean lock) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            TabbedPanelTab jp;
            Component tabCom = this.getTabComponentAt(i);
            if (tabCom == null || !(tabCom instanceof TabbedPanelTab) || !tabCom.isVisible() || !panel.equals((jp = (TabbedPanelTab)tabCom).getAbstractPanel())) continue;
            jp.setLocked(!lock);
        }
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        Component c;
        Component tabCom = this.getTabComponentAt(index);
        if (tabCom != null && tabCom instanceof JPanel && (c = ((JPanel)tabCom).getComponent(0)) != null && c instanceof JLabel) {
            ((JLabel)c).setIcon(icon);
        }
    }

    @Override
    public void setTitleAt(int index, String title) {
        Component tabCom = this.getTabComponentAt(index);
        if (tabCom != null && tabCom instanceof JPanel) {
            Component c = ((JPanel)tabCom).getComponent(0);
            if (c != null && c instanceof JLabel) {
                ((JLabel)c).setText(title);
            }
        } else {
            super.setTitleAt(index, title);
        }
    }

    public List<Component> getTabList() {
        return Collections.unmodifiableList(this.fullTabList);
    }

    public List<Component> getSortedTabList() {
        ArrayList<Component> copy = new ArrayList<Component>(this.fullTabList);
        Collections.sort(copy, NAME_COMPARATOR);
        return copy;
    }

    public void removeTab(AbstractPanel panel) {
        if (this.detachedTabs.containsKey(panel)) {
            this.detachedTabs.get(panel).reattach();
        }
        this.remove(panel);
        this.removeFromInternalState(panel);
    }

    @Override
    public void removeTabAt(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Tab count: " + this.getTabCount());
        }
        Component component = this.getComponentAt(index);
        super.removeTabAt(index);
        if (!(component instanceof AbstractPanel)) {
            return;
        }
        this.removeFromInternalState(component);
    }

    private void removeFromInternalState(Component panel) {
        this.fullTabList.remove(panel);
        if (this.hiddenTabs.remove(panel)) {
            this.handleHiddenTabListTab();
        }
    }

    @Override
    public void removeAll() {
        this.fullTabList.clear();
        this.hiddenTabs.clear();
        this.detachedTabs.clear();
        this.removeAllTabs();
        this.closeAllDetachedTabs();
    }

    private void removeAllTabs() {
        this.setSelectedIndex(-1);
        int tabCount = this.getTabCount();
        while (tabCount-- > 0) {
            super.removeTabAt(tabCount);
        }
        this.handleHiddenTabListTab();
    }

    public void hideAllTabs() {
        this.hiddenTabs.clear();
        this.hiddenTabs.addAll(this.fullTabList);
        this.removeAllTabs();
    }

    public void setShowTabNames(boolean showTabNames) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            String title = showTabNames ? this.getComponentAt(i).getName() : "";
            this.setTitleAt(i, title);
        }
    }

    @Override
    protected void fireStateChanged() {
        super.fireStateChanged();
        Component comp = this.getSelectedComponent();
        if (comp instanceof AbstractPanel) {
            ((AbstractPanel)comp).tabSelected();
        }
    }

    public boolean isActive() {
        return false;
    }

    public List<AbstractPanel> getPanels() {
        ArrayList<AbstractPanel> panels = new ArrayList<AbstractPanel>();
        for (Component component : this.fullTabList) {
            if (!(component instanceof AbstractPanel)) continue;
            panels.add((AbstractPanel)component);
        }
        return panels;
    }

    public List<AbstractPanel> getVisiblePanels() {
        return this.fullTabList.stream().filter(AbstractPanel.class::isInstance).map(AbstractPanel.class::cast).filter(Predicate.not(this.hiddenTabs::contains)).collect(Collectors.toList());
    }

    public void setVisiblePanels(List<AbstractPanel> panels) {
        this.hideAllTabs();
        for (Component component : this.fullTabList) {
            if (panels.contains(component)) {
                this.setVisible(component, true);
                continue;
            }
            if (!(component instanceof AbstractPanel)) continue;
            AbstractPanel ap = (AbstractPanel)component;
            if (!TabbedPanel2.canHidePanel(ap)) {
                this.setVisible(component, true);
                continue;
            }
            ap.setParent(this);
        }
        if (this.getSelectedComponent() == null && this.getTabCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setPanelsVisible(boolean visible) {
        for (Component component : this.fullTabList) {
            if (!(component instanceof AbstractPanel)) continue;
            AbstractPanel ap = (AbstractPanel)component;
            boolean canChangeVisibility = true;
            if (!visible) {
                canChangeVisibility = TabbedPanel2.canHidePanel(ap);
            }
            if (!canChangeVisibility) continue;
            this.setVisible(component, visible);
        }
    }

    public void addDetachedTabListener(DetachedTabListener listener) {
        this.detachedTabListeners.add(listener);
    }

    public void removeDetachedTabListener(DetachedTabListener listener) {
        this.detachedTabListeners.remove(listener);
    }

    private static boolean canHidePanel(AbstractPanel panel) {
        return panel.isHideable() && !panel.isPinned();
    }

    private static ImageIcon getImageIcon(String resourceName) {
        return DisplayUtils.getScaledIcon(new ImageIcon(TabbedPanel2.class.getResource(resourceName)));
    }

    public static class DetachedTabFrame
    extends AbstractFrame {
        TabbedPanel2 detachedTabParent;
        AbstractPanel panel;
        int lastIndex;

        public DetachedTabFrame(AbstractPanel panel, TabbedPanel2 detachedTabParent) {
            super(DetachedTabFrame.getPrefnzPrefix(panel.getName()));
            this.panel = panel;
            this.detachedTabParent = detachedTabParent;
            this.lastIndex = detachedTabParent.indexOfComponent(panel);
            this.setTitle(panel.getName());
            this.getContentPane().add(panel);
            this.setVisible(true);
        }

        public void reattach() {
            for (WindowListener listener : this.getWindowListeners()) {
                listener.windowClosing(null);
            }
            this.dispose();
        }

        public int getLastIndex() {
            return this.lastIndex;
        }

        public AbstractPanel getPanel() {
            return this.panel;
        }

        public TabbedPanel2 getDetachedTabParent() {
            return this.detachedTabParent;
        }

        public void setDetachedTabParent(TabbedPanel2 detachedTabParent) {
            this.detachedTabParent = detachedTabParent;
        }

        private static String getPrefnzPrefix(String title) {
            return DetachedTabFrame.class.getSimpleName() + "." + title.toLowerCase(Locale.ROOT).replaceAll("[^a-zA-Z0-9]+", "_") + ".";
        }
    }

    public static interface DetachedTabListener {
        public void tabDetached(Component var1);

        public void tabReattached(Component var1);
    }
}

