# (c) Copyright 2009-2015. CodeWeavers, Inc.

from gi.repository import GLib
from gi.repository import Gtk

import cxutils

import cxguitools


class WaitDialogController:

    def __init__(self, options, args):
        self.xml = Gtk.Builder()
        self.xml.set_translation_domain("crossover")
        self.xml.add_from_file(cxguitools.get_ui_path("cxwait"))

        # We have a c-style string format, and need to convert it.
        message_format = cxutils.cxgettext(args[0])
        try:
            message = message_format % tuple(args[1:])
        except TypeError:
            message = message_format

        window = self.xml.get_object("WaitDialog")
        window.connect("destroy", Gtk.main_quit)
        window.set_property('focus-on-map', not options.nofocus)

        # Set up title
        if options.title:
            window.set_title(cxutils.cxgettext(options.title))

        # Set up image
        if options.image:
            image = self.xml.get_object("WaitImage")
            if '/' in options.image:
                image.set_from_file(options.image)
            else:
                image.set_from_pixbuf(cxguitools.get_std_icon(options.image))

        # Set up progress bar
        prog_bar = self.xml.get_object("ProgBar")
        prog_bar.set_pulse_step(.05)
        GLib.timeout_add(100, self.prog_bar_pulse)
        prog_bar.show()

        # Fill Message Text
        msg_widget = self.xml.get_object("WaitMessage")
        msg_widget.set_text(message)

        cxguitools.set_default_icon()
        window.show()

    def prog_bar_pulse(self):
        prog_bar = self.xml.get_object("ProgBar")
        prog_bar.pulse()
        return True
