/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;

public class Activation
implements Serializable,
Cloneable,
InputLocationTracker {
    private boolean activeByDefault = false;
    private String jdk;
    private ActivationOS os;
    private ActivationProperty property;
    private ActivationFile file;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation activeByDefaultLocation;
    private InputLocation jdkLocation;
    private InputLocation osLocation;
    private InputLocation propertyLocation;
    private InputLocation fileLocation;

    public Activation clone() {
        try {
            Activation copy2 = (Activation)super.clone();
            if (this.os != null) {
                copy2.os = this.os.clone();
            }
            if (this.property != null) {
                copy2.property = this.property.clone();
            }
            if (this.file != null) {
                copy2.file = this.file.clone();
            }
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public ActivationFile getFile() {
        return this.file;
    }

    public String getJdk() {
        return this.jdk;
    }

    @Override
    public InputLocation getLocation(Object key2) {
        if (key2 instanceof String) {
            switch ((String)key2) {
                case "": {
                    return this.location;
                }
                case "activeByDefault": {
                    return this.activeByDefaultLocation;
                }
                case "jdk": {
                    return this.jdkLocation;
                }
                case "os": {
                    return this.osLocation;
                }
                case "property": {
                    return this.propertyLocation;
                }
                case "file": {
                    return this.fileLocation;
                }
            }
            return this.getOtherLocation(key2);
        }
        return this.getOtherLocation(key2);
    }

    public ActivationOS getOs() {
        return this.os;
    }

    @Override
    public void setLocation(Object key2, InputLocation location) {
        if (key2 instanceof String) {
            switch ((String)key2) {
                case "": {
                    this.location = location;
                    return;
                }
                case "activeByDefault": {
                    this.activeByDefaultLocation = location;
                    return;
                }
                case "jdk": {
                    this.jdkLocation = location;
                    return;
                }
                case "os": {
                    this.osLocation = location;
                    return;
                }
                case "property": {
                    this.propertyLocation = location;
                    return;
                }
                case "file": {
                    this.fileLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key2, location);
            return;
        }
        this.setOtherLocation(key2, location);
    }

    public void setOtherLocation(Object key2, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key2, location);
        }
    }

    private InputLocation getOtherLocation(Object key2) {
        return this.locations != null ? this.locations.get(key2) : null;
    }

    public ActivationProperty getProperty() {
        return this.property;
    }

    public boolean isActiveByDefault() {
        return this.activeByDefault;
    }

    public void setActiveByDefault(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    public void setFile(ActivationFile file2) {
        this.file = file2;
    }

    public void setJdk(String jdk) {
        this.jdk = jdk;
    }

    public void setOs(ActivationOS os) {
        this.os = os;
    }

    public void setProperty(ActivationProperty property) {
        this.property = property;
    }
}

