// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: images.proto
// Original file comments:
//
// Copyright The containerd Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_images_2eproto__INCLUDED
#define GRPC_images_2eproto__INCLUDED

#include "images.pb.h"

#include <functional>
#include <grpcpp/generic/async_generic_service.h>
#include <grpcpp/support/async_stream.h>
#include <grpcpp/support/async_unary_call.h>
#include <grpcpp/support/client_callback.h>
#include <grpcpp/client_context.h>
#include <grpcpp/completion_queue.h>
#include <grpcpp/support/message_allocator.h>
#include <grpcpp/support/method_handler.h>
#include <grpcpp/impl/proto_utils.h>
#include <grpcpp/impl/rpc_method.h>
#include <grpcpp/support/server_callback.h>
#include <grpcpp/impl/server_callback_handlers.h>
#include <grpcpp/server_context.h>
#include <grpcpp/impl/service_type.h>
#include <grpcpp/support/status.h>
#include <grpcpp/support/stub_options.h>
#include <grpcpp/support/sync_stream.h>
#include <grpcpp/ports_def.inc>

namespace containerd {
namespace services {
namespace images {
namespace v1 {

// Images is a service that allows one to register images with containerd.
//
// In containerd, an image is merely the mapping of a name to a content root,
// described by a descriptor. The behavior and state of image is purely
// dictated by the type of the descriptor.
//
// From the perspective of this service, these references are mostly shallow,
// in that the existence of the required content won't be validated until
// required by consuming services.
//
// As such, this can really be considered a "metadata service".
class Images final {
 public:
  static constexpr char const* service_full_name() {
    return "containerd.services.images.v1.Images";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Get returns an image by name.
    virtual ::grpc::Status Get(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest& request, ::containerd::services::images::v1::GetImageResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::GetImageResponse>> AsyncGet(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::GetImageResponse>>(AsyncGetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::GetImageResponse>> PrepareAsyncGet(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::GetImageResponse>>(PrepareAsyncGetRaw(context, request, cq));
    }
    // List returns a list of all images known to containerd.
    virtual ::grpc::Status List(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest& request, ::containerd::services::images::v1::ListImagesResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::ListImagesResponse>> AsyncList(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::ListImagesResponse>>(AsyncListRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::ListImagesResponse>> PrepareAsyncList(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::ListImagesResponse>>(PrepareAsyncListRaw(context, request, cq));
    }
    // Create an image record in the metadata store.
    //
    // The name of the image must be unique.
    virtual ::grpc::Status Create(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest& request, ::containerd::services::images::v1::CreateImageResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::CreateImageResponse>> AsyncCreate(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::CreateImageResponse>>(AsyncCreateRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::CreateImageResponse>> PrepareAsyncCreate(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::CreateImageResponse>>(PrepareAsyncCreateRaw(context, request, cq));
    }
    // Update assigns the name to a given target image based on the provided
    // image.
    virtual ::grpc::Status Update(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest& request, ::containerd::services::images::v1::UpdateImageResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::UpdateImageResponse>> AsyncUpdate(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::UpdateImageResponse>>(AsyncUpdateRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::UpdateImageResponse>> PrepareAsyncUpdate(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::UpdateImageResponse>>(PrepareAsyncUpdateRaw(context, request, cq));
    }
    // Delete deletes the image by name.
    virtual ::grpc::Status Delete(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDelete(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDelete(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Get returns an image by name.
      virtual void Get(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest* request, ::containerd::services::images::v1::GetImageResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Get(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest* request, ::containerd::services::images::v1::GetImageResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // List returns a list of all images known to containerd.
      virtual void List(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest* request, ::containerd::services::images::v1::ListImagesResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void List(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest* request, ::containerd::services::images::v1::ListImagesResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Create an image record in the metadata store.
      //
      // The name of the image must be unique.
      virtual void Create(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest* request, ::containerd::services::images::v1::CreateImageResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Create(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest* request, ::containerd::services::images::v1::CreateImageResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Update assigns the name to a given target image based on the provided
      // image.
      virtual void Update(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest* request, ::containerd::services::images::v1::UpdateImageResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Update(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest* request, ::containerd::services::images::v1::UpdateImageResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Delete deletes the image by name.
      virtual void Delete(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Delete(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::GetImageResponse>* AsyncGetRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::GetImageResponse>* PrepareAsyncGetRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::ListImagesResponse>* AsyncListRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::ListImagesResponse>* PrepareAsyncListRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::CreateImageResponse>* AsyncCreateRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::CreateImageResponse>* PrepareAsyncCreateRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::UpdateImageResponse>* AsyncUpdateRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::containerd::services::images::v1::UpdateImageResponse>* PrepareAsyncUpdateRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status Get(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest& request, ::containerd::services::images::v1::GetImageResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::GetImageResponse>> AsyncGet(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::GetImageResponse>>(AsyncGetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::GetImageResponse>> PrepareAsyncGet(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::GetImageResponse>>(PrepareAsyncGetRaw(context, request, cq));
    }
    ::grpc::Status List(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest& request, ::containerd::services::images::v1::ListImagesResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::ListImagesResponse>> AsyncList(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::ListImagesResponse>>(AsyncListRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::ListImagesResponse>> PrepareAsyncList(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::ListImagesResponse>>(PrepareAsyncListRaw(context, request, cq));
    }
    ::grpc::Status Create(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest& request, ::containerd::services::images::v1::CreateImageResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::CreateImageResponse>> AsyncCreate(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::CreateImageResponse>>(AsyncCreateRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::CreateImageResponse>> PrepareAsyncCreate(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::CreateImageResponse>>(PrepareAsyncCreateRaw(context, request, cq));
    }
    ::grpc::Status Update(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest& request, ::containerd::services::images::v1::UpdateImageResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::UpdateImageResponse>> AsyncUpdate(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::UpdateImageResponse>>(AsyncUpdateRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::UpdateImageResponse>> PrepareAsyncUpdate(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::UpdateImageResponse>>(PrepareAsyncUpdateRaw(context, request, cq));
    }
    ::grpc::Status Delete(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDelete(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDelete(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void Get(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest* request, ::containerd::services::images::v1::GetImageResponse* response, std::function<void(::grpc::Status)>) override;
      void Get(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest* request, ::containerd::services::images::v1::GetImageResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void List(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest* request, ::containerd::services::images::v1::ListImagesResponse* response, std::function<void(::grpc::Status)>) override;
      void List(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest* request, ::containerd::services::images::v1::ListImagesResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Create(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest* request, ::containerd::services::images::v1::CreateImageResponse* response, std::function<void(::grpc::Status)>) override;
      void Create(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest* request, ::containerd::services::images::v1::CreateImageResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Update(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest* request, ::containerd::services::images::v1::UpdateImageResponse* response, std::function<void(::grpc::Status)>) override;
      void Update(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest* request, ::containerd::services::images::v1::UpdateImageResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Delete(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void Delete(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::GetImageResponse>* AsyncGetRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::GetImageResponse>* PrepareAsyncGetRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::GetImageRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::ListImagesResponse>* AsyncListRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::ListImagesResponse>* PrepareAsyncListRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::ListImagesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::CreateImageResponse>* AsyncCreateRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::CreateImageResponse>* PrepareAsyncCreateRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::CreateImageRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::UpdateImageResponse>* AsyncUpdateRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::containerd::services::images::v1::UpdateImageResponse>* PrepareAsyncUpdateRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::UpdateImageRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteRaw(::grpc::ClientContext* context, const ::containerd::services::images::v1::DeleteImageRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_Get_;
    const ::grpc::internal::RpcMethod rpcmethod_List_;
    const ::grpc::internal::RpcMethod rpcmethod_Create_;
    const ::grpc::internal::RpcMethod rpcmethod_Update_;
    const ::grpc::internal::RpcMethod rpcmethod_Delete_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Get returns an image by name.
    virtual ::grpc::Status Get(::grpc::ServerContext* context, const ::containerd::services::images::v1::GetImageRequest* request, ::containerd::services::images::v1::GetImageResponse* response);
    // List returns a list of all images known to containerd.
    virtual ::grpc::Status List(::grpc::ServerContext* context, const ::containerd::services::images::v1::ListImagesRequest* request, ::containerd::services::images::v1::ListImagesResponse* response);
    // Create an image record in the metadata store.
    //
    // The name of the image must be unique.
    virtual ::grpc::Status Create(::grpc::ServerContext* context, const ::containerd::services::images::v1::CreateImageRequest* request, ::containerd::services::images::v1::CreateImageResponse* response);
    // Update assigns the name to a given target image based on the provided
    // image.
    virtual ::grpc::Status Update(::grpc::ServerContext* context, const ::containerd::services::images::v1::UpdateImageRequest* request, ::containerd::services::images::v1::UpdateImageResponse* response);
    // Delete deletes the image by name.
    virtual ::grpc::Status Delete(::grpc::ServerContext* context, const ::containerd::services::images::v1::DeleteImageRequest* request, ::google::protobuf::Empty* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_Get : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Get() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_Get() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Get(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::GetImageRequest* /*request*/, ::containerd::services::images::v1::GetImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGet(::grpc::ServerContext* context, ::containerd::services::images::v1::GetImageRequest* request, ::grpc::ServerAsyncResponseWriter< ::containerd::services::images::v1::GetImageResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_List : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_List() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_List() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status List(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::ListImagesRequest* /*request*/, ::containerd::services::images::v1::ListImagesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestList(::grpc::ServerContext* context, ::containerd::services::images::v1::ListImagesRequest* request, ::grpc::ServerAsyncResponseWriter< ::containerd::services::images::v1::ListImagesResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Create : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Create() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_Create() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Create(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::CreateImageRequest* /*request*/, ::containerd::services::images::v1::CreateImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreate(::grpc::ServerContext* context, ::containerd::services::images::v1::CreateImageRequest* request, ::grpc::ServerAsyncResponseWriter< ::containerd::services::images::v1::CreateImageResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Update : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Update() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_Update() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Update(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::UpdateImageRequest* /*request*/, ::containerd::services::images::v1::UpdateImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdate(::grpc::ServerContext* context, ::containerd::services::images::v1::UpdateImageRequest* request, ::grpc::ServerAsyncResponseWriter< ::containerd::services::images::v1::UpdateImageResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Delete : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Delete() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_Delete() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Delete(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::DeleteImageRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDelete(::grpc::ServerContext* context, ::containerd::services::images::v1::DeleteImageRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_Get<WithAsyncMethod_List<WithAsyncMethod_Create<WithAsyncMethod_Update<WithAsyncMethod_Delete<Service > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_Get : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Get() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::containerd::services::images::v1::GetImageRequest, ::containerd::services::images::v1::GetImageResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::containerd::services::images::v1::GetImageRequest* request, ::containerd::services::images::v1::GetImageResponse* response) { return this->Get(context, request, response); }));}
    void SetMessageAllocatorFor_Get(
        ::grpc::MessageAllocator< ::containerd::services::images::v1::GetImageRequest, ::containerd::services::images::v1::GetImageResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::containerd::services::images::v1::GetImageRequest, ::containerd::services::images::v1::GetImageResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Get() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Get(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::GetImageRequest* /*request*/, ::containerd::services::images::v1::GetImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Get(
      ::grpc::CallbackServerContext* /*context*/, const ::containerd::services::images::v1::GetImageRequest* /*request*/, ::containerd::services::images::v1::GetImageResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_List : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_List() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::containerd::services::images::v1::ListImagesRequest, ::containerd::services::images::v1::ListImagesResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::containerd::services::images::v1::ListImagesRequest* request, ::containerd::services::images::v1::ListImagesResponse* response) { return this->List(context, request, response); }));}
    void SetMessageAllocatorFor_List(
        ::grpc::MessageAllocator< ::containerd::services::images::v1::ListImagesRequest, ::containerd::services::images::v1::ListImagesResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::containerd::services::images::v1::ListImagesRequest, ::containerd::services::images::v1::ListImagesResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_List() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status List(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::ListImagesRequest* /*request*/, ::containerd::services::images::v1::ListImagesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* List(
      ::grpc::CallbackServerContext* /*context*/, const ::containerd::services::images::v1::ListImagesRequest* /*request*/, ::containerd::services::images::v1::ListImagesResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Create : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Create() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::containerd::services::images::v1::CreateImageRequest, ::containerd::services::images::v1::CreateImageResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::containerd::services::images::v1::CreateImageRequest* request, ::containerd::services::images::v1::CreateImageResponse* response) { return this->Create(context, request, response); }));}
    void SetMessageAllocatorFor_Create(
        ::grpc::MessageAllocator< ::containerd::services::images::v1::CreateImageRequest, ::containerd::services::images::v1::CreateImageResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::containerd::services::images::v1::CreateImageRequest, ::containerd::services::images::v1::CreateImageResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Create() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Create(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::CreateImageRequest* /*request*/, ::containerd::services::images::v1::CreateImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Create(
      ::grpc::CallbackServerContext* /*context*/, const ::containerd::services::images::v1::CreateImageRequest* /*request*/, ::containerd::services::images::v1::CreateImageResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Update : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Update() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::containerd::services::images::v1::UpdateImageRequest, ::containerd::services::images::v1::UpdateImageResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::containerd::services::images::v1::UpdateImageRequest* request, ::containerd::services::images::v1::UpdateImageResponse* response) { return this->Update(context, request, response); }));}
    void SetMessageAllocatorFor_Update(
        ::grpc::MessageAllocator< ::containerd::services::images::v1::UpdateImageRequest, ::containerd::services::images::v1::UpdateImageResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::containerd::services::images::v1::UpdateImageRequest, ::containerd::services::images::v1::UpdateImageResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Update() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Update(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::UpdateImageRequest* /*request*/, ::containerd::services::images::v1::UpdateImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Update(
      ::grpc::CallbackServerContext* /*context*/, const ::containerd::services::images::v1::UpdateImageRequest* /*request*/, ::containerd::services::images::v1::UpdateImageResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Delete : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Delete() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::containerd::services::images::v1::DeleteImageRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::containerd::services::images::v1::DeleteImageRequest* request, ::google::protobuf::Empty* response) { return this->Delete(context, request, response); }));}
    void SetMessageAllocatorFor_Delete(
        ::grpc::MessageAllocator< ::containerd::services::images::v1::DeleteImageRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::containerd::services::images::v1::DeleteImageRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Delete() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Delete(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::DeleteImageRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Delete(
      ::grpc::CallbackServerContext* /*context*/, const ::containerd::services::images::v1::DeleteImageRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_Get<WithCallbackMethod_List<WithCallbackMethod_Create<WithCallbackMethod_Update<WithCallbackMethod_Delete<Service > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_Get : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Get() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_Get() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Get(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::GetImageRequest* /*request*/, ::containerd::services::images::v1::GetImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_List : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_List() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_List() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status List(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::ListImagesRequest* /*request*/, ::containerd::services::images::v1::ListImagesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Create : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Create() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_Create() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Create(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::CreateImageRequest* /*request*/, ::containerd::services::images::v1::CreateImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Update : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Update() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_Update() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Update(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::UpdateImageRequest* /*request*/, ::containerd::services::images::v1::UpdateImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Delete : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Delete() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_Delete() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Delete(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::DeleteImageRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_Get : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Get() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_Get() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Get(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::GetImageRequest* /*request*/, ::containerd::services::images::v1::GetImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGet(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_List : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_List() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_List() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status List(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::ListImagesRequest* /*request*/, ::containerd::services::images::v1::ListImagesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestList(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Create : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Create() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_Create() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Create(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::CreateImageRequest* /*request*/, ::containerd::services::images::v1::CreateImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreate(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Update : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Update() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_Update() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Update(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::UpdateImageRequest* /*request*/, ::containerd::services::images::v1::UpdateImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdate(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Delete : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Delete() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_Delete() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Delete(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::DeleteImageRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDelete(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Get : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Get() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Get(context, request, response); }));
    }
    ~WithRawCallbackMethod_Get() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Get(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::GetImageRequest* /*request*/, ::containerd::services::images::v1::GetImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Get(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_List : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_List() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->List(context, request, response); }));
    }
    ~WithRawCallbackMethod_List() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status List(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::ListImagesRequest* /*request*/, ::containerd::services::images::v1::ListImagesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* List(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Create : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Create() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Create(context, request, response); }));
    }
    ~WithRawCallbackMethod_Create() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Create(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::CreateImageRequest* /*request*/, ::containerd::services::images::v1::CreateImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Create(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Update : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Update() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Update(context, request, response); }));
    }
    ~WithRawCallbackMethod_Update() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Update(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::UpdateImageRequest* /*request*/, ::containerd::services::images::v1::UpdateImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Update(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Delete : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Delete() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Delete(context, request, response); }));
    }
    ~WithRawCallbackMethod_Delete() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Delete(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::DeleteImageRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Delete(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Get : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Get() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::containerd::services::images::v1::GetImageRequest, ::containerd::services::images::v1::GetImageResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::containerd::services::images::v1::GetImageRequest, ::containerd::services::images::v1::GetImageResponse>* streamer) {
                       return this->StreamedGet(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Get() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Get(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::GetImageRequest* /*request*/, ::containerd::services::images::v1::GetImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGet(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::containerd::services::images::v1::GetImageRequest,::containerd::services::images::v1::GetImageResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_List : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_List() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::containerd::services::images::v1::ListImagesRequest, ::containerd::services::images::v1::ListImagesResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::containerd::services::images::v1::ListImagesRequest, ::containerd::services::images::v1::ListImagesResponse>* streamer) {
                       return this->StreamedList(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_List() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status List(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::ListImagesRequest* /*request*/, ::containerd::services::images::v1::ListImagesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedList(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::containerd::services::images::v1::ListImagesRequest,::containerd::services::images::v1::ListImagesResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Create : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Create() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::containerd::services::images::v1::CreateImageRequest, ::containerd::services::images::v1::CreateImageResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::containerd::services::images::v1::CreateImageRequest, ::containerd::services::images::v1::CreateImageResponse>* streamer) {
                       return this->StreamedCreate(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Create() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Create(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::CreateImageRequest* /*request*/, ::containerd::services::images::v1::CreateImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreate(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::containerd::services::images::v1::CreateImageRequest,::containerd::services::images::v1::CreateImageResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Update : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Update() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::containerd::services::images::v1::UpdateImageRequest, ::containerd::services::images::v1::UpdateImageResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::containerd::services::images::v1::UpdateImageRequest, ::containerd::services::images::v1::UpdateImageResponse>* streamer) {
                       return this->StreamedUpdate(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Update() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Update(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::UpdateImageRequest* /*request*/, ::containerd::services::images::v1::UpdateImageResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdate(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::containerd::services::images::v1::UpdateImageRequest,::containerd::services::images::v1::UpdateImageResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Delete : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Delete() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::containerd::services::images::v1::DeleteImageRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::containerd::services::images::v1::DeleteImageRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDelete(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Delete() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Delete(::grpc::ServerContext* /*context*/, const ::containerd::services::images::v1::DeleteImageRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDelete(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::containerd::services::images::v1::DeleteImageRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_Get<WithStreamedUnaryMethod_List<WithStreamedUnaryMethod_Create<WithStreamedUnaryMethod_Update<WithStreamedUnaryMethod_Delete<Service > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_Get<WithStreamedUnaryMethod_List<WithStreamedUnaryMethod_Create<WithStreamedUnaryMethod_Update<WithStreamedUnaryMethod_Delete<Service > > > > > StreamedService;
};

}  // namespace v1
}  // namespace images
}  // namespace services
}  // namespace containerd


#include <grpcpp/ports_undef.inc>
#endif  // GRPC_images_2eproto__INCLUDED
