/**
 * SECTION:group-details
 * @short_description: Groups for a contact.
 * 
 * <para>This allows contacts to be collected into user-defined groups (or categories) for organisational purposes. Groups are non-exclusive and non-hierarchical, so a single contact can be put into many groups, but groups may not themselves be put into groups.</para>
 */
/**
 * folks_group_details_change_group:
 * @self: the <link linkend="FolksGroupDetails"><type>FolksGroupDetails</type></link> instance
 * @group: (in): &nbsp;.  <para>a freeform group identifier </para>
 * @is_member: (in): &nbsp;.  <para>whether the contact should be a member of the group </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Add or remove the contact from the specified group.
 * 
 * <para>If <code>is_member</code> is <code>true</code>, the contact will be added to the <code>group</code>. If it is <code>false</code>, they will be removed from the <code>group</code>.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if changing the group failed in the backing store </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-group-details-change-group-finish"><function>folks_group_details_change_group_finish()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_group_details_change_group_finish:
 * @self: the <link linkend="FolksGroupDetails"><type>FolksGroupDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: location to store the error occurring, or %NULL to ignore
 * 
 * Add or remove the contact from the specified group.
 * 
 * <para>If <code>is_member</code> is <code>true</code>, the contact will be added to the <code>group</code>. If it is <code>false</code>, they will be removed from the <code>group</code>.</para>
 * <para><link linkend="GError"><type>GError</type></link> will be returned in @error <para>if changing the group failed in the backing store </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-group-details-change-group"><function>folks_group_details_change_group()</function></link>
 *
 * Since: 0.1.11
 */
/**
 * folks_group_details_change_groups:
 * @self: the <link linkend="FolksGroupDetails"><type>FolksGroupDetails</type></link> instance
 * @groups: (in): &nbsp;.  <para>the complete set of groups the contact should be a member of </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s groups.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksGroupDetails--groups"><type>"groups"</type></link> directly, as this method gives error notification and will only return once the groups have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the groups failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-group-details-change-groups-finish"><function>folks_group_details_change_groups_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_group_details_change_groups_finish:
 * @self: the <link linkend="FolksGroupDetails"><type>FolksGroupDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s groups.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksGroupDetails--groups"><type>"groups"</type></link> directly, as this method gives error notification and will only return once the groups have been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the groups failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-group-details-change-groups"><function>folks_group_details_change_groups()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksGroupDetails:groups:
 * 
 * A set of group IDs for groups containing the member.
 * 
 * <para>The complete set of freeform identifiers for all the groups the contact is a member of.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_group_details_get_groups:
 * @self: the <link linkend="FolksGroupDetails"><type>FolksGroupDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksGroupDetails--groups"><type>"groups"</type></link> property.
 * 
 * A set of group IDs for groups containing the member.
 * 
 * <para>The complete set of freeform identifiers for all the groups the contact is a member of.</para>
 * 
 * Returns: the value of the <link linkend="FolksGroupDetails--groups"><type>"groups"</type></link> property
 *
 * Since: 0.5.1
 */
/**
 * folks_group_details_set_groups:
 * @self: the <link linkend="FolksGroupDetails"><type>FolksGroupDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksGroupDetails--groups"><type>"groups"</type></link> property
 * 
 * Set the value of the <link linkend="FolksGroupDetails--groups"><type>"groups"</type></link> property to @value.
 * 
 * A set of group IDs for groups containing the member.
 * 
 * <para>The complete set of freeform identifiers for all the groups the contact is a member of.</para>
 *
 * Since: 0.5.1
 */
/**
 * FolksGroupDetailsChangeReason:
 * @FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE: No reason was provided for this change.<para>This is used when a member joins or leaves a group normally.</para>
 * @FOLKS_GROUP_DETAILS_CHANGE_REASON_OFFLINE: The change is due to a member going offline.<para>Also used when member is already offline, but this wasn&apos;t known previously.</para>
 * @FOLKS_GROUP_DETAILS_CHANGE_REASON_KICKED: The change is due to a kick operation.
 * @FOLKS_GROUP_DETAILS_CHANGE_REASON_BUSY: The change is due to a busy indication.
 * @FOLKS_GROUP_DETAILS_CHANGE_REASON_INVITED: The change is due to an invitation.
 * @FOLKS_GROUP_DETAILS_CHANGE_REASON_BANNED: The change is due to a kick+ban operation.
 * @FOLKS_GROUP_DETAILS_CHANGE_REASON_ERROR: The change is due to an error occurring.
 * @FOLKS_GROUP_DETAILS_CHANGE_REASON_INVALID_MEMBER: The change is because the requested member does not exist.<para>For instance, if the user invites a nonexistent contact to a chatroom or attempts to call a nonexistent contact</para>
 * @FOLKS_GROUP_DETAILS_CHANGE_REASON_NO_ANSWER: The change is because the requested contact did not respond.
 * @FOLKS_GROUP_DETAILS_CHANGE_REASON_RENAMED: The change is because a member&apos;s unique identifier changed.<para>There must be exactly one member in the removed set and exactly one member in one of the added sets.</para>
 * @FOLKS_GROUP_DETAILS_CHANGE_REASON_PERMISSION_DENIED: The change is because there was no permission to contact the requested member.
 * @FOLKS_GROUP_DETAILS_CHANGE_REASON_SEPARATED: If members are removed with this reason code, the change is because the group has split into unconnected parts which can only communicate within themselves (e.g. netsplits on IRC use this reason code).<para>If members are added with this reason code, the change is because unconnected parts of the group have rejoined. If this channel carries messages (e.g. Text or Tubes channels) applications must assume that the contacts being added are likely to have missed some messages as a result of the separation, and that the contacts in the group are likely to have missed some messages from the contacts being added.</para><para>Note that from the added contacts&apos; perspective, they have been in the group all along, and the contacts we indicate to be in the group (including the local user) have just rejoined the group with reason Separated. Application protocols in Tubes should be prepared to cope with this situation.</para>
 * 
 * The reason a group member has changed its membership in the group.
 * 
 * <para>These closely follow the <ulink url="http://telepathy.freedesktop.org/spec/Channel_Interface_Group.html#Channel_Group_Change_Reason">Channel_Group_Change_Reason</ulink> interface in the Telepathy specification.</para>
 */
/**
 * FolksGroupDetails::group-changed:
 * @group_details: the <link linkend="FolksGroupDetails"><type>FolksGroupDetails</type></link> instance that received the signal
 * @group: &nbsp;.  <para>a freeform group identifier for the group being left or joined </para><para></para>
 * @is_member: &nbsp;.  <para>whether the contact is joining or leaving the group </para><para></para>
 * 
 * Emitted when the contact&apos;s membership status changes for a group.
 * 
 * <para>This is emitted if the contact becomes a member of a group they weren&apos;t in before, or leaves a group they were in.</para>
 *
 * Since: 0.1.11
 */
/**
 * FolksGroupDetails:
 * 
 * Groups for a contact.
 * 
 * <para>This allows contacts to be collected into user-defined groups (or categories) for organisational purposes. Groups are non-exclusive and non-hierarchical, so a single contact can be put into many groups, but groups may not themselves be put into groups.</para>
 */
/**
 * FolksGroupDetailsIface:
 * @change_group: virtual method called by <link linkend="folks-group-details-change-group"><function>folks_group_details_change_group()</function></link>
 * @change_group_finish: asynchronous finish function for <structfield>change_group</structfield>, called by <link linkend="folks-group-details-change-group"><function>folks_group_details_change_group()</function></link>
 * @change_groups: virtual method called by <link linkend="folks-group-details-change-groups"><function>folks_group_details_change_groups()</function></link>
 * @change_groups_finish: asynchronous finish function for <structfield>change_groups</structfield>, called by <link linkend="folks-group-details-change-groups"><function>folks_group_details_change_groups()</function></link>
 * @get_groups: getter method for the abstract property <link linkend="FolksGroupDetails--groups"><type>"groups"</type></link>
 * @set_groups: setter method for the abstract property <link linkend="FolksGroupDetails--groups"><type>"groups"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksGroupDetails"><type>FolksGroupDetails</type></link> implementations.
 */
