/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.InvalidSyntaxException;

public class LDAPExpr {
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;
    public static final int EQ = 4;
    public static final int LE = 8;
    public static final int GE = 16;
    public static final int APPROX = 32;
    public static final int COMPLEX = 3;
    public static final int SIMPLE = 60;
    private static final char WILDCARD = '\uffff';
    private static final String WILDCARD_STRING = new String(new char[]{'\uffff'});
    private static final String NULL = "Null query";
    private static final String GARBAGE = "Trailing garbage";
    private static final String EOS = "Unexpected end of query";
    private static final String MALFORMED = "Malformed query";
    private static final String OPERATOR = "Undefined operator";
    private static Class<?> classBigDecimal;
    private static Constructor<?> consBigDecimal;
    private static Method compBigDecimal;
    private static Class<?> classBigInteger;
    private static Constructor<?> consBigInteger;
    private static Method compBigInteger;
    public int operator;
    public LDAPExpr[] args;
    public String attrName;
    public String attrValue;
    private static HashMap<Class<?>, Constructor<?>> constructorMap;

    public LDAPExpr(String filter) throws InvalidSyntaxException {
        ParseState ps = new ParseState(filter);
        LDAPExpr expr = null;
        try {
            expr = LDAPExpr.parseExpr(ps);
        }
        catch (StringIndexOutOfBoundsException e) {
            ps.error(EOS);
        }
        if (ps.rest().trim().length() != 0) {
            ps.error("Trailing garbage '" + ps.rest() + "'");
        }
        this.operator = expr.operator;
        this.args = expr.args;
        this.attrName = expr.attrName;
        this.attrValue = expr.attrValue;
    }

    private LDAPExpr(int operator, LDAPExpr[] args) {
        this.operator = operator;
        this.args = args;
        this.attrName = null;
        this.attrValue = null;
    }

    private LDAPExpr(int operator, String attrName, String attrValue) {
        this.operator = operator;
        this.args = null;
        this.attrName = attrName;
        this.attrValue = attrValue;
    }

    public Set<String> getMatchedObjectClasses() {
        AbstractSet objClasses;
        block8: {
            block9: {
                objClasses = null;
                if (this.operator != 4) break block9;
                if (!this.attrName.equalsIgnoreCase("objectClass") || this.attrValue.indexOf(65535) >= 0) break block8;
                objClasses = new OneSet<String>(this.attrValue);
                break block8;
            }
            if (this.operator == 0) {
                for (LDAPExpr arg : this.args) {
                    Set<String> r = arg.getMatchedObjectClasses();
                    if (r == null) continue;
                    if (objClasses == null) {
                        objClasses = new TreeSet();
                    }
                    objClasses.addAll(r);
                }
            } else if (this.operator == 1) {
                for (LDAPExpr arg : this.args) {
                    Set<String> r = arg.getMatchedObjectClasses();
                    if (r == null) {
                        objClasses = null;
                        break;
                    }
                    if (objClasses == null) {
                        objClasses = new TreeSet();
                    }
                    objClasses.addAll(r);
                }
            }
        }
        return objClasses;
    }

    public boolean isSimple(List<String> keywords, List<Object>[] cache, boolean matchCase) {
        if (this.operator == 4) {
            int index = keywords.indexOf(matchCase ? this.attrName : this.attrName.toLowerCase());
            if (index >= 0 && this.attrValue.indexOf(65535) < 0) {
                if (cache[index] == null) {
                    cache[index] = new ArrayList<Object>();
                }
                cache[index].add(this.attrValue);
                return true;
            }
        } else if (this.operator == 1) {
            for (int i = 0; i < this.args.length; ++i) {
                if (this.args[i].isSimple(keywords, cache, matchCase)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean query(String filter, Dictionary<String, Object> pd) throws InvalidSyntaxException {
        return new LDAPExpr(filter).evaluate(pd, false);
    }

    public boolean evaluate(Dictionary<String, ?> p, boolean matchCase) {
        if ((this.operator & 0x3C) != 0) {
            return this.compare(p.get(matchCase ? this.attrName : this.attrName.toLowerCase()), this.operator, this.attrValue);
        }
        switch (this.operator) {
            case 0: {
                for (int i = 0; i < this.args.length; ++i) {
                    if (this.args[i].evaluate(p, matchCase)) continue;
                    return false;
                }
                return true;
            }
            case 1: {
                for (LDAPExpr arg : this.args) {
                    if (!arg.evaluate(p, matchCase)) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                return !this.args[0].evaluate(p, matchCase);
            }
        }
        return false;
    }

    protected boolean compare(Object obj, int op, String s) {
        if (obj == null) {
            return false;
        }
        if (op == 4 && s.equals(WILDCARD_STRING)) {
            return true;
        }
        try {
            if (obj instanceof String) {
                return LDAPExpr.compareString((String)obj, op, s);
            }
            if (obj instanceof Character) {
                return LDAPExpr.compareString(obj.toString(), op, s);
            }
            if (obj instanceof Boolean) {
                if (op == 8 || op == 16) {
                    return false;
                }
                if (((Boolean)obj).booleanValue()) {
                    return s.equalsIgnoreCase("true");
                }
                return s.equalsIgnoreCase("false");
            }
            if (obj instanceof Number) {
                if (obj instanceof Byte) {
                    switch (op) {
                        case 8: {
                            return (Byte)obj <= Byte.parseByte(s);
                        }
                        case 16: {
                            return (Byte)obj >= Byte.parseByte(s);
                        }
                    }
                    return new Byte(s).equals(obj);
                }
                if (obj instanceof Integer) {
                    switch (op) {
                        case 8: {
                            return (Integer)obj <= Integer.parseInt(s);
                        }
                        case 16: {
                            return (Integer)obj >= Integer.parseInt(s);
                        }
                    }
                    return new Integer(s).equals(obj);
                }
                if (obj instanceof Short) {
                    switch (op) {
                        case 8: {
                            return (Short)obj <= Short.parseShort(s);
                        }
                        case 16: {
                            return (Short)obj >= Short.parseShort(s);
                        }
                    }
                    return new Short(s).equals(obj);
                }
                if (obj instanceof Long) {
                    switch (op) {
                        case 8: {
                            return (Long)obj <= Long.parseLong(s);
                        }
                        case 16: {
                            return (Long)obj >= Long.parseLong(s);
                        }
                    }
                    return new Long(s).equals(obj);
                }
                if (obj instanceof Float) {
                    switch (op) {
                        case 8: {
                            return ((Float)obj).floatValue() <= new Float(s).floatValue();
                        }
                        case 16: {
                            return ((Float)obj).floatValue() >= new Float(s).floatValue();
                        }
                    }
                    return new Float(s).equals(obj);
                }
                if (obj instanceof Double) {
                    switch (op) {
                        case 8: {
                            return (Double)obj <= new Double(s);
                        }
                        case 16: {
                            return (Double)obj >= new Double(s);
                        }
                    }
                    return new Double(s).equals(obj);
                }
                if (classBigInteger != null && classBigInteger.isInstance(obj)) {
                    Object n = consBigInteger.newInstance(s);
                    int c = (Integer)compBigInteger.invoke(obj, n);
                    switch (op) {
                        case 8: {
                            return c <= 0;
                        }
                        case 16: {
                            return c >= 0;
                        }
                    }
                    return c == 0;
                }
                if (classBigDecimal != null && classBigDecimal.isInstance(obj)) {
                    Object n = consBigDecimal.newInstance(s);
                    int c = (Integer)compBigDecimal.invoke(obj, n);
                    switch (op) {
                        case 8: {
                            return c <= 0;
                        }
                        case 16: {
                            return c >= 0;
                        }
                    }
                    return c == 0;
                }
            } else if (obj instanceof Collection) {
                for (Object name : (Collection)obj) {
                    if (!this.compare(name, op, s)) continue;
                    return true;
                }
            } else if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    if (!this.compare(Array.get(obj, i), op, s)) continue;
                    return true;
                }
            } else {
                Class<?> clazz = obj.getClass();
                Constructor<?> cons = LDAPExpr.getConstructor(clazz);
                if (cons != null) {
                    Object other = cons.newInstance(s);
                    if (obj instanceof Comparable) {
                        int c = ((Comparable)obj).compareTo(other);
                        switch (op) {
                            case 8: {
                                return c <= 0;
                            }
                            case 16: {
                                return c >= 0;
                            }
                        }
                        return c == 0;
                    }
                    boolean b = false;
                    if (op == 8 || op == 16 || op == 4 || op == 32) {
                        b = obj.equals(other);
                    }
                    return b;
                }
            }
        }
        catch (Exception ignored_but_evals_to_false) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Constructor<?> getConstructor(Class<?> clazz) {
        HashMap<Class<?>, Constructor<?>> hashMap = constructorMap;
        synchronized (hashMap) {
            Constructor<?> cons = constructorMap.get(clazz);
            if (!constructorMap.containsKey(clazz)) {
                try {
                    cons = clazz.getConstructor(String.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                constructorMap.put(clazz, cons);
            }
            return cons;
        }
    }

    private static boolean compareString(String s1, int op, String s2) {
        switch (op) {
            case 8: {
                return s1.compareTo(s2) <= 0;
            }
            case 16: {
                return s1.compareTo(s2) >= 0;
            }
            case 4: {
                return LDAPExpr.patSubstr(s1, s2);
            }
            case 32: {
                return LDAPExpr.fixupString(s2).equals(LDAPExpr.fixupString(s1));
            }
        }
        return false;
    }

    private static String fixupString(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean patSubstr(String s, String pat) {
        return s == null ? false : LDAPExpr.patSubstr(s.toCharArray(), 0, pat.toCharArray(), 0);
    }

    private static boolean patSubstr(char[] s, int si, char[] pat, int pi) {
        if (pat.length - pi == 0) {
            return s.length - si == 0;
        }
        if (pat[pi] == '\uffff') {
            ++pi;
            while (true) {
                if (LDAPExpr.patSubstr(s, si, pat, pi)) {
                    return true;
                }
                if (s.length - si == 0) {
                    return false;
                }
                ++si;
            }
        }
        if (s.length - si == 0) {
            return false;
        }
        if (s[si] != pat[pi]) {
            return false;
        }
        return LDAPExpr.patSubstr(s, ++si, pat, ++pi);
    }

    private static LDAPExpr parseExpr(ParseState ps) throws InvalidSyntaxException {
        int operator;
        ps.skipWhite();
        if (!ps.prefix("(")) {
            ps.error(MALFORMED);
        }
        ps.skipWhite();
        switch (ps.peek()) {
            case '&': {
                operator = 0;
                break;
            }
            case '|': {
                operator = 1;
                break;
            }
            case '!': {
                operator = 2;
                break;
            }
            default: {
                return LDAPExpr.parseSimple(ps);
            }
        }
        ps.skip(1);
        ArrayList<LDAPExpr> v = new ArrayList<LDAPExpr>();
        do {
            v.add(LDAPExpr.parseExpr(ps));
            ps.skipWhite();
        } while (ps.peek() == '(');
        int n = v.size();
        if (!ps.prefix(")") || n == 0 || operator == 2 && n > 1) {
            ps.error(MALFORMED);
        }
        LDAPExpr[] args = new LDAPExpr[n];
        v.toArray(args);
        return new LDAPExpr(operator, args);
    }

    private static LDAPExpr parseSimple(ParseState ps) throws InvalidSyntaxException {
        String attrName = ps.getAttributeName();
        if (attrName == null) {
            ps.error(MALFORMED);
        }
        int operator = 0;
        if (ps.prefix("=")) {
            operator = 4;
        } else if (ps.prefix("<=")) {
            operator = 8;
        } else if (ps.prefix(">=")) {
            operator = 16;
        } else if (ps.prefix("~=")) {
            operator = 32;
        } else {
            ps.error(OPERATOR);
        }
        String attrValue = ps.getAttributeValue();
        if (!ps.prefix(")")) {
            ps.error(MALFORMED);
        }
        return new LDAPExpr(operator, attrName, attrValue);
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("(");
        if ((this.operator & 0x3C) != 0) {
            res.append(this.attrName);
            switch (this.operator) {
                case 4: {
                    res.append("=");
                    break;
                }
                case 8: {
                    res.append("<=");
                    break;
                }
                case 16: {
                    res.append(">=");
                    break;
                }
                case 32: {
                    res.append("~=");
                }
            }
            for (int i = 0; i < this.attrValue.length(); ++i) {
                int c = this.attrValue.charAt(i);
                if (c == 40 || c == 41 || c == 42 || c == 92) {
                    res.append('\\');
                } else if (c == 65535) {
                    c = 42;
                }
                res.append((char)c);
            }
        } else {
            switch (this.operator) {
                case 0: {
                    res.append("&");
                    break;
                }
                case 1: {
                    res.append("|");
                    break;
                }
                case 2: {
                    res.append("!");
                }
            }
            for (LDAPExpr arg : this.args) {
                res.append(arg.toString());
            }
        }
        res.append(")");
        return res.toString();
    }

    static {
        constructorMap = new HashMap();
        try {
            classBigDecimal = Class.forName("java.math.BigDecimal");
            consBigDecimal = LDAPExpr.getConstructor(classBigDecimal);
            compBigDecimal = classBigDecimal.getMethod("compareTo", classBigDecimal);
        }
        catch (Exception ignore) {
            classBigDecimal = null;
        }
        try {
            classBigInteger = Class.forName("java.math.BigInteger");
            consBigInteger = LDAPExpr.getConstructor(classBigInteger);
            compBigInteger = classBigInteger.getMethod("compareTo", classBigInteger);
        }
        catch (Exception ignore) {
            classBigInteger = null;
        }
    }

    private static class OneSet<E>
    extends AbstractSet<E> {
        private final E elem;

        OneSet(E o) {
            this.elem = o;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                E ielem;
                {
                    this.ielem = OneSet.this.elem;
                }

                @Override
                public boolean hasNext() {
                    return this.ielem != null;
                }

                @Override
                public E next() {
                    if (this.ielem != null) {
                        Object r = this.ielem;
                        this.ielem = null;
                        return r;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.elem == null ? 0 : 1;
        }
    }

    private static class ParseState {
        int pos;
        String str;

        public ParseState(String str) throws InvalidSyntaxException {
            this.str = str;
            if (str.length() == 0) {
                this.error(LDAPExpr.NULL);
            }
            this.pos = 0;
        }

        public boolean prefix(String pre) {
            if (!this.str.startsWith(pre, this.pos)) {
                return false;
            }
            this.pos += pre.length();
            return true;
        }

        public char peek() {
            return this.str.charAt(this.pos);
        }

        public void skip(int n) {
            this.pos += n;
        }

        public String rest() {
            return this.str.substring(this.pos);
        }

        public void skipWhite() {
            while (Character.isWhitespace(this.str.charAt(this.pos))) {
                ++this.pos;
            }
        }

        public String getAttributeName() {
            char c;
            int start = this.pos;
            int end = -1;
            while ((c = this.str.charAt(this.pos)) != '(' && c != ')' && c != '<' && c != '>' && c != '=' && c != '~') {
                if (!Character.isWhitespace(c)) {
                    end = this.pos;
                }
                ++this.pos;
            }
            if (end == -1) {
                return null;
            }
            return this.str.substring(start, end + 1);
        }

        public String getAttributeValue() {
            StringBuffer sb = new StringBuffer();
            block5: while (true) {
                char c = this.str.charAt(this.pos);
                switch (c) {
                    case '(': 
                    case ')': {
                        break block5;
                    }
                    case '*': {
                        sb.append('\uffff');
                        break;
                    }
                    case '\\': {
                        sb.append(this.str.charAt(++this.pos));
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++this.pos;
            }
            return sb.toString();
        }

        public void error(String m) throws InvalidSyntaxException {
            throw new InvalidSyntaxException(m, this.str == null ? "" : this.str.substring(this.pos));
        }
    }
}

