---
stage: GitLab Dedicated
group: Environment Automation
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLab Dedicatedインスタンスのリリーススケジュール、バージョニングモデル、およびパッチプロセス。
title: GitLab Dedicatedのリリースとバージョニング
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab Dedicated

{{< /details >}}

GitLab Dedicatedは、新しい機能とセキュリティパッチへのアクセスとのバランスを取りながら、インスタンスの安定性を保つために、特定のバージョニングモデルとリリーススケジュールに従います。

## バージョニングモデル {#versioning-model}

インスタンスは、現在のGitLabリリースに対する以前のマイナーバージョン（`N-1`）で実行されます。たとえば、GitLab 16.9が利用可能な場合、インスタンスはGitLab 16.8を実行します。

このアプローチは以下を提供します:

- 安定性: デプロイ前のテストと検証のための追加時間。
- セキュリティ: 重大なパッチは、緊急メンテナンスを通じて迅速に適用されます。
- 予測可能性: 月次のリリースサイクルに合わせた定期的なアップグレードスケジュール。

新しい機能は、最初のGitLabリリースから約1か月後にインスタンスで利用可能になります。

## GitLabのバージョンを確認する {#check-your-gitlab-version}

GitLab自体またはスイッチボードを介してGitLabのバージョンを確認できます。

GitLabのバージョンを確認するには:

- GitLabで、次の手順を実行します: 左側のサイドバーの下部にある**ヘルプ**（{{< icon name="question" >}}）> **ヘルプ**を選択するか、`https://your-instance-url/help`に直接アクセスします。
- スイッチボードの場合: [テナント概要](tenant_overview.md)を参照してください。

## リリースロールアウトスケジュール {#release-rollout-schedule}

インスタンスは、各GitLabリリースから5日後に開始される段階的なタイムラインに従って、スケジュールされたメンテナンス期間中にアップグレードされます。

アップグレードは、割り当てられたメンテナンス期間中に次のスケジュールに従って行われます。`T`はマイナーGitLabリリースの日付です:

| リリース後の日数 | インスタンスのアップグレードの開始 |
| --------------------------- | ----------------------- |
| `T`+5                       | EMEAおよびアメリカ（オプション1）地域 |
| `T`+6                       | アジア太平洋地域     |
| `T`+10                      | アメリカ（オプション2）地域 |

たとえば、GitLab 16.9は2024-02-15にリリースされました。EMEAおよびアメリカ（オプション1）地域のインスタンスは、16.9リリースから5日後の2024-02-20に16.8にアップグレードされました。

運用上の制約によりメンテナンスが延期された場合、アップグレードは次に利用可能なメンテナンス期間に実行されます。

## 更新頻度 {#update-frequency}

インスタンスは、優先するメンテナンス期間中に定期的な更新を受け取ります:

毎月の更新には以下が含まれます:

- マイナーリリース1つ
- 2つのパッチリリース

追加の更新には以下が含まれる場合があります:

- 緊急メンテナンスによる重大なセキュリティパッチ
- インフラストラクチャの改善
- パフォーマンスの最適化

## パッチ検証タイムライン {#patch-validation-timeline}

重大なパッチは、セキュリティの脆弱性に迅速に対処できるように、迅速化されたタイムラインに従います:

1. 開発: バグの修正は、予想されるパッチリリース日の少なくとも2営業日前に、安定したブランチにマージされる必要があります。
1. パッチリリース: セキュリティの脆弱性または重大なバグに対するパッチがリリースされます。
1. 検証（0〜24時間）: このパッチは、ステージング環境で検証されます。
1. 緊急デプロイ: このパッチは、緊急メンテナンス手順を通じてインスタンスにデプロイされます。

### パッチリリーススケジュール {#patch-release-schedule}

毎月のリリースは、各月の第3木曜日の週に発生します。

重大なパッチは、月に2回、次の日にリリースされます:

- 月次リリース週の前の水曜日
- 月次リリース週の後の水曜日

たとえば、第3木曜日が2025年1月16日の場合:

- 月次リリース週: 2025年1月20～24日
- 最初のパッチリリース: 2025年1月15日 (前の水曜日)
- 2番目のパッチリリース: 2025年1月29日 (後の水曜日)

重要度の低いパッチは、次回の定期メンテナンス期間中にインスタンスにデプロイされます。

## 内部リリース {#internal-releases}

内部リリースは、公開前にGitLab Dedicatedインスタンスの重大なセキュリティ脆弱性および重大度の高いバグを修正するために使用されるプライベートリリースです。これらのリリースは、[緊急メンテナンス手順](maintenance.md#emergency-maintenance)を通じてデプロイされます。

次回の定期パッチを待つことができない重大な修正は、インスタンスが安全で安定した状態を維持できるように、内部リリースを通じて配信されます。

## バグの修正 {#bug-fixes}

GitLabエンジニアリングチームは、スケジュールされたメンテナンス期間中に、バージョンにバグの修正とパフォーマンスの改善を含めるように取り組んでいます。これらの修正は、ユーザーからのアクションを必要とせずに、事前に含まれています。

### バグ修正のリクエスト {#request-a-bug-fix}

バージョンに含まれていない特定のバグ修正をリクエストできます。

バグ修正をリクエストするには:

1. 修正を含むマージリクエストまたはイシューへのリンクを付けて、サポートチケットを送信します。
1. リクエストが承認されたかどうかについての応答を待ちます。

承認されると、修正は次回の定期メンテナンス期間に含まれます。

{{< alert type="note" >}}

依存関係、複雑さ、または互換性の考慮事項により、すべての修正をバックポートできるわけではありません。各リクエストは個別に評価されます。

{{< /alert >}}

## 関連トピック {#related-topics}

- [GitLab Dedicatedメンテナンスオペレーション](maintenance.md)
- [GitLabのリリースおよびメンテナンスポリシー](../../policy/maintenance.md)
