/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.one.util.streamex;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.jetbrains.kotlin.one.util.streamex.CancellableCollector;

interface Internals {
    public static final Function<int[], Integer> UNBOX_INT = box -> box[0];
    public static final Function<long[], Long> UNBOX_LONG = box -> box[0];
    public static final Function<double[], Double> UNBOX_DOUBLE = box -> box[0];
    public static final Object NONE = new Object();
    public static final Set<Collector.Characteristics> NO_CHARACTERISTICS = EnumSet.noneOf(Collector.Characteristics.class);
    public static final Set<Collector.Characteristics> UNORDERED_CHARACTERISTICS = EnumSet.of(Collector.Characteristics.UNORDERED);
    public static final Set<Collector.Characteristics> UNORDERED_ID_CHARACTERISTICS = EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
    public static final Set<Collector.Characteristics> ID_CHARACTERISTICS = EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);

    public static <T> Predicate<T> alwaysTrue() {
        return t2 -> true;
    }

    public static <A> Predicate<A> finished(Collector<?, A, ?> collector) {
        if (collector instanceof CancellableCollector) {
            return ((CancellableCollector)collector).finished();
        }
        return null;
    }

    public static abstract class CloneableSpliterator<T, S extends CloneableSpliterator<T, ?>>
    implements Cloneable,
    Spliterator<T> {
        S doClone() {
            try {
                return (S)((CloneableSpliterator)this.clone());
            }
            catch (CloneNotSupportedException e2) {
                throw new InternalError();
            }
        }
    }

    public static class ArrayCollection
    extends AbstractCollection<Object> {
        private final Object[] arr;

        ArrayCollection(Object[] arr) {
            this.arr = arr;
        }

        @Override
        public Iterator<Object> iterator() {
            return Arrays.asList(this.arr).iterator();
        }

        @Override
        public int size() {
            return this.arr.length;
        }

        @Override
        public Object[] toArray() {
            return this.arr;
        }
    }

    public static class CancelException
    extends Error {
        CancelException() {
            super(null, null, false, false);
        }
    }
}

