/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream64;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;
import com.dynatrace.hash4j.hashing.XXH3Base;
import com.dynatrace.hash4j.internal.ByteArrayUtil;

class XXH3_64
extends XXH3Base {
    private final long secShift12;
    private final long secShift13;
    private final long secShift14;
    private final long secShift15;
    private final long bitflip00;
    private final long bitflip12;
    private final long bitflip34;
    private final long bitflip56;
    private final long hash0;
    private static final Hasher64 DEFAULT_HASHER_INSTANCE = new XXH3_64();

    private XXH3_64(long seed) {
        super(seed);
        this.secShift12 = -4909775443879730369L + seed;
        this.secShift13 = -2282891677615274041L - seed;
        this.secShift14 = 8320639771003045937L + seed;
        this.secShift15 = -1453760514566526364L - seed;
        this.bitflip00 = 2267503259L + seed;
        this.bitflip12 = -4090762196417718878L - (seed ^ Long.reverseBytes(seed & 0xFFFFFFFFL));
        this.bitflip34 = 7458650908927343033L + seed;
        this.bitflip56 = -5812251307325107654L - seed;
        this.hash0 = XXH3_64.avalanche64(seed ^ 0x8726F9105DC21DDCL);
    }

    private XXH3_64() {
        this(0L);
    }

    public static Hasher64 create() {
        return DEFAULT_HASHER_INSTANCE;
    }

    public static Hasher64 create(long seed) {
        return new XXH3_64(seed);
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    private static long rrmxmx(long h64, long length) {
        h64 ^= Long.rotateLeft(h64, 49) ^ Long.rotateLeft(h64, 24);
        h64 *= -6939452855193903323L;
        h64 ^= (h64 >>> 35) + length;
        return (h64 *= -6939452855193903323L) ^ h64 >>> 28;
    }

    private static long mix16B(byte[] input, int offIn, long sec0, long sec1) {
        long lo = ByteArrayUtil.getLong(input, offIn);
        long hi = ByteArrayUtil.getLong(input, offIn + 8);
        return XXH3_64.mix2Accs(lo, hi, sec0, sec1);
    }

    private static long mix16B(CharSequence input, int offIn, long sec0, long sec1) {
        long lo = ByteArrayUtil.getLong(input, offIn);
        long hi = ByteArrayUtil.getLong(input, offIn + 4);
        return XXH3_64.mix2Accs(lo, hi, sec0, sec1);
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int length) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int offStripe;
        int s;
        int offBlock;
        if (length <= 16) {
            if (length > 8) {
                long lo = ByteArrayUtil.getLong(input, off) ^ this.bitflip34;
                long hi = ByteArrayUtil.getLong(input, off + length - 8) ^ this.bitflip56;
                long acc = (long)length + Long.reverseBytes(lo) + hi + XXH3_64.unsignedLongMulXorFold(lo, hi);
                return XXH3_64.avalanche3(acc);
            }
            if (length >= 4) {
                long input1 = ByteArrayUtil.getInt(input, off);
                long input2 = ByteArrayUtil.getInt(input, off + length - 4);
                long keyed = (input2 & 0xFFFFFFFFL) + (input1 << 32) ^ this.bitflip12;
                return XXH3_64.rrmxmx(keyed, length);
            }
            if (length != 0) {
                int c1 = input[off] & 0xFF;
                byte c2 = input[off + (length >> 1)];
                int c3 = input[off + length - 1] & 0xFF;
                long combined = (long)(c1 << 16 | c2 << 24 | c3 | length << 8) & 0xFFFFFFFFL;
                return XXH3_64.avalanche64(combined ^ this.bitflip00);
            }
            return this.hash0;
        }
        if (length <= 128) {
            long acc = (long)length * -7046029288634856825L;
            if (length > 32) {
                if (length > 64) {
                    if (length > 96) {
                        acc += XXH3_64.mix16B(input, off + 48, this.secret12, this.secret13);
                        acc += XXH3_64.mix16B(input, off + length - 64, this.secret14, this.secret15);
                    }
                    acc += XXH3_64.mix16B(input, off + 32, this.secret08, this.secret09);
                    acc += XXH3_64.mix16B(input, off + length - 48, this.secret10, this.secret11);
                }
                acc += XXH3_64.mix16B(input, off + 16, this.secret04, this.secret05);
                acc += XXH3_64.mix16B(input, off + length - 32, this.secret06, this.secret07);
            }
            acc += XXH3_64.mix16B(input, off, this.secret00, this.secret01);
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(input, off + length - 16, this.secret02, this.secret03));
        }
        if (length <= 240) {
            long acc = (long)length * -7046029288634856825L;
            acc += XXH3_64.mix16B(input, off + 0, this.secret00, this.secret01);
            acc += XXH3_64.mix16B(input, off + 16, this.secret02, this.secret03);
            acc += XXH3_64.mix16B(input, off + 32, this.secret04, this.secret05);
            acc += XXH3_64.mix16B(input, off + 48, this.secret06, this.secret07);
            acc += XXH3_64.mix16B(input, off + 64, this.secret08, this.secret09);
            acc += XXH3_64.mix16B(input, off + 80, this.secret10, this.secret11);
            acc += XXH3_64.mix16B(input, off + 96, this.secret12, this.secret13);
            acc += XXH3_64.mix16B(input, off + 112, this.secret14, this.secret15);
            acc = XXH3_64.avalanche3(acc);
            if (length >= 144) {
                acc += XXH3_64.mix16B(input, off + 128, this.secShift00, this.secShift01);
                if (length >= 160) {
                    acc += XXH3_64.mix16B(input, off + 144, this.secShift02, this.secShift03);
                    if (length >= 176) {
                        acc += XXH3_64.mix16B(input, off + 160, this.secShift04, this.secShift05);
                        if (length >= 192) {
                            acc += XXH3_64.mix16B(input, off + 176, this.secShift06, this.secShift07);
                            if (length >= 208) {
                                acc += XXH3_64.mix16B(input, off + 192, this.secShift08, this.secShift09);
                                if (length >= 224) {
                                    acc += XXH3_64.mix16B(input, off + 208, this.secShift10, this.secShift11);
                                    if (length >= 240) {
                                        acc += XXH3_64.mix16B(input, off + 224, this.secShift12, this.secShift13);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(input, off + length - 16, this.secShift14, this.secShift15));
        }
        long acc0 = 3266489917L;
        long acc1 = -7046029288634856825L;
        long acc2 = -4417276706812531889L;
        long acc3 = 1609587929392839161L;
        long acc4 = -8796714831421723037L;
        long acc5 = 2246822519L;
        long acc6 = 2870177450012600261L;
        long acc7 = 2654435761L;
        int nbBlocks = length - 1 >>> 10;
        for (int n = 0; n < nbBlocks; ++n) {
            offBlock = off + (n << 10);
            for (s = 0; s < 16; ++s) {
                offStripe = offBlock + (s << 6);
                b0 = ByteArrayUtil.getLong(input, offStripe + 0);
                b1 = ByteArrayUtil.getLong(input, offStripe + 8);
                b2 = ByteArrayUtil.getLong(input, offStripe + 16);
                b3 = ByteArrayUtil.getLong(input, offStripe + 24);
                b4 = ByteArrayUtil.getLong(input, offStripe + 32);
                b5 = ByteArrayUtil.getLong(input, offStripe + 40);
                b6 = ByteArrayUtil.getLong(input, offStripe + 48);
                b7 = ByteArrayUtil.getLong(input, offStripe + 56);
                acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
                acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
                acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
                acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
                acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
                acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
                acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
                acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
            }
            acc0 = XXH3_64.mixAcc(acc0, this.secret16);
            acc1 = XXH3_64.mixAcc(acc1, this.secret17);
            acc2 = XXH3_64.mixAcc(acc2, this.secret18);
            acc3 = XXH3_64.mixAcc(acc3, this.secret19);
            acc4 = XXH3_64.mixAcc(acc4, this.secret20);
            acc5 = XXH3_64.mixAcc(acc5, this.secret21);
            acc6 = XXH3_64.mixAcc(acc6, this.secret22);
            acc7 = XXH3_64.mixAcc(acc7, this.secret23);
        }
        int nbStripes = length - 1 - (nbBlocks << 10) >>> 6;
        offBlock = off + (nbBlocks << 10);
        for (s = 0; s < nbStripes; ++s) {
            offStripe = offBlock + (s << 6);
            b0 = ByteArrayUtil.getLong(input, offStripe + 0);
            b1 = ByteArrayUtil.getLong(input, offStripe + 8);
            b2 = ByteArrayUtil.getLong(input, offStripe + 16);
            b3 = ByteArrayUtil.getLong(input, offStripe + 24);
            b4 = ByteArrayUtil.getLong(input, offStripe + 32);
            b5 = ByteArrayUtil.getLong(input, offStripe + 40);
            b6 = ByteArrayUtil.getLong(input, offStripe + 48);
            b7 = ByteArrayUtil.getLong(input, offStripe + 56);
            acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
            acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
            acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
            acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
            acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
            acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
            acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
            acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
        }
        int offStripe2 = off + length - 64;
        long b02 = ByteArrayUtil.getLong(input, offStripe2 + 0);
        long b12 = ByteArrayUtil.getLong(input, offStripe2 + 8);
        long b22 = ByteArrayUtil.getLong(input, offStripe2 + 16);
        long b32 = ByteArrayUtil.getLong(input, offStripe2 + 24);
        long b42 = ByteArrayUtil.getLong(input, offStripe2 + 32);
        long b52 = ByteArrayUtil.getLong(input, offStripe2 + 40);
        long b62 = ByteArrayUtil.getLong(input, offStripe2 + 48);
        long b72 = ByteArrayUtil.getLong(input, offStripe2 + 56);
        return this.finalizeHash(length, acc0 += b12 + XXH3_64.contrib(b02, this.secShift16), acc1 += b02 + XXH3_64.contrib(b12, this.secShift17), acc2 += b32 + XXH3_64.contrib(b22, this.secShift18), acc3 += b22 + XXH3_64.contrib(b32, this.secShift19), acc4 += b52 + XXH3_64.contrib(b42, this.secShift20), acc5 += b42 + XXH3_64.contrib(b52, this.secShift21), acc6 += b72 + XXH3_64.contrib(b62, this.secShift22), acc7 += b62 + XXH3_64.contrib(b72, this.secShift23));
    }

    private long finalizeHash(long length, long acc0, long acc1, long acc2, long acc3, long acc4, long acc5, long acc6, long acc7) {
        long result64 = length * -7046029288634856825L + XXH3_64.mix2Accs(acc0, acc1, this.secShiftFinal0, this.secShiftFinal1) + XXH3_64.mix2Accs(acc2, acc3, this.secShiftFinal2, this.secShiftFinal3) + XXH3_64.mix2Accs(acc4, acc5, this.secShiftFinal4, this.secShiftFinal5) + XXH3_64.mix2Accs(acc6, acc7, this.secShiftFinal6, this.secShiftFinal7);
        return XXH3_64.avalanche3(result64);
    }

    @Override
    public long hashCharsToLong(CharSequence charSequence) {
        long b7;
        long b6;
        long b5;
        long b4;
        long b3;
        long b2;
        long b1;
        long b0;
        int offStripe;
        int s;
        int offBlock;
        int len = charSequence.length();
        if (len <= 8) {
            if (len > 4) {
                long lo = ByteArrayUtil.getLong(charSequence, 0) ^ this.bitflip34;
                long hi = ByteArrayUtil.getLong(charSequence, len - 4) ^ this.bitflip56;
                long acc = (long)(len << 1) + Long.reverseBytes(lo) + hi + XXH3_64.unsignedLongMulXorFold(lo, hi);
                return XXH3_64.avalanche3(acc);
            }
            if (len >= 2) {
                long input1 = ByteArrayUtil.getInt(charSequence, 0);
                long input2 = ByteArrayUtil.getInt(charSequence, len - 2);
                long keyed = (input2 & 0xFFFFFFFFL) + (input1 << 32) ^ this.bitflip12;
                return XXH3_64.rrmxmx(keyed, len << 1);
            }
            if (len != 0) {
                long c = charSequence.charAt(0);
                long combined = c << 16 | c >>> 8 | 0x200L;
                return XXH3_64.avalanche64(combined ^ this.bitflip00);
            }
            return this.hash0;
        }
        if (len <= 64) {
            long acc = (long)len * 4354685496439837966L;
            if (len > 16) {
                if (len > 32) {
                    if (len > 48) {
                        acc += XXH3_64.mix16B(charSequence, 24, this.secret12, this.secret13);
                        acc += XXH3_64.mix16B(charSequence, len - 32, this.secret14, this.secret15);
                    }
                    acc += XXH3_64.mix16B(charSequence, 16, this.secret08, this.secret09);
                    acc += XXH3_64.mix16B(charSequence, len - 24, this.secret10, this.secret11);
                }
                acc += XXH3_64.mix16B(charSequence, 8, this.secret04, this.secret05);
                acc += XXH3_64.mix16B(charSequence, len - 16, this.secret06, this.secret07);
            }
            acc += XXH3_64.mix16B(charSequence, 0, this.secret00, this.secret01);
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(charSequence, len - 8, this.secret02, this.secret03));
        }
        if (len <= 120) {
            long acc = (long)len * 4354685496439837966L;
            acc += XXH3_64.mix16B(charSequence, 0, this.secret00, this.secret01);
            acc += XXH3_64.mix16B(charSequence, 8, this.secret02, this.secret03);
            acc += XXH3_64.mix16B(charSequence, 16, this.secret04, this.secret05);
            acc += XXH3_64.mix16B(charSequence, 24, this.secret06, this.secret07);
            acc += XXH3_64.mix16B(charSequence, 32, this.secret08, this.secret09);
            acc += XXH3_64.mix16B(charSequence, 40, this.secret10, this.secret11);
            acc += XXH3_64.mix16B(charSequence, 48, this.secret12, this.secret13);
            acc += XXH3_64.mix16B(charSequence, 56, this.secret14, this.secret15);
            acc = XXH3_64.avalanche3(acc);
            if (len >= 72) {
                acc += XXH3_64.mix16B(charSequence, 64, this.secShift00, this.secShift01);
                if (len >= 80) {
                    acc += XXH3_64.mix16B(charSequence, 72, this.secShift02, this.secShift03);
                    if (len >= 88) {
                        acc += XXH3_64.mix16B(charSequence, 80, this.secShift04, this.secShift05);
                        if (len >= 96) {
                            acc += XXH3_64.mix16B(charSequence, 88, this.secShift06, this.secShift07);
                            if (len >= 104) {
                                acc += XXH3_64.mix16B(charSequence, 96, this.secShift08, this.secShift09);
                                if (len >= 112) {
                                    acc += XXH3_64.mix16B(charSequence, 104, this.secShift10, this.secShift11);
                                    if (len >= 120) {
                                        acc += XXH3_64.mix16B(charSequence, 112, this.secShift12, this.secShift13);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return XXH3_64.avalanche3(acc += XXH3_64.mix16B(charSequence, len - 8, this.secShift14, this.secShift15));
        }
        long acc0 = 3266489917L;
        long acc1 = -7046029288634856825L;
        long acc2 = -4417276706812531889L;
        long acc3 = 1609587929392839161L;
        long acc4 = -8796714831421723037L;
        long acc5 = 2246822519L;
        long acc6 = 2870177450012600261L;
        long acc7 = 2654435761L;
        int nbBlocks = len - 1 >>> 9;
        for (int n = 0; n < nbBlocks; ++n) {
            offBlock = n << 9;
            for (s = 0; s < 16; ++s) {
                offStripe = offBlock + (s << 5);
                b0 = ByteArrayUtil.getLong(charSequence, offStripe + 0);
                b1 = ByteArrayUtil.getLong(charSequence, offStripe + 4);
                b2 = ByteArrayUtil.getLong(charSequence, offStripe + 8);
                b3 = ByteArrayUtil.getLong(charSequence, offStripe + 12);
                b4 = ByteArrayUtil.getLong(charSequence, offStripe + 16);
                b5 = ByteArrayUtil.getLong(charSequence, offStripe + 20);
                b6 = ByteArrayUtil.getLong(charSequence, offStripe + 24);
                b7 = ByteArrayUtil.getLong(charSequence, offStripe + 28);
                acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
                acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
                acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
                acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
                acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
                acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
                acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
                acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
            }
            acc0 = XXH3_64.mixAcc(acc0, this.secret16);
            acc1 = XXH3_64.mixAcc(acc1, this.secret17);
            acc2 = XXH3_64.mixAcc(acc2, this.secret18);
            acc3 = XXH3_64.mixAcc(acc3, this.secret19);
            acc4 = XXH3_64.mixAcc(acc4, this.secret20);
            acc5 = XXH3_64.mixAcc(acc5, this.secret21);
            acc6 = XXH3_64.mixAcc(acc6, this.secret22);
            acc7 = XXH3_64.mixAcc(acc7, this.secret23);
        }
        int nbStripes = len - 1 - (nbBlocks << 9) >>> 5;
        offBlock = nbBlocks << 9;
        for (s = 0; s < nbStripes; ++s) {
            offStripe = offBlock + (s << 5);
            b0 = ByteArrayUtil.getLong(charSequence, offStripe + 0);
            b1 = ByteArrayUtil.getLong(charSequence, offStripe + 4);
            b2 = ByteArrayUtil.getLong(charSequence, offStripe + 8);
            b3 = ByteArrayUtil.getLong(charSequence, offStripe + 12);
            b4 = ByteArrayUtil.getLong(charSequence, offStripe + 16);
            b5 = ByteArrayUtil.getLong(charSequence, offStripe + 20);
            b6 = ByteArrayUtil.getLong(charSequence, offStripe + 24);
            b7 = ByteArrayUtil.getLong(charSequence, offStripe + 28);
            acc0 += b1 + XXH3_64.contrib(b0, this.secret[s + 0]);
            acc1 += b0 + XXH3_64.contrib(b1, this.secret[s + 1]);
            acc2 += b3 + XXH3_64.contrib(b2, this.secret[s + 2]);
            acc3 += b2 + XXH3_64.contrib(b3, this.secret[s + 3]);
            acc4 += b5 + XXH3_64.contrib(b4, this.secret[s + 4]);
            acc5 += b4 + XXH3_64.contrib(b5, this.secret[s + 5]);
            acc6 += b7 + XXH3_64.contrib(b6, this.secret[s + 6]);
            acc7 += b6 + XXH3_64.contrib(b7, this.secret[s + 7]);
        }
        int offStripe2 = len - 32;
        long b02 = ByteArrayUtil.getLong(charSequence, offStripe2 + 0);
        long b12 = ByteArrayUtil.getLong(charSequence, offStripe2 + 4);
        long b22 = ByteArrayUtil.getLong(charSequence, offStripe2 + 8);
        long b32 = ByteArrayUtil.getLong(charSequence, offStripe2 + 12);
        long b42 = ByteArrayUtil.getLong(charSequence, offStripe2 + 16);
        long b52 = ByteArrayUtil.getLong(charSequence, offStripe2 + 20);
        long b62 = ByteArrayUtil.getLong(charSequence, offStripe2 + 24);
        long b72 = ByteArrayUtil.getLong(charSequence, offStripe2 + 28);
        return this.finalizeHash((long)len << 1, acc0 += b12 + XXH3_64.contrib(b02, this.secShift16), acc1 += b02 + XXH3_64.contrib(b12, this.secShift17), acc2 += b32 + XXH3_64.contrib(b22, this.secShift18), acc3 += b22 + XXH3_64.contrib(b32, this.secShift19), acc4 += b52 + XXH3_64.contrib(b42, this.secShift20), acc5 += b42 + XXH3_64.contrib(b52, this.secShift21), acc6 += b72 + XXH3_64.contrib(b62, this.secShift22), acc7 += b62 + XXH3_64.contrib(b72, this.secShift23));
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        long lo = v1 ^ this.bitflip34;
        long hi = v2 ^ this.bitflip56;
        long acc = 16L + Long.reverseBytes(lo) + hi + XXH3_64.unsignedLongMulXorFold(lo, hi);
        return XXH3_64.avalanche3(acc);
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        long acc = -3084006263850599256L;
        acc += XXH3_64.mix2Accs(v1, v2, this.secret00, this.secret01);
        return XXH3_64.avalanche3(acc += XXH3_64.mix2Accs(v2, v3, this.secret02, this.secret03));
    }

    @Override
    protected long finish12Bytes(long a, long b) {
        long lo = a ^ this.bitflip34;
        long hi = b ^ this.bitflip56;
        long acc = 12L + Long.reverseBytes(lo) + hi + XXH3_64.unsignedLongMulXorFold(lo, hi);
        return XXH3_64.avalanche3(acc);
    }

    private final class HashStreamImpl
    extends XXH3Base.HashStreamImplBase
    implements AbstractHashStream64 {
        private HashStreamImpl() {
        }

        @Override
        public long getAsLong() {
            if (this.byteCount <= 256L) {
                return XXH3_64.this.hashBytesToLong(this.buffer, 0, (int)this.byteCount);
            }
            ByteArrayUtil.setLong(this.buffer, 256, ByteArrayUtil.getLong(this.buffer, 0));
            long acc0Loc = this.acc0;
            long acc1Loc = this.acc1;
            long acc2Loc = this.acc2;
            long acc3Loc = this.acc3;
            long acc4Loc = this.acc4;
            long acc5Loc = this.acc5;
            long acc6Loc = this.acc6;
            long acc7Loc = this.acc7;
            int off = 0;
            int s = (int)this.byteCount - 1 >>> 6 & 0xC;
            while (off + 64 <= ((int)this.byteCount - 1 & 0xFF)) {
                long b0 = ByteArrayUtil.getLong(this.buffer, off + 0);
                long b1 = ByteArrayUtil.getLong(this.buffer, off + 8);
                long b2 = ByteArrayUtil.getLong(this.buffer, off + 16);
                long b3 = ByteArrayUtil.getLong(this.buffer, off + 24);
                long b4 = ByteArrayUtil.getLong(this.buffer, off + 32);
                long b5 = ByteArrayUtil.getLong(this.buffer, off + 40);
                long b6 = ByteArrayUtil.getLong(this.buffer, off + 48);
                long b7 = ByteArrayUtil.getLong(this.buffer, off + 56);
                acc0Loc += b1 + XXH3Base.contrib(b0, XXH3_64.this.secret[s + 0]);
                acc1Loc += b0 + XXH3Base.contrib(b1, XXH3_64.this.secret[s + 1]);
                acc2Loc += b3 + XXH3Base.contrib(b2, XXH3_64.this.secret[s + 2]);
                acc3Loc += b2 + XXH3Base.contrib(b3, XXH3_64.this.secret[s + 3]);
                acc4Loc += b5 + XXH3Base.contrib(b4, XXH3_64.this.secret[s + 4]);
                acc5Loc += b4 + XXH3Base.contrib(b5, XXH3_64.this.secret[s + 5]);
                acc6Loc += b7 + XXH3Base.contrib(b6, XXH3_64.this.secret[s + 6]);
                acc7Loc += b6 + XXH3Base.contrib(b7, XXH3_64.this.secret[s + 7]);
                off += 64;
                ++s;
            }
            long b0 = ByteArrayUtil.getLong(this.buffer, this.offset - 64 & 0xFF);
            long b1 = ByteArrayUtil.getLong(this.buffer, this.offset - 56 & 0xFF);
            long b2 = ByteArrayUtil.getLong(this.buffer, this.offset - 48 & 0xFF);
            long b3 = ByteArrayUtil.getLong(this.buffer, this.offset - 40 & 0xFF);
            long b4 = ByteArrayUtil.getLong(this.buffer, this.offset - 32 & 0xFF);
            long b5 = ByteArrayUtil.getLong(this.buffer, this.offset - 24 & 0xFF);
            long b6 = ByteArrayUtil.getLong(this.buffer, this.offset - 16 & 0xFF);
            long b7 = ByteArrayUtil.getLong(this.buffer, this.offset - 8 & 0xFF);
            return XXH3_64.this.finalizeHash(this.byteCount, acc0Loc += b1 + XXH3Base.contrib(b0, XXH3_64.this.secShift16), acc1Loc += b0 + XXH3Base.contrib(b1, XXH3_64.this.secShift17), acc2Loc += b3 + XXH3Base.contrib(b2, XXH3_64.this.secShift18), acc3Loc += b2 + XXH3Base.contrib(b3, XXH3_64.this.secShift19), acc4Loc += b5 + XXH3Base.contrib(b4, XXH3_64.this.secShift20), acc5Loc += b4 + XXH3Base.contrib(b5, XXH3_64.this.secShift21), acc6Loc += b7 + XXH3Base.contrib(b6, XXH3_64.this.secShift22), acc7Loc += b6 + XXH3Base.contrib(b7, XXH3_64.this.secShift23));
        }

        @Override
        public HashStream64 putByte(byte v) {
            this.putByteImpl(v);
            return this;
        }

        @Override
        public HashStream64 putShort(short v) {
            this.putShortImpl(v);
            return this;
        }

        @Override
        public HashStream64 putChar(char v) {
            this.putCharImpl(v);
            return this;
        }

        @Override
        public HashStream64 putInt(int v) {
            this.putIntImpl(v);
            return this;
        }

        @Override
        public HashStream64 putLong(long v) {
            this.putLongImpl(v);
            return this;
        }

        @Override
        public HashStream64 putBytes(byte[] b, int off, int len) {
            this.putBytesImpl(b, off, len);
            return this;
        }

        @Override
        public HashStream64 putChars(CharSequence c) {
            this.putCharsImpl(c);
            return this;
        }

        @Override
        public HashStream64 reset() {
            this.resetImpl();
            return this;
        }

        @Override
        public HashStream64 copy() {
            HashStreamImpl hashStream = new HashStreamImpl();
            this.copyImpl(hashStream);
            return hashStream;
        }
    }
}

