/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.hmm;

import com.hankcs.hanlp.utility.MathUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class HiddenMarkovModel {
    public float[] start_probability;
    public float[][] emission_probability;
    public float[][] transition_probability;

    public HiddenMarkovModel(float[] start_probability, float[][] transition_probability, float[][] emission_probability) {
        this.start_probability = (float[])HiddenMarkovModel.deepCopy(start_probability);
        this.transition_probability = (float[][])HiddenMarkovModel.deepCopy(transition_probability);
        this.emission_probability = (float[][])HiddenMarkovModel.deepCopy(emission_probability);
    }

    protected static double[] logToCdf(float[] log) {
        double[] cdf = new double[log.length];
        cdf[0] = Math.exp(log[0]);
        for (int i = 1; i < cdf.length - 1; ++i) {
            cdf[i] = cdf[i - 1] + Math.exp(log[i]);
        }
        cdf[cdf.length - 1] = 1.0;
        return cdf;
    }

    protected static double[][] logToCdf(float[][] log) {
        double[][] cdf = new double[log.length][log[0].length];
        for (int i = 0; i < log.length; ++i) {
            cdf[i] = HiddenMarkovModel.logToCdf(log[i]);
        }
        return cdf;
    }

    protected static int drawFrom(double[] cdf) {
        int index = Arrays.binarySearch(cdf, Math.random());
        if (index >= 0) {
            return index;
        }
        return -index - 1;
    }

    protected void normalize(float[] freq) {
        float sum = MathUtility.sum(freq);
        int i = 0;
        while (i < freq.length) {
            int n = i++;
            freq[n] = freq[n] / sum;
        }
    }

    public void unLog() {
        int j;
        int i;
        for (i = 0; i < this.start_probability.length; ++i) {
            this.start_probability[i] = (float)Math.exp(this.start_probability[i]);
        }
        for (i = 0; i < this.emission_probability.length; ++i) {
            for (j = 0; j < this.emission_probability[i].length; ++j) {
                this.emission_probability[i][j] = (float)Math.exp(this.emission_probability[i][j]);
            }
        }
        for (i = 0; i < this.transition_probability.length; ++i) {
            for (j = 0; j < this.transition_probability[i].length; ++j) {
                this.transition_probability[i][j] = (float)Math.exp(this.transition_probability[i][j]);
            }
        }
    }

    protected void toLog() {
        if (this.start_probability == null || this.transition_probability == null || this.emission_probability == null) {
            return;
        }
        for (int i = 0; i < this.start_probability.length; ++i) {
            int j;
            this.start_probability[i] = (float)Math.log(this.start_probability[i]);
            for (j = 0; j < this.start_probability.length; ++j) {
                this.transition_probability[i][j] = (float)Math.log(this.transition_probability[i][j]);
            }
            for (j = 0; j < this.emission_probability[0].length; ++j) {
                this.emission_probability[i][j] = (float)Math.log(this.emission_probability[i][j]);
            }
        }
    }

    public void train(Collection<int[][]> samples) {
        if (samples.isEmpty()) {
            return;
        }
        int max_state = 0;
        int max_obser = 0;
        for (int[][] sample : samples) {
            if (sample.length != 2 || sample[0].length != sample[1].length) {
                throw new IllegalArgumentException("\u975e\u6cd5\u6837\u672c");
            }
            for (int o : sample[0]) {
                max_obser = Math.max(max_obser, o);
            }
            for (int s : sample[1]) {
                max_state = Math.max(max_state, s);
            }
        }
        this.estimateStartProbability(samples, max_state);
        this.estimateTransitionProbability(samples, max_state);
        this.estimateEmissionProbability(samples, max_state, max_obser);
        this.toLog();
    }

    protected void estimateEmissionProbability(Collection<int[][]> samples, int max_state, int max_obser) {
        this.emission_probability = new float[max_state + 1][max_obser + 1];
        for (int[][] sample : samples) {
            for (int i = 0; i < sample[0].length; ++i) {
                int o = sample[0][i];
                int s = sample[1][i];
                float[] fArray = this.emission_probability[s];
                int n = o;
                fArray[n] = fArray[n] + 1.0f;
            }
        }
        for (int i = 0; i < this.transition_probability.length; ++i) {
            this.normalize(this.emission_probability[i]);
        }
    }

    protected void estimateTransitionProbability(Collection<int[][]> samples, int max_state) {
        this.transition_probability = new float[max_state + 1][max_state + 1];
        for (int[][] sample : samples) {
            int prev_s = sample[1][0];
            for (int i = 1; i < sample[0].length; ++i) {
                int s = sample[1][i];
                float[] fArray = this.transition_probability[prev_s];
                int n = s;
                fArray[n] = fArray[n] + 1.0f;
                prev_s = s;
            }
        }
        for (int i = 0; i < this.transition_probability.length; ++i) {
            this.normalize(this.transition_probability[i]);
        }
    }

    protected void estimateStartProbability(Collection<int[][]> samples, int max_state) {
        this.start_probability = new float[max_state + 1];
        for (int[][] sample : samples) {
            int s;
            int n = s = sample[1][0];
            this.start_probability[n] = this.start_probability[n] + 1.0f;
        }
        this.normalize(this.start_probability);
    }

    public abstract int[][] generate(int var1);

    public List<int[][]> generate(int minLength, int maxLength, int size) {
        ArrayList<int[][]> samples = new ArrayList<int[][]>(size);
        for (int i = 0; i < size; ++i) {
            samples.add(this.generate((int)(Math.floor(Math.random() * (double)(maxLength - minLength)) + (double)minLength)));
        }
        return samples;
    }

    public abstract float predict(int[] var1, int[] var2);

    public float predict(int[] o, Integer[] s) {
        int[] states = new int[s.length];
        float p = this.predict(o, states);
        for (int i = 0; i < states.length; ++i) {
            s[i] = states[i];
        }
        return p;
    }

    public boolean similar(HiddenMarkovModel model) {
        if (!HiddenMarkovModel.similar(this.start_probability, model.start_probability)) {
            return false;
        }
        for (int i = 0; i < this.transition_probability.length; ++i) {
            if (!HiddenMarkovModel.similar(this.transition_probability[i], model.transition_probability[i])) {
                return false;
            }
            if (HiddenMarkovModel.similar(this.emission_probability[i], model.emission_probability[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean similar(float[] A, float[] B) {
        float eta = 0.01f;
        for (int i = 0; i < A.length; ++i) {
            if (!(Math.abs(A[i] - B[i]) > 0.01f)) continue;
            return false;
        }
        return true;
    }

    protected static Object deepCopy(Object object) {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.flush();
            oos.close();
            bos.close();
            byte[] byteData = bos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(byteData);
            return new ObjectInputStream(bais).readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

