//Written in the D programming language
/**
 * License: $(HTTP boost.org/LICENSE_1_0.txt, Boost License 1.0).
 *
 * Authors: Dmitry Olshansky
 *
 */
// !!! DO NOT EDIT !!!
// !!! Did you even read the comment? !!!
// This module is automatically generated from Unicode Character Database files
// https://github.com/dlang/phobos/blob/master/tools/unicode_table_generator.d
//dfmt off
module std.internal.unicode_norm;
import std.internal.unicode_tables;

package(std):


static if (size_t.sizeof == 4)
{
//1856 bytes
enum nfcQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
0000000000000040000000D0",
x"
000001000000012000002000",
x"
020201000302020205020204020602020202020207020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000010000000000000000000200030000000500040007000600080000
000A000900000000000000000000000000000000000B000000000000000C0000000E000D000F00000000000000000000
000000000000001000000000000000000000001100000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000012000000140013000000000000000000000000000000000000000000000000
0000000000000000000000000000000000160015001700000019001800000000001A0000000000000000000000000000
001B00000000000000000000000000000000000000000000001C00000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001D00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000001200120000001E0000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
081A9FDF010361F80000003F401000000000008000000000000000000000000000000000000000000038000000000000
000000000000000000000000000000000000000010000000FF000000000000000000000040000000B080000000000000
00000000004800004E0000000000000000000000000000000000000000000000000000004000000030C0000000000000
000000004000000000800000000000000000000000000000004000000000000000000000000000000060000400000000
000000004000000000800000000000000000000000000000800084000000000000000000000000001084200801680200
200800020200108400000000000000000000000000004000000000000000000000000000000000000000000000000000
000000000000000000000000003FFFFE00000000FFFFFF00000000070000000000000000002000000000000000000000
000000000000000000000000000000000000000000000000000000002AAA0000000000004800000008080A002A00C808
00000003000000000000000000000000000000000000000000000000000000000000000000000C400000000000000000
000000000000000000000000000000000000000000000600000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000
06000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
7FE53FFFFFFFFC65FFFFFFFFFFFF3FFFFFFFFFFFFFFFFFFF03FFFFFF00000000A00000005F7FFC0000007FDB00000000
000000000000000000000000000000000000000000000000000000000000000000000000040000000000000000000000
000000000000008000000000000000000000000000000000000000000000000000000000400000000080000000000000
0000000009000000000003A4000000000000000000000000000000000000000000000000240100000000000000000000
000000000000000000000000000000000000000000008000000000000000000000000000000100000000000000000000
00000000000000000000000000000000C0000000000003FF000000000000000000000000000000000000000000000000
00000000000000000000000000000180000000000000000000000000000000000000000000000000C00000000000001F
00000000F800000000000001000000003FFFFFFF00000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000",
);
//2208 bytes
enum nfdQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
0000000000000040000000F0",
x"
000001000000016000002700",
x"
020201000504030207020206020802020202020209020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000100000003000200050004000500060007000500090008000B000A000C0005
0005000D00050005000500050005000500050005000E0005000500050010000F00120011001400130005000500050005
000500050005001500050005000500050005001600050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050017001700170017
001700170017001700170017001700170017001700170017001700170017001700170017001700170017001700170017
001700170017001700170017001700170017001700170017001700170018001700050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
00170005001A001900050005000500050005000500050005001B00050005000500050005000500050005000500050005
001D001C001E00050020001F000500050021000500050005000500050005000500220005000500050005000500050005
000500050005000500230005000500050005000500050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500240005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050017001700050025000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
0000000000000000000000000000000000000000000000003E7EFFBFBE7EFFBFFFFCFFFF7EF1FF3FFFF3F1F87FFFFF3F
0000000000018003DFFFE000FF31FFCFCFFFFFFF000FFFC0000000000000000000000000000000000000000000000000
00000000000000000000001B401000000001D7E00001FC0000187C00000000000200708B02000000708B000000C00000
0000000000000000FCCF0006033FFCFC0000000000000000000000000000000000000000000000000000000000000000
000000000000007C0000000000000000000000000000000000080005000000000000000000120200FF00000000000000
0000000000000000B00018000000000000000000004800004E0000000000000000000000000000000000000000000000
00000000000000003000190000000000001000000000000000001C000000000000000000000000000000010000000000
000000000000000000000D8100000000000000000000000000001C000000000000000000000000007400000000000000
000000000000000010842008016802002008000202001084000000000000000000000000000000400000000000000000
0000000000000000000000000000000000045540280000000000000B0000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0BFFFFFFFFFFFFFFFFFFFFFF03FFFFFF3F3FFFFFFFFFFFFFAAFF3F3F3FFFFFFF
FFFFFFFF5FDFFFFFEFCFFFDE3FDCFFFF0000000300000000000000000000000000000000000000000000000000000000
0000000000000C4000000000000000000C000000000040000000E000000000000000121000000050000002920333E005
000003330000F0000000000000003C0F0000000000000600000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000100000000000000000000000000000005555500036DB02A5
401000005555500036DB02A547900000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000F00000000000000007FE53FFFFFFFFC65FFFFFFFFFFFF3FFF
FFFFFFFFFFFFFFFF03FFFFFF00000000A00000005F7FFC0000007FDB0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000002000000001000000000000000000000000000000000
14000000000008000000000000000000000000000000C000000000000000000000000000000000000000000000000000
000000000000000000001800000000000002402800000000000001A00000000000000000000000000000000000000000
0000000058000000000000000000000000000000000000000000000000000000000000000C0000000000000000000000
000000000100000000000000000000000000000000000000000000000000000000000000000001FE0000000000000000
000000000000000000000000000000000000000000000000000000000000070000000000000000000000000000000000
0000000000000000C00000000000001F00000000F800000000000001000000003FFFFFFF000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
);
//3008 bytes
enum nfkcQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
0000000000000040000000F0",
x"
000001000000016000004000",
x"
020201000402030206020205080702020202020209020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000100000003000200050004000400060007000400090008000B000A000D000C
000F000E0004000400040004000400040004000400100004001100040013001200150014001700160004001800040004
0004000400040019001B001A001D001C001F001E00210020000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040023002200040004002400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400210004002600250027002100290028
000400040004000400040004002A000400040004000400040004000400040004002C002B002D0004002F002E00040004
003000040004000400040004000400040031000400040004000400040004000400040004000400040032000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040033000400040034000400040004003600350038003700040004000400040004000400040004
000400390004000400040004000400040004000400040004000400040004003A003B00040004003C0004000400040004
00040004003D000400040004000400040004000400040004000400040004000400040004000400040004000400040004
00040004000400040004000400040004002100210004003E000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
0000000000000000000000000000000000000000773C8501000000000000000000000000800C00000000020180000000
000000000000000000001FF0000E0000000000000000000000000000000000000000000001FF00003F0000000000001F
081A9FDF010361F80000003F44100000000000B000000000007F00000237000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000080000000000000000000000000
00000000000000000038000001E00000000000000000000000000000000000000000000010000000FF00000000000000
0000000040000000B08000000000000000000000004800004E0000000000000000000000000000000000000000000000
000000004000000030C00000000000000000000040000000008000000000000000000000000000000040000000000000
000000000000000000600004000000000000000040000000008000000000000000000000000000008000840000000000
000000000008000000000000000000000000000000080000300000000000000000001000000000001084200803E80200
200800020200108400000000000000000000000000004000000000000000000000000000000000000000000010000000
000000000000000000000000003FFFFE00000000FFFFFF00000000070000000000000000002000000000000000000000
0000000000000000000000000000000000000000F7FF7000FFFFBFFF010007FFF8000000FFFFFFFF0000000000000000
000000000000000000000000000000000C0000000000000000000000000000000000000000000000000000002AAA0000
00000000E8000000E808EA036A00E808008207FF50D8807080800380FFF300001FFF7FFF000001000000000000000000
3E6FFEEFFBFBBD57FFFF03E1FFFFFFFF00000200000000000000000000000000000000000001B0000000000000000000
000000000000000000000000000000000000000000000600000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000007FF00001000000000000000000000700000
000000000000000010000000000000000000000000000000000000003000000000000000000000000000000000000000
000000000000000000000000000080000000000000000000000000000000000000000000000000000000000000000000
80000000000000000000000000080000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF003FFFFF00000000
000000010740000000000000000000009E00000000000000000000008000000000000000FFFE0000FFFFFFFFFFFFFFFF
FFFC7FFF0000000000000000000000007FFFFFFFFFFFFFFFFFFF00FF7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000
3000000000000000000000000000000000000000000000000000000000010000000000000000000000000000031E0000
0000000000000000F000000000000200000000000000000000000000000000007FE53FFFFFFFFC65FFFFFFFFFFFF3FFF
FFFFFFFFFFFFFFFF03FFFFFF00000000A0F8007F5F7FFFFFFFFFFFDBFFFFFFFFFFFFFFFF0003FFFFFFF80000FFFFFFFF
FFFFFFFF3FFFFFFFFFFF0000FFFFFFFFFFFCFFFFFFFFFFFF000000FF1FFF000003FF0000FFFF0000FFF7FF9FFFD70F7F
FFFFFFFFFFFFFFFFFFFFFFFF1FFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFF1CFCFCFC00007F7F
00000000000000000000000000000000FFFFFFBE07FDFFFF000000000000000000000000000000000000000000000000
000000000400000000000000000000000000000000000080000000000000000000000000000000000000000000000000
000000004000000000800000000000000000000009000000000003A40000000000000000000000000000000000000000
000000002401000000000000000000000000000000000000000000000000000000000000000080000000000000000000
0000000000010000000000000000000000000000000000000000000000000000C0000000000003FF0000000000000000
000000000000000000000000000000000000000000000000000000000000018000000000000000000000000000000000
000000000000000000000000000000000000000000000000FFC0000003FFFFFF0000000000000000C00000000000001F
00000000F80000000000000100000000FFFFFFFFFFFFFFFFFFDFFFFFFFFFFFFFDFFFFFFFEBFFDE64FFFFFFEFFFFFFFFF
DFDFE7BF7BFFFFFFFFFDFC5FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCFFFFFFFFFFF
00000000FFFF0000FFFFFFFF00003FFF00000000000000000000000000000000FFFFFFEF0AF7FE96AA96EA845EF7F796
0FFFFBFF0FFFFBEE0000000000000000FFFF07FFFFFF7FFF0000FFFF00001C0000010000000000000000000000000000
FFFF00070FFFFFFF000301FF000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000003FF00003FFFFFFF00000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000",
);
//3136 bytes
enum nfkdQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000004000000100",
x"
000001000000018000004200",
x"
02020100050403020702020609080202020202020A020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001000000030002000500040007000600080007000A0009000C000B000E000D
0007000F0007000700070007000700070007000700100007001100070013001200150014001700160007001800070007
0007000700070019001B001A001D001C001F001E00210020000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070023002200070007002400070021002100210021
002100210021002100210021002100210021002100210021002100210021002100210021002100210021002100210021
002100210021002100210021002100210021002100210021002100210025002100070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
002100070027002600280021002A00290007000700070007002B0007002C000700070007000700070007000700070007
002E002D002F000700310030000700070032000700070007000700070007000700330007000700070007000700070007
000700070007000700340007000700070007000700070007000700070007000700070007000700070007000700070007
0007000700070007000700070007000700070007000700070007003500070007003600070007000700380037003A0039
000700070007000700070007000700070007003B0007000700070007000700070007000700070007000700070007003C
003D00070007003E000700070007000700070007003F0007000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070007000700210021000700400007000700070007
000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
000700070007000700070007000700070000000000000000000000000000000000000000773C85013E7EFFBFBE7EFFBF
FFFCFFFFFEFDFF3FFFF3F3F9FFFFFF3F0000000000018003DFFFFFF0FF3FFFCFCFFFFFFF000FFFC00000000000000000
0000000001FF00003F0000000000001F00000000000000000000001B441000000001D7F00001FC00007F7C0002370000
0200708B02000000708B000000C000000000000000000000FCCF0006033FFCFC00000000000000000000000000000000
00000080000000000000000000000000000000000000007C0000000001E0000000000000000000000008000500000000
00000000000000000000000000000000000000000000000000000000000000000000000000120200FF00000000000000
0000000000000000B00018000000000000000000004800004E0000000000000000000000000000000000000000000000
00000000000000003000190000000000001000000000000000001C000000000000000000000000000000010000000000
000000000000000000000D8100000000000000000000000000001C000000000000000000000000007400000000000000
000000000008000000000000000000000000000000080000300000000000000000001000000000001084200803E80200
200800020200108400000000000000000000000000000040000000000000000000000000000000000000000010000000
00045540280000000000000B000000000000000000000000000000000000000000000000F7FF7000FFFFBFFF010007FF
F8000000FFFFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0FFFFFFFFFFFFFFFFFFFFFFF03FFFFFF
3F3FFFFFFFFFFFFFAAFF3F3F3FFFFFFFFFFFFFFFFFDFFFFFEFCFFFDF7FDCFFFF008207FF50D8807080800380FFF30000
1FFF7FFF0000010000000000000000003E6FFEEFFBFBBD57FFFF03E1FFFFFFFF0C000200000040000000E00000000000
000012100001B050000002920333E005000003330000F0000000000000003C0F00000000000006000000000000000000
00000000000000000000000000000000000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000007FF
000010000000000000000000007000000000000000000000100000000000000000000000000000000000000030000000
000000000000000000000000000000000000000000000000000000000000800000000000000000000000000000000000
0000000000000000000000000000000080000000000000000000000000080000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF003FFFFF0000000000000001074000005555500036DB02A5D81000005555500036DB02A5C7900000
00000000FFFE0000FFFFFFFFFFFFFFFFFFFC7FFF0000000000000000000000007FFFFFFFFFFFFFFFFFFF00FF7FFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000003000000000000000000000000000000000000000000000000000000000010000
000000000000000000000000031E00000000000000000000F00000000000020000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000F00000000000000007FE53FFFFFFFFC65FFFFFFFFFFFF3FFF
FFFFFFFFFFFFFFFF03FFFFFF00000000A0F8007F5F7FFFFFFFFFFFDBFFFFFFFFFFFFFFFF0003FFFFFFF80000FFFFFFFF
FFFFFFFF3FFFFFFFFFFF0000FFFFFFFFFFFCFFFFFFFFFFFF000000FF1FFF000003FF0000FFFF0000FFF7FF9FFFD70F7F
FFFFFFFFFFFFFFFFFFFFFFFF1FFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFF1CFCFCFC00007F7F
000000000000000000000000000000000000000000000000000002000000001000000000000000000000000000000000
FFFFFFBE07FDFFFF00000000000000000000000000000000000000000000000014000000000008000000000000000000
000000000000C00000000000000000000000000000000000000000000000000000000000000000000000180000000000
0002402800000000000001A0000000000000000000000000000000000000000000000000580000000000000000000000
00000000000000000000000000000000000000000C000000000000000000000000000000010000000000000000000000
0000000000000000000000000000000000000000000001FE000000000000000000000000000000000000000000000000
000000000000000000000000000007000000000000000000000000000000000000000000000000000000000000000000
0000000000000000FFC0000003FFFFFF0000000000000000C00000000000001F00000000F80000000000000100000000
FFFFFFFFFFFFFFFFFFDFFFFFFFFFFFFFDFFFFFFFEBFFDE64FFFFFFEFFFFFFFFFDFDFE7BF7BFFFFFFFFFDFC5FFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3FFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCFFFFFFFFFFF00000000FFFF0000FFFFFFFF00003FFF
00000000000000000000000000000000FFFFFFEF0AF7FE96AA96EA845EF7F7960FFFFBFF0FFFFBEE0000000000000000
FFFF07FFFFFF7FFF0000FFFF00001C0000010000000000000000000000000000FFFF00070FFFFFFF000301FF00000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003FF0000
3FFFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);

}


static if (size_t.sizeof == 8)
{
//1856 bytes
enum nfcQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000000000000000000000200000000000000068",
x"
000000000000010000000000000001200000000000002000",
x"
030202020202010002060202050202040702020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000001000000000000000000020000000000050004000300000008000000070006
00000000000A00090000000000000000000B000000000000000C000000000000000F0000000E000D0000000000000000
000000100000000000000000000000000000000000000011000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000014001300120000000000000000000000000000000000000000000000000000
000000000000000000000000000000000017000000160015000000000019001800000000001A00000000000000000000
00000000001B00000000000000000000000000000000000000000000001C000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000001D000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000001E001200120000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
010361F8081A9FDF401000000000003F0000000000000080000000000000000000000000000000000000000000380000
00000000000000000000000000000000100000000000000000000000FF000000400000000000000000000000B0800000
0048000000000000000000004E0000000000000000000000000000000000000040000000000000000000000030C00000
400000000000000000000000008000000000000000000000000000000040000000000000000000000000000000600004
400000000000000000000000008000000000000000000000000000008000840000000000000000000168020010842008
020010842008000200000000000000000000400000000000000000000000000000000000000000000000000000000000
0000000000000000003FFFFE00000000FFFFFF0000000000000000000000000700200000000000000000000000000000
0000000000000000000000000000000000000000000000002AAA00000000000048000000000000002A00C80808080A00
000000000000000300000000000000000000000000000000000000000000000000000C40000000000000000000000000
000000000000000000000000000000000000060000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000
00000000060000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFC657FE53FFFFFFF3FFFFFFFFFFFFFFFFFFFFFFFFFFF0000000003FFFFFF5F7FFC00A00000000000000000007FDB
000000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000
000000800000000000000000000000000000000000000000000000000000000040000000000000000000000000800000
090000000000000000000000000003A40000000000000000000000000000000024010000000000000000000000000000
000000000000000000000000000000000000800000000000000000000000000000010000000000000000000000000000
00000000000000000000000000000000000003FFC0000000000000000000000000000000000000000000000000000000
000000000000000000000180000000000000000000000000000000000000000000000000000000000000001FC0000000
F8000000000000000000000000000001000000003FFFFFFF000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000",
);
//2208 bytes
enum nfdQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000000000000000000000200000000000000078",
x"
000000000000010000000000000001600000000000002700",
x"
050403020202010002080202070202060902020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000300020001000000050006000500040009000800070005000C0005000B000A
000500050005000D0005000500050005000E0005000500050010000F0005000500140013001200110005000500050005
000500150005000500050005000500050005000500050016000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050017001700170017
001700170017001700170017001700170017001700170017001700170017001700170017001700170017001700170017
001700170017001700170017001700170017001700170017001800170017001700050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
001A0019001700050005000500050005000500050005000500050005001B000500050005000500050005000500050005
001E0005001D001C000500050020001F0005000500210005000500050005000500050005002200050005000500050005
000500050005000500050005002300050005000500050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005002400050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
000500050005000500050005000500050005002500170017000500050005000500050005000500050005000500050005
000500050005000500050005000500050005000500050005000500050005000500050005000500050005000500050005
000000000000000000000000000000000000000000000000BE7EFFBF3E7EFFBF7EF1FF3FFFFCFFFF7FFFFF3FFFF3F1F8
0001800300000000FF31FFCFDFFFE000000FFFC0CFFFFFFF000000000000000000000000000000000000000000000000
0000000000000000401000000000001B0001FC000001D7E00000000000187C00020000000200708B00C00000708B0000
0000000000000000033FFCFCFCCF00060000000000000000000000000000000000000000000000000000000000000000
0000007C00000000000000000000000000000000000000000000000000080005001202000000000000000000FF000000
000000000000000000000000B00018000048000000000000000000004E00000000000000000000000000000000000000
0000000000000000000000003000190000000000001000000000000000001C0000000000000000000000000000000100
00000000000000000000000000000D8100000000000000000000000000001C0000000000000000000000000074000000
000000000000000001680200108420080200108420080002000000000000000000000040000000000000000000000000
000000000000000000000000000000002800000000045540000000000000000B00000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0BFFFFFF03FFFFFFFFFFFFFFFFFFFFFF3F3FFFFF3FFFFFFFAAFF3F3F
5FDFFFFFFFFFFFFF3FDCFFFFEFCFFFDE0000000000000003000000000000000000000000000000000000000000000000
00000C40000000000000000000000000000040000C000000000000000000E00000000050000012100333E00500000292
0000F0000000033300003C0F000000000000060000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000010000000000000000000000036DB02A555555000
55555000401000004790000036DB02A5FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000FFFFFFFFF0000000000000000FFFFFC657FE53FFFFFFF3FFFFFFFFFFF
FFFFFFFFFFFFFFFF0000000003FFFFFF5F7FFC00A00000000000000000007FDB00000000000000000000000000000000
000000000000000000000000000000000000000000000000000000100000020000000000000000000000000000000000
000008001400000000000000000000000000C00000000000000000000000000000000000000000000000000000000000
00000000000000000000000000001800000000000002402800000000000001A000000000000000000000000000000000
58000000000000000000000000000000000000000000000000000000000000000C000000000000000000000000000000
0100000000000000000000000000000000000000000000000000000000000000000001FE000000000000000000000000
000000000000000000000000000000000000000000000000000007000000000000000000000000000000000000000000
00000000000000000000001FC0000000F8000000000000000000000000000001000000003FFFFFFF0000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
);
//3008 bytes
enum nfkcQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000000000000000000000200000000000000078",
x"
000000000000010000000000000001600000000000004000",
x"
040203020202010008070202060202050902020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000300020001000000040006000500040009000800070004000D000C000B000A
00040004000F000E00040004000400040010000400040004001300120011000400170016001500140004000400040018
0004001900040004001D001C001B001A00210020001F001E000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004002300220004000400240004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400260025002100040029002800270021
0004000400040004002A00040004000400040004000400040004000400040004002D0004002C002B00040004002F002E
000400040030000400040004000400040004000400310004000400040004000400040004000400040004000400320004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040004000400330004000400340004003800370036003500040004000400040004000400040004
0004000400040039000400040004000400040004000400040004003A000400040004003C003B00040004000400040004
003D00040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
000400040004000400040004000400040004003E00210021000400040004000400040004000400040004000400040004
000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004
00000000000000000000000000000000773C8501000000000000000000000000800C0000000000008000000000000201
0000000000000000000E000000001FF00000000000000000000000000000000001FF0000000000000000001F3F000000
010361F8081A9FDF441000000000003F00000000000000B002370000007F000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000800000000000000000
000000000000000001E000000038000000000000000000000000000000000000100000000000000000000000FF000000
400000000000000000000000B08000000048000000000000000000004E00000000000000000000000000000000000000
40000000000000000000000030C000004000000000000000000000000080000000000000000000000000000000400000
000000000000000000000000006000044000000000000000000000000080000000000000000000000000000080008400
0008000000000000000000000000000000080000000000000000000030000000000000000000100003E8020010842008
020010842008000200000000000000000000400000000000000000000000000000000000000000001000000000000000
0000000000000000003FFFFE00000000FFFFFF0000000000000000000000000700200000000000000000000000000000
00000000000000000000000000000000F7FF700000000000010007FFFFFFBFFFFFFFFFFFF80000000000000000000000
00000000000000000000000000000000000000000C000000000000000000000000000000000000002AAA000000000000
E8000000000000006A00E808E808EA0350D88070008207FFFFF3000080800380000001001FFF7FFF0000000000000000
FBFBBD573E6FFEEFFFFFFFFFFFFF03E1000000000000020000000000000000000001B000000000000000000000000000
000000000000000000000000000000000000060000000000000000000000000000000000000000000000000000000000
0000000000000000FFFFFFFF00000000FFFFFFFFFFFFFFFF000007FFFFFFFFFF00000000000010000070000000000000
000000000000000000000000100000000000000000000000300000000000000000000000000000000000000000000000
000000000000000000008000000000000000000000000000000000000000000000000000000000000000000000000000
00000000800000000008000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000003FFFFF
07400000000000010000000000000000000000009E0000008000000000000000FFFE000000000000FFFFFFFFFFFFFFFF
00000000FFFC7FFF0000000000000000FFFFFFFF7FFFFFFF7FFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000000000000000
00000000300000000000000000000000000000000000000000010000000000000000000000000000031E000000000000
000000000000000000000200F000000000000000000000000000000000000000FFFFFC657FE53FFFFFFF3FFFFFFFFFFF
FFFFFFFFFFFFFFFF0000000003FFFFFF5F7FFFFFA0F8007FFFFFFFFFFFFFFFDB0003FFFFFFFFFFFFFFFFFFFFFFF80000
3FFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFCFFFF1FFF0000000000FFFFFF000003FF0000FFD70F7FFFF7FF9F
FFFFFFFFFFFFFFFF1FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF7FFFFFFFFFFFFFFF00007F7F1CFCFCFC
0000000000000000000000000000000007FDFFFFFFFFFFBE000000000000000000000000000000000000000000000000
040000000000000000000000000000000000008000000000000000000000000000000000000000000000000000000000
40000000000000000000000000800000090000000000000000000000000003A400000000000000000000000000000000
240100000000000000000000000000000000000000000000000000000000000000008000000000000000000000000000
0001000000000000000000000000000000000000000000000000000000000000000003FFC00000000000000000000000
000000000000000000000000000000000000000000000000000001800000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000003FFFFFFFFC0000000000000000000000000001FC0000000
F8000000000000000000000000000001FFFFFFFFFFFFFFFFFFFFFFFFFFDFFFFFEBFFDE64DFFFFFFFFFFFFFFFFFFFFFEF
7BFFFFFFDFDFE7BFFFFFFFFFFFFDFC5FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCFFF
FFFF00000000000000003FFFFFFFFFFF000000000000000000000000000000000AF7FE96FFFFFFEF5EF7F796AA96EA84
0FFFFBEE0FFFFBFF0000000000000000FFFF7FFFFFFF07FF00001C000000FFFF00000000000100000000000000000000
0FFFFFFFFFFF000700000000000301FF0000000000000000000000000000000000000000000000000000000000000000
000000000000000003FF000000000000000000003FFFFFFF000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000",
);
//3136 bytes
enum nfkdQCTrieEntries = TrieEntry!(bool, 8, 5, 8)(x"
000000000000000000000000000000200000000000000080",
x"
000000000000010000000000000001800000000000004200",
x"
050403020202010009080202070202060A02020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202
020202020202020202020202020202020202020202020202020202020202020202020202020202020000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000030002000100000007000600050004000A000900080007000E000D000C000B
000700070007000F00070007000700070010000700070007001300120011000700170016001500140007000700070018
0007001900070007001D001C001B001A00210020001F001E000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700070007002300220007000700240007000700070021002100210021
002100210021002100210021002100210021002100210021002100210021002100210021002100210021002100210021
002100210021002100210021002100210021002100210021002500210021002100070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
0027002600210007002A0029002800210007000700070007002C0007002B000700070007000700070007000700070007
002F0007002E002D00070007003100300007000700320007000700070007000700070007003300070007000700070007
000700070007000700070007003400070007000700070007000700070007000700070007000700070007000700070007
00070007000700070007000700070007000700070007000700070007000700350007000700360007003A003900380037
00070007000700070007000700070007000700070007003B000700070007000700070007000700070007003C00070007
0007003E003D00070007000700070007003F000700070007000700070007000700070007000700070007000700070007
000700070007000700070007000700070007000700070007000700070007000700070040002100210007000700070007
000700070007000700070007000700070007000700070007000700070007000700070007000700070007000700070007
0007000700070007000700070007000700000000000000000000000000000000773C850100000000BE7EFFBF3E7EFFBF
FEFDFF3FFFFCFFFFFFFFFF3FFFF3F3F90001800300000000FF3FFFCFDFFFFFF0000FFFC0CFFFFFFF0000000000000000
01FF0000000000000000001F3F0000000000000000000000441000000000001B0001FC000001D7F002370000007F7C00
020000000200708B00C00000708B00000000000000000000033FFCFCFCCF000600000000000000000000000000000000
000000000000008000000000000000000000007C0000000001E000000000000000000000000000000000000000080005
0000000000000000000000000000000000000000000000000000000000000000001202000000000000000000FF000000
000000000000000000000000B00018000048000000000000000000004E00000000000000000000000000000000000000
0000000000000000000000003000190000000000001000000000000000001C0000000000000000000000000000000100
00000000000000000000000000000D8100000000000000000000000000001C0000000000000000000000000074000000
0008000000000000000000000000000000080000000000000000000030000000000000000000100003E8020010842008
020010842008000200000000000000000000004000000000000000000000000000000000000000001000000000000000
2800000000045540000000000000000B00000000000000000000000000000000F7FF700000000000010007FFFFFFBFFF
FFFFFFFFF80000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0FFFFFFF03FFFFFFFFFFFFFF
FFFFFFFF3F3FFFFF3FFFFFFFAAFF3F3FFFDFFFFFFFFFFFFF7FDCFFFFEFCFFFDF50D88070008207FFFFF3000080800380
000001001FFF7FFF0000000000000000FBFBBD573E6FFEEFFFFFFFFFFFFF03E1000040000C000200000000000000E000
0001B050000012100333E005000002920000F0000000033300003C0F0000000000000600000000000000000000000000
000000000000000000000000000000000000000000000000FFFFFFFF00000000FFFFFFFFFFFFFFFF000007FFFFFFFFFF
000000000000100000700000000000000000000000000000000000001000000000000000000000003000000000000000
000000000000000000000000000000000000000000000000000080000000000000000000000000000000000000000000
0000000000000000000000000000000000000000800000000008000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000003FFFFF074000000000000136DB02A55555500055555000D8100000C790000036DB02A5
FFFE000000000000FFFFFFFFFFFFFFFF00000000FFFC7FFF0000000000000000FFFFFFFF7FFFFFFF7FFFFFFFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000000000000000000000000000000030000000000000000000000000000000000000000001000000000000
0000000000000000031E000000000000000000000000000000000200F000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000FFFFFFFFF0000000000000000FFFFFC657FE53FFFFFFF3FFFFFFFFFFF
FFFFFFFFFFFFFFFF0000000003FFFFFF5F7FFFFFA0F8007FFFFFFFFFFFFFFFDB0003FFFFFFFFFFFFFFFFFFFFFFF80000
3FFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFCFFFF1FFF0000000000FFFFFF000003FF0000FFD70F7FFFF7FF9F
FFFFFFFFFFFFFFFF1FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFF7FFFFFFFFFFFFFFF00007F7F1CFCFCFC
000000000000000000000000000000000000000000000000000000100000020000000000000000000000000000000000
07FDFFFFFFFFFFBE00000000000000000000000000000000000000000000000000000800140000000000000000000000
0000C0000000000000000000000000000000000000000000000000000000000000000000000000000000000000001800
000000000002402800000000000001A00000000000000000000000000000000058000000000000000000000000000000
000000000000000000000000000000000C00000000000000000000000000000001000000000000000000000000000000
00000000000000000000000000000000000001FE00000000000000000000000000000000000000000000000000000000
000000000000000000000700000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000003FFFFFFFFC0000000000000000000000000001FC0000000F8000000000000000000000000000001
FFFFFFFFFFFFFFFFFFFFFFFFFFDFFFFFEBFFDE64DFFFFFFFFFFFFFFFFFFFFFEF7BFFFFFFDFDFE7BFFFFFFFFFFFFDFC5F
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF3FFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCFFFFFFF00000000000000003FFFFFFFFFFF
000000000000000000000000000000000AF7FE96FFFFFFEF5EF7F796AA96EA840FFFFBEE0FFFFBFF0000000000000000
FFFF7FFFFFFF07FF00001C000000FFFF000000000001000000000000000000000FFFFFFFFFFF000700000000000301FF
0000000000000000000000000000000000000000000000000000000000000000000000000000000003FF000000000000
000000003FFFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000",
);

}

