/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import oracle.net.nt.TimeoutInterruptHandler;

public class Clock {
    private static long ACCURACY_IN_MILLIS = 1000L;
    private static AtomicBoolean cachedCurrentTimeMillisTaskStarted = new AtomicBoolean(false);
    private static AtomicLong cachedCurrentTimeMillis = new AtomicLong(System.currentTimeMillis());
    private static TimerTask cacheCurrentTimeMillis = new TimerTask(){

        @Override
        public void run() {
            cachedCurrentTimeMillis.set(System.currentTimeMillis());
        }
    };

    private Clock() {
    }

    public static long currentTimeMillis() {
        return cachedCurrentTimeMillis.get();
    }

    static {
        if (cachedCurrentTimeMillisTaskStarted.compareAndSet(false, true)) {
            TimeoutInterruptHandler.scheduleAtFixedRate(cacheCurrentTimeMillis, 0L, ACCURACY_IN_MILLIS);
        }
    }
}

