\name{BilateralImageFilter}
\alias{BilateralImageFilter}
\title{BilateralImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Blurs an image while preserving edges.
BilateralImageFilter}
\details{
This filter uses bilateral filtering to blur an image using both
domain and range "neighborhoods". Pixels that are close to a pixel
in the image domain and similar to a pixel in the image range are used
to calculate the filtered value. Two gaussian kernels (one in the
image domain and one in the image range) are used to smooth the image.
The result is an image that is smoothed in homogeneous regions yet has
edges preserved. The result is similar to anisotropic diffusion but
the implementation in non-iterative. Another benefit to bilateral
filtering is that any distance metric can be used for kernel smoothing
the image range. Hence, color images can be smoothed as vector images,
using the CIE distances between intensity values as the similarity
metric (the Gaussian kernel for the image domain is evaluated using
CIE distances). A separate version of this filter will be designed for
color and vector images.
Bilateral filtering is capable of reducing the noise in an image by an
order of magnitude while maintaining edges.
The bilateral operator used here was described by Tomasi and Manduchi
(Bilateral Filtering for Gray and ColorImages. IEEE ICCV. 1998.)
See:
GaussianOperator
RecursiveGaussianImageFilter
DiscreteGaussianImageFilter
AnisotropicDiffusionImageFilter
Image
Neighborhood
NeighborhoodOperator
 TodoSupport color images
Support vector images
See:
Bilateral for the procedural interface
itk::BilateralImageFilter for the Doxygen on the original ITK class.
BilateralImageFilter}
%C++ includes: sitkBilateralImageFilter.h
\section{Methods}{
\describe{
\item{ BilateralImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetDomainSigma() const:}{
Standard get/set macros for filter parameters. DomainSigma is
specified in the same units as the Image spacing. RangeSigma is specified in the units of intensity.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{unsigned int GetNumberOfRangeGaussianSamples() const:}{
Set/Get the number of samples in the approximation to the Gaussian
used for the range smoothing. Samples are only generated in the range
of [0, 4*m_RangeSigma]. Default is 100.
}
\item{double GetRangeSigma() const:}{
Standard get/set macros for filter parameters. DomainSigma is
specified in the same units as the Image spacing. RangeSigma is specified in the units of intensity.
}
\item{Self SetDomainSigma(double DomainSigma):}{
Convenience get/set methods for setting all domain parameters to the
same values.
}
\item{Self SetNumberOfRangeGaussianSamples(unsigned int NumberOfRangeGaussianSamples):}{
Set/Get the number of samples in the approximation to the Gaussian
used for the range smoothing. Samples are only generated in the range
of [0, 4*m_RangeSigma]. Default is 100.
}
\item{Self SetRangeSigma(double RangeSigma):}{
Standard get/set macros for filter parameters. DomainSigma is
specified in the same units as the Image spacing. RangeSigma is specified in the units of intensity.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BilateralImageFilter():}{
Destructor
}
}
}
