\name{OtsuThresholdImageFilter}
\alias{OtsuThresholdImageFilter}
\title{OtsuThresholdImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Threshold an image using the Otsu Threshold.
OtsuThresholdImageFilter}
\details{
This filter creates a binary thresholded image that separates an image
into foreground and background components. The filter computes the
threshold using the OtsuThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .
Richard Beare
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/811
See:
HistogramThresholdImageFilter
OtsuThreshold for the procedural interface
itk::OtsuThresholdImageFilter for the Doxygen on the original ITK class.
OtsuThresholdImageFilter}
%C++ includes: sitkOtsuThresholdImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image):}{}
\item{Image Execute(const Image &image, const Image &maskImage):}{
Execute the filter on the input image
}
\item{uint8_t GetInsideValue() const:}{
Get the "inside" pixel value.
}
\item{bool GetMaskOutput() const:}{}
\item{uint8_t GetMaskValue() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfHistogramBins() const:}{}
\item{uint8_t GetOutsideValue() const:}{
Get the "outside" pixel value.
}
\item{bool GetReturnBinMidpoint() const:}{
Should the threshold value be mid-point of the bin or the maximum?
Default is to return bin maximum.
}
\item{double GetThreshold() const:}{
Get the computed threshold.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{Self MaskOutputOff():}{}
\item{Self MaskOutputOn():}{
Set the value of MaskOutput to true or false respectfully.
}
\item{ OtsuThresholdImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self ReturnBinMidpointOff():}{}
\item{Self ReturnBinMidpointOn():}{
Set the value of ReturnBinMidpoint to true or false respectfully.
}
\item{Self SetInsideValue(uint8_t InsideValue):}{
Set the "inside" pixel value. The default value NumericTraits<OutputPixelType>::max()
}
\item{Self SetMaskOutput(bool MaskOutput):}{
Do you want the output to be masked by the mask used in histogram
construction. Only relevant if masking is in use.
}
\item{Self SetMaskValue(uint8_t MaskValue):}{
The value in the mask image, if used, indicating voxels that should be
included. Default is the max of pixel type, as in the
MaskedImageToHistogramFilter
}
\item{Self SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins):}{
Set/Get the number of histogram bins. Defaults is 128.
}
\item{Self SetOutsideValue(uint8_t OutsideValue):}{
Set the "outside" pixel value. The default value NumericTraits<OutputPixelType>::Zero.
}
\item{Self SetReturnBinMidpoint(bool ReturnBinMidpoint):}{
Should the threshold value be mid-point of the bin or the maximum?
Default is to return bin maximum.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~OtsuThresholdImageFilter():}{
Destructor
}
}
}
