/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AlphaComposite;
import java.awt.Area;
import java.awt.BDFontMetrics;
import java.awt.BDGraphics;
import java.awt.BDImage;
import java.awt.BDImageConsumer;
import java.awt.BDRootWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.PolyEdge;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.reflect.Field;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.dvb.ui.DVBBufferedImage;
import org.videolan.Logger;
import sun.awt.ConstrainableGraphics;

abstract class BDGraphicsBase
extends Graphics2D
implements ConstrainableGraphics {
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    private int width;
    private int height;
    private int[] backBuffer;
    private Area dirty;
    private GraphicsConfiguration gc;
    private Color foreground;
    protected Color background;
    private Font font;
    private BDFontMetrics fontMetrics;
    private AlphaComposite composite;
    private Color xorColor;
    private int originX;
    private int originY;
    private Rectangle actualClip;
    private Rectangle clip = null;
    private Rectangle constrainedRect = null;
    private int[] tmpLine = null;
    private static Field bufferedImagePeer;
    private static final Logger logger;

    BDGraphicsBase(BDGraphicsBase g) {
        this.backBuffer = g.backBuffer;
        this.dirty = g.dirty;
        this.width = g.width;
        this.height = g.height;
        this.gc = g.gc;
        this.foreground = g.foreground;
        this.background = g.background;
        this.composite = g.composite;
        this.font = g.font;
        this.fontMetrics = g.fontMetrics;
        this.originX = g.originX;
        this.originY = g.originY;
        if (g.clip != null) {
            this.clip = new Rectangle(g.clip);
        }
        this.setupClip();
    }

    BDGraphicsBase(BDRootWindow window) {
        this.width = window.getWidth();
        this.height = window.getHeight();
        this.backBuffer = window.getBdBackBuffer();
        this.dirty = window.getDirtyArea();
        this.gc = window.getGraphicsConfiguration();
        this.foreground = window.getForeground();
        this.background = window.getBackground();
        this.font = window.getFont();
        if (this.foreground == null) {
            this.foreground = DEFAULT_COLOR;
        }
        if (this.background == null) {
            this.background = DEFAULT_COLOR;
        }
        if (this.font == null) {
            this.font = DEFAULT_FONT;
        }
        this.fontMetrics = BDFontMetrics.getFontMetrics(this.font);
        this.composite = AlphaComposite.SrcOver;
        this.setupClip();
    }

    BDGraphicsBase(BDImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.backBuffer = image.getBdBackBuffer();
        this.dirty = image.getDirtyArea();
        this.gc = image.getGraphicsConfiguration();
        Component component = image.getComponent();
        if (component != null) {
            this.foreground = component.getForeground();
            this.background = component.getBackground();
            this.font = component.getFont();
        }
        if (this.foreground == null) {
            this.foreground = DEFAULT_COLOR;
        }
        if (this.background == null) {
            this.background = new Color(0, 0, 0, 0);
        }
        if (this.font == null) {
            this.font = DEFAULT_FONT;
        }
        this.fontMetrics = BDFontMetrics.getFontMetrics(this.font);
        this.composite = AlphaComposite.SrcOver;
        this.setupClip();
    }

    public Graphics create() {
        return new BDGraphics((BDGraphics)this);
    }

    public void translate(int x, int y) {
        this.originX += x;
        this.originY += y;
    }

    public void setFont(Font font) {
        if (font != null && !font.equals(this.font)) {
            this.font = font;
            this.fontMetrics = BDFontMetrics.getFontMetrics(font);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public FontMetrics getFontMetrics(Font font) {
        return BDFontMetrics.getFontMetrics(font);
    }

    public void setColor(Color c) {
        if (c != null && c != this.foreground) {
            this.foreground = c;
        }
    }

    public Color getColor() {
        return this.foreground;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.gc;
    }

    public void setComposite(Composite comp) {
        if (comp != null && comp != this.composite) {
            if (!(comp instanceof AlphaComposite)) {
                throw new IllegalArgumentException("Only AlphaComposite is supported");
            }
            this.composite = (AlphaComposite)comp;
        }
    }

    public void setPaintMode() {
        this.xorColor = null;
        this.composite = AlphaComposite.SrcOver;
    }

    public void setXORMode(Color color) {
        this.xorColor = color;
    }

    public Rectangle getClipBounds() {
        if (this.clip != null) {
            return new Rectangle(this.clip.x - this.originX, this.clip.y - this.originY, this.clip.width, this.clip.height);
        }
        return null;
    }

    public void constrain(int x, int y, int w, int h) {
        Rectangle rect = this.constrainedRect != null ? this.constrainedRect : new Rectangle(0, 0, this.width, this.height);
        this.constrainedRect = rect.intersection(new Rectangle(rect.x + x, rect.y + y, w, h));
        this.originX = this.constrainedRect.x;
        this.originY = this.constrainedRect.y;
        this.setupClip();
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public void clipRect(int x, int y, int w, int h) {
        Rectangle rect = new Rectangle(x + this.originX, y + this.originY, w, h);
        this.clip = this.clip != null ? this.clip.intersection(rect) : rect;
        this.setupClip();
    }

    public void setClip(int x, int y, int w, int h) {
        this.clip = new Rectangle(x + this.originX, y + this.originY, w, h);
        this.setupClip();
    }

    public void setClip(Shape clip) {
        if (clip == null) {
            this.clip = null;
            this.setupClip();
        } else if (clip instanceof Rectangle) {
            Rectangle rect = (Rectangle)clip;
            this.setClip(rect.x, rect.y, rect.width, rect.height);
        } else {
            throw new IllegalArgumentException("setClip(Shape) only supports Rectangle objects");
        }
    }

    private void setupClip() {
        Rectangle rect = this.constrainedRect != null ? this.constrainedRect : new Rectangle(0, 0, this.width, this.height);
        this.actualClip = this.clip != null ? this.clip.intersection(rect) : rect;
    }

    private int alphaBlend(int dest, int src) {
        int As = src >>> 24;
        if (As == 0) {
            return dest;
        }
        if (As == 255) {
            return src;
        }
        int Ad = dest >>> 24;
        if (Ad == 0) {
            return src;
        }
        int R = (src >>> 16 & 0xFF) * As * 255;
        int G = (src >>> 8 & 0xFF) * As * 255;
        int B = (src & 0xFF) * As * 255;
        Ad *= 255 - As;
        As = As * 255 + Ad;
        R = (R + (dest >>> 16 & 0xFF) * Ad) / As;
        G = (G + (dest >>> 8 & 0xFF) * Ad) / As;
        B = (B + (dest & 0xFF) * Ad) / As;
        R = Math.min(255, R);
        G = Math.min(255, G);
        B = Math.min(255, B);
        Ad = As / 255;
        Ad = Math.min(255, Ad);
        return Ad << 24 | R << 16 | G << 8 | B;
    }

    private int applyComposite(int rgb) {
        return (int)((float)(rgb >>> 24) * this.composite.getAlpha()) << 24 | rgb & 0xFFFFFF;
    }

    private void drawSpanN(int x, int y, int length, int rgb) {
        Rectangle rect = new Rectangle(x, y, length, 1);
        rect = this.actualClip.intersection(rect);
        if (rect.width <= 0 || rect.height <= 0 || rect.x < 0 || rect.y < 0) {
            return;
        }
        x = rect.x;
        length = rect.width;
        if (this.xorColor != null) {
            for (int i = 0; i < length; ++i) {
                int n = y * this.width + x + i;
                this.backBuffer[n] = this.backBuffer[n] ^ (this.xorColor.getRGB() ^ rgb);
            }
            this.dirty.add(rect);
            return;
        }
        switch (this.composite.getRule()) {
            case 1: {
                for (int i = 0; i < length; ++i) {
                    this.backBuffer[y * this.width + x + i] = 0;
                }
                break;
            }
            case 2: {
                rgb = this.applyComposite(rgb);
                for (int i = 0; i < length; ++i) {
                    this.backBuffer[y * this.width + x + i] = rgb;
                }
                break;
            }
            case 3: {
                rgb = this.applyComposite(rgb);
                for (int i = 0; i < length; ++i) {
                    this.backBuffer[y * this.width + x + i] = this.alphaBlend(this.backBuffer[y * this.width + x + i], rgb);
                }
                break;
            }
        }
        this.dirty.add(rect);
    }

    private void drawSpanN(int x, int y, int length, int[] src, int srcOffset, boolean flipX) {
        Rectangle rect = new Rectangle(x, y, length, 1);
        rect = this.actualClip.intersection(rect);
        if (rect.width <= 0 || rect.height <= 0 || rect.x < 0 || rect.y < 0) {
            return;
        }
        srcOffset += rect.x - x;
        x = rect.x;
        length = rect.width;
        int dstOffset = y * this.width + x;
        if (this.xorColor != null) {
            if (flipX) {
                for (int i = 0; i < length; ++i) {
                    int n = dstOffset + length - 1 - i;
                    this.backBuffer[n] = this.backBuffer[n] ^ (this.xorColor.getRGB() ^ src[srcOffset + i]);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    int n = dstOffset + i;
                    this.backBuffer[n] = this.backBuffer[n] ^ (this.xorColor.getRGB() ^ src[srcOffset + i]);
                }
            }
            this.dirty.add(rect);
            return;
        }
        switch (this.composite.getRule()) {
            case 1: {
                for (int i = 0; i < length; ++i) {
                    this.backBuffer[dstOffset + i] = 0;
                }
                break;
            }
            case 2: {
                if (flipX) {
                    for (int i = 0; i < length; ++i) {
                        this.backBuffer[dstOffset + length - 1 - i] = this.applyComposite(src[srcOffset + i]);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        this.backBuffer[dstOffset + i] = this.applyComposite(src[srcOffset + i]);
                    }
                }
                break;
            }
            case 3: {
                if (flipX) {
                    for (int i = 0; i < length; ++i) {
                        this.backBuffer[dstOffset + length - 1 - i] = this.alphaBlend(this.backBuffer[dstOffset + length - 1 - i], this.applyComposite(src[srcOffset + i]));
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        this.backBuffer[dstOffset + i] = this.alphaBlend(this.backBuffer[dstOffset + i], this.applyComposite(src[srcOffset + i]));
                    }
                }
                break;
            }
        }
        this.dirty.add(rect);
    }

    private void drawSpan(int x, int y, int length, int rgb) {
        this.drawSpanN(x += this.originX, y += this.originY, length, rgb);
    }

    private void drawSpan(int x, int y, int length, int[] src, int srcOffset, boolean flipX) {
        this.drawSpanN(x += this.originX, y += this.originY, length, src, srcOffset, flipX);
    }

    private void drawPointN(int x, int y, int rgb) {
        this.drawSpanN(x, y, 1, rgb);
    }

    private void drawGlyph(int[] rgbArray, int x0, int y0, int w, int h) {
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                this.drawPoint(x + x0, y + y0, rgbArray[y * w + x]);
            }
        }
    }

    private void drawPoint(int x, int y, int rgb) {
        if (this.actualClip.contains(x += this.originX, y += this.originY)) {
            this.drawPointN(x, y, rgb);
        }
    }

    public void clearRect(int x, int y, int w, int h) {
        Rectangle rect = new Rectangle(x += this.originX, y += this.originY, w, h);
        if ((rect = this.actualClip.intersection(rect)).isEmpty()) {
            return;
        }
        x = rect.x;
        y = rect.y;
        w = rect.width;
        h = rect.height;
        int rgb = this.background.getRGB();
        for (int i = 0; i < h; ++i) {
            Arrays.fill(this.backBuffer, (y + i) * this.width + x, (y + i) * this.width + x + w, rgb);
        }
        this.dirty.add(rect);
    }

    public void fillRect(int x, int y, int w, int h) {
        Rectangle rect = new Rectangle(x += this.originX, y += this.originY, w, h);
        rect = this.actualClip.intersection(rect);
        x = rect.x;
        y = rect.y;
        w = rect.width;
        h = rect.height;
        int rgb = this.foreground.getRGB();
        for (int Y = y; Y < y + h; ++Y) {
            this.drawSpanN(x, Y, w, rgb);
        }
    }

    public void drawRect(int x, int y, int w, int h) {
        this.drawLineN(x += this.originX, y += this.originY, x + w, y);
        this.drawLineN(x, y + h, x + w, y + h);
        this.drawLineN(x, y, x, y + h);
        this.drawLineN(x + w, y, x + w, y + h);
    }

    private void drawLineN(int x1, int y1, int x2, int y2) {
        int stepx;
        int stepy;
        int rgb = this.foreground.getRGB();
        int dy = y2 - y1;
        int dx = x2 - x1;
        if (dy < 0) {
            dy = -dy;
            stepy = -1;
        } else {
            stepy = 1;
        }
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        this.drawPointN(x1, y1, rgb);
        if ((dx <<= 1) > (dy <<= 1)) {
            int fraction = dy - (dx >> 1);
            while (x1 != x2) {
                if (fraction >= 0) {
                    y1 += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                this.drawPointN(x1 += stepx, y1, rgb);
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y1 != y2) {
                if (fraction >= 0) {
                    x1 += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                this.drawPointN(x1, y1 += stepy, rgb);
            }
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.drawLineN(x1 += this.originX, y1 += this.originY, x2 += this.originX, y2 += this.originY);
    }

    public void copyArea(int x, int y, int w, int h, int dx, int dy) {
        int i;
        Rectangle rect = new Rectangle(x += this.originX, y += this.originY, w, h);
        rect = this.actualClip.intersection(rect);
        if (rect.width <= 0 || rect.height <= 0) {
            return;
        }
        x = rect.x;
        y = rect.y;
        w = rect.width;
        h = rect.height;
        int[] subImage = new int[w * h];
        for (i = 0; i < h; ++i) {
            System.arraycopy(this.backBuffer, (y + i) * this.width + x, subImage, w * i, w);
        }
        for (i = 0; i < h; ++i) {
            this.drawSpanN(x + dx, y + i + dy, w, subImage, w * i, false);
        }
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints == 1) {
            this.drawPoint(xPoints[0], yPoints[0], this.foreground.getRGB());
        } else {
            for (int i = 0; i < nPoints - 1; ++i) {
                this.drawLine(xPoints[i], xPoints[i], xPoints[i + 1], xPoints[i + 1]);
            }
        }
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints == 1) {
            this.drawPoint(xPoints[0], yPoints[0], this.foreground.getRGB());
        } else {
            for (int i = 0; i < nPoints - 1; ++i) {
                this.drawLine(xPoints[i], xPoints[i], xPoints[i + 1], xPoints[i + 1]);
            }
            if (nPoints > 2) {
                this.drawLine(xPoints[0], xPoints[0], xPoints[nPoints - 1], xPoints[nPoints - 1]);
            }
        }
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int colour = this.foreground.getRGB();
        if (nPoints < 3) {
            return;
        }
        for (int i = 0; i < nPoints; ++i) {
            if (yPoints[i] > maxY) {
                maxY = yPoints[i];
            }
            if (yPoints[i] >= minY) continue;
            minY = yPoints[i];
        }
        if (xPoints[0] == xPoints[nPoints - 1] && yPoints[0] == yPoints[nPoints - 1]) {
            --nPoints;
        }
        PolyEdge[] polyEdges = new PolyEdge[nPoints];
        for (int i = 0; i < nPoints - 1; ++i) {
            polyEdges[i] = new PolyEdge(xPoints[i], yPoints[i], xPoints[i + 1], yPoints[i + 1]);
        }
        polyEdges[nPoints - 1] = new PolyEdge(xPoints[nPoints - 1], yPoints[nPoints - 1], xPoints[0], yPoints[0]);
        ArrayList<Integer> xList = new ArrayList<Integer>();
        for (int i = minY; i <= maxY; ++i) {
            for (int j = 0; j < nPoints; ++j) {
                if (!polyEdges[j].intersects(i)) continue;
                int x = polyEdges[j].intersectionX(i);
                xList.add(new Integer(x));
            }
            HashSet<Integer> hs = new HashSet<Integer>();
            hs.addAll(xList);
            xList.clear();
            xList.addAll(hs);
            if (xList.size() % 2 > 0) {
                xList.clear();
                continue;
            }
            Collections.sort(xList);
            for (int j = 0; j < xList.size(); j += 2) {
                int x1 = (Integer)xList.get(j);
                int x2 = (Integer)xList.get(j + 1);
                this.drawSpan(x1, i, x2 - x1, colour);
            }
            xList.clear();
        }
    }

    public void drawOval(int x, int y, int w, int h) {
        int offset;
        int i;
        if (w <= 0 || h <= 0) {
            return;
        }
        int count = 0;
        int numPoints = (h / 2 + h / 2 + 1) * 2;
        int[] xList = new int[++numPoints];
        int[] yList = new int[numPoints];
        float as = (float)w / 2.0f * ((float)w / 2.0f);
        float bs = (float)h / 2.0f * ((float)h / 2.0f);
        for (i = -h / 2; i <= h / 2; ++i) {
            int startX;
            offset = (int)Math.sqrt((1.0 - (double)((float)(i * i) / bs)) * (double)as);
            xList[count] = startX = x - offset + w / 2;
            yList[count] = y + i + h / 2;
            ++count;
        }
        for (i = h / 2; i >= -h / 2; --i) {
            int endX;
            offset = (int)Math.sqrt((1.0 - (double)((float)(i * i) / bs)) * (double)as);
            xList[count] = endX = x + offset + w / 2;
            yList[count] = y + i + h / 2;
            ++count;
        }
        xList[count] = xList[0];
        yList[count] = yList[0];
        this.drawPolyline(xList, yList, numPoints);
    }

    public void fillOval(int x, int y, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        float as = (float)w / 2.0f * ((float)w / 2.0f);
        float bs = (float)h / 2.0f * ((float)h / 2.0f);
        int colour = this.foreground.getRGB();
        for (int i = -h / 2; i <= h / 2; ++i) {
            int offset = (int)Math.sqrt((1.0 - (double)((float)(i * i) / bs)) * (double)as);
            int startX = x - offset + w / 2;
            int endX = x + offset + w / 2;
            this.drawSpan(startX, y + i + h / 2, endX - startX + 1, colour);
        }
    }

    public void drawArc(int x, int y, int w, int h, int startAngle, int endAngle) {
        logger.unimplemented("drawArc");
    }

    public void fillArc(int x, int y, int w, int h, int startAngle, int endAngle) {
        logger.unimplemented("fillArc");
    }

    public void drawRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight) {
        int endX;
        int startX;
        int offset;
        int i;
        if (w <= 0 || h <= 0) {
            return;
        }
        if (arcWidth == 0 || arcHeight == 0) {
            this.drawRect(x, y, w, h);
            return;
        }
        if (arcWidth < 0) {
            arcWidth *= -1;
        }
        if (arcHeight < 0) {
            arcHeight *= -1;
        }
        int count = 0;
        int numPoints = (arcHeight / 2 + 1) * 2;
        numPoints += (arcHeight / 2 + 1) * 2;
        int[] xList = new int[++numPoints];
        int[] yList = new int[numPoints];
        float as = (float)arcWidth / 2.0f * ((float)arcWidth / 2.0f);
        float bs = (float)arcHeight / 2.0f * ((float)arcHeight / 2.0f);
        for (i = 0; -arcHeight / 2 <= i; --i) {
            offset = (int)Math.sqrt((1.0 - (double)((float)(i * i) / bs)) * (double)as);
            xList[count] = startX = x - offset + arcWidth / 2;
            yList[count] = y + i + arcHeight / 2;
            ++count;
        }
        for (i = -arcHeight / 2; i <= 0; ++i) {
            offset = (int)Math.sqrt((1.0 - (double)((float)(i * i) / bs)) * (double)as);
            xList[count] = endX = x + offset + (w - arcWidth) + arcWidth / 2;
            yList[count] = y + i + arcHeight / 2;
            ++count;
        }
        for (i = 0; i <= arcHeight / 2; ++i) {
            offset = (int)Math.sqrt((1.0 - (double)((float)(i * i) / bs)) * (double)as);
            startX = x - offset + arcWidth / 2;
            xList[count] = endX = x + offset + (w - arcWidth) + arcWidth / 2;
            yList[count] = y + i + h - arcHeight / 2;
            ++count;
        }
        for (i = arcHeight / 2; i >= 0; --i) {
            offset = (int)Math.sqrt((1.0 - (double)((float)(i * i) / bs)) * (double)as);
            startX = x - offset + arcWidth / 2;
            endX = x + offset + (w - arcWidth) + arcWidth / 2;
            xList[count] = startX;
            yList[count] = y + i + h - arcHeight / 2;
            ++count;
        }
        xList[count] = xList[0];
        yList[count] = yList[0];
        this.drawPolyline(xList, yList, numPoints);
    }

    public void fillRoundRect(int x, int y, int w, int h, int arcWidth, int arcHeight) {
        int endX;
        int startX;
        int offset;
        int i;
        if (w <= 0 || h <= 0) {
            return;
        }
        if (arcWidth == 0 || arcHeight == 0) {
            this.fillRect(x, y, w, h);
            return;
        }
        if (arcWidth < 0) {
            arcWidth *= -1;
        }
        if (arcHeight < 0) {
            arcHeight *= -1;
        }
        float as = (float)arcWidth / 2.0f * ((float)arcWidth / 2.0f);
        float bs = (float)arcHeight / 2.0f * ((float)arcHeight / 2.0f);
        int colour = this.foreground.getRGB();
        for (i = -arcHeight / 2; i < 0; ++i) {
            offset = (int)Math.sqrt((1.0 - (double)((float)(i * i) / bs)) * (double)as);
            startX = x - offset + arcWidth / 2;
            endX = x + offset + (w - arcWidth) + arcWidth / 2;
            this.drawSpan(startX, y + i + arcHeight / 2, endX - startX + 1, colour);
        }
        for (i = 0; i < h - arcHeight; ++i) {
            this.drawSpan(x, y + i + arcHeight / 2, w, colour);
        }
        for (i = 0; i <= arcHeight / 2; ++i) {
            offset = (int)Math.sqrt((1.0 - (double)((float)(i * i) / bs)) * (double)as);
            startX = x - offset + arcWidth / 2;
            endX = x + offset + (w - arcWidth) + arcWidth / 2;
            this.drawSpan(startX, y + i + h - 1 - arcHeight / 2, endX - startX + 1, colour);
        }
    }

    protected native void drawStringN(long var1, String var3, int var4, int var5, int var6);

    public void drawString(String string, int x, int y) {
        if (this.fontMetrics != null) {
            this.fontMetrics.drawString((BDGraphics)this, string, x, y, this.foreground.getRGB());
        }
    }

    public void drawChars(char[] chars, int offset, int length, int x, int y) {
        this.drawString(new String(chars, offset, length), x, y);
    }

    public void drawString(AttributedCharacterIterator arg0, int arg1, int arg2) {
        logger.unimplemented("drawString");
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, null, observer);
    }

    public boolean drawImage(Image img, int x, int y, Color bg, ImageObserver observer) {
        return this.drawImageN(img, x, y, -1, -1, 0, 0, -1, -1, false, false, bg, observer);
    }

    public boolean drawImage(Image img, int x, int y, int w, int h, ImageObserver observer) {
        return this.drawImage(img, x, y, w, h, null, observer);
    }

    public boolean drawImage(Image img, int x, int y, int w, int h, Color bg, ImageObserver observer) {
        return this.drawImageN(img, x, y, w, h, 0, 0, -1, -1, false, false, bg, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bg, ImageObserver observer) {
        int swap;
        boolean flipX = false;
        boolean flipY = false;
        if (dx1 > dx2) {
            swap = dx1;
            dx1 = dx2;
            dx2 = swap;
            boolean bl = flipX = !flipX;
        }
        if (dy1 > dy2) {
            swap = dy1;
            dy1 = dy2;
            dy2 = swap;
            boolean bl = flipY = !flipY;
        }
        if (sx1 > sx2) {
            swap = sx1;
            sx1 = sx2;
            sx2 = swap;
            boolean bl = flipX = !flipX;
        }
        if (sy1 > sy2) {
            swap = sy1;
            sy1 = sy2;
            sy2 = swap;
            flipY = !flipY;
        }
        return this.drawImageN(img, dx1, dy1, dx2 - dx1, dy2 - dy1, sx1, sy1, sx2 - sx1, sy2 - sy1, flipX, flipY, bg, observer);
    }

    protected boolean drawImageN(Image img, int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh, boolean flipX, boolean flipY, Color bg, ImageObserver observer) {
        int i;
        BDImageConsumer consumer;
        BDImage bdImage;
        if (sx < 0 || sy < 0 || sw == 0 || sh == 0 || dw == 0 || dh == 0) {
            return false;
        }
        if (img instanceof BDImage) {
            bdImage = (BDImage)img;
        } else if (img instanceof DVBBufferedImage) {
            bdImage = (BDImage)BDGraphicsBase.getBufferedImagePeer((BufferedImage)((DVBBufferedImage)img).getImage());
        } else if (img instanceof BufferedImage) {
            bdImage = (BDImage)BDGraphicsBase.getBufferedImagePeer((BufferedImage)img);
        } else {
            logger.unimplemented("drawImageN: unsupported image type " + img.getClass().getName());
            return false;
        }
        if (bdImage instanceof BDImageConsumer && !(consumer = (BDImageConsumer)bdImage).isComplete(observer)) {
            return false;
        }
        if (sw < 0) {
            sw = bdImage.width;
        }
        if (sh < 0) {
            sh = bdImage.height;
        }
        if (dw < 0) {
            dw = bdImage.width;
        }
        if (dh < 0) {
            dh = bdImage.height;
        }
        int stride = bdImage.width;
        int[] rgbArray = bdImage.getBdBackBuffer();
        int bgColor = 0;
        if (bg != null) {
            bgColor = bg.getRGB();
        }
        for (i = 0; i < dh && bg != null; ++i) {
            this.drawSpan(dx, dy + i, dw, bgColor);
        }
        if (dw != sw || dh != sh) {
            this.drawResizeBilinear(rgbArray, sy * stride + sx, stride, sw, sh, dx, dy, dw, dh, flipX, flipY);
            return true;
        }
        if (flipY) {
            for (i = 0; i < dh; ++i) {
                this.drawSpan(dx, dy + dh - 1 - i, dw, rgbArray, stride * (i + sy) + sx, flipX);
            }
        } else {
            for (i = 0; i < dh; ++i) {
                this.drawSpan(dx, dy + i, dw, rgbArray, stride * (i + sy) + sx, flipX);
            }
        }
        return true;
    }

    private void drawResizeBilinear(int[] pixels, int offset, int scansize, int sw, int sh, int dx, int dy, int dw, int dh, boolean flipX, boolean flipY) {
        int[] temp;
        if (sw == 1 && sh == 1) {
            for (int Y = dy; Y < dy + dh; ++Y) {
                this.drawSpan(dx, Y, dw, pixels[offset]);
            }
            return;
        }
        if (sw == 1) {
            temp = new int[2 * sh];
            for (int i = 0; i < sw * sh; ++i) {
                temp[i * 2 + 0] = pixels[offset + i];
                temp[i * 2 + 1] = pixels[offset + i];
            }
            scansize = 2;
            pixels = temp;
            offset = 0;
            sw = 2;
        } else if (sh == 1) {
            temp = new int[sw * 2];
            System.arraycopy(pixels, offset, temp, 0, sw);
            System.arraycopy(pixels, offset, temp, sw, sw);
            scansize = sw;
            pixels = temp;
            offset = 0;
            sh = 2;
        }
        if (this.tmpLine == null || this.tmpLine.length < dw + 1) {
            this.tmpLine = new int[Math.max(1920, dw + 1)];
        }
        float x_ratio = (float)(sw - 1) / (float)dw;
        float y_ratio = (float)(sh - 1) / (float)dh;
        int position = 0;
        for (int i = 0; i < dh; ++i) {
            for (int j = 0; j < dw; ++j) {
                int d;
                int dA;
                int c;
                int cA;
                int b;
                int bA;
                int x = (int)(x_ratio * (float)j);
                int y = (int)(y_ratio * (float)i);
                float x_diff = x_ratio * (float)j - (float)x;
                float y_diff = y_ratio * (float)i - (float)y;
                int index = y * scansize + x;
                int a = pixels[index += offset];
                int aA = a >>> 24;
                if (aA + (bA = (b = pixels[index + 1]) >>> 24) + (cA = (c = pixels[index + scansize]) >>> 24) + (dA = (d = pixels[index + scansize + 1]) >>> 24) < 1) {
                    this.tmpLine[position++] = 0;
                    continue;
                }
                float aFactor = (1.0f - x_diff) * (1.0f - y_diff) * (float)aA;
                float bFactor = x_diff * (1.0f - y_diff) * (float)bA;
                float cFactor = (1.0f - x_diff) * y_diff * (float)cA;
                float dFactor = x_diff * y_diff * (float)dA;
                float alpha = aFactor + bFactor + cFactor + dFactor;
                float blue = (float)(a & 0xFF) * aFactor + (float)(b & 0xFF) * bFactor + (float)(c & 0xFF) * cFactor + (float)(d & 0xFF) * dFactor;
                float green = (float)(a >> 8 & 0xFF) * aFactor + (float)(b >> 8 & 0xFF) * bFactor + (float)(c >> 8 & 0xFF) * cFactor + (float)(d >> 8 & 0xFF) * dFactor;
                float red = (float)(a >> 16 & 0xFF) * aFactor + (float)(b >> 16 & 0xFF) * bFactor + (float)(c >> 16 & 0xFF) * cFactor + (float)(d >> 16 & 0xFF) * dFactor;
                this.tmpLine[position++] = (int)alpha << 24 & 0xFF000000 | (int)(red /= alpha) << 16 & 0xFF0000 | (int)(green /= alpha) << 8 & 0xFF00 | (int)(blue /= alpha) & 0xFF;
            }
            if (flipY) {
                this.drawSpan(dx, dy + dh - 1 - i, dw, this.tmpLine, 0, flipX);
            } else {
                this.drawSpan(dx, dy + i, dw, this.tmpLine, 0, flipX);
            }
            position = 0;
        }
    }

    public Stroke getStroke() {
        logger.unimplemented("getStroke");
        throw new Error();
    }

    public void setStroke(Stroke stroke) {
        logger.unimplemented("setStroke");
    }

    public void dispose() {
        this.tmpLine = null;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.originX + "," + this.originY + "]";
    }

    private static Image getBufferedImagePeer(BufferedImage image) {
        try {
            return (Image)bufferedImagePeer.get(image);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        try {
            Class<?> c = Class.forName("java.awt.image.BufferedImage");
            bufferedImagePeer = c.getDeclaredField("peer");
            bufferedImagePeer.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            throw new AWTError("java.awt.image.BufferedImage not found");
        }
        catch (SecurityException e) {
            throw new AWTError("java.awt.image.BufferedImage.peer not accessible");
        }
        catch (NoSuchFieldException e) {
            throw new AWTError("java.awt.image.BufferedImage.peer not found");
        }
        logger = Logger.getLogger(BDGraphics.class.getName());
    }
}

