/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;

public class Copy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable deepCopy(ClassLoader cl, Serializable obj) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        try {
            oos.writeObject(obj);
        }
        catch (Exception e) {
            System.err.println("deepCopy write failed: " + e);
        }
        finally {
            oos.close();
        }
        ClObjectInputStream ios = new ClObjectInputStream(cl, new ByteArrayInputStream(bos.toByteArray()));
        Serializable s = (Serializable)ios.readObject();
        ios.close();
        return s;
    }

    private static class ClObjectInputStream
    extends ObjectInputStream {
        private ClassLoader classLoader = null;

        public ClObjectInputStream(ClassLoader cl, InputStream in) throws IOException {
            super(in);
            this.classLoader = cl;
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(desc.getName(), false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                Class<?> cl = super.resolveClass(desc);
                if (cl != null) {
                    return cl;
                }
                System.err.println("deepCopy: failed to resolve class " + desc.getName());
                throw e;
            }
            catch (Throwable t) {
                System.err.println("deepCopy: failed to resolve class " + desc.getName() + ": " + t);
                return null;
            }
        }
    }
}

