/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.InputStream;
import java.io.SyncFailedException;

public final class FileDescriptor {
    private int fd = -1;
    private long handle = -1L;
    private long fp = 0L;
    protected InputStream slave = null;
    private int useCount = 0;
    public static final FileDescriptor in = new FileDescriptor(0);
    public static final FileDescriptor out = new FileDescriptor(1);
    public static final FileDescriptor err = new FileDescriptor(2);

    public FileDescriptor() {
    }

    private FileDescriptor(int fd) {
        this();
        this.fd = fd;
    }

    public boolean valid() {
        return this.fd != -1 || this.handle != -1L || this.fp != 0L || this.slave != null;
    }

    public native void sync() throws SyncFailedException;

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int incrementAndGetUseCount() {
        FileDescriptor fileDescriptor = this;
        synchronized (fileDescriptor) {
            ++this.useCount;
            return this.useCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int decrementAndGetUseCount() {
        FileDescriptor fileDescriptor = this;
        synchronized (fileDescriptor) {
            --this.useCount;
            return this.useCount;
        }
    }

    void attach(Closeable c) {
    }

    static {
        FileDescriptor.initIDs();
    }
}

