/*
 * Decompiled with CFR 0.152.
 */
package org.havi.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import org.havi.ui.HTextLayoutManager;
import org.havi.ui.HVisible;
import org.videolan.StrUtil;

public class HDefaultTextLayoutManager
implements HTextLayoutManager {
    static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);

    public Dimension getMinimumSize(HVisible hvisible) {
        Dimension size = new Dimension(0, 0);
        for (int state = 128; state <= 135; ++state) {
            String text = hvisible.getTextContent(state);
            if (text == null || text.equals("")) continue;
            String[] lines = StrUtil.split(text, '\n');
            Graphics g = hvisible.getGraphics();
            FontMetrics fontMetrics = g.getFontMetrics(hvisible.getFont());
            g.dispose();
            int lineHeight = fontMetrics.getHeight();
            int textHeight = lines.length * lineHeight;
            if (textHeight > size.height) {
                size.height = textHeight;
            }
            for (int i = 0; i < lines.length; ++i) {
                int lineWidth = fontMetrics.stringWidth(lines[i]);
                if (lineWidth <= size.width) continue;
                size.width = lineWidth;
            }
        }
        return size;
    }

    public Dimension getMaximumSize(HVisible hvisible) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getPreferredSize(HVisible hvisible) {
        return this.getMinimumSize(hvisible);
    }

    public void render(String markedUpString, Graphics g, HVisible v, Insets insets) {
        if (markedUpString == null) {
            return;
        }
        if (insets == null) {
            insets = ZERO_INSETS;
        }
        String[] lines = StrUtil.split(markedUpString, '\n');
        Font font = v.getFont();
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics();
        int ascent = fontMetrics.getAscent();
        int descent = Math.abs(fontMetrics.getDescent());
        int leading = fontMetrics.getLeading();
        int stringHeight = ascent + descent + leading;
        int textHeight = lines.length * stringHeight;
        int x = 0;
        int y = 0;
        for (int i = 0; i < lines.length; ++i) {
            int lineWidth = fontMetrics.stringWidth(lines[i]);
            switch (v.getHorizontalAlignment()) {
                case 0: {
                    x = insets.left;
                    break;
                }
                case 2: {
                    x = v.getWidth() - lineWidth - insets.right;
                    break;
                }
                case 1: 
                case 3: {
                    x = insets.left + (v.getWidth() - insets.left - insets.right - lineWidth) / 2;
                }
            }
            switch (v.getVerticalAlignment()) {
                case 0: {
                    y = insets.top + ascent + descent + i * stringHeight;
                    break;
                }
                case 8: {
                    y = v.getHeight() - insets.bottom - textHeight + ascent + descent + i * stringHeight;
                    break;
                }
                case 4: 
                case 12: {
                    y = insets.top + (v.getHeight() - insets.top - insets.bottom - textHeight) / 2 + ascent + descent + i * stringHeight;
                }
            }
            g.drawString(lines[i], x, y);
        }
    }
}

