/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.InvalidObjectException;
import java.util.Enumeration;
import javax.media.Manager;
import javax.tv.locator.Locator;
import javax.tv.service.SIManager;
import org.bluray.net.BDLocator;
import org.bluray.ti.TitleImpl;
import org.davic.media.MediaLocator;
import org.dvb.application.AppID;
import org.dvb.application.AppsDatabase;
import org.dvb.application.CurrentServiceFilter;
import org.videolan.BDJAction;
import org.videolan.BDJActionQueue;
import org.videolan.BDJAppProxy;
import org.videolan.BDJAppsDatabase;
import org.videolan.BDJLoaderCallback;
import org.videolan.BDJXletContext;
import org.videolan.GUIManager;
import org.videolan.Libbluray;
import org.videolan.Logger;
import org.videolan.StrUtil;
import org.videolan.TitleInfo;
import org.videolan.bdjo.AppEntry;
import org.videolan.bdjo.Bdjo;
import org.videolan.bdjo.GraphicsResolution;
import org.videolan.bdjo.PlayListTable;
import org.videolan.bdjo.TerminalInfo;
import org.videolan.media.content.PlayerManager;

public class BDJLoader {
    private static final Logger logger = Logger.getLogger(BDJLoader.class.getName());
    private static BDJActionQueue queue = null;

    public static boolean load(int title) {
        return BDJLoader.load(title, true, null);
    }

    public static boolean load(int title, boolean restart, BDJLoaderCallback callback) {
        try {
            BDLocator locator = new BDLocator(null, title, -1);
            return BDJLoader.load((TitleImpl)SIManager.createInstance().getService(locator), restart, callback);
        }
        catch (Throwable e) {
            logger.error("load() failed: " + e);
            e.printStackTrace();
            return false;
        }
    }

    public static boolean load(Locator locator, boolean restart, BDJLoaderCallback callback) {
        try {
            return BDJLoader.load((TitleImpl)SIManager.createInstance().getService(locator), restart, callback);
        }
        catch (Throwable e) {
            logger.error("load() failed: " + e);
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean load(TitleImpl title, boolean restart, BDJLoaderCallback callback) {
        if (title == null) {
            return false;
        }
        Class clazz = BDJLoader.class;
        synchronized (clazz) {
            if (queue == null) {
                queue = new BDJActionQueue(null, "BDJLoader");
            }
        }
        queue.put(new BDJLoaderAction(title, restart, callback));
        return true;
    }

    public static boolean unload() {
        return BDJLoader.unload(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unload(BDJLoaderCallback callback) {
        Class clazz = BDJLoader.class;
        synchronized (clazz) {
            if (queue == null) {
                queue = new BDJActionQueue(null, "BDJLoader");
            }
        }
        queue.put(new BDJLoaderAction(null, false, callback));
        return true;
    }

    public static void shutdown() {
        BDJLoader.unload();
        try {
            queue.shutdown();
        }
        catch (Throwable e) {
            logger.error("shutdown() failed: " + e);
            e.printStackTrace();
        }
        queue = null;
    }

    private static boolean loadN(TitleImpl title, boolean restart) {
        TitleInfo ti = title.getTitleInfo();
        if (!ti.isBdj()) {
            logger.info("Not BD-J title - requesting HDMV title start");
            BDJLoader.unloadN();
            return Libbluray.selectTitle(title);
        }
        try {
            int i;
            Bdjo bdjo = Libbluray.getBdjo(ti.getBdjoName());
            if (bdjo == null) {
                throw new InvalidObjectException("bdjo not loaded");
            }
            AppEntry[] appTable = bdjo.getAppTable();
            BDJAppProxy[] proxys = new BDJAppProxy[appTable.length];
            AppsDatabase db = AppsDatabase.getAppsDatabase();
            Enumeration ids = db.getAppIDs(new CurrentServiceFilter());
            while (ids.hasMoreElements()) {
                AppID id = (AppID)ids.nextElement();
                BDJAppProxy proxy = (BDJAppProxy)db.getAppProxy(id);
                AppEntry entry = (AppEntry)db.getAppAttributes(id);
                for (i = 0; i < appTable.length; ++i) {
                    if (!id.equals(appTable[i].getIdentifier()) || !entry.getInitialClass().equals(appTable[i].getInitialClass())) continue;
                    if (restart && appTable[i].getIsServiceBound()) {
                        logger.info("Stopping xlet " + appTable[i].getInitialClass() + " (for restart)");
                        proxy.stop(true);
                        break;
                    }
                    logger.info("Keeping xlet " + appTable[i].getInitialClass());
                    proxy.getXletContext().update(appTable[i], bdjo.getAppCaches());
                    proxys[i] = proxy;
                    proxy = null;
                    break;
                }
                if (proxy == null) continue;
                logger.info("Terminating xlet " + entry.getInitialClass());
                proxy.release();
            }
            GUIManager gui = GUIManager.createInstance();
            TerminalInfo terminfo = bdjo.getTerminalInfo();
            GraphicsResolution res = terminfo.getResolution();
            gui.setResizable(true);
            gui.setSize(res.getWidth(), res.getHeight());
            gui.setVisible(true);
            Libbluray.setUOMask(terminfo.getMenuCallMask(), terminfo.getTitleSearchMask());
            for (i = 0; i < appTable.length; ++i) {
                if (proxys[i] == null) {
                    proxys[i] = new BDJAppProxy(new BDJXletContext(appTable[i], bdjo.getAppCaches(), gui));
                    String[] params = appTable[i].getParams();
                    String p = "";
                    if (params != null && params.length > 0) {
                        p = "(" + StrUtil.Join(params, ",") + ")";
                    }
                    logger.info("Loaded class: " + appTable[i].getInitialClass() + p + " from " + appTable[i].getBasePath() + ".jar");
                    continue;
                }
                logger.info("Reused class: " + appTable[i].getInitialClass() + " from " + appTable[i].getBasePath() + ".jar");
            }
            Libbluray.writePSR(4, title.getTitleNum());
            ((BDJAppsDatabase)BDJAppsDatabase.getAppsDatabase()).newDatabase(bdjo, proxys);
            for (i = 0; i < appTable.length; ++i) {
                int code = appTable[i].getControlCode();
                if (code == 1) {
                    logger.info("Autostart xlet " + i + ": " + appTable[i].getInitialClass());
                    proxys[i].start();
                    continue;
                }
                if (code == 2) {
                    logger.info("Init xlet " + i + ": " + appTable[i].getInitialClass());
                    proxys[i].init();
                    continue;
                }
                logger.info("Unsupported xlet code (" + code + ") xlet " + i + ": " + appTable[i].getInitialClass());
            }
            logger.info("Finished initializing and starting xlets.");
            PlayListTable plt = bdjo.getAccessiblePlaylists();
            if (plt != null && plt.isAutostartFirst()) {
                logger.info("Auto-starting playlist");
                String[] pl = plt.getPlayLists();
                if (pl.length > 0) {
                    Manager.createPlayer(new MediaLocator(new BDLocator("bd://PLAYLIST:" + pl[0]))).start();
                }
            }
            return true;
        }
        catch (Throwable e) {
            logger.error("loadN() failed: " + e);
            e.printStackTrace();
            BDJLoader.unloadN();
            return false;
        }
    }

    private static boolean unloadN() {
        try {
            BDJAppProxy proxy;
            AppID id;
            GUIManager.getInstance().setVisible(false);
            AppsDatabase db = AppsDatabase.getAppsDatabase();
            Enumeration ids = db.getAppIDs(new CurrentServiceFilter());
            while (ids.hasMoreElements()) {
                id = (AppID)ids.nextElement();
                proxy = (BDJAppProxy)db.getAppProxy(id);
                proxy.stop(true);
            }
            ids = db.getAppIDs(new CurrentServiceFilter());
            while (ids.hasMoreElements()) {
                id = (AppID)ids.nextElement();
                proxy = (BDJAppProxy)db.getAppProxy(id);
                proxy.release();
            }
            ((BDJAppsDatabase)db).newDatabase(null, null);
            PlayerManager.getInstance().releaseAllPlayers(true);
            return true;
        }
        catch (Throwable e) {
            logger.error("unloadN() failed: " + e);
            e.printStackTrace();
            return false;
        }
    }

    private static class BDJLoaderAction
    extends BDJAction {
        private TitleImpl title;
        private boolean restart;
        private BDJLoaderCallback callback;

        public BDJLoaderAction(TitleImpl title, boolean restart, BDJLoaderCallback callback) {
            this.title = title;
            this.restart = restart;
            this.callback = callback;
        }

        protected void doAction() {
            boolean succeed = this.title != null ? BDJLoader.loadN(this.title, this.restart) : BDJLoader.unloadN();
            if (this.callback != null) {
                this.callback.loaderDone(succeed);
            }
        }
    }
}

