/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import vlcskineditor.Helper;
import vlcskineditor.Item;
import vlcskineditor.Language;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.history.VideoEditEvent;

public class Video
extends Item
implements ActionListener {
    public final int WIDTH_DEFAULT = 0;
    public final int HEIGHT_DEFAULT = 0;
    public final boolean AUTORESIZE_DEFAULT = true;
    public int width = 0;
    public int height = 0;
    public boolean autoresize = true;
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField help_tf;
    JTextField visible_tf;
    JTextField width_tf;
    JTextField height_tf;
    JComboBox lefttop_cb;
    JComboBox rightbottom_cb;
    JComboBox xkeepratio_cb;
    JComboBox ykeepratio_cb;
    JComboBox autoresize_cb;
    JButton visible_btn;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;

    public Video(Node node, Skin skin) {
        this.type = Language.get("VIDEO");
        this.s = skin;
        this.id = XML.getStringAttributeValue(node, "id", Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId())));
        this.width = XML.getIntAttributeValue(node, "width", this.width);
        this.height = XML.getIntAttributeValue(node, "height", this.height);
        this.autoresize = XML.getBoolAttributeValue(node, "autoresize", this.autoresize);
        this.x = XML.getIntAttributeValue(node, "x", this.x);
        this.y = XML.getIntAttributeValue(node, "y", this.y);
        this.lefttop = XML.getStringAttributeValue(node, "lefttop", this.lefttop);
        this.rightbottom = XML.getStringAttributeValue(node, "rightbottom", this.rightbottom);
        this.xkeepratio = XML.getBoolAttributeValue(node, "xkeepratio", this.xkeepratio);
        this.ykeepratio = XML.getBoolAttributeValue(node, "ykeepratio", this.ykeepratio);
        this.visible = XML.getStringAttributeValue(node, "visible", this.visible);
        this.help = XML.getStringAttributeValue(node, "help", this.help);
        this.created = true;
    }

    public Video(String string, Skin skin) {
        this.type = Language.get("VIDEO");
        this.s = skin;
        if (string.indexOf(" width=\"") != -1) {
            this.width = XML.getIntValue(string, "width");
        }
        if (string.indexOf(" height=\"") != -1) {
            this.height = XML.getIntValue(string, "height");
        }
        if (string.indexOf(" autoresize=\"") != -1) {
            this.autoresize = XML.getBoolValue(string, "autoresize");
        }
        if (string.indexOf(" x=\"") != -1) {
            this.x = XML.getIntValue(string, "x");
        }
        if (string.indexOf(" y=\"") != -1) {
            this.y = XML.getIntValue(string, "y");
        }
        this.id = string.indexOf(" id=\"") != -1 ? XML.getValue(string, "id") : Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        if (string.indexOf(" lefttop=\"") != -1) {
            this.lefttop = XML.getValue(string, "lefttop");
        }
        if (string.indexOf(" rightbottom=\"") != -1) {
            this.rightbottom = XML.getValue(string, "rightbottom");
        }
        if (string.indexOf(" xkeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(string, "xkeepratio");
        }
        if (string.indexOf(" ykeepratio=\"") != -1) {
            this.ykeepratio = XML.getBoolValue(string, "ykeepratio");
        }
        if (string.indexOf(" visible=\"") != -1) {
            this.visible = XML.getValue(string, "visible");
        }
        this.created = true;
    }

    public Video(Skin skin) {
        this.type = Language.get("VIDEO");
        this.s = skin;
        this.id = Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        this.showOptions();
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.height = Integer.parseInt(this.height_tf.getText());
            this.autoresize = Boolean.parseBoolean(this.autoresize_cb.getSelectedItem().toString());
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.frame.setDefaultCloseOperation(2);
            this.created = true;
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
        } else {
            VideoEditEvent videoEditEvent = new VideoEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.height = Integer.parseInt(this.height_tf.getText());
            this.autoresize = Boolean.parseBoolean(this.autoresize_cb.getSelectedItem().toString());
            this.s.updateItems();
            this.s.expandItem(this.id);
            videoEditEvent.setNew();
            this.s.m.hist.addEvent(videoEditEvent);
        }
        this.updateToGlobalVariables();
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame(Language.get("WIN_VIDEO_TITLE"));
            this.frame.setIconImage(Main.edit_icon.getImage());
            this.frame.setResizable(false);
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel(Language.get("WIN_ITEM_ID"));
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel(Language.get("WIN_ITEM_X"));
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel(Language.get("WIN_ITEM_Y"));
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            JLabel jLabel4 = new JLabel(Language.get("WIN_ITEM_LEFTTOP"));
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText(Language.get("WIN_ITEM_LEFTTOP_TITLE"));
            JLabel jLabel5 = new JLabel(Language.get("WIN_ITEM_RIGHTBOTTOM"));
            this.rightbottom_cb = new JComboBox<String>(stringArray);
            this.rightbottom_cb.setToolTipText(Language.get("WIN_ITEM_RIGHTBOTTOM_TITLE"));
            Object[] objectArray = new Object[]{true, false};
            JLabel jLabel6 = new JLabel(Language.get("WIN_ITEM_XKEEPRATIO"));
            this.xkeepratio_cb = new JComboBox<Object>(objectArray);
            this.xkeepratio_cb.setToolTipText(Language.get("WIN_ITEM_XKEEPRATIO_TIP"));
            JLabel jLabel7 = new JLabel(Language.get("WIN_ITEM_YKEEPRATIO"));
            this.ykeepratio_cb = new JComboBox<Object>(objectArray);
            this.ykeepratio_cb.setToolTipText(Language.get("WIN_ITEM_YKEEPRATIO_TIP"));
            JLabel jLabel8 = new JLabel(Language.get("WIN_ITEM_VISIBLE"));
            this.visible_tf = new JTextField();
            this.visible_btn = new JButton("", Main.help_icon);
            this.visible_btn.addActionListener(this);
            JLabel jLabel9 = new JLabel(Language.get("WIN_ITEM_HELP"));
            this.help_tf = new JTextField();
            this.help_tf.setToolTipText(Language.get("WIN_ITEM_HELP_TIP"));
            JLabel jLabel10 = new JLabel(Language.get("WIN_ITEM_WIDTH"));
            this.width_tf = new JTextField();
            this.width_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel11 = new JLabel(Language.get("WIN_ITEM_HEIGHT"));
            this.height_tf = new JTextField();
            this.height_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel12 = new JLabel(Language.get("WIN_VIDEO_AUTORESIZE"));
            this.autoresize_cb = new JComboBox<Object>(objectArray);
            this.autoresize_cb.setToolTipText(Language.get("WIN_VIDEO_AUTORESIZE_TITLE"));
            JLabel jLabel13 = new JLabel(Language.get("NOTE_STARRED"));
            this.ok_btn = new JButton(Language.get("BUTTON_OK"));
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton(Language.get("BUTTON_CANCEL"));
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton(Language.get("BUTTON_HELP"));
            this.help_btn.addActionListener(this);
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3, jLabel4, jLabel5, jLabel6, jLabel7, jLabel8, jLabel9, jLabel10, jLabel11, jLabel12};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            this.id_tf.setPreferredSize(new Dimension(n2, this.id_tf.getPreferredSize().height));
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jPanel.add(jLabel4);
            jPanel.add(this.lefttop_cb);
            jPanel.add(jLabel5);
            jPanel.add(this.rightbottom_cb);
            jPanel.add(jLabel6);
            jPanel.add(this.xkeepratio_cb);
            jPanel.add(jLabel7);
            jPanel.add(this.ykeepratio_cb);
            jPanel.add(jLabel8);
            jPanel.add(this.visible_tf);
            jPanel.add(this.visible_btn);
            jPanel.add(jLabel9);
            jPanel.add(this.help_tf);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_ITEM_GENERAL")));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("North", (Component)jLabel2, 10, "South", (Component)this.id_tf);
            springLayout.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.x_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)this.x_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.x_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel3, 10, "South", (Component)this.x_tf);
            springLayout.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.y_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout.putConstraint("West", (Component)this.y_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.y_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel4, 10, "South", (Component)this.y_tf);
            springLayout.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.lefttop_cb, 0, "VerticalCenter", (Component)jLabel4);
            springLayout.putConstraint("West", (Component)this.lefttop_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.lefttop_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel5, 10, "South", (Component)this.lefttop_cb);
            springLayout.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.rightbottom_cb, 0, "VerticalCenter", (Component)jLabel5);
            springLayout.putConstraint("West", (Component)this.rightbottom_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.rightbottom_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel6, 10, "South", (Component)this.rightbottom_cb);
            springLayout.putConstraint("West", (Component)jLabel6, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.xkeepratio_cb, 0, "VerticalCenter", (Component)jLabel6);
            springLayout.putConstraint("West", (Component)this.xkeepratio_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.xkeepratio_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel7, 10, "South", (Component)this.xkeepratio_cb);
            springLayout.putConstraint("West", (Component)jLabel7, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.ykeepratio_cb, 0, "VerticalCenter", (Component)jLabel7);
            springLayout.putConstraint("West", (Component)this.ykeepratio_cb, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.ykeepratio_cb, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel8, 10, "South", (Component)this.ykeepratio_cb);
            springLayout.putConstraint("West", (Component)jLabel8, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_tf, 0, "VerticalCenter", (Component)jLabel8);
            springLayout.putConstraint("West", (Component)this.visible_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.visible_tf, -5, "West", (Component)this.visible_btn);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_btn, 0, "VerticalCenter", (Component)jLabel8);
            springLayout.putConstraint("East", (Component)this.visible_btn, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel9, 10, "South", (Component)this.visible_btn);
            springLayout.putConstraint("West", (Component)jLabel9, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.help_tf, 0, "VerticalCenter", (Component)jLabel9);
            springLayout.putConstraint("West", (Component)this.help_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.help_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.id_tf);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)this.help_tf);
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel10);
            jPanel2.add(this.width_tf);
            this.width_tf.setPreferredSize(new Dimension(n2, this.width_tf.getPreferredSize().height));
            jPanel2.add(jLabel11);
            jPanel2.add(this.height_tf);
            jPanel2.add(jLabel12);
            jPanel2.add(this.autoresize_cb);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_VIDEO_ATTR")));
            SpringLayout springLayout2 = new SpringLayout();
            jPanel2.setLayout(springLayout2);
            springLayout2.putConstraint("North", (Component)jLabel10, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel10, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.width_tf, 0, "VerticalCenter", (Component)jLabel10);
            springLayout2.putConstraint("West", (Component)this.width_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("North", (Component)jLabel11, 10, "South", (Component)this.width_tf);
            springLayout2.putConstraint("West", (Component)jLabel11, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.height_tf, 0, "VerticalCenter", (Component)jLabel11);
            springLayout2.putConstraint("West", (Component)this.height_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.height_tf, 0, "East", (Component)this.width_tf);
            springLayout2.putConstraint("North", (Component)jLabel12, 10, "South", (Component)this.height_tf);
            springLayout2.putConstraint("West", (Component)jLabel12, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.autoresize_cb, 0, "VerticalCenter", (Component)jLabel12);
            springLayout2.putConstraint("West", (Component)this.autoresize_cb, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.autoresize_cb, 0, "East", (Component)this.width_tf);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.width_tf);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)this.autoresize_cb);
            this.frame.add(jPanel2);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(jLabel13);
            SpringLayout springLayout3 = new SpringLayout();
            springLayout3.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jPanel2, 10, "South", (Component)jPanel);
            springLayout3.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jLabel13, 10, "South", (Component)jPanel2);
            springLayout3.putConstraint("West", (Component)jLabel13, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.ok_btn, 10, "South", (Component)jLabel13);
            springLayout3.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.cancel_btn, 0, "North", (Component)this.ok_btn);
            springLayout3.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout3.putConstraint("North", (Component)this.help_btn, 0, "North", (Component)this.cancel_btn);
            springLayout3.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout3.putConstraint("South", (Component)this.frame.getContentPane(), 10, "South", (Component)this.ok_btn);
            springLayout3.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel);
            this.frame.setLayout(springLayout3);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.rightbottom_cb.setSelectedItem(this.rightbottom);
        this.xkeepratio_cb.setSelectedItem(this.xkeepratio);
        this.ykeepratio_cb.setSelectedItem(this.ykeepratio);
        this.visible_tf.setText(this.visible);
        this.help_tf.setText(this.help);
        this.width_tf.setText(String.valueOf(this.width));
        this.height_tf.setText(String.valueOf(this.height));
        this.autoresize_cb.setSelectedItem(this.autoresize);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_INVALID_MSG"), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_EXISTS_MSG").replaceAll("%i", this.id_tf.getText()), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/i-video.html");
        } else if (actionEvent.getSource().equals(this.visible_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/boolexpr.html");
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Video";
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        if (this.width != 0) {
            string2 = string2 + " width=\"" + String.valueOf(this.width) + "\"";
        }
        if (this.height != 0) {
            string2 = string2 + " height=\"" + String.valueOf(this.height) + "\"";
        }
        if (!this.autoresize) {
            string2 = string2 + " autoresize=\"" + String.valueOf(this.autoresize) + "\"";
        }
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        if (!this.rightbottom.equals("lefttop")) {
            string2 = string2 + " rightbottom=\"" + this.rightbottom + "\"";
        }
        if (this.xkeepratio) {
            string2 = string2 + " xkeepratio=\"" + String.valueOf(this.xkeepratio) + "\"";
        }
        if (this.ykeepratio) {
            string2 = string2 + " ykeepratio=\"" + String.valueOf(this.ykeepratio) + "\"";
        }
        if (!this.help.equals("")) {
            string2 = string2 + " help=\"" + this.help + "\"";
        }
        if (!this.visible.equals("true")) {
            string2 = string2 + " visible=\"" + this.visible + "\"";
        }
        string2 = string2 + "/>";
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, this.offsetx, this.offsety, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        if (!this.created) {
            return;
        }
        graphics2D.setColor(Color.BLACK);
        if (this.vis) {
            graphics2D.fillRect((this.x + n) * n3, (this.y + n2) * n3, this.width * n3, this.height * n3);
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            graphics2D.drawRect((this.x + n) * n3, (this.y + n2) * n3, this.width * n3 - 1, this.height * n3 - 1);
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        return n >= this.x + this.offsetx && n <= this.x + this.width + this.offsetx && n2 >= this.y + this.offsety && n2 <= this.y + this.height + this.offsety;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Video: " + this.id);
        return defaultMutableTreeNode;
    }
}

