/*****************************************************************************
 * UIDevice+VLC
 * VLC for iOS
 *****************************************************************************
 * Copyright (c) 2013-2015 VideoLAN. All rights reserved.
 * $Id$
 *
 * Authors: Felix Paul Kühne <fkuehne # videolan.org>
 *
 * Refer to the COPYING file of the official project for license.
 *****************************************************************************/

#import "UIDevice+VLC.h"
#import <sys/sysctl.h> // for sysctlbyname
#import <sys/utsname.h>

int _currentSpeedCategory;

@implementation UIDevice (VLC)

- (int)VLCSpeedCategory
{
    if (_currentSpeedCategory != 0) {
        return _currentSpeedCategory;
    }

    size_t size;
    sysctlbyname("hw.machine", NULL, &size, NULL, 0);

    char *answer = malloc(size);
    sysctlbyname("hw.machine", answer, &size, NULL, 0);

    NSString *currentMachine = @(answer);
    free(answer);

    if ([currentMachine hasPrefix:@"iPhone2"] || [currentMachine hasPrefix:@"iPhone3"] || [currentMachine hasPrefix:@"iPad1"] || [currentMachine hasPrefix:@"iPod3"] || [currentMachine hasPrefix:@"iPod4"]) {
        // iPhone 4, 4th generation iPod touch
        APLog(@"this is a cat one device");
        _currentSpeedCategory = 1;
    } else if ([currentMachine hasPrefix:@"iPhone4"] || [currentMachine hasPrefix:@"iPad3,1"] || [currentMachine hasPrefix:@"iPad3,2"] || [currentMachine hasPrefix:@"iPad3,3"] || [currentMachine hasPrefix:@"iPod4"] || [currentMachine hasPrefix:@"iPad2"] || [currentMachine hasPrefix:@"iPod5"]) {
        // iPhone 4S, iPad 2 and 3, iPod 4 and 5
        APLog(@"this is a cat two device");
        _currentSpeedCategory = 2;
    } else if ([currentMachine hasPrefix:@"iPhone5"] || [currentMachine hasPrefix:@"iPhone6"] || [currentMachine hasPrefix:@"iPad4"]) {
        // iPhone 5 + 5S, iPad 4, iPad Air, iPad mini 2G
        APLog(@"this is a cat three device");
        _currentSpeedCategory = 3;
    } else {
        // iPhone 6 + 6S, 2014+2015 iPads
        APLog(@"this is a cat four device");
        _currentSpeedCategory = 4;
    }

    return _currentSpeedCategory;
}

- (NSNumber *)VLCFreeDiskSpace
{
    NSNumber *totalSpace;
    NSNumber *totalFreeSpace;
    NSError *error = nil;
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSDictionary *dictionary = [[NSFileManager defaultManager] attributesOfFileSystemForPath:[paths lastObject] error: &error];

    if (!error) {
        totalSpace = [dictionary objectForKey:NSFileSystemSize];
        totalFreeSpace = [dictionary objectForKey:NSFileSystemFreeSize];
        NSString *totalSize = [NSByteCountFormatter stringFromByteCount:[totalSpace longLongValue] countStyle:NSByteCountFormatterCountStyleFile];
        NSString *totalFreeSize = [NSByteCountFormatter stringFromByteCount:[totalFreeSpace longLongValue] countStyle:NSByteCountFormatterCountStyleFile];
        APLog(@"Memory Capacity of %@ with %@ Free memory available.", totalSize, totalFreeSize);
    } else
        APLog(@"Error Obtaining System Memory Info: Domain = %@, Code = %ld", [error domain], (long)[error code]);

    return totalFreeSpace;
}

- (BOOL)VLCHasExternalDisplay
{
    return ([[UIScreen screens] count] > 1);
}

- (BOOL)isiPhoneX
{
    static BOOL isiPhoneX = NO;
    static dispatch_once_t onceToken;

    dispatch_once(&onceToken, ^{
#if TARGET_IPHONE_SIMULATOR
    NSString *model = NSProcessInfo.processInfo.environment[@"SIMULATOR_MODEL_IDENTIFIER"];
#else
    struct utsname systemInfo;
    uname(&systemInfo);
    NSString *model = [NSString stringWithCString:systemInfo.machine encoding:NSUTF8StringEncoding];
#endif
        isiPhoneX = [model isEqualToString:@"iPhone10,3"] || [model isEqualToString:@"iPhone10,6"];
    });
    return isiPhoneX;
}

@end
