/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM ipcIService.idl
 */

#ifndef __gen_ipcIService_h__
#define __gen_ipcIService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class ipcIMessageObserver; /* forward declaration */

class ipcIClientObserver; /* forward declaration */

class ipcIClientQueryHandler; /* forward declaration */


/* starting interface:    ipcIService */
#define IPCISERVICE_IID_STR "53d3e3a7-528f-4b09-9eab-9416272568c0"

#define IPCISERVICE_IID \
  {0x53d3e3a7, 0x528f, 0x4b09, \
    { 0x9e, 0xab, 0x94, 0x16, 0x27, 0x25, 0x68, 0xc0 }}

/**
 * ipcIService
 *
 * the IPC service provides the means to communicate with an external IPC
 * daemon and/or other mozilla-based applications on the same physical system.
 * the IPC daemon hosts modules (some builtin and others dynamically loaded)
 * with which applications may interact.
 *
 * at application startup, the IPC service will attempt to establish a
 * connection with the IPC daemon.  the IPC daemon will be automatically
 * started if necessary.  when a connection has been established, the IPC
 * service will enumerate the "ipc-startup-category" and broadcast an
 * "ipc-startup" notification using the observer service.
 *
 * when the connection to the IPC daemon is closed, an "ipc-shutdown"
 * notification will be broadcast.
 *
 * each client has a name.  the client name need not be unique across all
 * clients, but it is usually good if it is.  the IPC service does not require
 * unique names.  instead, the IPC daemon assigns each client a unique ID that
 * is good for the current "session."  clients can query other clients by name
 * or by ID.  the IPC service supports forwarding messages from one client to
 * another via the IPC daemon.
 *
 * for performance reasons, this system should not be used to transfer large
 * amounts of data.  instead, applications may choose to utilize shared memory,
 * and rely on the IPC service for synchronization and small message transfer
 * only.
 */
class NS_NO_VTABLE ipcIService : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(IPCISERVICE_IID)

  /**************************************************************************
     * properties of this process
     */
/**
     * returns the "client ID" assigned to this process by the IPC daemon.
     *
     * @throws NS_ERROR_NOT_AVAILABLE if no connection to the IPC daemon.
     */
  /* readonly attribute unsigned long clientID; */
  NS_IMETHOD GetClientID(PRUint32 *aClientID) = 0;

  /**
     * this process can appear under several client names.  use the following
     * methods to add or remove names for this process.
     *
     * for example, the mozilla browser might have the primary name "mozilla",
     * but it could also register itself under the names "browser", "mail",
     * "news", "addrbook", etc.  other IPC clients can then query the IPC
     * daemon for the client named "mail" in order to talk with a mail program.
     *
     * XXX An IPC client name resembles a XPCOM contract ID.
     */
  /* void addClientName (in string aName); */
  NS_IMETHOD AddClientName(const char *aName) = 0;

  /* void removeClientName (in string aName); */
  NS_IMETHOD RemoveClientName(const char *aName) = 0;

  /**************************************************************************
     * client query methods
     */
/**
     * query info about a particular client given its client name. the
     * observer's onClientInfo method is called with the result of the lookup,
     * or if there is no client matching the given name, the observer's
     * onClientDown method will be called instead.
     *
     * @param aName
     *        the name of the client being queried.
     * @param aHandler
     *        the handler to be notified with result.
     * @param aSync
     *        block the calling thread until the query completes.
     *
     * @return integer value identifying this query.
     */
  /* unsigned long queryClientByName (in string aName, in ipcIClientQueryHandler aHandler, in boolean aSync); */
  NS_IMETHOD QueryClientByName(const char *aName, ipcIClientQueryHandler *aHandler, PRBool aSync, PRUint32 *_retval) = 0;

  /**
     * query info about a particular client given its client ID. the observer's
     * onClientInfo method is called with the result of the lookup, or if there
     * is no client matching the given name, the observer's onClientDown method
     * will be called instead.
     *
     * @param aClientID
     *        the ID of the client being queried.
     * @param aHandler
     *        the handler to be notified with result.
     * @param aSync
     *        block the calling thread until the query completes.
     *
     * @return integer value identifying this query.
     */
  /* unsigned long queryClientByID (in unsigned long aClientID, in ipcIClientQueryHandler aHandler, in boolean aSync); */
  NS_IMETHOD QueryClientByID(PRUint32 aClientID, ipcIClientQueryHandler *aHandler, PRBool aSync, PRUint32 *_retval) = 0;

  /**
     * called to cancel a pending query.
     *
     * @param aQueryID
     *        the return value from one of the "query" methods.
     */
  /* void cancelQuery (in unsigned long aQueryID); */
  NS_IMETHOD CancelQuery(PRUint32 aQueryID) = 0;

  /**
     * set client observer.  observer's onClientUp method is called whenever 
     * a new client comes online, and the observer's onClientDown method is
     * called whenever a client goes offline.
     *
     * @param aObserver
     *        the client observer.
     */
  /* void setClientObserver (in ipcIClientObserver aObserver); */
  NS_IMETHOD SetClientObserver(ipcIClientObserver *aObserver) = 0;

  /**************************************************************************
     * message methods
     */
/**
     * set a message observer for a particular message target.
     *
     * @param aTarget
     *        the message target being observed.  any existing observer will
     *        be replaced.
     * @param aObserver
     *        the message observer to receive incoming messages for the
     *        specified target.  pass null to remove the existing observer.
     */
  /* void setMessageObserver (in nsIDRef aTarget, in ipcIMessageObserver aObserver); */
  NS_IMETHOD SetMessageObserver(const nsID & aTarget, ipcIMessageObserver *aObserver) = 0;

  /**
     * send message asynchronously to a client or a module in the IPC daemon.
     * there is no guarantee that the message will be delivered.
     *
     * @param aClientID
     *        the client ID of the foreign application that should receive this
     *        message.  pass 0 to send a message to a module in the IPC daemon.
     * @param aTarget
     *        the target of the message.  if aClientID is 0, then this is the
     *        ID of the daemon module that should receive this message.
     * @param aData
     *        the message data.
     * @param aDataLen
     *        the message length.
     * @param aSync
     *        block the calling thread until a response to this message is
     *        received.
     */
  /* void sendMessage (in unsigned long aClientID, in nsIDRef aTarget, [array, size_is (aDataLen), const] in octet aData, in unsigned long aDataLen, in boolean aSync); */
  NS_IMETHOD SendMessage(PRUint32 aClientID, const nsID & aTarget, const PRUint8 *aData, PRUint32 aDataLen, PRBool aSync) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_IPCISERVICE \
  NS_IMETHOD GetClientID(PRUint32 *aClientID); \
  NS_IMETHOD AddClientName(const char *aName); \
  NS_IMETHOD RemoveClientName(const char *aName); \
  NS_IMETHOD QueryClientByName(const char *aName, ipcIClientQueryHandler *aHandler, PRBool aSync, PRUint32 *_retval); \
  NS_IMETHOD QueryClientByID(PRUint32 aClientID, ipcIClientQueryHandler *aHandler, PRBool aSync, PRUint32 *_retval); \
  NS_IMETHOD CancelQuery(PRUint32 aQueryID); \
  NS_IMETHOD SetClientObserver(ipcIClientObserver *aObserver); \
  NS_IMETHOD SetMessageObserver(const nsID & aTarget, ipcIMessageObserver *aObserver); \
  NS_IMETHOD SendMessage(PRUint32 aClientID, const nsID & aTarget, const PRUint8 *aData, PRUint32 aDataLen, PRBool aSync); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_IPCISERVICE(_to) \
  NS_IMETHOD GetClientID(PRUint32 *aClientID) { return _to GetClientID(aClientID); } \
  NS_IMETHOD AddClientName(const char *aName) { return _to AddClientName(aName); } \
  NS_IMETHOD RemoveClientName(const char *aName) { return _to RemoveClientName(aName); } \
  NS_IMETHOD QueryClientByName(const char *aName, ipcIClientQueryHandler *aHandler, PRBool aSync, PRUint32 *_retval) { return _to QueryClientByName(aName, aHandler, aSync, _retval); } \
  NS_IMETHOD QueryClientByID(PRUint32 aClientID, ipcIClientQueryHandler *aHandler, PRBool aSync, PRUint32 *_retval) { return _to QueryClientByID(aClientID, aHandler, aSync, _retval); } \
  NS_IMETHOD CancelQuery(PRUint32 aQueryID) { return _to CancelQuery(aQueryID); } \
  NS_IMETHOD SetClientObserver(ipcIClientObserver *aObserver) { return _to SetClientObserver(aObserver); } \
  NS_IMETHOD SetMessageObserver(const nsID & aTarget, ipcIMessageObserver *aObserver) { return _to SetMessageObserver(aTarget, aObserver); } \
  NS_IMETHOD SendMessage(PRUint32 aClientID, const nsID & aTarget, const PRUint8 *aData, PRUint32 aDataLen, PRBool aSync) { return _to SendMessage(aClientID, aTarget, aData, aDataLen, aSync); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_IPCISERVICE(_to) \
  NS_IMETHOD GetClientID(PRUint32 *aClientID) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetClientID(aClientID); } \
  NS_IMETHOD AddClientName(const char *aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->AddClientName(aName); } \
  NS_IMETHOD RemoveClientName(const char *aName) { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveClientName(aName); } \
  NS_IMETHOD QueryClientByName(const char *aName, ipcIClientQueryHandler *aHandler, PRBool aSync, PRUint32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->QueryClientByName(aName, aHandler, aSync, _retval); } \
  NS_IMETHOD QueryClientByID(PRUint32 aClientID, ipcIClientQueryHandler *aHandler, PRBool aSync, PRUint32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->QueryClientByID(aClientID, aHandler, aSync, _retval); } \
  NS_IMETHOD CancelQuery(PRUint32 aQueryID) { return !_to ? NS_ERROR_NULL_POINTER : _to->CancelQuery(aQueryID); } \
  NS_IMETHOD SetClientObserver(ipcIClientObserver *aObserver) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetClientObserver(aObserver); } \
  NS_IMETHOD SetMessageObserver(const nsID & aTarget, ipcIMessageObserver *aObserver) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetMessageObserver(aTarget, aObserver); } \
  NS_IMETHOD SendMessage(PRUint32 aClientID, const nsID & aTarget, const PRUint8 *aData, PRUint32 aDataLen, PRBool aSync) { return !_to ? NS_ERROR_NULL_POINTER : _to->SendMessage(aClientID, aTarget, aData, aDataLen, aSync); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class _MYCLASS_ : public ipcIService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_IPCISERVICE

  _MYCLASS_();
  virtual ~_MYCLASS_();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(_MYCLASS_, ipcIService)

_MYCLASS_::_MYCLASS_()
{
  /* member initializers and constructor code */
}

_MYCLASS_::~_MYCLASS_()
{
  /* destructor code */
}

/* readonly attribute unsigned long clientID; */
NS_IMETHODIMP _MYCLASS_::GetClientID(PRUint32 *aClientID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void addClientName (in string aName); */
NS_IMETHODIMP _MYCLASS_::AddClientName(const char *aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeClientName (in string aName); */
NS_IMETHODIMP _MYCLASS_::RemoveClientName(const char *aName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long queryClientByName (in string aName, in ipcIClientQueryHandler aHandler, in boolean aSync); */
NS_IMETHODIMP _MYCLASS_::QueryClientByName(const char *aName, ipcIClientQueryHandler *aHandler, PRBool aSync, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* unsigned long queryClientByID (in unsigned long aClientID, in ipcIClientQueryHandler aHandler, in boolean aSync); */
NS_IMETHODIMP _MYCLASS_::QueryClientByID(PRUint32 aClientID, ipcIClientQueryHandler *aHandler, PRBool aSync, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void cancelQuery (in unsigned long aQueryID); */
NS_IMETHODIMP _MYCLASS_::CancelQuery(PRUint32 aQueryID)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setClientObserver (in ipcIClientObserver aObserver); */
NS_IMETHODIMP _MYCLASS_::SetClientObserver(ipcIClientObserver *aObserver)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setMessageObserver (in nsIDRef aTarget, in ipcIMessageObserver aObserver); */
NS_IMETHODIMP _MYCLASS_::SetMessageObserver(const nsID & aTarget, ipcIMessageObserver *aObserver)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void sendMessage (in unsigned long aClientID, in nsIDRef aTarget, [array, size_is (aDataLen), const] in octet aData, in unsigned long aDataLen, in boolean aSync); */
NS_IMETHODIMP _MYCLASS_::SendMessage(PRUint32 aClientID, const nsID & aTarget, const PRUint8 *aData, PRUint32 aDataLen, PRBool aSync)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

// singleton implementing ipcIService
#define IPC_SERVICE_CLASSNAME \
    "ipcService"
#define IPC_SERVICE_CONTRACTID \
    "@mozilla.org/ipc/service;1"
#define IPC_SERVICE_CID                              \
{ /* 9f12676a-5168-4a08-beb8-edf8a593a1ca */         \
    0x9f12676a,                                      \
    0x5168,                                          \
    0x4a08,                                          \
    {0xbe, 0xb8, 0xed, 0xf8, 0xa5, 0x93, 0xa1, 0xca} \
}
// category and observer event defines
#define IPC_SERVICE_STARTUP_CATEGORY "ipc-startup-category"
#define IPC_SERVICE_STARTUP_TOPIC    "ipc-startup"
#define IPC_SERVICE_SHUTDOWN_TOPIC   "ipc-shutdown"

#endif /* __gen_ipcIService_h__ */
