/*******************************************************************************
* http.h: Http class definition
*-------------------------------------------------------------------------------
* (c)1999-2001 VideoLAN
* $Id: http.h,v 1.2 2001/11/03 18:09:08 asmax Exp $
*
* Authors: Benoit Steiner <benny@via.ecp.fr>
*          Arnaud de Bossoreille de Ribou <bozo@via.ecp.fr>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*-------------------------------------------------------------------------------
*
*******************************************************************************/


#ifndef _HTTP_H_
#define _HTTP_H_


//------------------------------------------------------------------------------
// E_Http class
//------------------------------------------------------------------------------
class E_Http : public E_Exception
{
 public:
  E_Http(const C_String& strMsg);
  E_Http(const C_String& strMsg, const E_Exception& e);
};


//------------------------------------------------------------------------------
// C_HttpOptions class
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
class C_HttpOptions
{
 public:
  C_Buffer<byte> Request(byte bAction, byte bOption);
  C_Buffer<byte> Answer(const C_Buffer<byte>& cRequest);
  int GetOptionStatus();

 private:
  // Local NVT settings
  bool m_bLocalEcho;
  bool m_bLocalSGA;
  bool m_bLocalLineMode;

  // Remote NVT settings
  bool m_bRemoteEcho;
  bool m_bRemoteSGA;
  bool m_bRemoteLineMode;

  // Pending negociations
  C_List< C_Buffer<byte> > m_cPendingRequests;
};


/*//------------------------------------------------------------------------------
// C_HttpLogin class
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
class C_HttpLogin
{
 public:  
  C_HttpLogin();

  const C_String& GetLogin() const;
  void SetLogin(const C_String& strLogin);
  void ResetLogin();
  
  bool IsLoginSet() const;

 private:
  C_String m_strLogin;
  bool m_bLoginSet;
};*/



//------------------------------------------------------------------------------
// C_HttpCmdLine class
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
class C_HttpCmdLine
{
 public:
  // Constructor
  C_HttpCmdLine();
  
  // Local and remote command line construction
  C_Buffer<byte> Edit(const C_Buffer<byte>& cCmd);
  C_String Append(byte bByte);

  // Local command line storage
  void StartNewLine();
  void DropLine();
  
  // Cmd line retrieval
  C_String GetCmdLine();

 private:
  // Current command line
  C_String m_strLine;
  unsigned int m_iPosInLine;
  
  // Command line history
  C_List<C_String> m_cHistory;
  C_ListIterator<C_String> m_cCurrent;
};


//------------------------------------------------------------------------------
// C_HttpSession class
//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
class C_HttpSession : public C_AdminSession
{
 public:
  C_HttpSession(C_Socket* pConnection, void* pAdmin);

  // Data processing
  void ProcessData();

  C_String m_strPeerName;

 protected:
  virtual void OnInit();
  virtual void OnClose();

  void HandleByte(byte bChar);
  void HandleLine();

  void ExecLogin();
  void ExecCommand();
  
  void SendAnswer(const C_Answer& cAnswer, const C_String& strPrefix = "");
  
 private:
  // Connection to the peer
  C_Socket* m_pConnection;
  C_Stream<C_Socket> m_cStream;

  // Session status
  int m_iMode;
  int m_iPhase;

  // Internal data
  C_String m_strPrompt;
  C_String m_strLogin;
  C_HttpCmdLine m_cCmdLine;
  C_HttpOptions m_cOptions;
  C_Buffer<byte> m_cBuffer;
};



//------------------------------------------------------------------------------
// C_Http class
//------------------------------------------------------------------------------
class C_Http : protected C_ConnectionsHandler<C_HttpSession>
{
 public:
  C_Http(handle hLog, C_Admin* pAdmin);
  
  int Init();
  int Run();
  int Stop();
  int Destroy();

 private:
  // Helpers
  handle m_hLog;
  C_Admin* m_pAdmin;

};



#else
#error "Multiple inclusions of http.h"
#endif

